/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.RoleMgr;
import com.trs.cms.auth.domain.RoleUserIdsMan;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.util.CMyString;
import com.trs.service.IRoleService;
import com.trs.service.IUserService;

public class RoleService
implements IRoleService {
    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    @Override
    public Role save(Role _roleToSave) throws WCMException {
        if (_roleToSave == null) {
            throw new WCMException(10, I18NMessage.get(RoleService.class, "RoleService.label1", "\u89d2\u8272\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff01"));
        }
        User currUser = this.getLoginUser();
        Role currRole = _roleToSave;
        IUserService aUserService = (IUserService)DreamFactory.createObjectById("IUserService");
        if (!AuthServer.hasRight(currUser, (CMSObj)currRole, 11) && !aUserService.isManagerOfRole(currUser)) {
            throw new WCMException(1002, I18NMessage.get(RoleService.class, "RoleService.label2", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u4fdd\u5b58\u89d2\u8272!"));
        }
        String sLogDesc = I18NMessage.get(RoleService.class, "RoleService.label3", "\u4fdd\u5b58") + "[" + currRole + "]";
        String sLogType = "ROLE_EDIT";
        if (currRole.isAddMode()) {
            sLogType = "ROLE_ADD";
        }
        long lStartTime = LogServer.startRecord(currUser.getName(), sLogType, sLogDesc, currRole);
        try {
            currRole = this.getRoleMgr().save(currRole);
        }
        catch (Throwable t) {
            LogServer.endRecordFailedOperation(lStartTime, t);
            throw new WCMException(1100, I18NMessage.get(RoleService.class, "RoleService.label4", "\u4fdd\u5b58\u89d2\u8272\u5931\u8d25!"), t);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return currRole;
    }

    @Override
    public Users getUsers(Role _dstRole, WCMFilter _filter) throws WCMException {
        return this.getRoleMgr().getUsers(_dstRole, _filter);
    }

    @Override
    public boolean delete(int _nDelRoleId) throws WCMException {
        if (_nDelRoleId <= 0) {
            throw new WCMException(10, I18NMessage.get(RoleService.class, "RoleService.label5", "\u65e0\u6548\u7684\u89d2\u8272Id[") + _nDelRoleId + I18NMessage.get(RoleService.class, "RoleService.label6", "],\u65e0\u6cd5\u5b8c\u6210\u5220\u9664!"));
        }
        Role currRole = Role.findById(_nDelRoleId);
        if (currRole == null) {
            throw new WCMException(200006, I18NMessage.get(RoleService.class, "RoleService.label7", "\u6ca1\u6709\u627e\u5230\u6307\u5b9aid\u7684\u89d2\u8272,\u65e0\u6cd5\u5220\u9664!"));
        }
        return this.delete(currRole);
    }

    @Override
    public boolean delete(String _sDelRoleIds) throws WCMException {
        if (_sDelRoleIds == null || _sDelRoleIds.length() == 0) {
            throw new WCMException(10, I18NMessage.get(RoleService.class, "RoleService.label8", "\u65e0\u6548\u7684id\u5e8f\u5217!"));
        }
        Roles aRoles = Roles.findByIds(this.getLoginUser(), _sDelRoleIds);
        if (aRoles.isEmpty()) {
            throw new WCMException(200006, I18NMessage.get(RoleService.class, "RoleService.label9", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u89d2\u8272,\u65e0\u6cd5\u5b8c\u6210\u5220\u9664!"));
        }
        return this.delete(aRoles);
    }

    @Override
    public boolean delete(Roles _rolesToDelete) throws WCMException {
        if (_rolesToDelete == null) {
            throw new WCMException(10, I18NMessage.get(RoleService.class, "RoleService.label10", "\u89d2\u8272\u96c6\u5408\u4e3a\u7a7a\uff01"));
        }
        if (_rolesToDelete.isEmpty()) {
            return true;
        }
        for (int i = 0; i < _rolesToDelete.size(); ++i) {
            this.delete((Role)_rolesToDelete.getAt(i));
        }
        return true;
    }

    @Override
    public boolean delete(Role _roleToDelete) throws WCMException {
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)_roleToDelete, 12)) {
            throw new WCMException(1002, I18NMessage.get(RoleService.class, "RoleService.label11", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u5220\u9664\u89d2\u8272!"));
        }
        String sLogDesc = I18NMessage.get(RoleService.class, "RoleService.label12", "\u5220\u9664") + "[" + _roleToDelete + "]";
        long lStartTime = LogServer.startRecord(this.getLoginUser().getName(), "ROLE_DEL", sLogDesc, _roleToDelete);
        try {
            this.getRoleMgr().delete(_roleToDelete, true);
        }
        catch (Throwable t) {
            LogServer.endRecordFailedOperation(lStartTime, t);
            throw new WCMException(1100, I18NMessage.get(RoleService.class, "RoleService.label13", "\u5220\u9664\u89d2\u8272\u5931\u8d25!"), t);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return true;
    }

    @Override
    public User addUser(User _dstUser, Role _toRole) throws WCMException {
        User user = _dstUser;
        String sLogDesc = CMyString.format(I18NMessage.get(RoleService.class, "RoleService.label21", "\u6dfb\u52a0{0}\u62c5\u4efb\u7684\u89d2\u8272:{1}"), new Object[]{_dstUser, _toRole});
        long lStartTime = LogServer.startRecord(this.getLoginUser().getName(), "ROLEUSER_ADD", sLogDesc, _toRole);
        try {
            this.getRoleMgr().addUser(_dstUser, _toRole);
        }
        catch (Throwable t) {
            LogServer.endRecordFailedOperation(lStartTime, t);
            throw new WCMException(1100, I18NMessage.get(RoleService.class, "RoleService.label16", "\u6dfb\u52a0\u7528\u6237\u62c5\u4efb\u7684\u89d2\u8272\u5931\u8d25!"), t);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return user;
    }

    @Override
    public boolean removeUser(User _dstUser, Role _fromRole) throws WCMException {
        IUserService aUserService = (IUserService)DreamFactory.createObjectById("IUserService");
        User currUser = this.getLoginUser();
        if (!currUser.isSecurityAdmin() && !aUserService.isManagerOfRole(currUser)) {
            throw new WCMException(1002, I18NMessage.get(RoleService.class, "RoleService.label17", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u4ece\u89d2\u8272\u4e2d\u5220\u9664\u7528\u6237!"));
        }
        String sLogDesc = CMyString.format(I18NMessage.get(RoleService.class, "RoleService.label22", "\u53d6\u6d88{0}\u62c5\u4efb\u7684\u89d2\u8272:{1}"), new Object[]{_dstUser, _fromRole});
        long lStartTime = LogServer.startRecord(currUser.getName(), "ROLEUSER_DEL", sLogDesc, _dstUser);
        try {
            this.getRoleMgr().removeUser(_dstUser, _fromRole);
        }
        catch (Throwable t) {
            LogServer.endRecordFailedOperation(lStartTime, t);
            throw new WCMException(1100, I18NMessage.get(RoleService.class, "RoleService.label20", "\u53d6\u6d88\u7528\u6237\u7684\u89d2\u8272\u5931\u8d25!"), t);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return true;
    }

    private RoleMgr getRoleMgr() {
        return (RoleMgr)DreamFactory.createObjectById("RoleMgr");
    }

    @Override
    public void setRoleUsers(int _nDstRoleId, String _sUserIdsToAdd) throws WCMException {
        RoleUserIdsMan roleUserIdsMan = new RoleUserIdsMan(_nDstRoleId);
        roleUserIdsMan.dowithIds(_sUserIdsToAdd);
    }
}

