/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUrl;
import com.trs.infra.util.Reports;
import com.trs.infra.util.database.FieldInfo;
import com.trs.presentation.util.DefaultWhereSQLMaker;
import com.trs.presentation.util.PageParameter;
import com.trs.presentation.util.PageParameters;
import com.trs.presentation.util.WhereSQLMaker;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestHelper {
    private Hashtable m_hParameterValue;
    private HttpServletRequest m_oRequest;
    private HttpServletResponse m_oResponse;
    private ServletContext m_oServletContext;
    private boolean m_bParsed = false;
    private boolean m_bPostMethod = false;
    private static final int MAX_ROW_NUM = 1000;
    public static final String PARAM_NAME_SEARCH_KEY = "SearchKey";
    public static final String PARAM_NAME_SEARCH_TABLE = "SearchTable";
    public static final String PARAM_NAME_SEARCH_VALUE = "SearchValue";
    public static final String PARAM_NAME_ORDER_FIELD = "OrderField";
    public static final String PARAM_NAME_ORDER_TYPE = "OrderType";
    private PageParameters m_oPageParameters = null;
    private HashMap m_hNameMap = null;

    public RequestHelper() {
        this.m_hParameterValue = new Hashtable();
        this.m_hNameMap = new HashMap();
        this.m_bParsed = true;
    }

    public RequestHelper(HttpServletRequest _request, HttpServletResponse _response, ServletContext _servletContext) {
        this.setRequest(_request);
        this.setResponse(_response);
        this.m_bPostMethod = "POST".equalsIgnoreCase(_request.getMethod());
        this.m_oServletContext = _servletContext;
        this.m_hParameterValue = new Hashtable();
        this.m_hNameMap = new HashMap();
    }

    public RequestHelper(HttpServletRequest _request, HttpServletResponse _response, ServletContext _servletContext, boolean _bPostMehthod) {
        this(_request, _response, _servletContext);
        this.m_bPostMethod = _bPostMehthod;
        this.m_hParameterValue = new Hashtable();
        this.m_hNameMap = new HashMap();
    }

    public HttpServletRequest getRequest() {
        return this.m_oRequest;
    }

    public void setRequest(HttpServletRequest request) {
        this.m_oRequest = request;
    }

    public HttpServletResponse getResponse() {
        return this.m_oResponse;
    }

    public void setResponse(HttpServletResponse response) {
        this.m_oResponse = response;
    }

    public void doValid() throws WCMException {
        this.doValid(false);
    }

    public void doValid(boolean _bCheckFileExists) throws WCMException {
        if (this.m_oRequest == null) {
            throw new WCMException(10, I18NMessage.get(RequestHelper.class, "RequestHelper.label1", "\u6307\u5b9a\u7684HttpServletRequest\u5bf9\u8c61\u65e0\u6548!"));
        }
        String sRequestURI = this.m_oRequest.getRequestURI();
        String sPageName = CMyFile.extractHttpFileName(sRequestURI);
        String sContextPath = this.m_oRequest.getContextPath();
        String sServletPath = sRequestURI.substring(sContextPath.length());
        String sAbsolutePagePath = CMyFile.extractFilePath(this.m_oServletContext.getRealPath(sServletPath));
        int nPose = sPageName.indexOf(".");
        String sFilePrefix = "";
        sFilePrefix = nPose > 0 ? sPageName.substring(0, nPose) : sPageName;
        String sAbsolutInfoFile = sAbsolutePagePath + sFilePrefix + ".xml";
        if (!CMyFile.fileExists(sAbsolutInfoFile)) {
            if (_bCheckFileExists) {
                throw new WCMException(55, I18NMessage.get(RequestHelper.class, "RequestHelper.label2", "\u9875\u9762\u914d\u7f6e\u6587\u4ef6[") + sFilePrefix + ".xml" + I18NMessage.get(RequestHelper.class, "RequestHelper.label3", "]\u6ca1\u6709\u627e\u5230\uff01"));
            }
            return;
        }
        this.m_oPageParameters = PageParameters.getParametersOfPage(sPageName, sAbsolutePagePath);
        Enumeration enNames = this.m_oRequest.getParameterNames();
        PageParameter currPageParameter = null;
        while (enNames.hasMoreElements()) {
            String sValue;
            String sParamName = (String)enNames.nextElement();
            currPageParameter = null;
            int nSize = this.m_oPageParameters.size();
            for (int i = 0; i < nSize; ++i) {
                PageParameter parameter = (PageParameter)this.m_oPageParameters.get(i);
                if (!parameter.getName().equalsIgnoreCase(sParamName)) continue;
                currPageParameter = parameter;
                break;
            }
            if (((sValue = this.getValueFromRequest(sParamName)) == null || (sValue = sValue.trim()).length() == 0) && currPageParameter != null) {
                sValue = CMyString.showNull(currPageParameter.getDefault());
            }
            if (sValue == null || CMyString.isEmpty(sValue) && currPageParameter != null && !"string".equalsIgnoreCase(currPageParameter.getType())) continue;
            this.setValue(sParamName, sValue);
        }
        this.m_bParsed = true;
        for (int i = 0; i < this.m_oPageParameters.size(); ++i) {
            currPageParameter = (PageParameter)this.m_oPageParameters.get(i);
            if (currPageParameter == null) continue;
            this.doValidAndSaveParamValue(currPageParameter);
        }
        this.putPageMaxCount();
    }

    private void putPageMaxCount() throws WCMException {
        String sValue = (String)this.getValue("PageMaxCount");
        if (CMyString.isEmpty(sValue)) {
            this.setValue("PageMaxCount", "1000");
        }
    }

    private boolean existPageMaxCount() throws WCMException {
        String sValue = (String)this.getValue("PageMaxCount");
        return sValue != null;
    }

    private void validTypeOfParamValue(PageParameter _currPageParameter, String _sValue) throws WCMException {
        String sType = _currPageParameter.getType().toLowerCase();
        if (sType.equals("string")) {
            return;
        }
        if (sType.equals("int")) {
            try {
                Integer.parseInt(_sValue);
            }
            catch (Exception ex) {
                throw new WCMException(10, I18NMessage.get(RequestHelper.class, "RequestHelper.label4", "\u9875\u9762\u6240\u9700\u53c2\u6570[") + _currPageParameter.getDesc() + "][" + _currPageParameter.getName() + I18NMessage.get(RequestHelper.class, "RequestHelper.label5", "]\u7c7b\u578b\u4e0d\u5bf9![") + _sValue + I18NMessage.get(RequestHelper.class, "RequestHelper.label6", "]\u4e0d\u662f\u6574\u578b\u6570"), ex);
            }
        }
        if (sType.equals("long")) {
            try {
                Long.parseLong(_sValue);
            }
            catch (Exception ex) {
                throw new WCMException(10, I18NMessage.get(RequestHelper.class, "RequestHelper.label4", "\u9875\u9762\u6240\u9700\u53c2\u6570[") + _currPageParameter.getDesc() + "][" + _currPageParameter.getName() + I18NMessage.get(RequestHelper.class, "RequestHelper.label5", "]\u7c7b\u578b\u4e0d\u5bf9![") + _sValue + I18NMessage.get(RequestHelper.class, "RequestHelper.label7", "]\u4e0d\u662f\u957f\u6574\u578b"));
            }
        }
        if (sType.equals("boolean")) {
            try {
                int nValue = Integer.parseInt(_sValue);
                if (nValue != 1 && nValue != 0) {
                    throw new Exception();
                }
            }
            catch (Exception ex) {
                throw new WCMException(10, I18NMessage.get(RequestHelper.class, "RequestHelper.label4", "\u9875\u9762\u6240\u9700\u53c2\u6570[") + _currPageParameter.getDesc() + "][" + _currPageParameter.getName() + I18NMessage.get(RequestHelper.class, "RequestHelper.label5", "]\u7c7b\u578b\u4e0d\u5bf9![") + _sValue + I18NMessage.get(RequestHelper.class, "RequestHelper.label8", "]\u4e0d\u662f\u5e03\u5c14\u578b"));
            }
        }
        if (sType.equals("float")) {
            try {
                Float.parseFloat(_sValue);
            }
            catch (Exception ex) {
                throw new WCMException(10, I18NMessage.get(RequestHelper.class, "RequestHelper.label4", "\u9875\u9762\u6240\u9700\u53c2\u6570[") + _currPageParameter.getDesc() + "][" + _currPageParameter.getName() + I18NMessage.get(RequestHelper.class, "RequestHelper.label5", "]\u7c7b\u578b\u4e0d\u5bf9![") + _sValue + I18NMessage.get(RequestHelper.class, "RequestHelper.label9", "]\u4e0d\u662f\u6d6e\u70b9\u6570"));
            }
        }
    }

    private String getValueFromRequest(String _sParamName) {
        String[] pValues = this.m_oRequest.getParameterValues(_sParamName);
        if (pValues == null || pValues.length == 0) {
            return null;
        }
        boolean encodingEnable = true;
        try {
            encodingEnable = this.m_bPostMethod ? true : ConfigServer.getServer().getSysConfigValue("REQUEST_ENCODING_ENABLE", "true").trim().equalsIgnoreCase("true");
        }
        catch (WCMException wCMException) {
            // empty catch block
        }
        if (pValues.length == 1) {
            return encodingEnable ? CMyString.getStr(pValues[0], this.m_bPostMethod) : pValues[0];
        }
        String sValue = null;
        for (int i = 0; i < pValues.length; ++i) {
            sValue = i == 0 ? (encodingEnable ? CMyString.getStr(pValues[i], this.m_bPostMethod) : pValues[i]) : sValue + "," + (encodingEnable ? CMyString.getStr(pValues[i], this.m_bPostMethod) : pValues[i]);
        }
        return sValue;
    }

    private Object getValue(String _sName) throws WCMException {
        String sNameKey;
        if (!this.m_bParsed) {
            this.doValid(true);
        }
        if ((sNameKey = (String)this.m_hNameMap.get(_sName.toUpperCase())) == null) {
            sNameKey = _sName;
        }
        return this.m_hParameterValue.get(sNameKey);
    }

    public String getString(String _sName) throws WCMException {
        Object objValue = this.getValue(_sName);
        if (objValue == null) {
            return null;
        }
        return (String)objValue;
    }

    public CMyDateTime getDateTime(String _sName) throws WCMException {
        Object oValue = this.getValue(_sName);
        if (oValue == null) {
            return null;
        }
        CMyDateTime dtValue = new CMyDateTime();
        try {
            dtValue.setDateTimeWithString((String)oValue);
        }
        catch (Exception ex) {
            throw new WCMException(2, I18NMessage.get(RequestHelper.class, "RequestHelper.label10", "\u5c5e\u6027\u683c\u5f0f\u4e0d\u662f\u65e5\u671f\u578b\uff01[") + oValue + "]");
        }
        return dtValue;
    }

    public CMyDateTime getDateTime(String _sName, String _sDateFormate) throws WCMException {
        Object oValue = this.getValue(_sName);
        if (oValue == null) {
            return null;
        }
        CMyDateTime dtValue = new CMyDateTime();
        try {
            dtValue.setDateTimeWithString((String)oValue, _sDateFormate);
        }
        catch (Exception ex) {
            throw new WCMException(2, I18NMessage.get(RequestHelper.class, "RequestHelper.label10", "\u5c5e\u6027\u683c\u5f0f\u4e0d\u662f\u65e5\u671f\u578b\uff01[") + oValue + "]");
        }
        return dtValue;
    }

    public long getLong(String _sName, long _lDefault) throws WCMException {
        Object oValue = this.getValue(_sName);
        if (oValue == null) {
            return _lDefault;
        }
        try {
            return Long.parseLong(oValue.toString());
        }
        catch (Exception ex) {
            throw new WCMException(2, I18NMessage.get(RequestHelper.class, "RequestHelper.label11", "\u5c5e\u6027\u683c\u5f0f\u4e0d\u662f\u957f\u6574\u578b\uff01[") + oValue + "]");
        }
    }

    public int getInt(String _sName, int _nDefault) throws WCMException {
        Object oValue = this.getValue(_sName);
        if (oValue == null) {
            return _nDefault;
        }
        try {
            return Integer.parseInt(oValue.toString());
        }
        catch (Exception ex) {
            throw new WCMException(2, I18NMessage.get(RequestHelper.class, "RequestHelper.label12", "\u5c5e\u6027\u683c\u5f0f\u4e0d\u662f\u6574\u578b\uff01[") + oValue + "]");
        }
    }

    public boolean getBoolean(String _sName, boolean _bDefault) throws WCMException {
        int nValue = this.getInt(_sName, _bDefault ? 1 : 0);
        return nValue != 0;
    }

    public String toString() {
        String sResult = "";
        Enumeration enKeys = this.m_hParameterValue.keys();
        Object oKey = null;
        while (enKeys.hasMoreElements()) {
            oKey = enKeys.nextElement();
            Object oValue = this.m_hParameterValue.get(oKey);
            if (oValue == null) continue;
            sResult = sResult + "Parameter Name:" + oKey.toString() + "     Parameter Value:" + oValue + "\n";
        }
        return sResult;
    }

    public String toURL() throws WCMException {
        if (!this.m_bParsed) {
            this.doValid();
        }
        return this.m_oRequest.getRequestURI() + "?" + this.toURLParameters();
    }

    public String toURLParameters() throws WCMException {
        if (!this.m_bParsed) {
            this.doValid();
        }
        String sResult = "";
        Enumeration enKeys = this.m_hParameterValue.keys();
        Object oKey = null;
        boolean bNotFirst = false;
        while (enKeys.hasMoreElements()) {
            Object oValue;
            oKey = enKeys.nextElement();
            if (oKey.equals("PageMaxCount") && !this.existPageMaxCount() || (oValue = this.m_hParameterValue.get(oKey)) == null) continue;
            if (bNotFirst) {
                sResult = sResult + "&";
            } else {
                bNotFirst = true;
                sResult = "";
            }
            sResult = sResult + oKey.toString() + "=" + CMyString.URLEncode(oValue.toString());
        }
        return sResult;
    }

    public String toHTMLHidden() throws WCMException {
        if (!this.m_bParsed) {
            this.doValid();
        }
        String sResult = "";
        Enumeration enKeys = this.m_hParameterValue.keys();
        Object oKey = null;
        while (enKeys.hasMoreElements()) {
            Object oValue;
            oKey = enKeys.nextElement();
            if (oKey.equals("PageMaxCount") && !this.existPageMaxCount() || (oValue = this.m_hParameterValue.get(oKey)) == null) continue;
            sResult = sResult + "<input type=hidden name=\"" + CMyString.filterForHTMLValue(oKey.toString()) + "\" value=\"" + CMyString.filterForHTMLValue(oValue.toString()) + "\">\n";
        }
        return sResult;
    }

    public String toTRSRequestParam() throws WCMException {
        if (!this.m_bParsed) {
            this.doValid();
        }
        String sResult = "<script>\n";
        Enumeration enKeys = this.m_hParameterValue.keys();
        Object oKey = null;
        while (enKeys.hasMoreElements()) {
            Object oValue;
            oKey = enKeys.nextElement();
            if (oKey.equals("PageMaxCount") && !this.existPageMaxCount() || (oValue = this.m_hParameterValue.get(oKey)) == null) continue;
            sResult = sResult + "TRSRequestParam.setParameter(\"" + CMyString.filterForJs(oKey.toString()) + "\", \"" + CMyString.filterForJs(oValue.toString()) + "\");\n";
        }
        sResult = sResult + "</script>";
        return sResult;
    }

    public String toInitSearchJavaScript() throws WCMException {
        if (!this.m_bParsed) {
            this.doValid();
        }
        String sResult = "<script>\n" + I18NMessage.get(RequestHelper.class, "RequestHelper.label13", "//\u521d\u59cb\u5316\u68c0\u7d22Form\n") + " var frmSearch = document.frmSearch;";
        int nSize = this.m_oPageParameters.size();
        for (int i = 0; i < nSize; ++i) {
            String sValue;
            String sName;
            PageParameter pageParameter = (PageParameter)this.m_oPageParameters.get(i);
            if (pageParameter == null || !pageParameter.isSearch() || (sName = pageParameter.getName()).equals("PageMaxCount") && !this.existPageMaxCount() || (sValue = (String)this.m_hParameterValue.get(sName)) == null) continue;
            sResult = sResult + "    //" + pageParameter.getDesc() + "\n";
            sResult = sResult + "    frmSearch." + sName + ".value=" + this.getInitSearchValue(pageParameter, sValue) + ";\n";
        }
        sResult = sResult + "</script>";
        return sResult;
    }

    private String getInitSearchValue(PageParameter _pageParameter, String _sValue) {
        String sValue = CMyString.filterForJs(_sValue);
        int nType = _pageParameter.getType().hashCode();
        switch (nType) {
            case -891985903: {
                return "\"" + sValue + "\"";
            }
            case 3076014: 
            case 3560141: 
            case 1793702779: {
                return "\"" + sValue + "\"";
            }
        }
        return sValue;
    }

    public void reloadPageConfig() throws WCMException {
        String sReferer = this.m_oRequest.getHeader("referer");
        String sPageName = CMyFile.extractHttpFileName(sReferer);
        int nTemp = sPageName.indexOf("?");
        if (nTemp > 0) {
            sPageName = sPageName.substring(0, nTemp);
        }
        String sWebAppPath = this.m_oRequest.getScheme() + "://" + this.m_oRequest.getServerName();
        if (this.m_oRequest.getServerPort() != 80) {
            sWebAppPath = sWebAppPath + ":" + this.m_oRequest.getServerPort();
        }
        sWebAppPath = sWebAppPath + this.m_oRequest.getContextPath();
        int nStartPose = sReferer.toLowerCase().indexOf(sWebAppPath.toLowerCase());
        if (nStartPose < 0) {
            System.out.println("Error Request:" + sReferer);
        }
        String sServletPath = sReferer.substring(nStartPose + sWebAppPath.length());
        String sAbsolutePagePath = CMyFile.extractFilePath(this.m_oServletContext.getRealPath(sServletPath));
        PageParameters.reloadParametersOfPageName(sPageName, sAbsolutePagePath);
    }

    public void removePageConfig(String _sPageName) {
        PageParameters.removeParametersOfPageName(_sPageName);
    }

    public String getSearchKey() throws WCMException {
        if (CMyString.isEmpty(this.getString(PARAM_NAME_SEARCH_KEY))) {
            return null;
        }
        return CMyString.filterForHTMLValue(this.getString(PARAM_NAME_SEARCH_KEY).replaceAll("(?i)[;'\n\r\\-]|delete|update|insert", ""));
    }

    public void setSearchKey(String searchKey) {
        this.setValue(PARAM_NAME_SEARCH_KEY, searchKey);
    }

    public String getSearchValue() throws WCMException {
        return this.getString(PARAM_NAME_SEARCH_VALUE);
    }

    public void setSearchValue(String searchValue) {
        this.setValue(PARAM_NAME_SEARCH_VALUE, searchValue);
    }

    private void doValidAndSaveParamValue(PageParameter _currPageParameter) throws WCMException {
        String sValue = (String)this.getValue(_currPageParameter.getName());
        if (_currPageParameter.isRequired() && sValue == null) {
            throw new WCMException(10, CMyString.format(I18NMessage.get(RequestHelper.class, "RequestHelper.label14", "\u9875\u9762\u6240\u9700\u53c2\u6570[{0}]\u6ca1\u6709\u4f20\u5165!"), new String[]{_currPageParameter.getName()}));
        }
        if (!CMyString.isEmpty(sValue)) {
            this.validTypeOfParamValue(_currPageParameter, sValue);
        }
        if (CMyString.isEmpty(sValue) && _currPageParameter.getDefault() != null) {
            this.setValue(_currPageParameter.getName(), _currPageParameter.getDefault());
        }
    }

    public Object setValue(String _sName, String _sValue) {
        String sNameKey = _sName.toUpperCase();
        if (!this.m_hNameMap.containsKey(sNameKey)) {
            this.m_hNameMap.put(sNameKey, _sName);
        }
        return this.m_hParameterValue.put(_sName, _sValue);
    }

    public String getSearchTableName() throws WCMException {
        return this.getString(PARAM_NAME_SEARCH_TABLE);
    }

    public void setSearchTableName(String searchTableName) {
        this.setValue(PARAM_NAME_SEARCH_TABLE, searchTableName);
    }

    public String getOrderField() throws WCMException {
        return this.getString(PARAM_NAME_ORDER_FIELD);
    }

    public void setOrderField(String orderField) {
        this.setValue(PARAM_NAME_ORDER_FIELD, orderField);
    }

    public String getOrderType() throws WCMException {
        return this.getString(PARAM_NAME_ORDER_TYPE);
    }

    public void setOrderType(String orderType) {
        this.setValue(PARAM_NAME_ORDER_TYPE, orderType);
    }

    public WCMFilter getPageFilter(WCMFilter _extraFilter) throws WCMException {
        int nValue;
        WhereSQLMaker whereSQLMaker = new WhereSQLMaker(this.m_oPageParameters);
        whereSQLMaker.makeWhereSQL(this);
        String sWhereSQL = whereSQLMaker.getWhereSQL();
        DefaultWhereSQLMaker defaultSQLMaker = new DefaultWhereSQLMaker(this.getSearchTableName(), this.getSearchKey(), this.getSearchValue());
        defaultSQLMaker.makeWhereSQL();
        String sDefaultWhereSQL = defaultSQLMaker.getWhereSQL();
        if (sWhereSQL == null || sWhereSQL.length() == 0) {
            sWhereSQL = sDefaultWhereSQL == null ? "" : sDefaultWhereSQL;
        } else if (sDefaultWhereSQL != null && sDefaultWhereSQL.length() > 0) {
            sWhereSQL = sWhereSQL + " and (" + sDefaultWhereSQL + ")";
        }
        List searchValues = whereSQLMaker.getSearchValues();
        if (defaultSQLMaker.getSearchValues() != null) {
            if (searchValues == null) {
                searchValues = defaultSQLMaker.getSearchValues();
            } else {
                searchValues.addAll(defaultSQLMaker.getSearchValues());
            }
        }
        WCMFilter filter = new WCMFilter("", sWhereSQL, this.getOrderSQL());
        filter.setSearchValues(searchValues);
        filter.mergeWith(_extraFilter);
        String sValue = this.getString("PageMaxCount");
        try {
            nValue = Integer.parseInt(sValue);
        }
        catch (NumberFormatException ex) {
            nValue = 1000;
        }
        filter.setMaxRowNumber(nValue);
        return filter;
    }

    public String getWhereSQL() throws WCMException {
        WhereSQLMaker whereSQLMaker = new WhereSQLMaker(this.m_oPageParameters);
        whereSQLMaker.makeWhereSQL(this);
        String sWhereSQL = whereSQLMaker.getWhereSQL();
        String sDefaultWhereSQL = this.getDefaultWhereSQL();
        if (sWhereSQL == null || sWhereSQL.length() == 0) {
            sWhereSQL = sDefaultWhereSQL;
        } else if (sDefaultWhereSQL != null && sDefaultWhereSQL.length() > 0) {
            sWhereSQL = sWhereSQL + " and (" + sDefaultWhereSQL + ")";
        }
        return sWhereSQL;
    }

    private String getDefaultWhereSQL() throws WCMException {
        String sSearchTable = this.getSearchTableName();
        if (sSearchTable == null || sSearchTable.length() == 0) {
            return "";
        }
        String sSearchKey = this.getSearchKey();
        if (sSearchKey == null || sSearchKey.length() == 0) {
            return "";
        }
        String sSearchValue = this.getSearchValue();
        if (sSearchValue == null || sSearchValue.length() == 0) {
            return "";
        }
        StringTokenizer stKeys = new StringTokenizer(sSearchKey, ",");
        String sWhere = "";
        boolean bFirst = true;
        String[] searchTables = CMyString.split(sSearchTable, ",");
        while (stKeys.hasMoreTokens()) {
            String sKey = stKeys.nextToken();
            for (int i = 0; i < searchTables.length; ++i) {
                if (bFirst) {
                    sWhere = this.getSingleWhereSQL(searchTables[i], sKey, sSearchValue);
                    bFirst = sWhere.length() == 0;
                    continue;
                }
                String temp = this.getSingleWhereSQL(sSearchTable, sKey, sSearchValue);
                if (temp.length() <= 0) continue;
                sWhere = sWhere + " or " + temp;
            }
        }
        return sWhere;
    }

    private String getSingleWhereSQL(String _sDBTableName, String _sFieldName, String _sSearchValue) throws WCMException {
        String sSearchValue = CMyString.filterForSQL(_sSearchValue);
        sSearchValue = sSearchValue.replaceAll("(?i)([;'\n\r\\-]).*", "");
        DBManager dbManager = DBManager.getDBManager();
        FieldInfo currFieldInfo = dbManager.getFieldInfo(_sDBTableName, _sFieldName);
        if (currFieldInfo == null) {
            return "";
        }
        switch (currFieldInfo.getDataType().getType()) {
            case 4: 
            case 6: {
                return _sFieldName + "=" + sSearchValue;
            }
            case 91: {
                return "";
            }
            case 2005: {
                return this.getDBManager().getDBType().sqlFilterForClob(_sFieldName, sSearchValue);
            }
        }
        return _sFieldName + " like '%" + sSearchValue + "%'";
    }

    public String getOrderSQL() throws WCMException {
        if (this.getOrderField() == null || this.getOrderField().length() == 0) {
            return "";
        }
        if (this.getOrderType() == null || this.getOrderType().length() == 0) {
            return "";
        }
        String sOrderSQL = this.getOrderField() + " " + this.getOrderType();
        return CMyString.filterForSQL(sOrderSQL);
    }

    protected DBManager getDBManager() throws WCMException {
        DBManager currDBManager = DBManager.getDBManager();
        if (currDBManager == null || !currDBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(RequestHelper.class, "RequestHelper.label15", "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        if (!currDBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(RequestHelper.class, "RequestHelper.label16", "DBManaer\u6ca1\u6709\u542f\u52a8\uff01"));
        }
        return currDBManager;
    }

    public void handleOpReports(String _sResponseUrl, Reports _currReports) throws Exception {
        if (_sResponseUrl == null || _sResponseUrl.trim().length() <= 0) {
            throw new WCMException(10, I18NMessage.get(RequestHelper.class, "RequestHelper.label17", "\u4f20\u5165\u54cd\u5e94Reports\u7684URL\u5730\u5740\u65e0\u6548\uff01"));
        }
        if (_currReports == null) {
            throw new WCMException(10, I18NMessage.get(RequestHelper.class, "RequestHelper.label18", "\u64cd\u4f5c\u6267\u884c\u4e0d\u6210\u529f\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u64cd\u4f5c\u6267\u884c\u7ed3\u679c\u62a5\u544a\uff01"));
        }
        if (!RequestHelper.validURL(_sResponseUrl)) {
            throw new WCMException(10, "\u4f20\u5165\u54cd\u5e94Reports\u7684URL[" + _sResponseUrl + "]\u5730\u5740\u4e0d\u5408\u6cd5\uff01");
        }
        this.m_oRequest.setAttribute("OperReports", (Object)_currReports);
        this.m_oRequest.getRequestDispatcher(_sResponseUrl).forward((ServletRequest)this.m_oRequest, (ServletResponse)this.m_oResponse);
    }

    public Reports getReports() {
        return (Reports)this.m_oRequest.getAttribute("OperReports");
    }

    public void forward(String _sURL) throws Exception {
        if (_sURL == null) {
            throw new WCMException(10, I18NMessage.get(RequestHelper.class, "RequestHelper.label19", "\u64cd\u4f5c\u6267\u884c\u4e0d\u6210\u529f\uff0c\u4f20\u5165\u7a7a\u7684URL\u5b57\u7b26\u4e32\uff01"));
        }
        if (!RequestHelper.validURL(_sURL)) {
            throw new WCMException(10, "\u4f20\u5165\u54cd\u5e94Reports\u7684URL[" + _sURL + "]\u5730\u5740\u4e0d\u5408\u6cd5\uff01");
        }
        RequestDispatcher rd = this.m_oRequest.getRequestDispatcher(_sURL);
        if (rd == null) {
            throw new WCMException(1100, I18NMessage.get(RequestHelper.class, "RequestHelper.label20", "\u64cd\u4f5c\u6267\u884c\u4e0d\u6210\u529f\uff0c\u6ca1\u6709\u627e\u5230\u8df3\u8f6c\u5230[]\u7684RequestDispatcher"));
        }
        rd.forward((ServletRequest)this.m_oRequest, (ServletResponse)this.m_oResponse);
    }

    private static boolean validURL(String sUrl) {
        if (sUrl.toLowerCase().indexOf("web-inf") != -1) {
            return false;
        }
        String sURLFileName = CMyUrl.extractFileName(sUrl);
        String sFileExt = CMyFile.extractFileExt(sURLFileName);
        return "jsp".equalsIgnoreCase(sFileExt);
    }

    public String getServerName() {
        return this.m_oRequest.getServerName();
    }

    public int getServerPort() {
        return this.m_oRequest.getServerPort();
    }

    public void sendRedirect(String url) throws Exception {
        String urlWithPara = url + "?" + this.realParameters2QueryString();
        this.m_oRequest.setAttribute("RedirectUrl", (Object)urlWithPara);
        this.forward("../tools/custom_page_redirect.jsp");
    }

    public String realParameters2QueryString() throws WCMException {
        if (!this.m_bParsed) {
            this.doValid();
        }
        String sResult = "";
        Enumeration enKeys = this.m_hParameterValue.keys();
        Object oKey = null;
        boolean bNotFirst = false;
        while (enKeys.hasMoreElements()) {
            Object oValue;
            oKey = enKeys.nextElement();
            if (oKey.toString().equalsIgnoreCase("PageMaxCount") && !this.existPageMaxCount() || this.m_oRequest.getParameter(oKey.toString()) == null || (oValue = this.m_hParameterValue.get(oKey)) == null) continue;
            if (bNotFirst) {
                sResult = sResult + "&";
            } else {
                bNotFirst = true;
                sResult = "";
            }
            sResult = sResult + oKey.toString() + "=" + CMyString.URLEncode(oValue.toString());
        }
        return sResult;
    }
}

