/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.ExtendedField;
import com.trs.cms.content.ExtendedFields;
import com.trs.cms.content.WCMSystemObject;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.DataType;

public class ContentExtField
extends CMSObj {
    private ExtendedField m_extfield;
    public static final int OBJ_TYPE = 1319922479;
    public static final String DB_TABLE_NAME = "WCMCONTENTEXTFIELD";
    public static final String DB_ID_NAME = "CONTENTEXTFIELDID";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 1319922479;
    }

    public int getObjId() {
        return this.getPropertyAsInt("OBJID", 0);
    }

    public boolean setObjId(int _nObjId) throws WCMException {
        return this.setProperty("OBJID", _nObjId);
    }

    public int getObjType() {
        return this.getPropertyAsInt("OBJTYPE", 0);
    }

    public boolean setObjType(int _nObjType) throws WCMException {
        return this.setProperty("OBJTYPE", _nObjType);
    }

    public String getDesc() {
        return this.getPropertyAsString("LOGICFIELDDESC");
    }

    public boolean setDesc(String _sLogicFieldDesc) throws WCMException {
        return this.setProperty("LOGICFIELDDESC", _sLogicFieldDesc);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("OBJID") == null) {
                throw new WCMException(1106, I18NMessage.get(ContentExtField.class, "ContentExtField.label1", "\u5c5e\u6027ObjId\u6ca1\u6709\u8bbe\u7f6e(ContentExtField.isValid)"));
            }
            if (this.getProperty("OBJTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(ContentExtField.class, "ContentExtField.label2", "\u5c5e\u6027ObjType\u6ca1\u6709\u8bbe\u7f6e(ContentExtField.isValid)"));
            }
            if (this.getProperty("EXTFIELDID") == null) {
                throw new WCMException(1106, I18NMessage.get(ContentExtField.class, "ContentExtField.label3", "\u5c5e\u6027ExtFieldId\u6ca1\u6709\u8bbe\u7f6e(ContentExtField.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(ContentExtField.class, "ContentExtField.label4", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(ContentExtField.isValid)"));
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            if (this.getProperty("EXTFIELDID") == null) {
                ExtendedField field = this.findExtfield(_currUser);
                if (field == null) {
                    this.m_extfield.save(_currUser);
                    this.setExtFieldId(this.m_extfield.getId());
                } else {
                    this.setExtFieldId(field.getId());
                }
            }
            if (this.logicFieldExists()) {
                String msg = "";
                try {
                    msg = msg + this.getHost();
                }
                catch (Exception e) {
                    msg = msg + I18NMessage.get(ContentExtField.class, "ContentExtField.label5", "\u5bf9\u8c61[Id=") + this.getObjId() + ",Type=" + this.getObjType() + "]";
                }
                msg = msg + I18NMessage.get(ContentExtField.class, "ContentExtField.label6", "\u4e0b\u5df2\u7ecf\u5b58\u5728[") + this.getExtendedField() + "]!";
                throw new WCMException(1100, msg);
            }
            super.insert(_currUser);
        }
    }

    private boolean logicFieldExists() throws WCMException {
        String sWhere = " ObjId=" + this.getObjId() + " AND ObjType=" + this.getObjType() + " AND ExtFieldId=" + this.getExtFieldId();
        return this.checkExists(sWhere);
    }

    private ExtendedField findExtfield(User _user) throws WCMException {
        String sWhere = "FieldName='" + CMyString.filterForSQL(this.m_extfield.getName()) + "' AND TableName='" + CMyString.filterForSQL(this.m_extfield.getTableName()) + "'";
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        aFilter.setMaxRowNumber(1);
        ExtendedFields fields = new ExtendedFields(_user);
        fields.open(aFilter);
        if (fields.isEmpty()) {
            return null;
        }
        return (ExtendedField)fields.getAt(0);
    }

    public String getTableName() {
        return this.getExtendedField().getTableName();
    }

    public boolean setTableName(String _tableName) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(ContentExtField.class, "ContentExtField.label7", "\u5c5e\u6027TableName\u4e0d\u5141\u8bb8\u4fee\u6539"));
        }
        if (_tableName == null) {
            throw new WCMException(10, I18NMessage.get(ContentExtField.class, "ContentExtField.label8", "\u6307\u5b9a\u7684\u8868\u540d\u79f0\u4e3a\u7a7a"));
        }
        _tableName = _tableName.toUpperCase();
        if (this.getDBManager().getTableInfo(_tableName) == null) {
            throw new WCMException(10, I18NMessage.get(ContentExtField.class, "ContentExtField.label9", "\u6307\u5b9a\u7684\u6570\u636e\u8868") + _tableName + I18NMessage.get(ContentExtField.class, "ContentExtField.label10", "\u4e0d\u5b58\u5728!"));
        }
        return this.getExtendedField().setTableName(_tableName);
    }

    public String getName() {
        return this.getExtendedField().getName();
    }

    public boolean setName(String _sName) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(ContentExtField.class, "ContentExtField.label11", "\u5c5e\u6027Name\u4e0d\u5141\u8bb8\u4fee\u6539\uff08ExtendedField.setName\uff09"));
        }
        return this.getExtendedField().setName(_sName);
    }

    public String getTypeName() {
        return this.getExtendedField().getTypeName();
    }

    public String getTypeDesc() throws WCMException {
        return this.getExtendedField().getTypeDesc();
    }

    public DataType getType() throws WCMException {
        return this.getExtendedField().getType();
    }

    public int getMaxLength() {
        return this.getExtendedField().getMaxLength();
    }

    public int getScale() {
        return this.getExtendedField().getScale();
    }

    public boolean isNullable() {
        return this.getExtendedField().isNullable();
    }

    public String getDefaultValue() {
        return this.getExtendedField().getDefaultValue();
    }

    public int getDefaultValueAsInt(int _nDefault) throws WCMException {
        return this.getExtendedField().getDefaultValueAsInt(_nDefault);
    }

    public boolean setType(String _typeName, int _maxLength) throws WCMException {
        return this.setType(_typeName, _maxLength, true, null);
    }

    public boolean setType(String _typeName, int _maxLength, boolean _bNullable, String _sDefaultValue) throws WCMException {
        return this.setType(_typeName, _maxLength, _bNullable, _sDefaultValue, 0);
    }

    public boolean setType(String _typeName, int _maxLength, boolean _bNullable, String _sDefaultValue, int _nScale) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(ContentExtField.class, "ContentExtField.label12", "\u5c5e\u6027Name\u4e0d\u5141\u8bb8\u4fee\u6539"));
        }
        if (_typeName == null) {
            throw new WCMException(10, I18NMessage.get(ContentExtField.class, "ContentExtField.label13", "\u6307\u5b9a\u5b57\u6bb5\u7c7b\u578b\u4e3a\u7a7a"));
        }
        if (_maxLength < 0) {
            throw new WCMException(10, I18NMessage.get(ContentExtField.class, "ContentExtField.label14", "\u6307\u5b9a\u6700\u5927\u957f\u5ea6\u5c0f\u4e8e0\uff1a") + _maxLength);
        }
        if (!_bNullable && _sDefaultValue == null) {
            throw new WCMException(10, I18NMessage.get(ContentExtField.class, "ContentExtField.label15", "\u975e\u7a7a\u5b57\u6bb5\u5fc5\u987b\u8bbe\u7f6e\u9ed8\u8ba4\u503c"));
        }
        DataType dataType = this.getDBManager().getDBType().getDataType(_typeName);
        if (dataType == null) {
            throw new WCMException(10, I18NMessage.get(ContentExtField.class, "ContentExtField.label16", "\u65e0\u6548\u7684\u6570\u636e\u7c7b\u578b\uff1a") + _typeName);
        }
        int nLengthLimit = dataType.getMaxLength();
        if (!dataType.isLengthDefinedByUser()) {
            _maxLength = nLengthLimit;
        } else if (_maxLength > nLengthLimit) {
            throw new WCMException(10, I18NMessage.get(ContentExtField.class, "ContentExtField.label17", "\u6700\u5927\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7") + nLengthLimit);
        }
        return this.getExtendedField().setType(_typeName, _maxLength, _bNullable, _sDefaultValue, _nScale);
    }

    @Override
    public String getAttribute() {
        return this.getExtendedField().getAttribute();
    }

    @Override
    public boolean setAttribute(String _attribute) throws WCMException {
        return this.getExtendedField().setAttribute(_attribute);
    }

    public static final ContentExtField findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        ContentExtField field = (ContentExtField)BaseObj.findById(ContentExtField.class, _nId);
        if (field == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(_nId), WCMTypes.getLowerObjName(1319922479)}));
        }
        return field;
    }

    public static final ContentExtField createNewInstance() {
        return new ContentExtField();
    }

    public static final ContentExtField findByKey(Object _oKey) throws WCMException {
        ContentExtField contentExtField = (ContentExtField)BaseObj.findByKey(ContentExtField.class, _oKey);
        return contentExtField;
    }

    public int getExtFieldId() {
        return this.getPropertyAsInt("EXTFIELDID", 0);
    }

    public CMSObj getHost() throws WCMException {
        int nHostId = this.getObjId();
        switch (this.getObjType()) {
            case 103: {
                WebSite currSite = WebSite.findById(nHostId);
                if (currSite == null) {
                    throw new WCMException(I18NMessage.get(ContentExtField.class, "ContentExtField.label18", "\u6307\u5b9a\u7684\u7ad9\u70b9[ID=") + nHostId + I18NMessage.get(ContentExtField.class, "ContentExtField.label19", "]\u4e0d\u5b58\u5728\uff01"));
                }
                return currSite;
            }
            case 101: {
                Channel currChannel = Channel.findById(nHostId);
                if (currChannel == null) {
                    throw new WCMException(I18NMessage.get(ContentExtField.class, "ContentExtField.label20", "\u6307\u5b9a\u7684\u680f\u76ee[ID=") + nHostId + I18NMessage.get(ContentExtField.class, "ContentExtField.label19", "]\u4e0d\u5b58\u5728\uff01"));
                }
                return currChannel;
            }
            case 605: {
                String SQL_QUERY_CHANNEL_ID = "select DocChannel from WCMDocument where DocId=?";
                int nChannelId = DBManager.getDBManager().sqlExecuteIntQuery("select DocChannel from WCMDocument where DocId=?", new int[]{nHostId});
                Channel docChannel = Channel.findById(nChannelId);
                if (docChannel == null) {
                    throw new WCMException(I18NMessage.get(ContentExtField.class, "ContentExtField.label21", "\u6307\u5b9a\u7684\u6587\u6863[ID=") + nHostId + I18NMessage.get(ContentExtField.class, "ContentExtField.label22", "]\u7684\u6240\u5c5e\u9891\u9053\u4e0d\u5b58\u5728\uff01"));
                }
                return docChannel;
            }
            case 1: {
                return new WCMSystemObject(nHostId);
            }
        }
        throw new WCMException(I18NMessage.get(ContentExtField.class, "ContentExtField.label23", "\u672a\u77e5\u5bf9\u8c61\u7c7b\u578b[ObjType=") + this.getObjType() + "]");
    }

    private boolean setExtFieldId(int _nExtFieldId) throws WCMException {
        return this.setProperty("EXTFIELDID", _nExtFieldId);
    }

    private ExtendedField getExtendedField() {
        if (this.m_extfield == null) {
            if (this.isAddMode()) {
                this.m_extfield = new ExtendedField();
            } else {
                try {
                    this.m_extfield = ExtendedField.findById(this.getExtFieldId());
                }
                catch (WCMException e) {
                    throw new RuntimeException(e);
                }
                if (this.m_extfield == null) {
                    throw new RuntimeException(I18NMessage.get(ContentExtField.class, "ContentExtField.label24", "\u6307\u5b9a\u6269\u5728\u5b57\u6bb5\u4e0d\u5b58\u5728![ID=" + this.getExtFieldId() + "]"));
                }
            }
        }
        return this.m_extfield;
    }

    @Override
    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getName();
        }
        return this.getName() + I18NMessage.get(ContentExtField.class, "ContentExtField.label25", "[\u6269\u5c55\u5b57\u6bb5-") + this.getId() + "]";
    }

    public boolean setExtFieldProperty(String _sName, String _attribute) throws WCMException {
        return this.getExtendedField().setProperty(_sName, _attribute);
    }

    public String getExtFieldProperty(String _sName) throws WCMException {
        return this.getExtendedField().getPropertyAsString(_sName);
    }
}

