/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.wcm.content.domain.IDocumentsTimeRangeMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DebugTimer;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import org.apache.log4j.Logger;

public class DocumentsGetHelper {
    private static final String REG_CONTAINS_WCMDOCUMENT = "(?ism).*WCMDOCUMENT.*";
    private static Logger logger = Logger.getLogger(DocumentsGetHelper.class);
    private static IDocumentsTimeRangeMgr m_oTimeRangeMgr = null;

    public static Documents getDocuments(Channel _channel, WCMFilter _filter) throws WCMException {
        return DocumentsGetHelper.getDocuments(_channel, _filter, true);
    }

    public static Documents getDocuments(Channel _channel, WCMFilter _filter, boolean _bIncludeOrder) throws WCMException {
        WCMFilter filter = DocumentsGetHelper.makeChannelFilter(_channel, _filter, _bIncludeOrder, false);
        filter.setForceFirstLoadIds(true);
        return Documents.openWCMObjs(null, filter);
    }

    public static WCMFilter makeChannelFilter(Channel _channel, WCMFilter _filter) throws WCMException {
        return DocumentsGetHelper.makeChannelFilter(_channel, _filter, false, false);
    }

    public static WCMFilter makeChannelFilter(Channel _channel, WCMFilter _filter, boolean _bIncludeOrder, boolean _bFromRecycle) throws WCMException {
        return DocumentsGetHelper.makeChannelFilter(_channel, _filter, _bIncludeOrder, _bFromRecycle, 0);
    }

    public static WCMFilter makeChannelFilter(Channel _channel, WCMFilter _filter, boolean _bIncludeOrder, boolean _bFromRecycle, int _nTrueChannelId) throws WCMException {
        String sOrder;
        if (m_oTimeRangeMgr == null) {
            m_oTimeRangeMgr = (IDocumentsTimeRangeMgr)DreamFactory.createObjectById("IDocumentsTimeRangeMgr");
        }
        if (DocumentsGetHelper.isQueryInDocument(_filter, _channel)) {
            return DocumentsGetHelper.makeChannelFilterInDocument(_channel, _filter, _bIncludeOrder, _bFromRecycle, _nTrueChannelId);
        }
        StringBuffer buff = new StringBuffer();
        String sQuery = _channel.getQuery();
        boolean bInCurrChannelSearch = !_channel.isOnlySearch();
        boolean bAppendChannelLimit = false;
        if (bInCurrChannelSearch) {
            buff.append("CHNLID=?");
            bAppendChannelLimit = true;
        }
        if (sQuery != null && sQuery.trim().length() > 0) {
            buff.append(bAppendChannelLimit ? " and (" : "(").append(sQuery).append(')');
        }
        String sWhere = buff.toString();
        buff.setLength(0);
        String sUperCaseWhere = sWhere.toUpperCase();
        if (sUperCaseWhere.indexOf("SRCCHNLID=0") >= 0) {
            sWhere = sUperCaseWhere = CMyString.replaceStr(sUperCaseWhere, "SRCCHNLID=0", "MODAL=1");
        }
        if (sUperCaseWhere.indexOf("WCMDOCUMENT.DOCID=WCMCHNLDOC.DOCID") >= 0) {
            sWhere = sUperCaseWhere = CMyString.replaceStr(sUperCaseWhere, "WCMDOCUMENT.DOCID=WCMCHNLDOC.DOCID", "1=1");
        }
        String sExtraWhere = null;
        if (_filter != null && _filter.getWhere() != null && (sExtraWhere = _filter.getWhere().trim().toUpperCase()).length() == 0) {
            sExtraWhere = null;
        }
        if ((sExtraWhere == null || sExtraWhere.indexOf("DOCSTATUS") < 0) && sUperCaseWhere.indexOf("DOCSTATUS") < 0) {
            buff.append(_bFromRecycle ? " (DOCSTATUS<0 or Modal<0 or DocChannel<0)" : " DOCSTATUS>0 and Modal>0 and DocChannel>0");
        } else {
            buff.append(_bFromRecycle ? " (Modal<0 or DocChannel<0)" : " Modal>0 and DocChannel>0");
        }
        if ((sExtraWhere == null || sExtraWhere.indexOf("CHNLID") < 0) && sUperCaseWhere.indexOf("CHNLID") < 0) {
            buff.append(_bFromRecycle ? "" : " and CHNLID>0");
        }
        sWhere = sWhere + " AND (" + buff.toString() + ")";
        if (_bIncludeOrder) {
            sOrder = _channel.getOrderBy();
            if (!(sOrder != null && sOrder.trim().length() != 0 || (sOrder = _channel.getSite().getOrderBy()) != null && sOrder.trim().length() != 0)) {
                sOrder = "DOCORDERPRI desc, DocOrder desc";
            }
        } else {
            sOrder = "";
        }
        WCMFilter aFilter = new WCMFilter("WCMCHNLDOC", sWhere, sOrder);
        if (bInCurrChannelSearch) {
            aFilter.addSearchValues(_channel.getId());
        }
        aFilter.mergeWith(_filter);
        CMyDateTime dtStartTime = m_oTimeRangeMgr.getStartDateTime(_channel.getId());
        if (dtStartTime != null) {
            sWhere = aFilter.getWhere();
            if (sWhere.length() > 0) {
                sWhere = sWhere + " and ";
            }
            sWhere = sWhere + "CrTime >= ?";
            aFilter.setWhere(sWhere);
            int nIndex = 0;
            if (aFilter.getSearchValues() != null) {
                nIndex = aFilter.getSearchValues().size();
            }
            aFilter.addSearchValues(nIndex, dtStartTime);
        }
        return aFilter;
    }

    private static WCMFilter makeChannelFilterInDocument(Channel _channel, WCMFilter _filter, boolean _bIncludeOrder, boolean _bFromRecycle, int _nTrueChannelId) throws WCMException {
        String sOrder;
        boolean bInCurrChannelSearch;
        StringBuffer buff = new StringBuffer();
        buff.append("WCMDocument.DocId=WCMChnlDoc.DocId");
        String sQuery = _channel.getQuery();
        boolean bl = bInCurrChannelSearch = !_channel.isOnlySearch();
        if (bInCurrChannelSearch) {
            buff.append(" and WCMChnlDoc.CHNLID=?");
        }
        if (sQuery != null && sQuery.trim().length() > 0) {
            buff.append(" AND (").append(sQuery).append(')');
        }
        String sWhere = buff.toString();
        buff.setLength(0);
        String sUperCaseWhere = sWhere.toUpperCase();
        if (sUperCaseWhere.indexOf("SRCCHNLID=0") >= 0) {
            sWhere = sUperCaseWhere = CMyString.replaceStr(sUperCaseWhere, "SRCCHNLID=0", "MODAL=1");
        }
        String sExtraWhere = null;
        if (_filter != null && _filter.getWhere() != null && (sExtraWhere = _filter.getWhere().trim().toUpperCase()).length() == 0) {
            sExtraWhere = null;
        }
        if ((sExtraWhere == null || sExtraWhere.indexOf("DOCSTATUS") < 0) && sUperCaseWhere.indexOf("DOCSTATUS") < 0) {
            buff.append(_bFromRecycle ? " ( WCMChnlDoc.DOCSTATUS<0 or WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : " WCMChnlDoc.DOCSTATUS>0 and WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        } else {
            buff.append(_bFromRecycle ? "( WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : "WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        }
        if ((sExtraWhere == null || sExtraWhere.indexOf("CHNLID") < 0) && sUperCaseWhere.indexOf("CHNLID") < 0) {
            buff.append(_bFromRecycle ? "" : " and WCMChnlDoc.CHNLID>0");
        }
        sWhere = sWhere + " AND (" + buff.toString() + ")";
        if (_bIncludeOrder) {
            WebSite site;
            sOrder = _channel.getOrderBy();
            if (!(sOrder != null && sOrder.trim().length() != 0 || (site = _channel.getSite()) != null && (sOrder = site.getOrderBy()) != null && sOrder.trim().length() != 0)) {
                sOrder = "WCMChnlDoc.DOCORDERPRI desc, WCMChnlDoc.DocOrder desc";
            }
        } else {
            sOrder = "";
        }
        int nSearchParamIndex = 0;
        WCMFilter aFilter = null;
        IMetaViewEmployerMgr m_oMetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
        Channel currChannel = Channel.findById(_nTrueChannelId);
        MetaView view = null;
        if (currChannel != null) {
            view = m_oMetaViewEmployerMgr.getViewOfEmployer(currChannel);
        }
        aFilter = view != null ? new WCMFilter("WCMChnlDoc,WCMDocument," + view.getTrueTableName(), sWhere, sOrder) : new WCMFilter("WCMCHNLDOC,WCMDocument", sWhere, sOrder);
        if (bInCurrChannelSearch) {
            aFilter.addSearchValues(nSearchParamIndex++, _channel.getId());
        }
        aFilter.mergeWith(_filter);
        CMyDateTime dtStartTime = m_oTimeRangeMgr.getStartDateTime(_channel.getId());
        if (dtStartTime != null) {
            sWhere = aFilter.getWhere();
            if (sWhere.length() > 0) {
                sWhere = sWhere + " and ";
            }
            sWhere = sWhere + "WCMDocument.CrTime >= ?";
            aFilter.setWhere(sWhere);
            int nIndex = 0;
            if (aFilter.getSearchValues() != null) {
                nIndex = aFilter.getSearchValues().size();
            }
            aFilter.addSearchValues(nIndex, dtStartTime);
        }
        return aFilter;
    }

    public static WCMFilter makeFilter(WebSite _site, WCMFilter _extraFilter, boolean _bIncludeOrder, boolean _bFromRecycle) {
        CMyDateTime dtStartTime;
        if (DocumentsGetHelper.isQueryInDocument(_extraFilter, null)) {
            return DocumentsGetHelper.makeFilterInDocument(_site, _extraFilter, _bIncludeOrder, _bFromRecycle);
        }
        WCMFilter aFilter = new WCMFilter("WCMCHNLDOC", null, null);
        String sWhere = "exists(Select WCMChannel.ChannelId from WCMChannel where " + (_bFromRecycle ? "(WCMChnlDoc.CHNLID=WCMChannel.ChannelId or WCMChnlDoc.CHNLID=-WCMChannel.ChannelId)" : "WCMChnlDoc.CHNLID=WCMChannel.ChannelId") + " and SiteId=?)";
        String sExtraWhere = null;
        if (_extraFilter != null && _extraFilter.getWhere() != null && (sExtraWhere = _extraFilter.getWhere().trim().toUpperCase()).length() == 0) {
            sExtraWhere = null;
        }
        StringBuffer buff = new StringBuffer(sWhere.length() + 40);
        buff.append(sWhere);
        if (sExtraWhere == null || sExtraWhere.indexOf("DOCSTATUS") < 0) {
            buff.append(_bFromRecycle ? " and (DocStatus<0 or Modal<0 or DocChannel<0 or ChnlId<0)" : " and DOCSTATUS>0 and Modal>0 and DocChannel>0");
        } else {
            buff.append(_bFromRecycle ? " and (Modal<0 or DocChannel<0 or ChnlId<0)" : " and Modal>0 and DocChannel>0");
        }
        aFilter.setWhere(buff.toString());
        aFilter.addSearchValues(_site.getId());
        String sOrder = _bIncludeOrder ? "CrTime Desc" : "";
        aFilter.setOrder(sOrder);
        aFilter.mergeWith(_extraFilter);
        if (m_oTimeRangeMgr == null) {
            m_oTimeRangeMgr = (IDocumentsTimeRangeMgr)DreamFactory.createObjectById("IDocumentsTimeRangeMgr");
        }
        if ((dtStartTime = m_oTimeRangeMgr.getStartDateTime(_site.getId(), 103)) != null) {
            sWhere = aFilter.getWhere();
            if (sWhere.length() > 0) {
                sWhere = sWhere + " and ";
            }
            sWhere = sWhere + "CrTime >= ?";
            aFilter.setWhere(sWhere);
            aFilter.addSearchValues(dtStartTime);
        }
        return aFilter;
    }

    private static WCMFilter makeFilterInDocument(WebSite _site, WCMFilter _extraFilter, boolean _bIncludeOrder, boolean _bFromRecycle) {
        CMyDateTime dtStartTime;
        WCMFilter aFilter = new WCMFilter("WCMCHNLDOC,WCMDOCUMENT", null, null);
        String sWhere = "exists(Select WCMChannel.ChannelId from WCMChannel where " + (_bFromRecycle ? "(WCMChnlDoc.CHNLID=WCMChannel.ChannelId or WCMChnlDoc.CHNLID=-WCMChannel.ChannelId)" : "WCMChnlDoc.CHNLID=WCMChannel.ChannelId") + " and SiteId=?) and WCMChnlDoc.DocId=WCMDocument.DocId";
        String sExtraWhere = null;
        if (_extraFilter != null && _extraFilter.getWhere() != null && (sExtraWhere = _extraFilter.getWhere().trim().toUpperCase()).length() == 0) {
            sExtraWhere = null;
        }
        StringBuffer buff = new StringBuffer(sWhere.length() + 40);
        buff.append(sWhere);
        if (sExtraWhere == null || sExtraWhere.indexOf("DOCSTATUS") < 0) {
            buff.append(_bFromRecycle ? " and (WCMChnlDoc.DOCSTATUS<0 or WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0 or WCMChnlDoc.ChnlId<0)" : " and WCMChnlDoc.DOCSTATUS>0 and WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        } else {
            buff.append(_bFromRecycle ? " and (WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0 or WCMChnlDoc.ChnlId<0)" : " and WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        }
        aFilter.setWhere(buff.toString());
        aFilter.addSearchValues(_site.getId());
        String sOrder = _bIncludeOrder ? "WCMChnlDoc.CrTime Desc" : "";
        aFilter.setOrder(sOrder);
        aFilter.mergeWith(_extraFilter);
        if (m_oTimeRangeMgr == null) {
            m_oTimeRangeMgr = (IDocumentsTimeRangeMgr)DreamFactory.createObjectById("IDocumentsTimeRangeMgr");
        }
        if ((dtStartTime = m_oTimeRangeMgr.getStartDateTime(_site.getId(), 103)) != null) {
            sWhere = aFilter.getWhere();
            if (sWhere.length() > 0) {
                sWhere = sWhere + " and ";
            }
            sWhere = sWhere + "WCMChnlDoc.CrTime >= ?";
            aFilter.setWhere(sWhere);
            aFilter.addSearchValues(dtStartTime);
        }
        return aFilter;
    }

    public static WCMFilter makeFilter(WebSites _sites, WCMFilter _extraFilter, boolean _bIncludeOrder, boolean _bFromRecycle) {
        if (_sites == null || _sites.isEmpty()) {
            return null;
        }
        if (_sites.size() == 1) {
            return DocumentsGetHelper.makeFilter((WebSite)_sites.getAt(0), _extraFilter, _bIncludeOrder, _bFromRecycle);
        }
        if (DocumentsGetHelper.isQueryInDocument(_extraFilter, null)) {
            return DocumentsGetHelper.makeFilterInDocument(_sites, _extraFilter, _bIncludeOrder, _bFromRecycle);
        }
        WCMFilter aFilter = new WCMFilter("WCMCHNLDOC", null, null);
        StringBuffer sbWhere = new StringBuffer(300 + _sites.size() * 2);
        sbWhere.append("exists(Select WCMChannel.ChannelId from WCMChannel where WCMChnlDoc.CHNLID=WCMChannel.ChannelId and SiteId in(?");
        aFilter.addSearchValues(_sites.getIdAt(0));
        int nSize = _sites.size();
        for (int i = 1; i < nSize; ++i) {
            sbWhere.append(",?");
            aFilter.addSearchValues(_sites.getIdAt(i));
        }
        sbWhere.append("))");
        sbWhere.append(_bFromRecycle ? " and (DocChannel<0 or Modal<0)" : " and DocChannel>0");
        String sExtraWhere = null;
        if (_extraFilter != null && _extraFilter.getWhere() != null && (sExtraWhere = _extraFilter.getWhere().trim().toUpperCase()).length() == 0) {
            sExtraWhere = null;
        }
        if (sExtraWhere == null || sExtraWhere.indexOf("DOCSTATUS") < 0) {
            sbWhere.append(_bFromRecycle ? " and DOCSTATUS<0" : " and DOCSTATUS>0");
        }
        aFilter.setWhere(sbWhere.toString());
        String sOrder = _bIncludeOrder ? "CrTime Desc" : "";
        aFilter.setOrder(sOrder);
        aFilter.mergeWith(_extraFilter);
        return aFilter;
    }

    private static WCMFilter makeFilterInDocument(WebSites _sites, WCMFilter _extraFilter, boolean _bIncludeOrder, boolean _bFromRecycle) {
        WCMFilter aFilter = new WCMFilter("WCMCHNLDOC,WCMDOCUMENT", null, null);
        StringBuffer sbWhere = new StringBuffer(300 + _sites.size() * 2);
        sbWhere.append("exists(Select WCMChannel.ChannelId from WCMChannel where WCMChnlDoc.CHNLID=WCMChannel.ChannelId and SiteId in(?");
        aFilter.addSearchValues(_sites.getIdAt(0));
        int nSize = _sites.size();
        for (int i = 1; i < nSize; ++i) {
            sbWhere.append(",?");
            aFilter.addSearchValues(_sites.getIdAt(i));
        }
        sbWhere.append(")) and WCMChnlDoc.DocId=WCMDocument.DocId");
        String sExtraWhere = null;
        if (_extraFilter != null && _extraFilter.getWhere() != null && (sExtraWhere = _extraFilter.getWhere().trim().toUpperCase()).length() == 0) {
            sExtraWhere = null;
        }
        if (sExtraWhere == null || sExtraWhere.indexOf("DOCSTATUS") < 0) {
            sbWhere.append(_bFromRecycle ? " and (WCMChnlDoc.DOCSTATUS<0 or WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : " and WCMChnlDoc.DOCSTATUS>0 and WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        } else {
            sbWhere.append(_bFromRecycle ? " and (WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : " and WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        }
        aFilter.setWhere(sbWhere.toString());
        String sOrder = _bIncludeOrder ? "WCMChnlDoc.CrTime Desc" : "";
        aFilter.setOrder(sOrder);
        aFilter.mergeWith(_extraFilter);
        return aFilter;
    }

    public static WCMFilter makeChannelFilter(Channels _channels, WCMFilter _filter, boolean _bFromRecycle) throws WCMException {
        if (_channels.isEmpty()) {
            return null;
        }
        if (_channels.size() == 1) {
            return DocumentsGetHelper.makeChannelFilter((Channel)_channels.getAt(0), _filter, true, _bFromRecycle);
        }
        if (DocumentsGetHelper.isQueryInDocument(_filter, null)) {
            return DocumentsGetHelper.makeChannelFilterInDocument(_channels, _filter, _bFromRecycle);
        }
        String DEFAULT_WHERE = _bFromRecycle ? "(WCMChnlDoc.DocStatus<0 or WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : "WCMChnlDoc.DocChannel>0 and WCMChnlDoc.DocStatus>0 and WCMChnlDoc.Modal>0";
        WCMFilter filter = new WCMFilter("", "", "");
        StringBuffer sbWhere = new StringBuffer(_channels.size() * 2 + DEFAULT_WHERE.length() + 16);
        if (!_channels.isEmpty()) {
            sbWhere.append("ChnlId in(");
        }
        int nSize = _channels.size();
        for (int i = 0; i < nSize; ++i) {
            if (i > 0) {
                sbWhere.append(",");
            }
            sbWhere.append("?");
            filter.addSearchValues(_channels.getIdAt(i));
        }
        if (!_channels.isEmpty()) {
            sbWhere.append(") and ");
        }
        sbWhere.append(DEFAULT_WHERE);
        filter.setWhere(sbWhere.toString());
        filter.mergeWith(_filter);
        return filter;
    }

    private static WCMFilter makeChannelFilterInDocument(Channels _channels, WCMFilter _filter, boolean _bFromRecycle) {
        String DEFAULT_WHERE = (_bFromRecycle ? " (WCMChnlDoc.DocStatus<0 or WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : " WCMChnlDoc.DocStatus>0 and WCMChnlDoc.DocChannel>0 and WCMChnlDoc.Modal>0") + " and WCMDocument.DocId=WCMChnlDoc.DocId";
        WCMFilter filter = new WCMFilter("WCMChnlDoc,WCMDocument", "", "");
        StringBuffer sbWhere = new StringBuffer(_channels.size() * 2 + DEFAULT_WHERE.length() + 16);
        if (!_channels.isEmpty()) {
            sbWhere.append("WCMChnlDoc.ChnlId in(");
        }
        int nSize = _channels.size();
        for (int i = 0; i < nSize; ++i) {
            if (i > 0) {
                sbWhere.append(",");
            }
            sbWhere.append("?");
            filter.addSearchValues(_channels.getIdAt(i));
        }
        if (!_channels.isEmpty()) {
            sbWhere.append(") and ");
        }
        sbWhere.append(DEFAULT_WHERE);
        filter.setWhere(sbWhere.toString());
        filter.mergeWith(_filter);
        return filter;
    }

    private static boolean isQueryInDocument(WCMFilter _filter, Channel _channel) {
        if (_filter != null) {
            if (_filter.getWhere() != null && _filter.getWhere().matches(REG_CONTAINS_WCMDOCUMENT)) {
                return true;
            }
            if (_filter.getOrder() != null && _filter.getOrder().matches(REG_CONTAINS_WCMDOCUMENT)) {
                return true;
            }
            if (_filter.getSelect() != null && _filter.getSelect().matches(REG_CONTAINS_WCMDOCUMENT)) {
                return true;
            }
        }
        if (_channel == null) {
            return false;
        }
        String sQuery = _channel.getQuery();
        if (sQuery != null && sQuery.matches(REG_CONTAINS_WCMDOCUMENT)) {
            return true;
        }
        String sOrder = _channel.getOrderBy();
        return sOrder != null && sOrder.matches(REG_CONTAINS_WCMDOCUMENT);
    }

    public static void main(String[] args) {
        String[] pPath = new String[]{"D:\\YHIntranet\\webapps\\wcm\\wcm_use\\", "D:\\YHIntranet\\webapps\\wcm\\test\\", "D:\\YHIntranet\\webapps\\wcm\\temp\\"};
        for (int i = 0; i < pPath.length; ++i) {
            System.out.println(I18NMessage.get(DocumentsGetHelper.class, "DocumentsGetHelper.label1", "\u76ee\u5f55:") + pPath[i] + "<BR>");
            FileService file = new FileService(pPath[i]);
            FileStore[] pFiles = file.listFiles();
            for (int j = 0; j < pFiles.length; ++j) {
                if (pFiles[j].getName().indexOf("jsp") > 0) {
                    System.out.println(I18NMessage.get(DocumentsGetHelper.class, "DocumentsGetHelper.label2", "\u6587\u4ef6:") + pFiles[j].getName());
                }
                if (!pFiles[j].isDirectory()) continue;
                System.out.println(I18NMessage.get(DocumentsGetHelper.class, "DocumentsGetHelper.label1", "\u76ee\u5f55:") + pFiles[j].getName());
            }
        }
        try {
            DebugTimer timer = new DebugTimer();
            Documents newDocuments = null;
            WCMFilter filter = new WCMFilter();
            filter.setMaxRowNumber(1);
            WCMFilter chnlFilter = new WCMFilter("", "", "ChannelId");
            Channels channels = Channels.openWCMObjs(null, chnlFilter);
            int nSize = channels.size();
            for (int i = 0; i < nSize; ++i) {
                Channel channel = (Channel)channels.getAt(i);
                if (channel == null) continue;
                timer.start();
                try {
                    newDocuments = DocumentsGetHelper.getDocuments(channel, filter);
                }
                catch (Throwable ex) {
                    logger.error((Object)("[" + channel + I18NMessage.get(DocumentsGetHelper.class, "DocumentsGetHelper.label4", "]\u51fa\u73b0\u5f02\u5e38!")), ex);
                }
                timer.stop();
                if (timer.getTime() > 2000L) {
                    logger.info((Object)("Long!!! get [" + channel + "] documents use[" + timer.getTime() + "]ms [" + newDocuments.size() + "] SQL:" + newDocuments.getFilter().toSQL()));
                }
                newDocuments.clear();
            }
        }
        catch (Exception ex) {
            logger.error((Object)I18NMessage.get(DocumentsGetHelper.class, "DocumentsGetHelper.label5", "\u6d4b\u8bd5\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)ex);
        }
    }
}

