/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.calendar;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.calendar.Event;
import com.trs.components.common.calendar.EventShare;
import com.trs.components.common.calendar.EventShares;
import com.trs.components.common.calendar.Events;
import com.trs.components.common.message.Message;
import com.trs.components.common.message.MsgReceiver;
import com.trs.components.common.message.MsgReceivers;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;

public class EventMgr {
    private static final int EVENTSHARER_TYPE_ALL = -1;

    public Event save(Event _anEvent) throws WCMException {
        if (_anEvent == null) {
            throw new WCMException(10, I18NMessage.get(EventMgr.class, "EventMgr.label1", "\u65e0\u6548\u7684Event\u5bf9\u8c61,\u65e0\u6cd5\u5b8c\u6210\u4fdd\u5b58!"));
        }
        _anEvent.save(ContextHelper.getLoginUser());
        return _anEvent;
    }

    public boolean delete(Event _anEvent) throws WCMException {
        if (_anEvent == null) {
            throw new WCMException(10, I18NMessage.get(EventMgr.class, "EventMgr.label2", "\u65e0\u6548\u7684Event\u5bf9\u8c61,\u65e0\u6cd5\u5220\u9664!"));
        }
        this.cancelShares(_anEvent);
        return _anEvent.delete(ContextHelper.getLoginUser()) == 1;
    }

    public Events getDailyEvents(CMyDateTime _date, WCMFilter _filter) throws WCMException {
        User currUser = ContextHelper.getLoginUser();
        if (currUser == null) {
            throw new WCMException(1001, I18NMessage.get(EventMgr.class, "EventMgr.label3", "\u7528\u6237\u672a\u767b\u5f55\u6216\u767b\u5f55\u8d85\u65f6!"));
        }
        if (_date == null || _date.isNull()) {
            throw new WCMException(10, I18NMessage.get(EventMgr.class, "EventMgr.label4", "\u65e0\u6548\u7684\u65e5\u671f,\u65e0\u6cd5\u83b7\u53d6\u5f53\u65e5\u7684\u65e5\u7a0b\u5b89\u6392"));
        }
        StringBuffer sbWhere = new StringBuffer("Owner='");
        sbWhere.append(CMyString.filterForSQL(currUser.getName()));
        sbWhere.append("' AND ");
        this.setDateZoneSql(_date, sbWhere);
        WCMFilter aFilter = new WCMFilter("", sbWhere.toString(), "EventId desc");
        aFilter.mergeWith(_filter);
        return Events.openWCMObjs(currUser, aFilter);
    }

    private void setDateZoneSql(CMyDateTime _date, StringBuffer sbWhere) throws WCMException {
        String[] sDateZone = this.getDateZone(_date);
        sbWhere.append("EStart<=");
        sbWhere.append(sDateZone[0]);
        sbWhere.append(" AND ");
        sbWhere.append("EEnd>=");
        sbWhere.append(sDateZone[1]);
    }

    public Events getEvents(User _currUser, CMyDateTime _date, boolean _bIncludingShared, WCMFilter _filter) throws WCMException {
        if (_currUser == null) {
            throw new WCMException(10, I18NMessage.get(EventMgr.class, "EventMgr.label5", "\u65e0\u6548\u7684\u5f53\u524d\u7528\u6237!"));
        }
        if (_date == null || _date.isNull()) {
            throw new WCMException(10, I18NMessage.get(EventMgr.class, "EventMgr.label4", "\u65e0\u6548\u7684\u65e5\u671f,\u65e0\u6cd5\u83b7\u53d6\u5f53\u65e5\u7684\u65e5\u7a0b\u5b89\u6392"));
        }
        int currUserId = _currUser.getId();
        StringBuffer sbWhere = new StringBuffer();
        this.setDateZoneSql(_date, sbWhere);
        sbWhere.append(" AND (");
        if (_bIncludingShared) {
            StringBuffer sbShareWhere = new StringBuffer();
            sbShareWhere.append("(OBJID=");
            sbShareWhere.append(currUserId);
            sbShareWhere.append(" AND OBJTYPE=");
            sbShareWhere.append(204);
            sbShareWhere.append(")");
            sbShareWhere.append(" OR ");
            sbShareWhere.append("(OBJTYPE=");
            sbShareWhere.append(201);
            sbShareWhere.append(" AND EXISTS(");
            sbShareWhere.append(" SELECT ");
            sbShareWhere.append("GROUPID");
            sbShareWhere.append(" FROM ");
            sbShareWhere.append("WCMGRPUSER");
            sbShareWhere.append(" GrpUser WHERE ");
            sbShareWhere.append("USERID");
            sbShareWhere.append("=");
            sbShareWhere.append(currUserId);
            sbShareWhere.append(" AND ");
            sbShareWhere.append("GrpUser.");
            sbShareWhere.append("GROUPID");
            sbShareWhere.append("=");
            sbShareWhere.append("WCMEVENTSHARE.OBJID");
            sbShareWhere.append(")");
            sbShareWhere.append(")");
            EventShares pools = EventShares.openWCMObjs(_currUser, new WCMFilter("", sbShareWhere.toString(), ""));
            String sIds = ",";
            for (int i = 0; i < pools.size(); ++i) {
                EventShare pool = (EventShare)pools.getAt(i);
                if (pool == null) continue;
                sIds = sIds + pool.getEventId() + ",";
            }
            if (sIds.length() > 1) {
                sbWhere.append("EVENTID");
                sbWhere.append(" IN (");
                sbWhere.append(sIds.substring(1, sIds.length() - 1));
                sbWhere.append(")");
                sbWhere.append(" OR ");
            }
        }
        sbWhere.append("Owner='");
        sbWhere.append(CMyString.filterForSQL(_currUser.getName()));
        sbWhere.append("'");
        sbWhere.append(")");
        WCMFilter aFilter = new WCMFilter("", sbWhere.toString(), "");
        aFilter.mergeWith(_filter);
        return this.getEvents(aFilter);
    }

    private String[] getDateZone(CMyDateTime _date) throws WCMException {
        String[] dateZone = new String[2];
        String sDate = CMyDateTime.getStr(_date, "yyyy-MM-dd");
        dateZone[0] = this.getDBManager().getDBType().sqlDateTime(sDate + " 23:59:59", "YYYY-MM-DD HH24:MI:SS");
        dateZone[1] = this.getDBManager().getDBType().sqlDateTime(sDate + " 00:00:00", "YYYY-MM-DD HH24:MI:SS");
        return dateZone;
    }

    public Users getUsers(Event _anEvent) throws WCMException {
        if (_anEvent == null || !_anEvent.isShared()) {
            return Users.createNewInstance(ContextHelper.getLoginUser());
        }
        String sWhere = "EXISTS (SELECT ObjId FROM WCMEVENTSHARE WHERE ObjType=204 AND EventId=" + _anEvent.getId() + " AND WCMEVENTSHARE.OBJID=WCMUSER.USERID )";
        WCMFilter aFilter = new WCMFilter("WCMUSER", sWhere, "");
        return Users.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public Groups getGroups(Event _anEvent) throws WCMException {
        if (_anEvent == null || !_anEvent.isShared()) {
            return Groups.createNewInstance(ContextHelper.getLoginUser());
        }
        String sWhere = "EXISTS (SELECT ObjId FROM WCMEVENTSHARE WHERE ObjType=201 AND EventId=" + _anEvent.getId() + " AND WCMEVENTSHARE.OBJID=WCMGROUP.GROUPID )";
        WCMFilter aFilter = new WCMFilter("WCMGROUP", sWhere, "");
        return Groups.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public Events getEvents(WCMFilter _filter) throws WCMException {
        WCMFilter aFilter = new WCMFilter("WCMEVENT", "", "Estart desc");
        aFilter.mergeWith(_filter);
        return Events.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public void shareTo(Event _anEvent, CMSObj _cmsObj) throws WCMException {
        if (_anEvent == null) {
            throw new WCMException(10, I18NMessage.get(EventMgr.class, "EventMgr.label6", "\u65e0\u6548\u7684Event\u5bf9\u8c61,\u65e0\u6cd5\u5171\u4eab!"));
        }
        if (!this.isValidSharer(_cmsObj)) {
            throw new WCMException(10, I18NMessage.get(EventMgr.class, "EventMgr.label7", "\u4e0d\u6b63\u786e\u7684\u5171\u4eab\u8005\u7c7b\u578b!"));
        }
        int nSharerId = _cmsObj.getId();
        int nSharerType = _cmsObj.getWCMType();
        EventShare anEventShare = this.getEventShare(_anEvent.getId(), nSharerId, nSharerType);
        if (anEventShare != null) {
            return;
        }
        anEventShare = EventShare.createNewInstance();
        anEventShare.setEventId(_anEvent.getId());
        anEventShare.setObjId(nSharerId);
        anEventShare.setObjType(nSharerType);
        anEventShare.insert(ContextHelper.getLoginUser());
        if (!_anEvent.isShared()) {
            _anEvent.canEdit(ContextHelper.getLoginUser());
            _anEvent.setShare(true);
            _anEvent.save(ContextHelper.getLoginUser());
        }
        this.addMsgReceivers(_anEvent, _cmsObj);
    }

    private void addMsgReceivers(Event _anEvent, CMSObj _cmsObj) throws WCMException {
        Message aMsg = Message.findById(_anEvent.getRemindMsgId());
        if (aMsg == null) {
            return;
        }
        int nObjId = _cmsObj.getId();
        int nObjType = _cmsObj.getWCMType();
        String sName = "";
        if (nObjType == 204) {
            sName = ((User)_cmsObj).getName();
        }
        if (nObjType == 201) {
            sName = ((Group)_cmsObj).getName();
        }
        if (nObjType == 203) {
            sName = ((Role)_cmsObj).getName();
        }
        WCMFilter aFilter = new WCMFilter("", "MsgId=" + aMsg.getId() + " and ReceiverId=" + nObjId + " and ReceiverType=" + nObjType, "");
        aFilter.setMaxRowNumber(1);
        MsgReceivers receivers = MsgReceivers.openWCMObjs(aFilter);
        if (!receivers.isEmpty()) {
            return;
        }
        MsgReceiver newReceiver = MsgReceiver.createNewInstance();
        newReceiver.setMsgId(aMsg.getId());
        newReceiver.setReceiverId(nObjId);
        newReceiver.setReceiverType(nObjType);
        newReceiver.setReceiverName(sName);
        newReceiver.insert();
    }

    private void removeMsgReceivers(Event _anEvent, CMSObj _cmsObj) throws WCMException {
        Message aMsg = Message.findById(_anEvent.getRemindMsgId());
        if (aMsg == null) {
            return;
        }
        String sWhere = "MsgId=" + aMsg.getId();
        if (_cmsObj != null) {
            int nObjId = _cmsObj.getId();
            int nObjType = _cmsObj.getWCMType();
            sWhere = sWhere + " and ReceiverId=" + nObjId + " and ReceiverType=" + nObjType;
        } else {
            User crUser = _anEvent.getCrUser();
            if (crUser != null) {
                sWhere = sWhere + " and not(ReceiverId=" + crUser.getId() + " and ReceiverType=" + crUser.getWCMType() + ")";
            }
        }
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        MsgReceivers receivers = MsgReceivers.openWCMObjs(aFilter);
        if (receivers.isEmpty()) {
            return;
        }
        receivers.removeAll();
    }

    private boolean isValidSharer(CMSObj _cmsObj) {
        if (_cmsObj == null) {
            return false;
        }
        return 204 == _cmsObj.getWCMType() || 201 == _cmsObj.getWCMType();
    }

    public void cancelShare(Event _anEvent, CMSObj _cmsObj) throws WCMException {
        if (_anEvent == null) {
            throw new WCMException(10, I18NMessage.get(EventMgr.class, "EventMgr.label8", "\u65e0\u6548\u7684Event\u5bf9\u8c61!"));
        }
        if (!_anEvent.isShared()) {
            return;
        }
        if (!this.isValidSharer(_cmsObj)) {
            return;
        }
        EventShare share = this.getEventShare(_anEvent.getId(), _cmsObj.getId(), _cmsObj.getWCMType());
        if (share == null) {
            return;
        }
        this.removeMsgReceivers(_anEvent, _cmsObj);
        share.delete(ContextHelper.getLoginUser());
    }

    private EventShare getEventShare(int _nEventId, int _nObjId, int _nObjType) throws WCMException {
        StringBuffer sbWhere = new StringBuffer("EventId=");
        sbWhere.append(_nEventId);
        sbWhere.append(" AND ObjId=");
        sbWhere.append(_nObjId);
        sbWhere.append(" AND ObjType=");
        sbWhere.append(_nObjType);
        WCMFilter aFilter = new WCMFilter("WCMEVENTSHARE", sbWhere.toString(), "", "EVENTSHAREID", 1);
        EventShares shares = EventShares.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
        if (shares.isEmpty()) {
            return null;
        }
        return (EventShare)shares.getAt(0);
    }

    public void cancelShares(Event _anEvent) throws WCMException {
        if (_anEvent == null) {
            throw new WCMException(10, I18NMessage.get(EventMgr.class, "EventMgr.label8", "\u65e0\u6548\u7684Event\u5bf9\u8c61!"));
        }
        if (!_anEvent.isShared()) {
            return;
        }
        EventShares eventShares = this.getEventShares(_anEvent.getId(), -1);
        eventShares.removeAll();
        this.removeMsgReceivers(_anEvent, null);
        _anEvent.canEdit(ContextHelper.getLoginUser());
        _anEvent.setShare(false);
        _anEvent.update(ContextHelper.getLoginUser());
    }

    EventShares getEventShares(int _nEventId, int _nSharerType) throws WCMException {
        String sWhere = "EventId=" + _nEventId;
        if (-1 != _nSharerType) {
            sWhere = sWhere + " AND ObjType=" + _nSharerType;
        }
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        EventShares eventShares = EventShares.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
        return eventShares;
    }

    protected DBManager getDBManager() throws WCMException {
        DBManager currDBManager = DBManager.getDBManager();
        if (currDBManager == null || !currDBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(EventMgr.class, "EventMgr.label9", "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        if (!currDBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(EventMgr.class, "EventMgr.label10", "DBManaer\u6ca1\u6709\u542f\u52a8\uff01"));
        }
        return currDBManager;
    }
}

