/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.exception.IdMException;
import com.trs.idm.util.JMSUtil;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.log4j.Logger;

public class JMSConsumerProvider {
    private Connection connection;
    private Session session;
    private static final Logger logger = Logger.getLogger(JMSConsumerProvider.class);

    public MessageConsumer createConsumer(String factoryName, String className, String connectionUrl, String connectionQueueName) {
        JMSUtil.releaseConnection(this.connection, this.session);
        try {
            this.connection = JMSUtil.getJNDIConnection(factoryName, className, connectionUrl);
            this.connection.start();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("succeed to get connection from connectionUrl [" + connectionUrl + "] by factoryName [" + factoryName + "] with className [" + className + "]"));
            }
        }
        catch (IdMException e) {
            logger.error((Object)("failed to get connection from connectionUrl [" + connectionUrl + "] by factoryName [" + factoryName + "] with className [" + className + "]"), (Throwable)e);
            return null;
        }
        catch (Throwable t) {
            logger.error((Object)("failed to get connection from connectionUrl [" + connectionUrl + "] by factoryName [" + factoryName + "] with className [" + className + "]"), t);
            return null;
        }
        Destination destination = null;
        try {
            this.session = this.connection.createSession(true, 1);
            destination = JMSUtil.getDestination(factoryName, className, connectionUrl, connectionQueueName);
            if (destination == null) {
                logger.info((Object)("destination is null by connectionUrl [" + connectionUrl + "] by factoryName [" + factoryName + "] with className [" + className + "], createQueue as default from session [" + this.session + "]."));
                destination = this.session.createQueue(connectionQueueName);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("succeed to create session [" + this.session + "] ,and get destination [" + destination + "] from connection [" + this.connection + "] with connectionQueueName [" + connectionQueueName + "]."));
            }
        }
        catch (JMSException e) {
            logger.error((Object)("failed to create session or get destination from connection [" + this.connection + "],with connectionQueueName [" + connectionQueueName + "]"), (Throwable)e);
            return null;
        }
        catch (Throwable t) {
            logger.error((Object)("failed to create session or get destination from connection [" + this.connection + "],with connectionQueueName [" + connectionQueueName + "]"), t);
            return null;
        }
        try {
            return this.createConsumer(destination);
        }
        catch (Throwable t) {
            logger.error((Object)("failed to create consumer from session [" + this.session + "] by destination [" + destination + "]"), t);
            return null;
        }
    }

    private MessageConsumer createConsumer(Destination destination) {
        MessageConsumer consumer = null;
        try {
            consumer = this.session.createConsumer(destination);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("succeed to create consumer by session [" + this.session + "], from destination [" + destination + "]"));
            }
        }
        catch (JMSException e) {
            logger.error((Object)("failed to create consumer by session [" + this.session + "], from destination [" + destination + "]"), (Throwable)e);
        }
        return consumer;
    }
}

