/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.protocol;

import com.trs.idm.interact.protocol.AbstractPU;
import com.trs.idm.interact.protocol.PacketUtil;
import com.trs.idm.interact.protocol.ProtocolPacket;
import com.trs.idm.interact.protocol.RequestPacket;
import com.trs.idm.interact.protocol.ResponsePacket;
import com.trs.idm.util.StringHelper;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;

class JDK13PUImpl
extends AbstractPU {
    private static final Logger LOG = Logger.getLogger(JDK13PUImpl.class);

    JDK13PUImpl() {
    }

    byte[] convertPacketHead2Bytes(short bodyLen, byte type, short packetID, byte cmdOrErrcode, byte encryptAlgo, byte reversed1, byte reversed2, byte processCmd) {
        byte[] headBytes = new byte[]{73, 80, 80, 73, 2, 0, (byte)(bodyLen >> 8), (byte)(bodyLen % 256), type, (byte)(packetID >> 8), (byte)(packetID % 256), cmdOrErrcode, encryptAlgo, reversed1, reversed2, processCmd};
        return headBytes;
    }

    short parseBodyLength(byte[] data) {
        if (data == null || data.length < 16) {
            throw new IllegalArgumentException("the bytes is null, or its length < 16");
        }
        byte lenHi = data[6];
        short lenLo = data[7];
        short remain = lenLo < 0 ? (short)(256 + lenLo) : lenLo;
        return (short)((lenHi << 8) + remain);
    }

    byte[] short2Bytes(short value) {
        byte[] result = new byte[]{(byte)(value >> 8), (byte)(value & 0xFF)};
        return result;
    }

    byte[] stringArray2PacketBodyBytes(String[] body, short bodyLen) {
        boolean PROTOCOL_MAJ_OLD_VER = true;
        return this.stringArray2PacketBodyBytes(body, bodyLen, (byte)1, null);
    }

    ProtocolPacket parseFromBytes(byte[] data) {
        if (data == null) {
            LOG.warn((Object)"data=null! skip and return null!");
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("packetData=" + StringHelper.toString(data)));
        }
        if (data.length < 16) {
            LOG.error((Object)"protocol datas < 16", (Throwable)new Exception());
            throw new RuntimeException("protocol datas < 16");
        }
        byte type = data[8];
        short bodyLen = PacketUtil.parseBodyLength(data);
        byte majorVersion = data[4];
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("packetType=" + type + ", bodyLen=" + bodyLen + ", majorVersion[" + majorVersion + "]"));
        }
        byte[] bodyDatas = new byte[bodyLen];
        System.arraycopy(data, 16, bodyDatas, 0, bodyDatas.length);
        if (type == 0) {
            byte cmd = data[11];
            return new RequestPacket(cmd, bodyDatas, majorVersion, null);
        }
        if (type == 1) {
            byte errcode = data[11];
            byte processCmd = data[15];
            return new ResponsePacket(errcode, bodyDatas, processCmd, majorVersion);
        }
        LOG.error((Object)("invalid packet type! type=" + type));
        return null;
    }

    byte[] stringArray2PacketBodyBytes(String[] body, short bodyLen, byte majorVersion, String idmServerCharset) {
        String charsetName = PacketUtil.getCharsetName(majorVersion, idmServerCharset);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("get charsetName[" + charsetName + "] by majorVersion[" + majorVersion + "]"));
        }
        byte[] bodyBytes = new byte[bodyLen];
        int dstPos = 0;
        int i = 0;
        while (i < body.length) {
            try {
                if (body[i] == null) {
                    body[i] = "";
                }
                byte[] temp = body[i].getBytes(charsetName);
                System.arraycopy(temp, 0, bodyBytes, dstPos, temp.length);
                dstPos += temp.length;
                temp = "\n\r".getBytes(charsetName);
                System.arraycopy(temp, 0, bodyBytes, dstPos, temp.length);
                dstPos += temp.length;
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Object)("UnsupportedEncoding[" + charsetName + "] by majorVersion[" + majorVersion + "]"));
            }
            ++i;
        }
        return bodyBytes;
    }
}

