/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

import com.trs.dev4.jdk16.exception.WrappedException;
import com.trs.dev4.jdk16.utils.AssertUtil;
import com.trs.dev4.jdk16.utils.ClassUtil;
import com.trs.dev4.jdk16.utils.CloseUtil;
import com.trs.dev4.jdk16.utils.FileUtil;
import de.schlichtherle.io.FileOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertyUtil {
    private static final Logger LOG = Logger.getLogger(PropertyUtil.class);
    public static final String PLACEHOLDER_PREFIX = "${";
    public static final String PLACEHOLDER_SUFFIX = "}";

    public static Properties loadProperties(String fileName) {
        if (fileName == null) {
            return new Properties();
        }
        return PropertyUtil.loadProperties(new File(fileName));
    }

    public static Properties loadProperties(File f) {
        Properties props;
        block6: {
            props = new Properties();
            if (f == null || !f.isFile()) {
                return props;
            }
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(f);
                    props.load(fis);
                }
                catch (Exception e) {
                    LOG.error((Object)("erron on load file: " + f), (Throwable)e);
                    CloseUtil.closeInputStream(fis);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                CloseUtil.closeInputStream(fis);
                throw throwable;
            }
            CloseUtil.closeInputStream(fis);
        }
        return props;
    }

    public static String loadProperty(File f, String key, String defaultValue) {
        Properties props = PropertyUtil.loadProperties(f);
        return props.getProperty(key, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadFromResource(Class clazz, String resName, String keyPrefix) {
        Properties props = PropertyUtil.assertAndLoadFromResource(clazz, resName);
        Properties result = new Properties();
        Properties properties = props;
        synchronized (properties) {
            int max = props.size() - 1;
            Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
            int i = 0;
            while (i <= max) {
                Map.Entry<Object, Object> e = it.next();
                String key = (String)e.getKey();
                if (key.startsWith(keyPrefix)) {
                    result.put(key, e.getValue());
                }
                ++i;
            }
        }
        return result;
    }

    public static int getPropertyAsInt(Properties props, String key, int defaultValue) {
        try {
            return PropertyUtil.assertAndGetAsInt(props, key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int assertAndGetAsInt(Properties props, String key) {
        String strValue = PropertyUtil.assertAndGet(props, key);
        AssertUtil.notNull(strValue, null);
        return Integer.parseInt(strValue.trim());
    }

    public static String assertAndGet(Properties props, String key) {
        AssertUtil.notNull(props, null);
        AssertUtil.notNull(key, null);
        return props.getProperty(key);
    }

    public static String getPropertyAsGBK(Properties props, String key) {
        return PropertyUtil.getPropertyAsGBK(props, key, "");
    }

    public static String getPropertyAsGBK(Properties props, String key, String defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String strValue = props.getProperty(key);
        if (strValue == null) {
            return defaultValue;
        }
        try {
            return new String(strValue.getBytes("ISO-8859-1"), "GBK");
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getTrimString(Properties props, String key, String defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String strValue = props.getProperty(key);
        if (strValue == null) {
            return defaultValue;
        }
        return (strValue = strValue.trim()).length() == 0 ? defaultValue : strValue;
    }

    public static String getTrimPlaceholdersString(Properties props, String key, String defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String text = props.getProperty(key);
        if (text == null) {
            return defaultValue;
        }
        StringBuffer buf = new StringBuffer(text);
        int startIndex = text.indexOf(PLACEHOLDER_PREFIX);
        while (startIndex != -1) {
            int endIndex = buf.toString().indexOf(PLACEHOLDER_SUFFIX, startIndex + PLACEHOLDER_PREFIX.length());
            if (endIndex != -1) {
                String placeholder = buf.substring(startIndex + PLACEHOLDER_PREFIX.length(), endIndex);
                String propVal = props.getProperty(placeholder);
                if (propVal != null) {
                    buf.replace(startIndex, endIndex + PLACEHOLDER_SUFFIX.length(), propVal);
                    startIndex = buf.toString().indexOf(PLACEHOLDER_PREFIX, startIndex + propVal.length());
                    continue;
                }
                LOG.warn((Object)("Could not resolve placeholder '" + placeholder + "' in [" + text + "]"));
                startIndex = buf.toString().indexOf(PLACEHOLDER_PREFIX, endIndex + PLACEHOLDER_SUFFIX.length());
                continue;
            }
            startIndex = -1;
        }
        return buf.toString().trim();
    }

    public static long getPropertyAsLong(Properties props, String key, long defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String strValue = props.getProperty(key);
        if (strValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(strValue.trim());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean getPropertyAsBool(Properties props, String key, boolean defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String strValue = props.getProperty(key);
        if (strValue == null || "".equals(strValue)) {
            return defaultValue;
        }
        try {
            return strValue.trim().equalsIgnoreCase("true");
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String[] getPropertyAsStrAry(Properties props, String key, String token) {
        if (props == null) {
            return null;
        }
        String value = props.getProperty(key);
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        return value.split(token);
    }

    public static float getPropertyAsFloat(Properties props, String key, float defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String strValue = props.getProperty(key);
        if (strValue == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(strValue.trim());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Properties props, String keyPrefix) {
        if (props == null || keyPrefix == null) {
            return "null! keyPrefix=" + keyPrefix;
        }
        String delit = ", ";
        int delitLen = ", ".length();
        StringBuffer sb = new StringBuffer(64);
        sb.append('{');
        Properties properties = props;
        synchronized (properties) {
            int max = props.size() - 1;
            Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
            int i = 0;
            while (i <= max) {
                Map.Entry<Object, Object> e = it.next();
                String key = (String)e.getKey();
                if (key.startsWith(keyPrefix)) {
                    sb.append(key).append('=').append(e.getValue());
                    sb.append(", ");
                }
                ++i;
            }
        }
        sb.delete(sb.length() > delitLen ? sb.length() - delitLen : 1, sb.length());
        sb.append('}');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getSubProperties(Properties props, String keyPrefix) {
        if (props == null || keyPrefix == null) {
            return props;
        }
        Properties result = new Properties();
        Properties properties = props;
        synchronized (properties) {
            int max = props.size() - 1;
            Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
            int i = 0;
            while (i <= max) {
                Map.Entry<Object, Object> e = it.next();
                String key = (String)e.getKey();
                if (key.startsWith(keyPrefix)) {
                    result.put(key, e.getValue());
                }
                ++i;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getTrimedSubProperties(Properties props, String keyPrefix) {
        if (props == null || keyPrefix == null) {
            return props;
        }
        Properties result = new Properties();
        Properties properties = props;
        synchronized (properties) {
            int max = props.size();
            Iterator<Object> it = props.keySet().iterator();
            int i = 0;
            while (i < max) {
                String value;
                String key = (String)it.next();
                if (key.startsWith(keyPrefix) && (value = props.getProperty(key)) != null) {
                    result.put(key, value.trim());
                }
                ++i;
            }
        }
        return result;
    }

    public static Properties assertAndLoadFromResource(Class<?> clazz, String resourcePath) {
        URL resUrl = ClassUtil.assertAndLocateResource(clazz, resourcePath);
        InputStream fis = null;
        try {
            fis = resUrl.openStream();
        }
        catch (IOException e) {
            throw new WrappedException("erron on url.openStream(), url=" + resUrl, e);
        }
        Properties props = new Properties();
        try {
            try {
                props.load(fis);
            }
            catch (IOException e) {
                throw new WrappedException("erron on load resource: " + resourcePath + ", url=" + resUrl, e);
            }
        }
        finally {
            CloseUtil.closeInputStream(fis);
        }
        return props;
    }

    public static Properties assertAndLoadFromXmlResource(Class<?> clazz, String resourcePath) {
        URL resUrl = ClassUtil.assertAndLocateResource(clazz, resourcePath);
        InputStream fis = null;
        try {
            fis = resUrl.openStream();
        }
        catch (IOException e) {
            throw new WrappedException("erron on url.openStream(), url=" + resUrl, e);
        }
        Properties props = new Properties();
        try {
            try {
                props.loadFromXML(fis);
            }
            catch (IOException e) {
                throw new WrappedException("erron on load resource: " + resourcePath + ", url=" + resUrl, e);
            }
        }
        finally {
            CloseUtil.closeInputStream(fis);
        }
        return props;
    }

    public static Properties loadFromXmlFile(File xmlFile) {
        Properties props;
        block6: {
            props = new Properties();
            if (xmlFile == null || !xmlFile.isFile()) {
                return props;
            }
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(xmlFile);
                    props.loadFromXML(fis);
                }
                catch (Exception e) {
                    LOG.error((Object)("erron on load file: " + xmlFile), (Throwable)e);
                    CloseUtil.closeInputStream(fis);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                CloseUtil.closeInputStream(fis);
                throw throwable;
            }
            CloseUtil.closeInputStream(fis);
        }
        return props;
    }

    public static Properties assertAndLoadFromResource(String resName) {
        return PropertyUtil.assertAndLoadFromResource(PropertyUtil.class, resName);
    }

    public static boolean getSysPropertyAsBool(String key) {
        return PropertyUtil.getPropertyAsBool(System.getProperties(), key, false);
    }

    public static void storeToXMLFile(Properties props, File file) {
        if (props == null || props.size() == 0) {
            return;
        }
        if (file == null) {
            throw new IllegalArgumentException("file is null!");
        }
        if (!file.exists()) {
            FileUtil.createNewFile(file);
        }
        FileOutputStream os = null;
        try {
            try {
                os = new FileOutputStream(file);
                props.storeToXML((OutputStream)os, null, "UTF-8");
            }
            catch (IOException e) {
                LOG.error((Object)("fail to store " + props.size() + " properties to " + file + "."), (Throwable)e);
                throw new WrappedException(e);
            }
        }
        catch (Throwable throwable) {
            CloseUtil.closeOutputStream(os);
            throw throwable;
        }
        CloseUtil.closeOutputStream((OutputStream)os);
    }
}

