/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.model.impl;

import com.trs.dev4.jdk16.dao.IAccessor;
import com.trs.dev4.jdk16.model.BaseManager;
import com.trs.dev4.jdk16.model.IEntity;
import com.trs.dev4.jdk16.utils.StringHelper;
import java.lang.reflect.ParameterizedType;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;

public class AnnoBaseManager<T extends IEntity>
extends BaseManager<T>
implements InitializingBean,
BeanFactoryAware {
    protected Logger logger = Logger.getLogger(this.getClass());
    private Class<T> classType;
    private BeanFactory beanFactory;

    public AnnoBaseManager() {
        this.setClassType((Class)((ParameterizedType)super.getClass().getGenericSuperclass()).getActualTypeArguments()[0]);
    }

    public AnnoBaseManager(Class<T> classType) {
        this.setClassType(classType);
    }

    @Override
    public int addNew(T t) {
        return super.addNew(t);
    }

    @Override
    public void delete(T t) {
        super.delete(t);
    }

    @Override
    public void saveOrUpdate(T t) {
        super.saveOrUpdate(t);
    }

    @Override
    public void update(T t) {
        super.update(t);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getAccessor() != null) {
            return;
        }
        if (this.beanFactory instanceof ListableBeanFactory) {
            ListableBeanFactory listBeanFactory = (ListableBeanFactory)this.beanFactory;
            Map beans = listBeanFactory.getBeansOfType(IAccessor.class);
            for (Object bean : beans.values()) {
                IAccessor accessor = (IAccessor)bean;
                if (!accessor.getClassType().equals(this.classType)) continue;
                this.setAccessor(accessor);
            }
            return;
        }
        String beanName = StringHelper.uncapitalize(this.classType.getName());
        Object bean = this.beanFactory.getBean(String.valueOf(beanName) + "DAO", IAccessor.class);
        if (bean == null) {
            return;
        }
        this.setAccessor((IAccessor)bean);
    }

    public void setClassType(Class<T> classType) {
        this.classType = classType;
    }

    public Class<T> getClassType() {
        return this.classType;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

