/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.exec;

import com.trs.dev4.jdk16.exception.ProcessException;
import com.trs.dev4.jdk16.exec.StreamRunner;
import com.trs.dev4.jdk16.utils.CollectionUtil;
import com.trs.dev4.jdk16.utils.EnvConst;
import com.trs.dev4.jdk16.utils.FileUtil;
import com.trs.dev4.jdk16.utils.RegexUtil;
import com.trs.dev4.jdk16.utils.StringHelper;
import com.trs.dev4.jdk16.utils.Substring;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ProcessHelper {
    private static final String PATTERN_SPACES = "\\s+";
    private String cmd;
    private int exitValue = Integer.MIN_VALUE;
    private Process process;
    private long startTime;
    private long endTime;
    private long endCallTime;
    private File workDir;
    private File actualWorkDir;
    private Map<String, String> env;
    private Map<String, String> actualEnv;
    private List<String> listStdout = new ArrayList<String>();
    private List<String> listStderr = new ArrayList<String>();
    private boolean omitOutput;
    private boolean showDetail;
    public static final String WINDOWS_CMD_PRIFEX = "cmd /c ";

    public ProcessHelper(String cmd) {
        this(cmd, null);
    }

    public ProcessHelper(String cmd, String strWorkDir) {
        if (cmd == null) {
            throw new IllegalArgumentException("cmd is null!");
        }
        if ((cmd = cmd.trim()).length() == 0) {
            throw new IllegalArgumentException("cmd is empty!");
        }
        this.cmd = cmd;
        this.prepare();
        this.workDir = StringHelper.isEmpty(strWorkDir) ? new File(FileUtil.getCurrentWorkingDir()) : new File(strWorkDir);
    }

    public long getEstimatedTimeMillis() {
        return this.endTime - this.startTime;
    }

    public List<String> getStdOut() {
        return this.listStdout;
    }

    public List<String> getStdErr() {
        return this.listStderr;
    }

    public void cancelProcess() {
        if (this.process == null) {
            return;
        }
        this.process.destroy();
    }

    private void prepare() {
        if (EnvConst.isWindows()) {
            this.cmd = WINDOWS_CMD_PRIFEX + this.cmd;
        }
    }

    int startAndWait() {
        this.startProcess();
        StreamRunner stdoutRunner = null;
        StreamRunner stderrRunner = null;
        if (!this.omitOutput) {
            stdoutRunner = new StreamRunner(this.process.getInputStream());
            stderrRunner = new StreamRunner(this.process.getErrorStream());
            stdoutRunner.start();
            stderrRunner.start();
        }
        try {
            try {
                this.exitValue = this.process.waitFor();
            }
            catch (InterruptedException e) {
                throw new ProcessException("the process [] interrupted, maybe by another thread!", e);
            }
        }
        finally {
            this.endCallTime = System.currentTimeMillis();
        }
        if (!this.omitOutput) {
            while (!stdoutRunner.isFinished() || !stderrRunner.isFinished()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.listStdout = stdoutRunner.getOutput();
            this.listStderr = stderrRunner.getOutput();
        }
        this.recordEndTime();
        return this.exitValue;
    }

    ProcessHelper startProcess() {
        List<String> lstCmd = ProcessHelper.parseCmd(this.cmd);
        ProcessBuilder pb = new ProcessBuilder(lstCmd);
        pb.directory(this.workDir);
        this.actualWorkDir = pb.directory();
        if (this.env != null) {
            Map<String, String> pbEnv = pb.environment();
            for (Map.Entry<String, String> entry : this.env.entrySet()) {
                pbEnv.put(entry.getKey(), entry.getValue());
            }
        }
        this.actualEnv = pb.environment();
        this.recordStartTime();
        try {
            this.process = pb.start();
            return this;
        }
        catch (IOException e) {
            throw new ProcessException(e);
        }
    }

    static List<String> parseCmd(String sCmd) {
        ArrayList<String> lstCmd = new ArrayList<String>();
        List<Substring> lstQuotes = RegexUtil.getSubstringsByQuote(sCmd);
        if (lstQuotes.size() == 0) {
            String[] arr = sCmd.split(PATTERN_SPACES);
            return Arrays.asList(arr);
        }
        int prevEnd = 0;
        for (Substring substring : lstQuotes) {
            String before = substring.getBefore(prevEnd);
            ProcessHelper.simpleSplitAndAddToList(before, lstCmd);
            lstCmd.add(StringHelper.trimQuote(substring.getValue()));
            prevEnd = substring.getEnd();
        }
        String substrAfterLastQuote = sCmd.substring(prevEnd);
        ProcessHelper.simpleSplitAndAddToList(substrAfterLastQuote, lstCmd);
        return lstCmd;
    }

    private static void simpleSplitAndAddToList(String str, List<String> lstCmd) {
        if (str == null || str.length() == 0) {
            return;
        }
        str = str.trim();
        String[] arr = str.split(PATTERN_SPACES);
        lstCmd.addAll(Arrays.asList(arr));
    }

    private void recordStartTime() {
        this.startTime = System.currentTimeMillis();
    }

    private void recordEndTime() {
        this.endTime = System.currentTimeMillis();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ProcessHelper [");
        builder.append("cmd=").append(this.cmd);
        builder.append(", exitValue=").append(this.exitValue);
        builder.append(", in ").append(this.workDir);
        if (this.hasErrorOutput()) {
            builder.append("; stderr has ").append(this.listStderr.size()).append(" lines, the last 2 line: ");
            builder.append(CollectionUtil.lastSublines(this.listStderr, 2));
        }
        if (this.hasStdOutput()) {
            builder.append("; stdout ").append(this.listStdout.size()).append(" lines");
        }
        builder.append("]");
        return builder.toString();
    }

    public boolean hasErrorOutput() {
        return this.listStderr != null && this.listStderr.size() > 0;
    }

    public boolean hasStdOutput() {
        return this.listStdout != null && this.listStdout.size() > 0;
    }

    public String getCmd() {
        return this.cmd;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    void dumpStaticis() {
        if (this.startTime == 0L) {
            System.out.println("The process (" + this.cmd + ") not start yet!");
            return;
        }
        System.out.println("The process: cmd: " + this.cmd);
        if (this.showDetail) {
            System.out.println("workDir: " + this.workDir + ", env:");
            for (String key : this.env.keySet()) {
                System.out.println(String.valueOf(key) + " = " + this.env.get(key));
            }
        }
        System.out.println("EstimatedTime: " + this.getEstimatedTimeMillis() + "ms. (start: " + this.startTime + ", endCall: " + this.endCallTime + ", end: " + this.endTime);
        System.out.println("ExitValue: " + this.getExitValue());
        System.out.println("StdOut: " + this.getStdOut());
        System.out.println("StdErr: " + this.getStdErr());
        System.out.println();
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    void setEnv(Map<String, String> env) {
        this.env = env;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public String sublinesOfStdout(int count) {
        return CollectionUtil.sublines(this.listStdout, count);
    }

    public String sublinesOfStderr(int count) {
        return CollectionUtil.sublines(this.listStderr, count);
    }

    public String lastSublinesOfStdout(int count) {
        return CollectionUtil.lastSublines(this.listStdout, count);
    }

    public String lastSublinesOdStderr(int count) {
        return CollectionUtil.lastSublines(this.listStderr, count);
    }

    public boolean isOmitOutput() {
        return this.omitOutput;
    }

    public void setOmitOutput(boolean omitOutput) {
        this.omitOutput = omitOutput;
    }

    public long getEndCallTime() {
        return this.endCallTime;
    }

    public File getActualWorkDir() {
        return this.actualWorkDir == null ? this.workDir : this.actualWorkDir;
    }

    public Map<String, String> getActualEnv() {
        return this.actualEnv == null ? this.env : this.actualEnv;
    }
}

