/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.security.dos;

import com.trs.dev4.security.dos.DosAttackJudger;
import com.trs.dev4.security.http.HttpServletRequestWrapper;
import com.trs.dev4.util.StringHelperInDev4CompJDK14;
import java.io.IOException;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DosAttackFilter
implements Filter {
    private static final Logger logger;
    private int timeUnit = 1;
    private int maxClickPerTimeUnit = 5;
    private String httpHeaderOfOriginalClientIp;
    private Set pathSet;
    private Set excludeIpSet;
    private String filterMode;
    private DosAttackJudger dosJudger;
    private int expiryTimeAsSecond;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.dev4.security.dos.DosAttackFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public void init(FilterConfig chain) throws ServletException {
        this.dosJudger = new DosAttackJudger();
        this.filterMode = chain.getInitParameter("mode");
        String timeUnitString = chain.getInitParameter("timeUnit");
        String maxClickPerTimeUnitString = chain.getInitParameter("maxClickPerTimeUnit");
        this.httpHeaderOfOriginalClientIp = chain.getInitParameter("httpHeaderOfOriginalClientIp");
        String pathString = chain.getInitParameter("path");
        String excludeIpString = chain.getInitParameter("excludeIp");
        String expiryTimeString = chain.getInitParameter("expiryTime");
        try {
            this.timeUnit = Integer.parseInt(timeUnitString);
        }
        catch (Throwable t) {
            logger.warn((Object)("error while convert timeUnitString[" + timeUnitString + "] to Integer"), t);
        }
        try {
            this.maxClickPerTimeUnit = Integer.parseInt(maxClickPerTimeUnitString);
        }
        catch (Throwable t) {
            logger.warn((Object)("error while convert maxClickPerSecondString[" + maxClickPerTimeUnitString + "] to Integer"), t);
        }
        try {
            this.expiryTimeAsSecond = Integer.parseInt(expiryTimeString);
        }
        catch (Throwable e) {
            logger.warn((Object)("error while convert expiryTimeString[" + expiryTimeString + "] to Integer"), e);
        }
        String[] pathArray = StringHelperInDev4CompJDK14.split(pathString, ";");
        this.pathSet = StringHelperInDev4CompJDK14.StringArrayToSet(pathArray);
        String[] excludeIpArray = StringHelperInDev4CompJDK14.split(excludeIpString, ";");
        this.excludeIpSet = StringHelperInDev4CompJDK14.StringArrayToSet(excludeIpArray);
        logger.info((Object)("filterMode: " + this.filterMode + ", timeUnit: " + this.timeUnit + ", maxClickPerTimeUnit: " + this.maxClickPerTimeUnit + ", httpHeaderOfOriginalClientIp: " + this.httpHeaderOfOriginalClientIp + "; pathSet: " + this.pathSet + ", excludeIpSet: " + this.excludeIpSet + ", expiryTimeAsSecond: " + this.expiryTimeAsSecond));
        this.dosJudger.setExpiryTime(this.expiryTimeAsSecond * 1000);
    }

    public void doFilter(ServletRequest srq, ServletResponse sresp, FilterChain chain) throws IOException, ServletException {
        if (!this.isEnable()) {
            chain.doFilter(srq, sresp);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)srq;
        HttpServletResponse response = (HttpServletResponse)sresp;
        HttpServletRequestWrapper requestWrapper = new HttpServletRequestWrapper(request);
        String currentPath = request.getServletPath();
        String clientIp = requestWrapper.getRemoteAddr(this.getHttpHeaderOfOrigialClientIp());
        logger.debug((Object)"");
        logger.debug((Object)"");
        logger.debug((Object)("Requesting path: " + currentPath + "; clientIp: " + clientIp));
        if (this.dosJudger.shouldPass(this.getPathSet(), this.getExcludeIpSet(), this.getFilterMode(), currentPath, clientIp)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.dosJudger.shouldDenyBySuspect(this.getTimeUnit(), this.getMaxClickPerTimeUnit(), clientIp)) {
            this.writeErrorMsgToResponse(response, "GBK", this.getHint());
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
        this.dosJudger.stop();
        this.dosJudger = null;
    }

    protected boolean isEnable() {
        return true;
    }

    protected void writeErrorMsgToResponse(HttpServletResponse response, String encoding, String hint) throws IOException {
        response.setCharacterEncoding(encoding);
        response.setContentType("text/html; charset=" + encoding);
        response.getWriter().write("<html><head>");
        response.getWriter().write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + encoding + "\" />");
        response.getWriter().write("<title>\u9519\u8bef\u4fe1\u606f\u63d0\u793a</title>");
        response.getWriter().write("</head>");
        response.getWriter().write("<body bgcolor=\"#F7F7F7\">");
        response.getWriter().write("<table width=\"100%\" height=\"100%\"  border=\"0\" cellpadding=\"0\" cellspacing=\"0\">");
        response.getWriter().write(" <tr><td><table width=\"600\"  border=\"0\" align=\"center\" cellpadding=\"20\" cellspacing=\"0\" style=\"border:4px solid #D4E2EE\">");
        response.getWriter().write("<tr><td align=\"center\"><p><br>");
        response.getWriter().write("<font color=\"#FF0000\"><b>" + hint + "</b></font></p>");
        response.getWriter().write("<p>&nbsp;</p><p>&nbsp;</p><div align=\"center\">");
        response.getWriter().write("<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" height=\"20\">");
        response.getWriter().write("<tr><td height=\"20\" align=\"right\"><b></b> </td></tr></table></div></td></tr></table></td></tr></table>");
        response.getWriter().write("</body>");
        response.getWriter().write("</html>");
        response.getWriter().close();
    }

    protected String getHint() {
        return "\u60a8\u8bbf\u95ee\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!";
    }

    protected String getHttpHeaderOfOrigialClientIp() {
        return this.httpHeaderOfOriginalClientIp;
    }

    protected Set getExcludeIpSet() {
        return this.excludeIpSet;
    }

    protected String getFilterMode() {
        return this.filterMode;
    }

    protected Set getPathSet() {
        return this.pathSet;
    }

    protected int getTimeUnit() {
        return this.timeUnit;
    }

    protected int getMaxClickPerTimeUnit() {
        return this.maxClickPerTimeUnit;
    }
}

