/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.session;

import com.trs.infra.cluster.Callbackable;
import com.trs.infra.cluster.ClusterContext;
import com.trs.infra.cluster.ClusterMessage;
import com.trs.infra.cluster.Member;
import com.trs.infra.cluster.ack.ACKMessage;
import com.trs.infra.cluster.io.FilterStreamWriter;
import com.trs.infra.cluster.session.Acknowledged;
import com.trs.infra.cluster.session.ClusterSession;
import com.trs.infra.cluster.session.ClusterSessionImpl;
import com.trs.infra.cluster.session.ClusterSessionListener;
import com.trs.infra.cluster.session.SessionManager;
import com.trs.infra.cluster.session.SessionMessage;
import com.trs.infra.cluster.session.SessionSynchronizer;
import com.trs.infra.session.Session;
import com.trs.infra.session.SessionContext;
import com.trs.infra.session.impl.StandardContextBase;
import com.trs.infra.session.impl.StandardSessionBase;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class SessionManagerImpl
extends StandardContextBase
implements SessionManager {
    private static final Logger s_logger;
    private static final int SYNCACK_MAX_WAIT = 5000;
    private ClusterContext clusterContext;
    private ClusterSessionListener[] clusterListeners;
    private final Object clusterListenersMutex = new Object();
    private SessionSynchronizer sessionSynchronizer;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.cluster.session.SessionManagerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    public final ClusterContext getClusterContext() {
        return this.clusterContext;
    }

    public final void setClusterContext(ClusterContext clusterContext) {
        this.clusterContext = clusterContext;
    }

    public void start() {
        super.start();
        this.syncSessions();
    }

    public void syncSessions() {
        this.sessionSynchronizer = new SessionSynchronizer();
        s_logger.info((Object)"To send sync broadcast");
        this.sendSyncBroadcast();
        if (this.sessionSynchronizer.getCount() > 0 && this.sessionSynchronizer.getMember() != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("To full sync session with '");
            sb.append(this.sessionSynchronizer.getMember());
            sb.append("', count=");
            sb.append(this.sessionSynchronizer.getCount());
            s_logger.info((Object)sb.toString());
            this.sendSyncRequest(this.sessionSynchronizer.getMember());
        } else {
            s_logger.info((Object)"No member response sync");
        }
        this.sessionSynchronizer = null;
    }

    protected StandardSessionBase newSession() {
        ClusterSessionImpl csi = new ClusterSessionImpl(this);
        csi.setPrimarySession(true);
        return csi;
    }

    public ClusterSessionImpl getClusterSession(String id) {
        return (ClusterSessionImpl)this.getSessionInternal(id);
    }

    protected void afterCreateSession(StandardSessionBase session) {
        this.sendSessionCreate((ClusterSessionImpl)session);
    }

    protected boolean beforeExpireSession(StandardSessionBase session) {
        ClusterSessionImpl clusterSession = (ClusterSessionImpl)session;
        if (clusterSession.getCalloverCount() >= 3) {
            return true;
        }
        clusterSession.incCalloverCount();
        this.sendCallover(clusterSession);
        return false;
    }

    protected void afterExpireSession(StandardSessionBase session) {
        if (!session.isDestroyed()) {
            this.sendSessionDelete(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ClusterSessionListener listener) {
        if (listener == null) {
            return;
        }
        Object object = this.clusterListenersMutex;
        synchronized (object) {
            ClusterSessionListener[] oldListeners = this.clusterListeners;
            ClusterSessionListener[] newListeners = null;
            if (oldListeners == null || oldListeners.length <= 0) {
                newListeners = new ClusterSessionListener[]{listener};
                this.clusterListeners = newListeners;
                return;
            }
            int oldLength = oldListeners.length;
            newListeners = new ClusterSessionListener[oldLength + 1];
            int oldIndex = 0;
            while (oldIndex < oldLength) {
                ClusterSessionListener tempListener = oldListeners[oldIndex];
                if (tempListener == listener) {
                    s_logger.warn((Object)("Duplicate ClusterSessionListener: " + listener));
                    return;
                }
                newListeners[oldIndex] = tempListener;
                ++oldIndex;
            }
            newListeners[oldLength] = listener;
            this.clusterListeners = newListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ClusterSessionListener listener) {
        if (listener == null) {
            return;
        }
        Object object = this.clusterListenersMutex;
        synchronized (object) {
            ClusterSessionListener[] oldListeners = this.clusterListeners;
            ClusterSessionListener[] newListeners = null;
            if (oldListeners == null || oldListeners.length <= 0) {
                return;
            }
            int oldLength = oldListeners.length;
            if (oldLength > 1) {
                newListeners = new ClusterSessionListener[oldLength - 1];
            }
            int oldIndex = 0;
            int newIndex = 0;
            while (oldIndex < oldLength) {
                ClusterSessionListener tempListener;
                if ((tempListener = oldListeners[oldIndex++]) == listener) continue;
                newListeners[newIndex++] = tempListener;
            }
            if (oldIndex > newIndex) {
                this.clusterListeners = newListeners;
            } else {
                s_logger.warn((Object)("ClusterSessionListener not exist: " + listener));
            }
        }
    }

    public SessionContext getSessionContext() {
        return this;
    }

    protected void fireSessionCreated(Session session) {
        super.fireSessionCreated(session);
        ClusterSessionImpl csi = (ClusterSessionImpl)session;
        if (csi.isPrimarySession()) {
            this.fireClusterSessionCreated(csi);
        }
    }

    private void fireClusterSessionCreated(ClusterSession session) {
        ClusterSessionListener[] listeners = this.clusterListeners;
        if (listeners == null || listeners.length <= 0) {
            return;
        }
        int length = listeners.length;
        int i = 0;
        while (i < length) {
            ClusterSessionListener listener = listeners[i];
            if (listener != null) {
                try {
                    listener.clusterSessionCreated(session);
                }
                catch (Throwable e) {
                    s_logger.error((Object)"Error on clusterSessionCreated", e);
                }
            }
            ++i;
        }
    }

    protected void fireSessionDestroyed(Session session) {
        super.fireSessionDestroyed(session);
        ClusterSessionImpl csi = (ClusterSessionImpl)session;
        if (csi.isPrimarySession()) {
            this.fireClusterSessionDestroyed(csi);
        }
    }

    private void fireClusterSessionDestroyed(ClusterSession session) {
        ClusterSessionListener[] listeners = this.clusterListeners;
        if (listeners == null || listeners.length <= 0) {
            return;
        }
        int length = listeners.length;
        int i = 0;
        while (i < length) {
            ClusterSessionListener listener = listeners[i];
            if (listener != null) {
                try {
                    listener.clusterSessionDestroyed(session);
                }
                catch (Throwable e) {
                    s_logger.error((Object)"Error on clusterSessionDestroyed", e);
                }
            }
            ++i;
        }
    }

    public int getAcceptedMessage() {
        return 5;
    }

    public void receive(ClusterMessage msg, Member sender) {
        if (msg == null) {
            return;
        }
        if (!(msg instanceof SessionMessage)) {
            return;
        }
        SessionMessage message = (SessionMessage)msg;
        switch (message.getMinorId()) {
            case 1: {
                this.receiveSessionCreate(message, sender);
                break;
            }
            case 2: {
                this.receiveSessionDelete(message);
                break;
            }
            case 3: {
                this.receiveSessionUpdate(message);
                break;
            }
            case 4: {
                this.receiveSessionCallover(message, sender);
                break;
            }
            case 5: {
                this.receiveSessionCalloverResponse(message);
                break;
            }
            case 6: {
                this.receiveSessionLevel(message);
                break;
            }
            case 7: {
                this.receiveSessionUpdate(message);
                break;
            }
            case 8: {
                this.receiveMaxInactiveInterval(message);
                break;
            }
            case 9: {
                this.receiveSessionAttribute(message, sender);
                break;
            }
            case 10: {
                this.receiveSessionInvalidate(message);
                break;
            }
            case 11: {
                this.receiveSessionExpire(message);
                break;
            }
            case 12: {
                this.receiveSyncBroadcast(message, sender);
                break;
            }
            case 13: {
                this.receiveSyncResponse(message, sender);
                break;
            }
            case 14: {
                this.receiveSyncRequest(message, sender);
                break;
            }
            case 15: {
                this.receiveSyncTransfers(message, sender);
                break;
            }
            default: {
                s_logger.error((Object)"Unknown minor message id ");
            }
        }
    }

    void sendSessionCreate(ClusterSessionImpl csi) {
        SessionMessage message = new SessionMessage();
        message.setMinorId(1);
        message.setSessionObject(csi);
        message.setNeedACK(true);
        this.clusterContext.send(message);
        message.getWaitACK().waitFor();
    }

    void receiveSessionCreate(SessionMessage message, Member sender) {
        ClusterSessionImpl session = message.getSessionObject();
        session.setSessionContext(this);
        this.addSession(session);
        ACKMessage ackMsg = new ACKMessage();
        ackMsg.setAckFor(message.getSequence());
        this.clusterContext.send((ClusterMessage)ackMsg, sender);
    }

    void sendSessionDelete(Session csi) {
        SessionMessage message = new SessionMessage();
        message.setMinorId(2);
        message.setSessionId(csi.getSessionID());
        this.clusterContext.send(message);
    }

    void receiveSessionDelete(SessionMessage message) {
        String sessionId = message.getSessionId();
        ClusterSessionImpl session = this.getClusterSession(sessionId);
        if (session != null) {
            session.setDestroyed(true);
        }
    }

    void sendSessionUpdate(ClusterSessionImpl csi) {
        SessionMessage message = new SessionMessage();
        message.setMinorId(3);
        message.setSessionId(csi.getSessionID());
        this.clusterContext.send(message);
    }

    void receiveSessionUpdate(SessionMessage message) {
        String sessionId = message.getSessionId();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("receiveSessionUpdate session id:" + sessionId));
        }
    }

    void sendCallover(ClusterSessionImpl csi) {
        SessionMessage message = new SessionMessage();
        message.setMinorId(4);
        message.setSessionId(csi.getSessionID());
        this.clusterContext.send(message);
    }

    void receiveSessionCallover(SessionMessage message, Member member) {
        String sessionId = message.getSessionId();
        ClusterSessionImpl session = this.getClusterSession(sessionId);
        if (session != null && session.isValid() && session.getCalloverCount() <= 0 && !session.isExpired()) {
            this.sendSessionCalloverResponse(message, session, member);
        }
    }

    void sendSessionCalloverResponse(SessionMessage message, ClusterSessionImpl session, Member member) {
        message.setMinorId(5);
        message.setThatAccessTime(session.getThisAccessTime());
        this.clusterContext.send((ClusterMessage)message, member);
    }

    void receiveSessionCalloverResponse(SessionMessage message) {
        String sessionId = message.getSessionId();
        ClusterSessionImpl session = this.getClusterSession(sessionId);
        if (session != null && session.isValid()) {
            session.clearCalloverCount();
            long thatAccessTime = message.getThatAccessTime();
            session.setThisAccessTime(thatAccessTime);
        }
    }

    void sendSessionLevel(ClusterSessionImpl csi) {
        SessionMessage message = new SessionMessage();
        message.setMinorId(6);
        message.setSessionId(csi.getSessionID());
        message.setSessionLevel(csi.getLevel());
        this.clusterContext.send(message);
    }

    void receiveSessionLevel(SessionMessage message) {
        String sessionId = message.getSessionId();
        ClusterSessionImpl session = this.getClusterSession(sessionId);
        if (session != null) {
            session.setLevelByCluster(message.getSessionLevel());
        }
    }

    void sendSessionUserName(ClusterSessionImpl csi) {
        SessionMessage message = new SessionMessage();
        message.setMinorId(7);
        message.setSessionId(csi.getSessionID());
        message.setSessionUserName(csi.getUserName());
        this.clusterContext.send(message);
    }

    void receiveSessionUserName(SessionMessage message) {
        String sessionId = message.getSessionId();
        ClusterSessionImpl session = this.getClusterSession(sessionId);
        if (session != null) {
            session.setUserNameByCluster(message.getSessionUserName());
        }
    }

    void sendMaxInactiveInterval(ClusterSessionImpl csi) {
        SessionMessage message = new SessionMessage();
        message.setMinorId(8);
        message.setSessionId(csi.getSessionID());
        message.setMaxInactiveInterval(csi.getMaxInactiveInterval());
        this.clusterContext.send(message);
    }

    void receiveMaxInactiveInterval(SessionMessage message) {
        String sessionId = message.getSessionId();
        ClusterSessionImpl session = this.getClusterSession(sessionId);
        if (session != null) {
            session.setMaxInactiveIntervalByCluster(message.getMaxInactiveInterval());
        }
    }

    void sendSessionAttribute(ClusterSessionImpl csi, String name, Serializable value) {
        SessionMessage message = new SessionMessage();
        message.setMinorId(9);
        message.setSessionId(csi.getSessionID());
        message.setAttributeName(name);
        message.setAttributeValue(value);
        boolean needACK = value instanceof Acknowledged;
        if (needACK) {
            message.setNeedACK(true);
        }
        this.clusterContext.send(message);
        if (needACK) {
            message.getWaitACK().waitFor();
        }
    }

    void receiveSessionAttribute(SessionMessage message, Member sender) {
        String sessionId = message.getSessionId();
        ClusterSessionImpl session = this.getClusterSession(sessionId);
        if (session != null) {
            session.setAttributeByCluster(message.getAttributeName(), message.getAttributeValue());
            if (message.isNeedACK()) {
                ACKMessage ackMsg = new ACKMessage();
                ackMsg.setAckFor(message.getSequence());
                this.clusterContext.send((ClusterMessage)ackMsg, sender);
            }
        }
    }

    void sendSessionInvalidate(ClusterSessionImpl csi) {
        SessionMessage message = new SessionMessage();
        message.setMinorId(10);
        message.setSessionId(csi.getSessionID());
        this.clusterContext.send(message);
    }

    void receiveSessionInvalidate(SessionMessage message) {
        String sessionId = message.getSessionId();
        ClusterSessionImpl session = this.getClusterSession(sessionId);
        if (session != null) {
            session.invalidateByCluster();
        }
    }

    void sendSessionExpire(ClusterSessionImpl csi) {
    }

    void receiveSessionExpire(SessionMessage message) {
        String sessionId = message.getSessionId();
        ClusterSessionImpl session = this.getClusterSession(sessionId);
        if (session != null) {
            session.expireByCluster();
        }
    }

    void sendSyncBroadcast() {
        SessionMessage message = new SessionMessage();
        message.setMinorId(12);
        message.setNeedACK(true);
        this.clusterContext.send(message);
        message.getWaitACK().waitFor(0, 5000L);
    }

    void receiveSyncBroadcast(SessionMessage message, Member member) {
        int sequence = message.getSequence();
        this.sendSyncResponse(message, member);
        this.sendSyncBroadcastAck(sequence, member);
    }

    private void sendSyncBroadcastAck(int sequence, Member member) {
        ACKMessage ack = new ACKMessage();
        ack.setAckFor(sequence);
        this.clusterContext.send((ClusterMessage)ack, member);
    }

    void sendSyncResponse(SessionMessage message, Member member) {
        message.setMinorId(13);
        message.setSessionCount(this.getSessionCount());
        this.clusterContext.send((ClusterMessage)message, member);
    }

    void receiveSyncResponse(SessionMessage message, Member member) {
        SessionSynchronizer synchronizer = this.sessionSynchronizer;
        if (synchronizer != null) {
            synchronizer.setMemberCount(member, message.getSessionCount());
        }
    }

    void sendSyncRequest(Member member) {
        SessionMessage message = new SessionMessage();
        message.setMinorId(14);
        this.clusterContext.send((ClusterMessage)message, member);
    }

    void receiveSyncRequest(SessionMessage message, Member member) {
        this.sendSyncTransfers(message, member);
    }

    void sendSyncTransfers(SessionMessage message, Member member) {
        message.setMinorId(15);
        message.setDelaySend(true);
        message.setDelayReceive(true);
        message.setCallback(new SessionSyncCallback());
        this.clusterContext.send((ClusterMessage)message, member);
    }

    /*
     * Exception decompiling
     */
    void receiveSyncTransfers(SessionMessage message, Member member) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private class SessionSyncCallback
    implements Callbackable {
        private SessionSyncCallback() {
        }

        public Object callBack(Object args) {
            FilterStreamWriter writer = (FilterStreamWriter)args;
            Iterator itr = SessionManagerImpl.this.getSessions();
            if (itr != null) {
                try {
                    while (itr.hasNext()) {
                        ClusterSessionImpl session = (ClusterSessionImpl)itr.next();
                        if (session == null) continue;
                        writer.write_boolean(true);
                        session._save(writer);
                        writer.flush();
                    }
                    writer.write_boolean(false);
                    writer.flush();
                }
                catch (Exception e) {
                    s_logger.error((Object)"Full session send failed", (Throwable)e);
                }
            }
            return null;
        }
    }
}

