/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2InputStream;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class DB2Blob
implements Blob {
    protected int locator;
    protected DB2Connection connection;
    protected DB2Statement statement;
    protected int lobType;
    protected int maxFieldSize;
    protected DB2InputStream db2is;
    protected boolean closed = false;
    protected byte[] data = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DB2Blob(DB2Statement dB2Statement, int n, int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "DB2Blob( stmt, " + n + ", " + n2 + " )");
            }
            DB2Connection dB2Connection = this.connection = (DB2Connection)dB2Statement.getConnection();
            synchronized (dB2Connection) {
                this.locator = n;
                this.lobType = n2;
                this.db2is = new DB2InputStream(dB2Statement, this.locator, this.lobType);
                this.statement = this.connection.getInputStreamStmt();
                this.closed = false;
            }
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "DB2Blob()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "DB2Blob()");
    }

    public DB2Blob(byte[] byArray) {
        this.data = byArray == null ? new byte[0] : byArray;
    }

    protected native int SQLGetBAPosition(int var1, Integer var2, byte[] var3, int var4);

    protected native int SQLGetBlobPosition(int var1, Integer var2, int var3, int var4);

    public void close() {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "close()");
            }
            if (!this.closed && this.db2is != null) {
                this.db2is.close();
            }
            this.closed = true;
        }
        finally {
            Object var2_1 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "close()");
            }
        }
    }

    public void finalize() {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "finalize()");
            }
            this.close();
        }
        finally {
            Object var2_1 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "finalize()");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getBinaryStream() throws SQLException {
        DB2InputStream dB2InputStream;
        block5: {
            ByteArrayInputStream byteArrayInputStream;
            block4: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "getBinaryStream()");
                    }
                    if (this.db2is == null) {
                        byteArrayInputStream = new ByteArrayInputStream(this.data);
                        Object var3_3 = null;
                        if (!DB2Trace.TraceOn) return byteArrayInputStream;
                        break block4;
                    }
                    DB2InputStream dB2InputStream2 = null;
                    dB2InputStream = dB2InputStream2 = new DB2InputStream(this.statement, this.locator, this.lobType);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit((Object)this, "getBinaryStream()", "InputStream");
                    throw throwable;
                }
            }
            DB2Trace.methodExit((Object)this, "getBinaryStream()", "InputStream");
            return byteArrayInputStream;
        }
        Object var3_4 = null;
        if (!DB2Trace.TraceOn) return dB2InputStream;
        DB2Trace.methodExit((Object)this, "getBinaryStream()", "InputStream");
        return dB2InputStream;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getBytes(long l, int n) throws SQLException {
        byte[] byArray;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getBytes( " + l + ", " + n + " )");
            }
            byte[] byArray2 = null;
            if (this.db2is == null) {
                if (l > (long)this.data.length || n == 0) {
                    byArray2 = new byte[]{};
                } else {
                    n = (int)Math.min((long)this.data.length - l + 1L, (long)n);
                    byArray2 = new byte[n];
                    System.arraycopy(this.data, (int)l - 1, byArray2, 0, n);
                }
            } else {
                byte[] byArray3 = new byte[n];
                this.db2is.moveTo((int)l);
                try {
                    int n2 = this.db2is.read(byArray3);
                    if (n2 > 0) {
                        byArray2 = new byte[n2];
                        System.arraycopy(byArray3, 0, byArray2, 0, n2);
                    }
                }
                catch (IOException iOException) {
                    throw new SQLException(iOException.toString());
                }
            }
            byArray = byArray2;
            Object var6_8 = null;
            if (!DB2Trace.TraceOn) return byArray;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "getBytes()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "getBytes()");
        return byArray;
    }

    final int getLocator() {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "getLocator()");
            DB2Trace.methodExit((Object)this, "getLocator()", this.locator);
        }
        return this.locator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long length() throws SQLException {
        long l;
        long l2 = 0L;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "length()");
            }
            l2 = this.db2is == null ? (long)this.data.length : this.db2is.getLength();
            l = l2;
            Object var6_3 = null;
            if (!DB2Trace.TraceOn) return l;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "length()", l2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "length()", l2);
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long position(Blob blob, long l) throws SQLException {
        long l2;
        long l3 = -1L;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "position( pattern, " + l + " )");
            }
            if (blob instanceof DB2Blob && ((DB2Blob)blob).db2is != null && this.db2is != null) {
                Integer n = new Integer(0);
                DB2Statement dB2Statement = this.statement;
                synchronized (dB2Statement) {
                    l3 = this.SQLGetBlobPosition(this.statement.statementHandle, n, ((DB2Blob)blob).getLocator(), (int)l);
                    this.connection.sqlExcptGen.check_return_code(this.statement, (int)n);
                }
            } else {
                long l4 = blob.length();
                byte[] byArray = blob.getBytes(0L, (int)l4);
                l3 = this.position(byArray, l);
            }
            l2 = l3;
            Object var9_9 = null;
            if (!DB2Trace.TraceOn) return l2;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "position()", l3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "position()", l3);
        return l2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long position(byte[] byArray, long l) throws SQLException {
        long l2;
        long l3 = -1L;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "position( pattern[], " + l + " )");
            }
            if (byArray == null || byArray.length == 0) {
                l3 = -1L;
            } else if (this.db2is == null) {
                while (l + (long)byArray.length - 1L < (long)this.data.length) {
                    int n = (int)l - 1;
                    int n2 = 0;
                    while (n2 < byArray.length && this.data[n] == byArray[n2]) {
                        ++n;
                        ++n2;
                    }
                    if (byArray.length == n2) {
                        l3 = l;
                    }
                    ++l;
                }
            } else {
                Integer n = new Integer(0);
                DB2Statement dB2Statement = this.statement;
                synchronized (dB2Statement) {
                    l3 = this.SQLGetBAPosition(this.statement.statementHandle, n, byArray, (int)l);
                    this.connection.sqlExcptGen.check_return_code(this.statement, (int)n);
                }
            }
            l2 = l3;
            Object var9_9 = null;
            if (!DB2Trace.TraceOn) return l2;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "position()", l3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "position()", l3);
        return l2;
    }
}

