/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.impl;

import com.trs.infra.util.CMyException;
import com.trs.scm.sdk.impl.AbstractFavoriteMgr;
import com.trs.scm.sdk.model.ExtraParams;
import com.trs.scm.sdk.model.FavoriteWrapper;
import com.trs.scm.sdk.model.MicroContent;
import com.trs.scm.sdk.model.OAuth;
import com.trs.scm.sdk.model.SinaErrorMessage;
import com.trs.scm.sdk.util.SinaObjectUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import weibo4j.Favorite;
import weibo4j.Weibo;
import weibo4j.http.Response;
import weibo4j.model.Favorites;
import weibo4j.model.Paging;
import weibo4j.model.Status;
import weibo4j.model.WeiboException;
import weibo4j.org.json.JSONException;
import weibo4j.util.WeiboConfig;

public class SinaFavoriteMgr
extends AbstractFavoriteMgr {
    private static Logger logger = Logger.getLogger(SinaFavoriteMgr.class);
    private Weibo m_oSinaWeibo;
    private Favorite m_oSinaWeiboFavorite;

    public SinaFavoriteMgr(OAuth auth) {
        super(auth);
        String sAccessToken = this.m_oOAuth.getOAuth_token();
        this.m_oSinaWeibo = new Weibo();
        this.m_oSinaWeibo.setToken(sAccessToken);
        this.m_oSinaWeiboFavorite = new Favorite();
        this.m_oSinaWeiboFavorite.setToken(sAccessToken);
    }

    @Override
    public com.trs.scm.sdk.model.Favorite createFavorite(String microContentId) throws Exception {
        Favorites oSinaWeiboFavorites = null;
        com.trs.scm.sdk.model.Favorite oResult = new com.trs.scm.sdk.model.Favorite();
        try {
            oSinaWeiboFavorites = this.m_oSinaWeiboFavorite.createFavorites(microContentId);
        }
        catch (Exception _oWeiboException) {
            if (_oWeiboException instanceof WeiboException && ((WeiboException)((Object)_oWeiboException)).getErrorCode() != 20704) {
                CMyException oCMyException = SinaErrorMessage.getCMyException(_oWeiboException);
                logger.error((Object)oCMyException.getMyMessage());
                throw oCMyException;
            }
            return oResult;
        }
        Date oDate = oSinaWeiboFavorites.getFavoritedTime();
        Status oStatus = oSinaWeiboFavorites.getStatus();
        MicroContent oMicroContent = null;
        try {
            oMicroContent = SinaObjectUtil.constructMicroContent(oStatus);
        }
        catch (Exception _oWeiboException) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(_oWeiboException);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        oResult.setFavoriteTime(oDate);
        oResult.setMicroContent(oMicroContent);
        return oResult;
    }

    @Override
    public boolean destroyFavorite(String microContentId) throws Exception {
        Favorites SinaWeiboFavorites = null;
        try {
            SinaWeiboFavorites = this.m_oSinaWeiboFavorite.destroyFavorites(microContentId);
        }
        catch (Exception _oWeiboException) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(_oWeiboException);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        return SinaWeiboFavorites != null;
    }

    @Override
    public FavoriteWrapper getFavorites(int pageIndex, int pageSize, ExtraParams extraParams) throws Exception {
        Paging page = SinaObjectUtil.constructSinaPaging(pageIndex, pageSize, extraParams);
        Response oResponse = null;
        try {
            oResponse = this.m_oSinaWeibo.client.get(WeiboConfig.getValue((String)"baseURL") + "favorites.json", null, page);
        }
        catch (Exception _oWeiboException) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(_oWeiboException);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        List oSinaFavoritesList = null;
        try {
            oSinaFavoritesList = Favorites.constructFavorites((Response)oResponse);
        }
        catch (Exception _oWeiboException) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(_oWeiboException);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        int nTotalNumber = 0;
        try {
            nTotalNumber = oResponse.asJSONObject().getInt("total_number");
        }
        catch (JSONException _oJSONException) {
            logger.error((Object)_oJSONException.getStackTrace());
            throw new Exception("JSON\u83b7\u53d6\u6536\u85cf\u603b\u6570\u53c2\u6570\u9519\u8bef", _oJSONException);
        }
        catch (Exception _oWeiboException) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(_oWeiboException);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        FavoriteWrapper oResult = null;
        ArrayList<com.trs.scm.sdk.model.Favorite> oMicroFavoriteList = null;
        if (oSinaFavoritesList != null && oSinaFavoritesList.size() > 0) {
            oMicroFavoriteList = new ArrayList<com.trs.scm.sdk.model.Favorite>();
            for (Favorites oSinaFavors : oSinaFavoritesList) {
                oMicroFavoriteList.add(SinaObjectUtil.constructMicroFavorites(oSinaFavors));
            }
            oResult = new FavoriteWrapper(oMicroFavoriteList, nTotalNumber);
            return oResult;
        }
        return null;
    }
}

