/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.util;

import com.trs.components.wcm.util.INameGenerator;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;

public class NameGenerator
implements INameGenerator {
    @Override
    public String generate(BaseObj obj, String sFieldName, String sName) throws WCMException {
        if (CMyString.isEmpty(sName) || CMyString.isEmpty(sFieldName)) {
            throw new WCMException(10, "\u6570\u636e\u5e93\u5b57\u6bb5\u540d\u79f0\u6216\u8005\u4f20\u5165\u7684\u540d\u79f0\u4e3a\u7a7a");
        }
        if (!this.existsName(obj, sFieldName, sName, null)) {
            return sName;
        }
        if (obj.getId() == 0) {
            obj.setNextId();
        }
        String sNewName = this.generateNewName(sName, sFieldName, obj, null);
        return sNewName;
    }

    private boolean existsName(BaseObj _obj, String _sFieldName, String _sName, WCMFilter _extraFilter) throws WCMException {
        String sWhere = _sFieldName.toUpperCase() + "=?";
        WCMFilter filter = new WCMFilter(_obj.getDbTableName(), sWhere, "", "");
        filter.addSearchValues(_sName);
        if (_extraFilter != null) {
            filter.mergeWith(_extraFilter);
        }
        return DBManager.getDBManager().sqlExecuteCountQuery(filter) > 0;
    }

    private String generateNewName(String sName, String sFieldName, BaseObj obj, WCMFilter extraFilter) throws WCMException {
        sName = sName.replaceAll("(_\\d+)+$", "");
        int nCount = obj.getId();
        String sNewName = sName + "_" + nCount;
        while (this.existsName(obj, sFieldName, sNewName, extraFilter)) {
            sNewName = sName + "_" + nCount;
            ++nCount;
        }
        return sNewName;
    }

    @Override
    public String generate(BaseObj obj, String sFieldName, String sName, WCMFilter extraExistsFilter) throws WCMException {
        if (CMyString.isEmpty(sName) || CMyString.isEmpty(sFieldName)) {
            throw new WCMException(10, "\u6570\u636e\u5e93\u5b57\u6bb5\u540d\u79f0\u6216\u8005\u4f20\u5165\u7684\u540d\u79f0\u4e3a\u7a7a");
        }
        if (!this.existsName(obj, sFieldName, sName, extraExistsFilter)) {
            return sName;
        }
        if (obj.getId() == 0) {
            obj.setNextId();
        }
        String sNewName = this.generateNewName(sName, sFieldName, obj, extraExistsFilter);
        return sNewName;
    }
}

