/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.key.CKeyUtil;
import com.trs.license.License;
import com.trs.license.LicenseException;
import com.trs.license.LicenseUtil;

public class MySite
implements License {
    private static final String LICENSE = "license/LICENSE.trswcm";
    private static int m_nMaxSiteNum = -1;

    @Override
    public int getMaxSiteNum() {
        if (m_nMaxSiteNum < 0) {
            this.validate();
        }
        return m_nMaxSiteNum;
    }

    @Override
    public int getMaxUserNum() {
        return 0;
    }

    @Override
    public int getPluginCode() {
        return 0;
    }

    @Override
    public String validate() {
        try {
            String sKeyInfo = MySite.getProductKey();
            String temp = sKeyInfo.substring(12, 14);
            int nMaxSiteNum = CKeyUtil.getKeyNum(temp);
            if (nMaxSiteNum == 99) {
                return I18NMessage.get(MySite.class, "MySite.label1", "Platform\u7684License");
            }
            m_nMaxSiteNum = nMaxSiteNum;
            return null;
        }
        catch (Throwable e) {
            return "Validate Exception\uff01Site" + e;
        }
    }

    private static String getProductKey() {
        String sKey = MySite.loadLicenseFile();
        sKey = LicenseUtil.decodeRadix64(sKey);
        return CKeyUtil.DecodeKey(sKey);
    }

    private static String loadLicenseFile() {
        String sLicenseContent = "";
        Class<MySite> clazz = MySite.class;
        String filename = clazz.getClassLoader().getResource(LICENSE).getFile();
        try {
            sLicenseContent = CMyFile.readFile(filename).trim();
        }
        catch (CMyException e) {
            int nErrNumber = e.getErrNo();
            if (55 == nErrNumber) {
                throw new LicenseException(I18NMessage.get(MySite.class, "MySite.label2", "\u975e\u6cd5\u4f7f\u7528!\u6ca1\u6709\u627e\u5230\u5408\u6cd5\u7684License."));
            }
            throw new LicenseException(I18NMessage.get(MySite.class, "MySite.label3", "\u7cfb\u7edf\u542f\u52a8\u5f02\u5e38!\u6821\u9a8c\u4f7f\u7528\u8bb8\u53ef\u5931\u8d25"));
        }
        String decodeContent = LicenseUtil.decodeRadix64(sLicenseContent);
        return decodeContent;
    }
}

