/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.db;

import com.trs.cms.ContextHelper;
import com.trs.components.infoview.InfoViewConstants;
import com.trs.components.infoview.InfoViewHelper;
import com.trs.components.infoview.db.XMLContentRender;
import com.trs.components.infoview.persistent.InfoViewData;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.BaseServer;
import com.trs.infra.common.WCMException;
import java.util.List;

public class InfoViewDBStoreServer
extends BaseServer {
    @Override
    protected void doShutdown() {
    }

    @Override
    protected boolean doStart() throws WCMException {
        return true;
    }

    public void saveInfoViewData(int _nInfoViewId, Document _oDocument) throws WCMException {
        InfoViewData oInfoViewData = null;
        if (!_oDocument.isAddMode()) {
            oInfoViewData = InfoViewData.findById2(_nInfoViewId, _oDocument.getId());
        }
        boolean bIsAddMode = false;
        boolean bNeedSave = false;
        if (oInfoViewData != null && _oDocument.isChangeProperty("DocFlag")) {
            oInfoViewData.delete();
            oInfoViewData = null;
        }
        if (oInfoViewData == null) {
            oInfoViewData = InfoViewData.createNewInstance(_nInfoViewId, _oDocument.getId());
            oInfoViewData.setChannelId(_oDocument.getChannelId());
            bIsAddMode = true;
            bNeedSave = true;
        } else if (_oDocument.isChangeProperty("DocChannel")) {
            oInfoViewData.setChannelId(_oDocument.getChannelId());
            bNeedSave = true;
        }
        for (int i = 0; i < InfoViewConstants.SYNC_FIELD_NAMES.length; ++i) {
            bNeedSave = this.syncFieldValue(_oDocument, oInfoViewData, InfoViewConstants.SYNC_FIELD_NAMES[i], bIsAddMode) || bNeedSave;
        }
        String sXmlContent = bIsAddMode ? _oDocument.getContent() : _oDocument.getNewPropertyAsString("DOCCONTENT");
        List complexFieldDatas = null;
        if (sXmlContent != null) {
            complexFieldDatas = this.renderXmlContent(oInfoViewData, sXmlContent);
            bNeedSave = true;
        }
        if (!bNeedSave && !bIsAddMode) {
            return;
        }
        oInfoViewData.save(ContextHelper.getLoginUser());
        if (bIsAddMode) {
            InfoViewHelper.buildComplexFields(complexFieldDatas, oInfoViewData.getId(), oInfoViewData.getDocumentId());
        } else {
            InfoViewHelper.restoreComplexFields(complexFieldDatas, oInfoViewData.getId(), oInfoViewData.getDocumentId());
        }
    }

    private List renderXmlContent(InfoViewData _oDocData, String sXMLContent) throws WCMException {
        XMLContentRender worker = new XMLContentRender();
        worker.render(_oDocData, sXMLContent, null);
        return worker.getComplexFieldDatas();
    }

    private boolean syncFieldValue(Document _oDocument, InfoViewData _oInfoViewData, String _sFieldName, boolean _bIsAddMode) throws WCMException {
        if (_bIsAddMode) {
            return _oInfoViewData.setProperty(_sFieldName, _oDocument.getProperty(_sFieldName));
        }
        if (_oDocument.isChangeProperty(_sFieldName)) {
            return _oInfoViewData.setProperty(_sFieldName, _oDocument.getNewProperty(_sFieldName));
        }
        return false;
    }

    public void deleteInfoViewData(int _nInfoViewId, Document _oDocument) throws WCMException {
        InfoViewData oInfoViewData = InfoViewData.findById2(_nInfoViewId, _oDocument.getId());
        if (oInfoViewData != null) {
            oInfoViewData.delete(ContextHelper.getLoginUser());
            InfoViewHelper.clearComplexFieldDatas(oInfoViewData.getId());
        }
    }

    public void changeChnnlOfInfoviewDatasaveInfoViewData(int _nInfoViewId, Document _oDocument, ChnlDoc _oChnDoc) throws WCMException {
        InfoViewData oInfoViewData = null;
        if (!_oDocument.isAddMode()) {
            oInfoViewData = InfoViewData.findById2(_nInfoViewId, _oDocument.getId());
        }
        oInfoViewData.setChannelId(_oChnDoc.getNewPropertyAsInt("CHNLID", 0));
        oInfoViewData.save();
    }
}

