/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.distribute.PublishDistributionMgr;
import com.trs.components.common.publish.persistent.distribute.PublishDistribution;
import com.trs.components.common.publish.persistent.distribute.PublishDistributions;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.WCMFilter;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class DistributeServiceProvider
implements IGlueServiceProvider {
    private PublishDistributionMgr m_oPublishDistributionMgr = (PublishDistributionMgr)DreamFactory.createObjectById("PublishDistributionMgr");

    @Override
    public void delete(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sObjectIds = _methContext.getObjectIds();
        PublishDistributions distributions = PublishDistributions.findByIds(loginUser, sObjectIds);
        int nSize = distributions.size();
        for (int i = 0; i < nSize; ++i) {
            PublishDistribution distribution = (PublishDistribution)distributions.getAt(i);
            if (distribution == null) continue;
            if (!loginUser.isAdministrator()) {
                this.validateRight(loginUser, distribution.getFolder().getSubstance(), I18NMessage.get(DistributeServiceProvider.class, "DistributeServiceProvider.label1", "\u5220\u9664\u5206\u53d1\u4fe1\u606f"));
            }
            this.m_oPublishDistributionMgr.delete(distribution);
        }
    }

    @Override
    public Object query(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        IPublishFolder folder = this.findFolder(_methContext);
        this.validateRight(loginUser, folder.getSubstance(), I18NMessage.get(DistributeServiceProvider.class, "DistributeServiceProvider.label2", "\u83b7\u53d6"));
        boolean bExcludeDisabled = _methContext.getValue("ExcludeDisabled", false);
        WCMFilter filter = new WCMFilter();
        int nFilterType = _methContext.getValue("FilterType", 0);
        switch (nFilterType) {
            case 1: {
                filter.setWhere("Enabled=?");
                filter.addSearchValues(0, 1);
                break;
            }
            case 2: {
                filter.setWhere("Enabled=?");
                filter.addSearchValues(0, 0);
            }
        }
        filter.mergeWith(_methContext.getExtraWCMFilter());
        return this.m_oPublishDistributionMgr.getDistributionsOf(folder, bExcludeDisabled, filter);
    }

    @Override
    public int save(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        IPublishFolder folder = null;
        PublishDistribution distribution = null;
        int nObjectId = _methodContext.getObjectId();
        if (nObjectId == 0) {
            folder = this.findFolder(_methodContext);
            this.validateRight(loginUser, folder.getSubstance(), I18NMessage.get(DistributeServiceProvider.class, "DistributeServiceProvider.label3", "\u4fdd\u5b58"));
            distribution = PublishDistribution.createNewInstance();
            distribution.setFolder(folder);
        } else {
            distribution = this.findById(nObjectId);
            folder = distribution.getFolder();
            this.validateRight(loginUser, folder.getSubstance(), I18NMessage.get(DistributeServiceProvider.class, "DistributeServiceProvider.label3", "\u4fdd\u5b58"));
            distribution.validCanEditAndLock(loginUser);
        }
        String[] pLogicFields = new String[]{"FolderType", "FolderId"};
        WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _methodContext, distribution, pLogicFields);
        this.m_oPublishDistributionMgr.save(distribution);
        return distribution.getId();
    }

    private PublishDistribution findById(int nObjectId) throws WCMException {
        PublishDistribution distribution = PublishDistribution.findById(nObjectId);
        if (distribution == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nObjectId), WCMTypes.getLowerObjName(955)}));
        }
        return distribution;
    }

    @Override
    public Object findById(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        IPublishFolder folder = null;
        PublishDistribution distribution = null;
        if (_methContext.getObjectId() == 0) {
            folder = this.findFolder(_methContext);
            this.validateRight(loginUser, folder.getSubstance(), I18NMessage.get(DistributeServiceProvider.class, "DistributeServiceProvider.label5", "\u67e5\u770b\u5177\u4f53\u7684\u5206\u53d1\u4fe1\u606f"));
            distribution = new PublishDistribution();
            distribution.setFolder(folder);
        } else {
            distribution = this.findById(_methContext.getObjectId());
            folder = distribution.getFolder();
            this.validateRight(loginUser, folder.getSubstance(), I18NMessage.get(DistributeServiceProvider.class, "DistributeServiceProvider.label5", "\u67e5\u770b\u5177\u4f53\u7684\u5206\u53d1\u4fe1\u606f"));
        }
        return distribution;
    }

    @Override
    public Object findByIds(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        PublishDistributions distributions = PublishDistributions.findByIds(loginUser, _methContext.getObjectIds());
        if (loginUser.isAdministrator()) {
            return distributions;
        }
        int nSize = distributions.size();
        for (int i = 0; i < nSize; ++i) {
            PublishDistribution distribution = (PublishDistribution)distributions.getAt(i);
            if (distribution == null) continue;
            this.validateRight(loginUser, distribution.getFolder().getSubstance(), I18NMessage.get(DistributeServiceProvider.class, "DistributeServiceProvider.label5", "\u67e5\u770b\u5177\u4f53\u7684\u5206\u53d1\u4fe1\u606f"));
        }
        return distributions;
    }

    public void updateStatus(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        PublishDistributions distributions = PublishDistributions.findByIds(loginUser, _methodContext.getObjectIds());
        boolean bEnabled = _methodContext.getValue("Enable", false);
        this.updateStatus(distributions, bEnabled, loginUser);
    }

    public void updateStatusAll(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        _methodContext.setValue("PageSize", -1);
        PublishDistributions distributions = (PublishDistributions)this.query(_methodContext);
        boolean bEnabled = _methodContext.getValue("Enable", false);
        this.updateStatus(distributions, bEnabled, loginUser);
    }

    private void updateStatus(PublishDistributions distributions, boolean bEnabled, User loginUser) throws Throwable {
        int nSize = distributions.size();
        for (int i = 0; i < nSize; ++i) {
            PublishDistribution distribution = (PublishDistribution)distributions.getAt(i);
            if (distribution == null || distribution.isEnabled() == bEnabled) continue;
            if (!loginUser.isAdministrator()) {
                this.validateRight(loginUser, distribution.getFolder().getSubstance(), I18NMessage.get(DistributeServiceProvider.class, "DistributeServiceProvider.label6", "\u66f4\u65b0\u5206\u53d1\u670d\u52a1\u72b6\u6001"));
            }
            distribution.validCanEditAndLock(loginUser);
            distribution.setEnabled(bEnabled);
            this.m_oPublishDistributionMgr.save(distribution);
        }
    }

    public Object[] queryTargetTypes() throws Throwable {
        return PublishServerConfigMapper.getDistributionTargetTypes().values().toArray();
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private void validateRight(User loginUser, CMSObj _currObj, String _sOprDesc) throws Throwable {
        int nRightIndex = 0;
        switch (_currObj.getWCMType()) {
            case 103: {
                nRightIndex = 1;
                break;
            }
            case 101: {
                nRightIndex = 13;
                break;
            }
        }
        if (!AuthServer.hasRight(loginUser, _currObj, nRightIndex)) {
            throw new WCMException(I18NMessage.get(DistributeServiceProvider.class, "DistributeServiceProvider.label7", "\u60a8[") + loginUser.getName() + I18NMessage.get(DistributeServiceProvider.class, "DistributeServiceProvider.label8", "]\u6ca1\u6709\u6743\u9650") + _sOprDesc + " " + _currObj + I18NMessage.get(DistributeServiceProvider.class, "DistributeServiceProvider.label9", " \u7684\u5206\u53d1\u8bbe\u7f6e"));
        }
    }

    private IPublishFolder findFolder(MethodContext _methodContext) throws WCMException {
        int nObjectId;
        int nObjectType = _methodContext.getValue("FolderType", 0);
        IPublishFolder publishElement = (IPublishFolder)PublishElementFactory.lookupElement(nObjectType, nObjectId = _methodContext.getValue("FolderId", 0));
        if (publishElement == null) {
            throw new WCMException(I18NMessage.get(DistributeServiceProvider.class, "DistributeServiceProvider.label10", "\u6307\u5b9a\u7684\u680f\u76ee[Type=") + nObjectType + ", Id=" + nObjectId + I18NMessage.get(DistributeServiceProvider.class, "DistributeServiceProvider.label11", "]\u4e0d\u5b58\u5728\uff01"));
        }
        return publishElement;
    }
}

