/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.saml.interact.impl.simple.response;

import com.trs.idm.saml.common.IDSUser;
import com.trs.idm.saml.interact.ResponseBase;
import com.trs.idm.util.Base64Util;
import com.trs.idm.util.StringHelper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class SimpleSelfPageLoginHttpPostResponse
extends ResponseBase {
    private static final Logger LOG = Logger.getLogger(SimpleSelfPageLoginHttpPostResponse.class);
    private String encry_token;
    private String decry_token;
    private String tokenType;
    private String userName;
    private int period;
    private long createTime;
    private String allowedCoAppName;
    private String allowedCosessionId;
    private IDSUser idsUser;

    public SimpleSelfPageLoginHttpPostResponse(String responseCode, String responseContent) {
        this.responseType = "SimpleSelfPageLoginHttpPostResponse";
        this.responseCode = responseCode;
        this.responseBody = responseContent;
        if ("200".equals(responseCode)) {
            this.encry_token = responseContent;
            this.decry_token = Base64Util.decode(this.encry_token);
            this.idsUser = this.resolveToken(this.decry_token);
        }
    }

    @Override
    public boolean validate(HttpServletRequest request, HttpServletResponse response) {
        if (!"200".equals(this.responseCode)) {
            LOG.error((Object)"this is not sucess resposne!");
            return false;
        }
        if (StringHelper.isEmpty(this.encry_token)) {
            LOG.warn((Object)"validate fail! encry_token is null");
            return false;
        }
        if (this.userName == null || this.allowedCoAppName == null || this.allowedCosessionId == null || this.period == 0 || this.createTime == 0L) {
            LOG.warn((Object)("validate fail! userName[" + this.userName + "], coAppName[" + this.allowedCoAppName + "], period[" + this.period + "],createTime[" + this.createTime + "]"));
            return false;
        }
        if (!this.allowedCosessionId.equals(request.getSession().getId())) {
            LOG.warn((Object)("validate fail! allowedCosessionId[" + this.allowedCosessionId + "] is not equals with current coSessionId: " + request.getSession().getId()));
            return false;
        }
        if (this.createTime - System.currentTimeMillis() > 0x6DDD00L) {
            LOG.info((Object)"validate fail! token time out!");
            return false;
        }
        return true;
    }

    private IDSUser resolveToken(String decry_token) {
        String[] tokenArray = StringHelper.split(decry_token, "_");
        IDSUser user = null;
        try {
            int i = 0;
            while (i < tokenArray.length) {
                this.tokenType = tokenArray[0];
                this.userName = tokenArray[1];
                this.allowedCoAppName = tokenArray[2];
                this.allowedCosessionId = tokenArray[3];
                this.period = new Integer(tokenArray[4]);
                this.createTime = new Long(tokenArray[5]).intValue();
                ++i;
            }
            user = new IDSUser();
            user.setUserName(this.userName);
        }
        catch (Exception e) {
            LOG.warn((Object)("resovle token error, token is: [" + decry_token + "," + decry_token + "]"), (Throwable)e);
            this.userName = null;
            this.allowedCoAppName = null;
            this.period = 0;
            this.createTime = 0L;
        }
        LOG.debug((Object)("resolveToken: " + decry_token + ", user=" + user + ", tokenType=" + this.tokenType + "; period=" + this.period + ";createTime=" + this.createTime));
        return user;
    }

    @Override
    public IDSUser getIDSUser() {
        return this.idsUser;
    }
}

