/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.wordfilter;

import com.trs.dev4.jdk16.utils.StringHelper;
import com.trs.dev4.jdk16.wordfilter.Word;
import com.trs.dev4.jdk16.wordfilter.WordFilterImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

final class Dictionary {
    private Word[] m_fwl = null;
    private List<String> words = new ArrayList<String>();
    private String color = "red";
    private int level = 0;
    protected static final Logger LOG = Logger.getLogger(WordFilterImpl.class);
    private String groupName;
    private boolean isEmpty = true;

    public Dictionary(String groupName) {
        this.groupName = groupName;
        this.m_fwl = new Word[65535];
    }

    public Dictionary(String groupName, Word[] words) {
        this.groupName = groupName;
        this.m_fwl = (Word[])words.clone();
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public void addWord(String p_word, int level, String color) {
        if (!StringHelper.isEmpty(p_word)) {
            p_word = p_word.toLowerCase().trim();
            char index = p_word.charAt(0);
            Word word = new Word();
            word.setWord(p_word);
            word.setGroup(this.groupName);
            word.setNext(this.m_fwl[index]);
            word.setLevel(level);
            word.setColor(color);
            this.m_fwl[index] = word;
            this.words.add(p_word);
            this.isEmpty = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("\u52a0\u5165\u8fc7\u6ee4\u8bcd:" + word));
            }
        }
    }

    public Word getWord(char p_ch) {
        return this.m_fwl[p_ch];
    }

    public Dictionary getCloneDic(String newGroupName) {
        return new Dictionary(newGroupName, this.m_fwl);
    }

    public String listWords() {
        StringBuilder sb = new StringBuilder();
        Word[] wordArray = this.m_fwl;
        int n = this.m_fwl.length;
        int n2 = 0;
        while (n2 < n) {
            Word word = wordArray[n2];
            if (word != null) {
                sb.append(word.getWord()).append("[").append(word.getLevel()).append("]").append(";");
            }
            ++n2;
        }
        return sb.toString();
    }

    public boolean contains(String word) {
        return this.words.contains(word);
    }

    public List<String> listAllWords() {
        return this.words;
    }

    public void clear() {
        this.m_fwl = new Word[65535];
        this.isEmpty = true;
        this.words.clear();
    }

    public int size() {
        return this.words.size();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }
}

