/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.util;

import cpdetector.io.ASCIIDetector;
import cpdetector.io.CodepageDetectorProxy;
import cpdetector.io.ICodepageDetector;
import cpdetector.io.JChardetFacade;
import cpdetector.io.ParsingDetector;
import cpdetector.io.UnicodeDetector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.log4j.Logger;

public class EncodingUtil {
    private static final Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.cis4.util.EncodingUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public static void main(String[] args) {
        try {
            String string = "wrwer\u58eb\u5927\u592bwegwg,.,/34234]234,23,./34";
            byte[] aa = string.getBytes();
            System.out.println(String.valueOf(string.length()) + " " + aa.length);
        }
        catch (Exception string) {
            // empty catch block
        }
        String sGB = "\u7231";
        String sGBK = "\u611b";
        String sBIG5 = "\u7a32";
        byte[] sChars = null;
        sChars = sGB.getBytes();
        System.out.println(String.valueOf(sGB) + " is " + EncodingUtil.isGB2312(sChars[0], sChars[1]) + " for GB2312;" + EncodingUtil.isGBK(sChars[0], sChars[1]) + " for GBK," + EncodingUtil.isBIG5(sChars[0], sChars[1]) + " for BIG5");
        sChars = sGBK.getBytes();
        System.out.println(String.valueOf(sGBK) + " is " + EncodingUtil.isGB2312(sChars[0], sChars[1]) + " for GB2312;" + EncodingUtil.isGBK(sChars[0], sChars[1]) + " for GBK," + EncodingUtil.isBIG5(sChars[0], sChars[1]) + " for BIG5");
        sChars = sBIG5.getBytes();
        System.out.println(String.valueOf(sBIG5) + " is " + EncodingUtil.isGB2312(sChars[0], sChars[1]) + " for GB2312;" + EncodingUtil.isGBK(sChars[0], sChars[1]) + " for GBK," + EncodingUtil.isBIG5(sChars[0], sChars[1]) + " for BIG5");
    }

    public static boolean isGB2312(byte head, byte tail) {
        int iHead = head & 0xFF;
        int iTail = tail & 0xFF;
        return iHead >= 161 && iHead <= 247 && iTail >= 161 && iTail <= 254;
    }

    public static boolean isGBK(byte head, byte tail) {
        int iHead = head & 0xFF;
        int iTail = tail & 0xFF;
        return iHead >= 129 && iHead <= 254 && (iTail >= 64 && iTail <= 126 || iTail >= 128 && iTail <= 254);
    }

    public static boolean isBIG5(byte head, byte tail) {
        int iHead = head & 0xFF;
        int iTail = tail & 0xFF;
        return iHead >= 161 && iHead <= 249 && (iTail >= 64 && iTail <= 126 || iTail >= 161 && iTail <= 254);
    }

    public static String detectCharset(URL url) throws IOException {
        CodepageDetectorProxy detector = EncodingUtil.prepareDetector();
        Charset charset = detector.detectCodepage(url);
        String charsetname = charset.name();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Input url is :[" + url.toString() + "], guess charset is :[" + charsetname + "]"));
        }
        return charsetname;
    }

    private static CodepageDetectorProxy prepareDetector() {
        CodepageDetectorProxy detector = CodepageDetectorProxy.getInstance();
        detector.add((ICodepageDetector)new ParsingDetector(false));
        detector.add((ICodepageDetector)JChardetFacade.getInstance());
        detector.add(ASCIIDetector.getInstance());
        detector.add(UnicodeDetector.getInstance());
        return detector;
    }

    public static String detectCharset(File file) throws IOException {
        CodepageDetectorProxy detector = EncodingUtil.prepareDetector();
        Charset charset = detector.detectCodepage(file.toURI().toURL());
        String charsetname = charset.name();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Input file is :[" + file.getName() + "], guess charset is :[" + charsetname + "]"));
        }
        return charsetname;
    }

    public static String detectCharset(InputStream in, int length) throws IOException {
        CodepageDetectorProxy detector = EncodingUtil.prepareDetector();
        Charset charset = detector.detectCodepage(in, length);
        String charsetname = charset.name();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("InputStream, guess charset is :[" + charsetname + "]"));
        }
        return charsetname;
    }
}

