/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.pool;

import com.eprobiti.trs.TRSConnection;
import com.eprobiti.trs.TRSException;
import com.trs.cis4.pool.PooledConnection;
import com.trs.cis4.pool.TrsDbConfig;
import com.trs.cis4.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ConnectionManager
implements Runnable {
    private Logger log = Logger.getLogger(this.getClass());
    private static long connectionTotal = 0L;
    private static List idleConnections = new ArrayList();
    private static int MAX_CON = 200;
    private static int TIMEOUT = 1500;
    private static int Refresh_Interval = 60000;
    private static long Valid_Time = 600000L;
    private TrsDbConfig trsdbConfig;

    public TrsDbConfig getTrsdbConfig() {
        return this.trsdbConfig;
    }

    public void setTrsdbConfig(TrsDbConfig trsdbConfig) {
        this.trsdbConfig = trsdbConfig;
    }

    public void setMAX_CON(int max_con) {
        MAX_CON = max_con;
    }

    public void setTIMEOUT(int timeout) {
        TIMEOUT = timeout;
    }

    public void setRefresh_Interval(int refresh_Interval) {
        Refresh_Interval = refresh_Interval;
    }

    public void setValid_Time(long valid_Time) {
        Valid_Time = valid_Time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                Thread.sleep(Refresh_Interval);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                int i = idleConnections.size() - 1;
                while (i >= 0) {
                    PooledConnection con = (PooledConnection)idleConnections.get(i);
                    if (!con.isValid() || System.currentTimeMillis() - con.getStartIdleTime() > Valid_Time) {
                        this.removeFromPool(i);
                        --connectionTotal;
                        this.notify();
                    }
                    --i;
                }
                if (connectionTotal >= 10L) {
                    this.log.error((Object)("\u5f53\u524dTRSDB\u8fde\u63a5\u6c60\u5927\u5c0f\uff1a" + connectionTotal));
                }
            }
        }
    }

    public synchronized TRSConnection dbConnect() throws ExceptionUtil {
        return this.getConnection();
    }

    public synchronized TRSConnection dbConnectAgain() throws ExceptionUtil {
        long startTime = System.currentTimeMillis();
        TRSConnection conn = null;
        while ((conn = this.getConnection()) == null) {
            try {
                this.wait(TIMEOUT);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() - startTime < (long)TIMEOUT) continue;
            return this.getConnection();
        }
        return conn;
    }

    public synchronized int dbDisConnect(TRSConnection conn) {
        block3: {
            try {
                if (conn != null) break block3;
                return 0;
            }
            catch (Exception e) {
                return -1;
            }
        }
        idleConnections.add(new PooledConnection(conn));
        this.notify();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int forceDisConnect() {
        try {
            int count = 0;
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                count = idleConnections.size();
                int i = count - 1;
                while (i >= 0) {
                    this.removeFromPool(i);
                    --connectionTotal;
                    this.notify();
                    --i;
                }
            }
            return count;
        }
        catch (Exception e) {
            return -1;
        }
    }

    private TRSConnection getConnection() throws ExceptionUtil {
        TRSConnection conn = this.getConnectionFromPool();
        if (conn == null && connectionTotal < (long)MAX_CON) {
            try {
                TRSConnection trscon = new TRSConnection();
                trscon.connect(this.trsdbConfig.getServerhost(), this.trsdbConfig.getServerport(), this.trsdbConfig.getUsername(), this.trsdbConfig.getPassword());
                TRSConnection.setCharset((int)this.trsdbConfig.getTrsserverCharsetInt(), (boolean)true);
                conn = trscon;
                ++connectionTotal;
                return conn;
            }
            catch (TRSException e) {
                this.log.error((Object)(String.valueOf(e.getErrorString()) + " " + e.toString()));
                throw new ExceptionUtil(e.getErrorCode(), "\u8fde\u63a5\u6570\u636e\u5e93\u5931\u8d25\uff01", e);
            }
        }
        return conn;
    }

    private TRSConnection getConnectionFromPool() {
        while (idleConnections.size() > 0) {
            PooledConnection con = (PooledConnection)idleConnections.remove(0);
            if (con.isValid()) {
                return con.getConnection();
            }
            con.release();
            --connectionTotal;
        }
        return null;
    }

    private void removeFromPool(int index) {
        ((PooledConnection)idleConnections.remove(index)).release();
    }
}

