/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.DateObject;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.RawInputStream;
import com.sybase.jdbc2.tds.BlobOutputStream;
import com.sybase.jdbc2.tds.PduOutputFormatter;
import com.sybase.jdbc2.tds.Tds;
import com.sybase.jdbc2.tds.TdsDataObject;
import com.sybase.jdbc2.tds.TdsDateTime;
import com.sybase.jdbc2.tds.TdsJdbcInputStream;
import com.sybase.jdbc2.tds.TdsNumeric;
import com.sybase.jdbc2.tds.TdsOutputStream;
import com.sybase.jdbc2.tds.TdsParam;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.SQLException;

public class TdsDataOutputStream
extends TdsOutputStream {
    Tds _tds;
    protected static final int BUF_SIZE = 2048;
    protected static final int TDS_TYPE = 0;
    protected static final int LENGTH = 1;
    protected static final int PRECISION = 2;
    protected static final int SCALE = 3;
    protected static final int INFO_LENGTH = 4;

    public TdsDataOutputStream(Tds tds, PduOutputFormatter pduOutputFormatter) throws IOException {
        super(pduOutputFormatter);
        this._tds = tds;
    }

    protected void convertString(TdsParam tdsParam, int[] nArray) throws IOException {
        if (tdsParam._inValue != null) {
            if (tdsParam._inValue instanceof String) {
                if (tdsParam._cvtString == null) {
                    tdsParam._parameterAsAString = (String)tdsParam._inValue;
                    if (this._tds.isUnicharEnabled()) {
                        this.setUnicharParameter(tdsParam);
                    } else {
                        tdsParam._cvtString = this.stringToByte((String)tdsParam._inValue);
                    }
                }
                nArray[1] = tdsParam._cvtString.length;
            } else if (tdsParam._inValue instanceof InputStream) {
                if (tdsParam._cvtString == null) {
                    String string = null;
                    tdsParam._parameterAsAString = string = tdsParam.getStringFromStream(0);
                    if (this._tds.isUnicharEnabled()) {
                        this.setUnicharParameter(tdsParam);
                    } else {
                        tdsParam._cvtString = this.stringToByte(string);
                    }
                }
                nArray[1] = tdsParam._cvtString.length;
            } else if (tdsParam._inValue instanceof Reader) {
                if (tdsParam._cvtString == null) {
                    char[] cArray = new char[2048];
                    StringBuffer stringBuffer = new StringBuffer(2048);
                    int n = 0;
                    while (true) {
                        int n2;
                        int n3 = 2048;
                        if (tdsParam._scale >= 0 && tdsParam._scale < 2048) {
                            n3 = tdsParam._scale - n;
                        }
                        if (n3 <= 0 || (n2 = ((Reader)tdsParam._inValue).read(cArray, 0, n3)) <= 0) break;
                        stringBuffer.append(cArray, 0, n2);
                        n += n2;
                    }
                    tdsParam._parameterAsAString = stringBuffer.toString();
                    if (this._tds.isUnicharEnabled()) {
                        this.setUnicharParameter(tdsParam);
                    } else {
                        tdsParam._cvtString = this.stringToByte(stringBuffer.toString());
                    }
                }
                nArray[1] = tdsParam._cvtString.length;
            } else {
                if (tdsParam._cvtString == null) {
                    tdsParam._parameterAsAString = tdsParam._inValue.toString();
                    if (this._tds.isUnicharEnabled()) {
                        this.setUnicharParameter(tdsParam);
                    } else {
                        tdsParam._cvtString = this.stringToByte(tdsParam._inValue.toString());
                    }
                }
                nArray[1] = tdsParam._cvtString.length;
            }
        }
    }

    protected void dataTypeInfo(TdsParam tdsParam, int[] nArray) throws IOException {
        switch (tdsParam._sqlType) {
            case -7: {
                nArray[0] = 50;
                break;
            }
            case -6: {
                nArray[0] = 38;
                nArray[1] = 1;
                break;
            }
            case 5: {
                nArray[0] = 38;
                nArray[1] = 2;
                break;
            }
            case -998: {
                nArray[0] = 56;
                nArray[1] = 4;
                break;
            }
            case 4: {
                nArray[0] = 38;
                nArray[1] = 4;
                break;
            }
            case -5: {
                nArray[0] = 38;
                nArray[1] = 8;
                break;
            }
            case 7: {
                nArray[0] = 109;
                nArray[1] = 4;
                break;
            }
            case 6: 
            case 8: {
                nArray[0] = 109;
                nArray[1] = 8;
                break;
            }
            case 2: 
            case 3: {
                nArray[0] = 108;
                if (tdsParam == null) break;
                TdsNumeric.tdsNumeric((BigDecimal)tdsParam._inValue, tdsParam._scale, nArray);
                break;
            }
            case 9219: 
            case 9220: {
                nArray[0] = tdsParam._sqlType;
                nArray[1] = tdsParam._scale;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                if (this._tds.isUnicharEnabled()) {
                    nArray[0] = 225;
                    tdsParam._sqlType = -4;
                    tdsParam._parameterHoldsUnicharData = true;
                } else {
                    nArray[0] = tdsParam._sqlType == -1 ? 175 : 39;
                }
                this.convertString(tdsParam, nArray);
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                nArray[0] = 111;
                nArray[1] = 8;
                break;
            }
            case -3: 
            case -2: {
                nArray[0] = 37;
                if (tdsParam._inValue == null) break;
                nArray[1] = ((byte[])tdsParam._inValue).length;
                break;
            }
            case -4: {
                nArray[0] = 225;
                if (tdsParam._inValue == null) break;
                if (tdsParam._inValue instanceof byte[]) {
                    nArray[1] = ((byte[])tdsParam._inValue).length;
                    break;
                }
                if (!(tdsParam._inValue instanceof InputStream)) break;
                if (tdsParam._scale == -1) {
                    InputStream inputStream = (InputStream)tdsParam._inValue;
                    nArray[1] = inputStream.available();
                    break;
                }
                nArray[1] = tdsParam._scale;
                break;
            }
            case 2000: {
                nArray[0] = 9217;
                nArray[1] = -1;
                break;
            }
            default: {
                ErrorMessage.raiseIOException("JZ0SM", String.valueOf(tdsParam._sqlType));
            }
        }
        if (tdsParam._inValue == null) {
            nArray[1] = 0;
        }
    }

    public String getCharset() {
        return this._tds._charsetName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void send(TdsDataObject tdsDataObject) throws SQLException {
        block42: {
            block41: {
                block40: {
                    block39: {
                        block38: {
                            block37: {
                                block36: {
                                    block35: {
                                        try {
                                            block43: {
                                                try {
                                                    tdsDataObject.beginRead();
                                                    if (!tdsDataObject._isNull) {
                                                        int n;
                                                        int n2 = tdsDataObject._dataLength;
                                                        switch (tdsDataObject._dataFmt._datatype) {
                                                            case 48: {
                                                                this.writeByte(tdsDataObject.getByte());
                                                                Object var3_4 = null;
                                                                break block35;
                                                            }
                                                            case 52: {
                                                                this.writeShort(tdsDataObject.getShort());
                                                                break block36;
                                                            }
                                                            case 56: {
                                                                this.writeInt(tdsDataObject.getInt());
                                                                break block37;
                                                            }
                                                            case 38: {
                                                                this.writeByte(n2);
                                                                long l = tdsDataObject.getLong();
                                                                switch (n2) {
                                                                    case 1: {
                                                                        this.writeByte((byte)l);
                                                                        break;
                                                                    }
                                                                    case 2: {
                                                                        this.writeShort((short)l);
                                                                        break;
                                                                    }
                                                                    case 4: {
                                                                        this.writeInt((int)l);
                                                                        break;
                                                                    }
                                                                    case 8: {
                                                                        this.writeLong(l);
                                                                        break;
                                                                    }
                                                                }
                                                                break block38;
                                                            }
                                                            case 59: {
                                                                this.writeFloat(tdsDataObject.getFloat());
                                                                break block39;
                                                            }
                                                            case 62: {
                                                                this.writeDouble(tdsDataObject.getDouble());
                                                                break block40;
                                                            }
                                                            case 109: {
                                                                this.writeByte(n2);
                                                                double d = tdsDataObject.getDouble();
                                                                switch (n2) {
                                                                    case 4: {
                                                                        this.writeFloat((float)d);
                                                                        break;
                                                                    }
                                                                    case 8: {
                                                                        this.writeDouble(d);
                                                                        break;
                                                                    }
                                                                }
                                                                break block41;
                                                            }
                                                            case 37: 
                                                            case 39: 
                                                            case 45: 
                                                            case 47: 
                                                            case 103: 
                                                            case 104: 
                                                            case 106: 
                                                            case 108: 
                                                            case 110: 
                                                            case 111: {
                                                                this.writeByte(n2);
                                                                break;
                                                            }
                                                            case 34: 
                                                            case 35: 
                                                            case 175: 
                                                            case 225: {
                                                                this.writeInt(n2);
                                                                break;
                                                            }
                                                            case 36: {
                                                                int n3;
                                                                tdsDataObject.reset();
                                                                RawInputStream rawInputStream = ((TdsJdbcInputStream)tdsDataObject).makeNewRIS(4);
                                                                byte[] byArray = new byte[2048];
                                                                while ((n3 = rawInputStream.read(byArray)) >= 0) {
                                                                    this.write(byArray, 0, n3);
                                                                }
                                                                break block42;
                                                            }
                                                            default: {
                                                                ErrorMessage.raiseError("JZ0TC");
                                                                break;
                                                            }
                                                            case 50: 
                                                            case 58: 
                                                            case 60: 
                                                            case 61: 
                                                            case 122: 
                                                        }
                                                        byte[] byArray = new byte[n2 < 2048 ? n2 : 2048];
                                                        int n4 = 0;
                                                        while (n4 < n2 && (n = tdsDataObject.read(byArray)) >= 0) {
                                                            this.write(byArray, 0, n);
                                                            n4 += n;
                                                        }
                                                        break block43;
                                                    }
                                                    if ((tdsDataObject._dataFmt._status & 0x20) != 0) {
                                                        switch (tdsDataObject._dataFmt._datatype) {
                                                            case 37: 
                                                            case 38: 
                                                            case 39: 
                                                            case 45: 
                                                            case 47: 
                                                            case 103: 
                                                            case 104: 
                                                            case 106: 
                                                            case 108: 
                                                            case 109: 
                                                            case 110: 
                                                            case 111: {
                                                                this.writeByte(0);
                                                                break;
                                                            }
                                                            case 34: 
                                                            case 35: 
                                                            case 36: 
                                                            case 175: 
                                                            case 225: {
                                                                this.writeInt(0);
                                                                break;
                                                            }
                                                            default: {
                                                                ErrorMessage.raiseError("JZ0TC");
                                                                break;
                                                            }
                                                        }
                                                    }
                                                }
                                                catch (IOException iOException) {
                                                    ErrorMessage.raiseErrorCheckDead(iOException);
                                                }
                                            }
                                            Object var3_12 = null;
                                        }
                                        catch (Throwable throwable) {
                                            Object var3_13 = null;
                                            tdsDataObject.endRead();
                                            throw throwable;
                                        }
                                        tdsDataObject.endRead();
                                        return;
                                    }
                                    tdsDataObject.endRead();
                                    return;
                                }
                                Object var3_5 = null;
                                tdsDataObject.endRead();
                                return;
                            }
                            Object var3_6 = null;
                            tdsDataObject.endRead();
                            return;
                        }
                        Object var3_7 = null;
                        tdsDataObject.endRead();
                        return;
                    }
                    Object var3_8 = null;
                    tdsDataObject.endRead();
                    return;
                }
                Object var3_9 = null;
                tdsDataObject.endRead();
                return;
            }
            Object var3_10 = null;
            tdsDataObject.endRead();
            return;
        }
        Object var3_11 = null;
        tdsDataObject.endRead();
    }

    private void setUnicharParameter(TdsParam tdsParam) {
        tdsParam._cvtString = tdsParam.stringToUnicodeBytes(tdsParam._parameterAsAString);
        tdsParam._inValue = tdsParam._cvtString;
        tdsParam._sqlType = -4;
        tdsParam._parameterHoldsUnicharData = true;
    }

    protected byte[] toBytes(String string) throws CharConversionException {
        if (string == null) {
            return null;
        }
        return this._tds._charsetConverter.fromUnicode(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeParam(TdsParam tdsParam, int n) throws IOException {
        int[] nArray = new int[4];
        this.dataTypeInfo(tdsParam, nArray);
        if (tdsParam._inValue == null) {
            switch (nArray[0]) {
                case 50: {
                    this.writeByte(0);
                    return;
                }
                case 37: 
                case 38: 
                case 39: 
                case 108: 
                case 109: 
                case 111: {
                    this.writeByte(0);
                    return;
                }
                case 175: 
                case 225: {
                    this.writeInt(0);
                    return;
                }
                case 36: 
                case 9217: {
                    this.writeByte(1);
                    this.writeShort(0);
                    this.writeInt(0);
                    return;
                }
                case 9219: 
                case 9220: {
                    this.writeByte(0);
                    this.writeShort(0);
                    this.writeInt(0);
                    return;
                }
            }
            return;
        }
        switch (nArray[0]) {
            case 50: {
                this.writeByte((Boolean)tdsParam._inValue != false ? 1 : 0);
                return;
            }
            case 38: {
                this.writeByte(nArray[1]);
                switch (nArray[1]) {
                    case 1: {
                        this.writeByte((Integer)tdsParam._inValue);
                        return;
                    }
                    case 2: {
                        this.writeShort((Integer)tdsParam._inValue);
                        return;
                    }
                    case 4: {
                        this.writeInt((Integer)tdsParam._inValue);
                        return;
                    }
                    case 8: {
                        this.writeLong((Long)tdsParam._inValue);
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 109: {
                this.writeByte(nArray[1]);
                switch (nArray[1]) {
                    case 4: {
                        this.writeFloat(((Float)tdsParam._inValue).floatValue());
                        return;
                    }
                    case 8: {
                        this.writeDouble((Double)tdsParam._inValue);
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 39: 
            case 175: {
                int n2 = nArray[1];
                if (nArray[0] == 39) {
                    this.writeByte(n2);
                } else {
                    this.writeInt(n2);
                }
                if (n2 <= 0) return;
                this.write(tdsParam._cvtString, 0, n2);
                return;
            }
            case 37: {
                int n3 = nArray[1];
                this.writeByte(n3);
                if (n3 <= 0) return;
                this.write((byte[])tdsParam._inValue, 0, n3);
                return;
            }
            case 225: {
                int n4 = nArray[1];
                this.writeInt(n4);
                if (n4 <= 0) return;
                if (tdsParam._inValue instanceof byte[]) {
                    this.write((byte[])tdsParam._inValue, 0, n4);
                    return;
                }
                if (!(tdsParam._inValue instanceof InputStream)) return;
                InputStream inputStream = (InputStream)tdsParam._inValue;
                int n5 = n4 < 2048 ? n4 : 2048;
                byte[] byArray = new byte[n5];
                while (n4 > 0) {
                    int n6 = inputStream.read(byArray, 0, n4 > n5 ? n5 : n4);
                    if (n6 < 0) return;
                    this.write(byArray, 0, n6);
                    n4 -= n6;
                }
                return;
            }
            case 108: {
                byte[] byArray = TdsNumeric.tdsNumeric((BigDecimal)tdsParam._inValue, tdsParam._scale, nArray);
                this.writeByte(nArray[1]);
                if (nArray[1] <= 0) return;
                this.write(byArray);
                return;
            }
            case 111: {
                this.writeByte(nArray[1]);
                if (nArray[1] <= 0) return;
                int[] nArray2 = TdsDateTime.tdsDateTime((DateObject)tdsParam._inValue);
                this.writeInt(nArray2[0]);
                this.writeInt(nArray2[1]);
                return;
            }
            case 9217: {
                this.writeByte(1);
                this.writeShort(0);
                BlobOutputStream blobOutputStream = new BlobOutputStream(this);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(blobOutputStream);
                objectOutputStream.writeObject(tdsParam._inValue);
                objectOutputStream.close();
                return;
            }
            case 9219: {
                this.writeByte(0);
                this.writeShort(0);
                BlobOutputStream blobOutputStream = new BlobOutputStream(this);
                if (tdsParam._inValue instanceof InputStream) {
                    InputStream inputStream = (InputStream)tdsParam._inValue;
                    byte[] byArray = new byte[2048];
                    int n7 = nArray[1];
                    if (n7 > 0) {
                        n7 *= 2;
                    }
                    char[] cArray = new char[1024];
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)blobOutputStream, this._tds._charsetName);
                    while (n7 != 0) {
                        int n8;
                        int n9;
                        int n10;
                        int n11 = 2048;
                        if (n7 > 0 && n7 < n11) {
                            n11 = n7;
                        }
                        if ((n10 = inputStream.read(byArray, 0, n11)) < 0) break;
                        if (n10 % 2 != 0) {
                            n9 = inputStream.read();
                            if (n9 == -1) break;
                            byArray[n10++] = (byte)n9;
                        }
                        if (n7 > 0) {
                            n7 -= n10;
                        }
                        n9 = n10 / 2;
                        if (!tdsParam._paramIsLittleEndian) {
                            n8 = 0;
                            while (n8 < n9) {
                                cArray[n8] = (char)(byArray[n8 * 2] << 8 | byArray[n8 * 2 + 1] & 0xFF);
                                ++n8;
                            }
                        } else {
                            n8 = 0;
                            while (n8 < n9) {
                                cArray[n8] = (char)(byArray[n8 * 2 + 1] << 8 | byArray[n8 * 2] & 0xFF);
                                ++n8;
                            }
                        }
                        outputStreamWriter.write(cArray, 0, n9);
                    }
                    outputStreamWriter.flush();
                } else if (tdsParam._inValue instanceof Reader) {
                    Reader reader = (Reader)tdsParam._inValue;
                    int n12 = nArray[1];
                    char[] cArray = new char[2048];
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)blobOutputStream, this._tds._charsetName);
                    while (n12 != 0) {
                        int n13;
                        int n14 = 2048;
                        if (n12 > 0 && n12 < n14) {
                            n14 = n12;
                        }
                        if ((n13 = reader.read(cArray, 0, n14)) < 0) break;
                        if (n12 > 0) {
                            n12 -= n13;
                        }
                        outputStreamWriter.write(cArray, 0, n13);
                    }
                    outputStreamWriter.flush();
                }
                blobOutputStream.close();
                return;
            }
            case 9220: {
                this.writeByte(0);
                this.writeShort(0);
                BlobOutputStream blobOutputStream = new BlobOutputStream(this);
                InputStream inputStream = (InputStream)tdsParam._inValue;
                byte[] byArray = new byte[2048];
                int n15 = nArray[1];
                while (n15 != 0) {
                    int n16;
                    int n17 = 2048;
                    if (n15 > 0 && n15 < n17) {
                        n17 = n15;
                    }
                    if ((n16 = inputStream.read(byArray, 0, n17)) < 0) break;
                    if (n15 > 0) {
                        n15 -= n16;
                    }
                    blobOutputStream.write(byArray, 0, n16);
                }
                blobOutputStream.close();
                return;
            }
        }
    }
}

