/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2CallableStatement;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2PreparedStatement;
import COM.ibm.db2.jdbc.app.DB2ResultSet;
import COM.ibm.db2.jdbc.app.DB2ResultSetTrace;
import COM.ibm.db2.jdbc.app.DB2ScrollableResultSet;
import COM.ibm.db2.jdbc.app.DB2ScrollableResultSetTrace;
import COM.ibm.db2.jdbc.app.SQLExceptionGenerator;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class DB2Statement
implements Statement {
    protected static final short STMT_TYPE_QUERY = 24;
    protected static final short STMT_TYPE_CALL = 25;
    protected static final short STMT_TYPE_OTHER = 26;
    protected static final short STMT_TYPE_SQLJ = 27;
    protected int statementHandle = 0;
    protected DB2Connection connection;
    SQLWarning warnings = null;
    protected int maxRows = 0;
    protected int maxFieldSize = 0;
    protected int rowCount = 0;
    protected short colCount = 0;
    protected int returnCode = 0;
    protected boolean closed = false;
    protected boolean internalStmt = false;
    protected DB2ResultSet resultSet = null;
    protected boolean moreResults = true;
    protected SQLExceptionGenerator sqlExcptGen;
    protected String[] colNames4JSQL = null;
    protected int colCount4JSQL = 0;
    protected String SQLState = null;
    protected String SQLmessage = null;
    protected int SQLnativeCode = 0;
    protected byte[] SQLca = null;
    protected boolean cachedError = false;
    protected int SQLNextErrorRC = 0;
    protected int sqlSuccess = 0;
    protected int rsType = 1003;
    protected int rsConcur = 1007;
    protected int rsTypeAllocated = this.rsType;
    private boolean counted = false;
    private static int statementCount = 0;
    private static int peakStatementCount = 0;
    protected String sql = null;
    protected int fetchDirection = 1000;
    protected int fetchSize = 0;
    protected String batchQuery = null;
    protected int batchSize = 0;
    protected int[] batchReturn = null;
    protected BatchUpdateException batchUpdateException = null;
    protected BatchUpdateException lastBatchUpdateException = null;

    public DB2Statement(DB2Connection dB2Connection) throws SQLException {
        this(dB2Connection, 1003, 1007);
    }

    public DB2Statement(DB2Connection dB2Connection, int n, int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "DB2Statement( con, " + n + ", " + n2 + " )");
            }
            this.connection = dB2Connection;
            this.sqlExcptGen = this.connection.sqlExcptGen;
            this.checkResultSetType(n, n2);
            this.rsType = n;
            this.rsConcur = n2;
            this.rsTypeAllocated = n;
            this.returnCode = 0;
            this.statementHandle = this.SQLAllocStmt(this.connection.connectionHandle, n, n2);
            if (this.returnCode != 0) {
                this.sqlExcptGen.check_return_code(this, this.returnCode);
                if (this.returnCode == 1 && this.rsTypeAllocated != 1003) {
                    SQLWarning sQLWarning = this.getWarnings();
                    while (sQLWarning != null) {
                        if (sQLWarning.getSQLState().equalsIgnoreCase("01S02")) {
                            this.rsTypeAllocated = this.rsType = 1003;
                            this.connection.addWarning(new SQLWarning("Cursor downgraded to TYPE_FORWARD_ONLY", "01S02", -99999));
                            if (DB2Trace.TraceOn) {
                                DB2Trace.data(10, "Cursor downgraded to TYPE_FORWARD_ONLY");
                            }
                        }
                        sQLWarning = sQLWarning.getNextWarning();
                    }
                }
            }
            this.incrementStatementCount();
        }
        finally {
            Object var5_5 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                DB2Trace.methodExit(this, "DB2Statement()");
            }
        }
    }

    public DB2Statement(DB2Connection dB2Connection, boolean bl) throws SQLException {
        this(dB2Connection);
        this.internalStmt = bl;
    }

    protected native int SQLAllocStmt(int var1, int var2, int var3);

    protected native int SQLCancel(int var1);

    protected native int SQLExecBatch(String var1, int var2, int var3, int var4);

    protected native int SQLExecDirect(String var1, int var2, int var3);

    protected native int SQLFreeStmt(int var1);

    protected native int SQLGetColumnCount(int var1);

    protected native int SQLGetQueryTimeout(int var1);

    protected native int SQLGetRowCount(int var1);

    protected native int SQLGetStmtAttr(int var1, int var2);

    protected native int SQLMaxFieldSize(int var1, int var2);

    protected native int SQLMaxRows(int var1, int var2);

    protected native int SQLMoreResults(int var1, int var2);

    protected native int SQLScan(boolean var1, int var2);

    protected native int SQLSetCursorName(String var1, int var2, int var3);

    protected native int SQLSetQueryTimeout(int var1, int var2);

    protected native int SQLSetStmtAttr(int var1, int var2, int var3);

    public void addBatch(String string) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "addBatch( " + string + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            this.batchQuery = this.batchSize == 0 ? string : String.valueOf(this.batchQuery) + ";" + string;
            ++this.batchSize;
        }
        finally {
            Object var3_2 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "addBatch()");
            }
        }
    }

    protected void addWarning(SQLWarning sQLWarning) {
        block7: {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "addWarning()");
                }
                if (this.warnings == null) {
                    this.warnings = sQLWarning;
                    break block7;
                }
                SQLWarning sQLWarning2 = this.warnings;
                while (sQLWarning2.getNextWarning() != null) {
                    sQLWarning2 = sQLWarning2.getNextWarning();
                }
                sQLWarning2.setNextWarning(sQLWarning);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodExit(this, "addWarning()");
                }
                throw throwable;
            }
        }
        Object var3_3 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "addWarning()");
        }
    }

    private static synchronized void adjustStatementCount(int n) {
        if ((statementCount += n) > peakStatementCount) {
            peakStatementCount = statementCount;
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "Peak statements", peakStatementCount);
            }
            DriverManager.println("DB2 Peak statements = " + peakStatementCount);
        }
    }

    public void cancel() throws SQLException {
        int n;
        block7: {
            n = 0;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "cancel()");
                    DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                }
                if (this.connection.closed) {
                    this.sqlExcptGen.throwConnectionClosedError();
                }
                if (this.closed) {
                    this.sqlExcptGen.throwClosedError();
                }
                if (this.statementHandle == 0 || (n = this.SQLCancel(this.statementHandle)) == 0) break block7;
                this.sqlExcptGen.check_return_code(this, n);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "SQLCancel- rc ", n);
                    DB2Trace.methodExit(this, "cancel()");
                }
                throw throwable;
            }
        }
        Object var3_2 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, "SQLCancel- rc ", n);
            DB2Trace.methodExit(this, "cancel()");
        }
    }

    protected void checkFetchDirection(int n, int n2) throws SQLException {
        block6: {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "checkFetchDirection( " + n + ", " + n2 + " )");
                }
                if (n2 != 1000 && n2 != 1001 && n2 != 1002) {
                    this.sqlExcptGen.throwFetchDirectionError();
                }
                if (n != 1003 || n2 != 1001) break block6;
                this.sqlExcptGen.throwFetchDirectionError();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodExit(this, "checkFetchDirection()");
                }
                throw throwable;
            }
        }
        Object var4_3 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "checkFetchDirection()");
        }
    }

    protected void checkFetchSize(int n, int n2) throws SQLException {
        block5: {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "checkFetchSize( " + n + ", " + n2 + " )");
                }
                if ((n == 0 || n2 <= n) && n2 >= 0) break block5;
                this.sqlExcptGen.throwFetchSizeError();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodExit(this, "checkFetchSize()");
                }
                throw throwable;
            }
        }
        Object var4_3 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "checkFetchSize()");
        }
    }

    protected void checkResultSetType(int n, int n2) throws SQLException {
        block8: {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "checkResultSetType( " + n + ", " + n2 + " )");
                }
                if (n2 == 1008) {
                    this.sqlExcptGen.throwNotSupportedByDB2("Updatable result set");
                }
                if (n2 != 1007) {
                    this.sqlExcptGen.throwUnknownResultSetType(n2);
                }
                if (n == 1005) {
                    this.sqlExcptGen.throwNotSupportedByDB2("Scroll sensitive result set");
                }
                if (n == 1003 || n == 1004) break block8;
                this.sqlExcptGen.throwUnknownResultSetType(n);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodExit(this, "checkResultSetType()");
                }
                throw throwable;
            }
        }
        Object var4_3 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "checkResultSetType()");
        }
    }

    public void clearBatch() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "clearBatch()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            this.batchSize = 0;
            this.batchQuery = null;
        }
        finally {
            Object var2_1 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "batchSize ", this.batchSize);
                DB2Trace.methodExit(this, "clearBatch()");
            }
        }
    }

    public synchronized void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public void close() throws SQLException {
        block5: {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "close()");
                    DB2Trace.data(10, "StatementHandle ", this.getTraceHandle());
                }
                if (this.closed) break block5;
                this.close2(true);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodExit(this, "close()");
                }
                throw throwable;
            }
        }
        Object var2_1 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "close()");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void close2(boolean bl) throws SQLException {
        int n;
        block18: {
            block19: {
                block16: {
                    block15: {
                        n = 0;
                        try {
                            if (DB2Trace.TraceOn) {
                                DB2Trace.methodEntry(this, "close2( " + bl + " )");
                            }
                            this.closed = true;
                            this.decrementStatementCount();
                            if (this.connection == null) {
                                if (DB2Trace.TraceOn) {
                                    DB2Trace.data(10, "connection is null");
                                }
                                Object var4_3 = null;
                                if (!DB2Trace.TraceOn) return;
                                break block15;
                            }
                            if (this.statementHandle == 0) {
                                if (DB2Trace.TraceOn) {
                                    DB2Trace.data(20, "statementHandle = 0");
                                }
                                break block16;
                            }
                            DB2Connection dB2Connection = this.connection;
                            synchronized (dB2Connection) {
                                block17: {
                                    if (this.connection.closed) {
                                        if (DB2Trace.TraceOn) {
                                            DB2Trace.data(30, "connection is closed");
                                        }
                                        Object var6_9 = null;
                                        break block17;
                                    }
                                    if (this.resultSet != null) {
                                        this.resultSet.clearIsList();
                                    }
                                    if (!this.connection.SPConnected || this.connection.SPConnected && bl) {
                                        n = this.SQLFreeStmt(this.statementHandle);
                                        if (this.returnCode != 0) {
                                            this.sqlExcptGen.check_return_code(this, n);
                                        }
                                        this.statementHandle = 0;
                                    }
                                    break block18;
                                }
                            }
                            break block19;
                        }
                        catch (Throwable throwable) {
                            Object var4_7 = null;
                            if (!DB2Trace.TraceOn) throw throwable;
                            DB2Trace.methodExit((Object)this, "close2()", n);
                            throw throwable;
                        }
                    }
                    DB2Trace.methodExit((Object)this, "close2()", n);
                    return;
                }
                Object var4_4 = null;
                if (!DB2Trace.TraceOn) return;
                DB2Trace.methodExit((Object)this, "close2()", n);
                return;
            }
            Object var4_5 = null;
            if (!DB2Trace.TraceOn) return;
            DB2Trace.methodExit((Object)this, "close2()", n);
            return;
        }
        Object var4_6 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit((Object)this, "close2()", n);
    }

    private synchronized void decrementStatementCount() {
        if (this.counted) {
            DB2Statement.adjustStatementCount(-1);
            this.counted = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(String string) throws SQLException {
        boolean bl;
        boolean bl2;
        block6: {
            boolean bl3;
            block5: {
                this.sql = string;
                bl2 = false;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "execute( " + string + " )");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (string == null || string.trim().length() == 0) {
                        this.sqlExcptGen.throwNullError();
                    }
                    this.execute2(string);
                    this.getResultSet();
                    if (this.resultSet.numCols > 0) {
                        bl3 = bl2 = true;
                        Object var5_5 = null;
                        if (!DB2Trace.TraceOn) return bl3;
                        break block5;
                    }
                    bl = bl2 = false;
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit((Object)this, "execute()", String.valueOf(bl2));
                    throw throwable;
                }
            }
            DB2Trace.methodExit((Object)this, "execute()", String.valueOf(bl2));
            return bl3;
        }
        Object var5_6 = null;
        if (!DB2Trace.TraceOn) return bl;
        DB2Trace.methodExit((Object)this, "execute()", String.valueOf(bl2));
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void execute2(String string) throws SQLException {
        block17: {
            block16: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "execute2( " + string + " )");
                        DB2Trace.data(10, "StatementHandle ", this.getTraceHandle());
                    }
                    this.moreResults = true;
                    if (this.connection.closed) {
                        this.sqlExcptGen.throwConnectionClosedError();
                    }
                    if (this.closed) {
                        this.sqlExcptGen.throwClosedError();
                    }
                    if (string == null || string.trim().length() == 0) {
                        this.sqlExcptGen.throwNullError();
                    }
                    this.warnings = null;
                    if (this.resultSet != null) {
                        this.resultSet.close();
                    }
                    this.rowCount = 0;
                    if (this.rsTypeAllocated != 1003 && this.rsType == 1003) {
                        this.returnCode = 0;
                        int n = this.SQLSetStmtAttr(this.statementHandle, 6, 3);
                        if (n != 0) {
                            this.sqlExcptGen.check_return_code(this, n);
                        }
                        this.rsType = this.rsTypeAllocated;
                        if (DB2Trace.TraceOn) {
                            DB2Trace.data(10, "rsType upgraded (rsTypeAllocated,rsType)", String.valueOf(this.rsTypeAllocated) + "," + this.rsType);
                        }
                    }
                    this.returnCode = 0;
                    DB2Connection dB2Connection = this.connection;
                    synchronized (dB2Connection) {
                        this.returnCode = (short)this.SQLExecDirect(string, this.statementHandle, this.connection.connectionHandle);
                    }
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "SQLExecDirect - returnCode ", this.returnCode);
                    }
                    if (this.returnCode == 100) {
                        this.rowCount = 0;
                        Object var3_4 = null;
                        if (!DB2Trace.TraceOn) return;
                        break block16;
                    }
                    if (this.returnCode != 0) {
                        this.sqlExcptGen.check_return_code(this, this.returnCode);
                    }
                    break block17;
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.data(10, "rowCount", this.rowCount);
                    DB2Trace.methodExit(this, "execute2()");
                    throw throwable;
                }
            }
            DB2Trace.data(10, "rowCount", this.rowCount);
            DB2Trace.methodExit(this, "execute2()");
            return;
        }
        Object var3_5 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.data(10, "rowCount", this.rowCount);
        DB2Trace.methodExit(this, "execute2()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        int[] nArray;
        block11: {
            int[] nArray2;
            block10: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "executeBatch()");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (this.connection.closed) {
                        this.sqlExcptGen.throwConnectionClosedError();
                    }
                    if (this.closed) {
                        this.sqlExcptGen.throwClosedError();
                    }
                    if (this.resultSet != null) {
                        this.resultSet.close();
                    }
                    if (this.batchSize == 0) {
                        nArray2 = new int[]{};
                        Object var3_3 = null;
                        if (!DB2Trace.TraceOn) return nArray2;
                        break block10;
                    }
                    this.batchReturn = null;
                    this.lastBatchUpdateException = null;
                    this.batchUpdateException = null;
                    int n = this.SQLExecBatch(this.batchQuery, this.batchSize, this.statementHandle, this.connection.connectionHandle);
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "SQLExecBatch - return code", n);
                    }
                    if (n != 0 && n != 1) {
                        this.sqlExcptGen.check_batch_return_code(this, n);
                    }
                    this.clearBatch();
                    if (this.batchUpdateException != null) {
                        BatchUpdateException batchUpdateException = this.batchUpdateException;
                        this.lastBatchUpdateException = null;
                        this.batchUpdateException = null;
                        throw batchUpdateException;
                    }
                    nArray = this.batchReturn;
                    break block11;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit(this, "executeBatch()");
                    throw throwable;
                }
            }
            DB2Trace.methodExit(this, "executeBatch()");
            return nArray2;
        }
        Object var3_4 = null;
        if (!DB2Trace.TraceOn) return nArray;
        DB2Trace.methodExit(this, "executeBatch()");
        return nArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultSet executeQuery(String string) throws SQLException {
        DB2ResultSet dB2ResultSet;
        this.sql = string;
        try {
            short s;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "executeQuery( " + string + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (string == null || string.trim().length() == 0) {
                this.sqlExcptGen.throwNullError();
            }
            if ((s = this.getStatementType(string)) != 24 && s != 25 && s != 27) {
                this.sqlExcptGen.throwInvalidQueryError();
            }
            this.execute2(string);
            this.getResultSet();
            dB2ResultSet = this.resultSet;
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) return dB2ResultSet;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "executeQuery()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "executeQuery()");
        return dB2ResultSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int executeUpdate(String string) throws SQLException {
        int n;
        this.sql = string;
        int n2 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "executeUpdate( " + string + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.getStatementType(string) == 24) {
                this.sqlExcptGen.throwInvalidUpdateError();
            }
            this.execute2(string);
            n = n2 = this.getUpdateCount();
            Object var5_4 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "executeUpdate", n2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "executeUpdate", n2);
        return n;
    }

    public void finalize() throws SQLException {
        block6: {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "finalize()");
                }
                if (this.closed) break block6;
                String string = null;
                string = this instanceof DB2CallableStatement ? "DB2CallableStatement closed in finalizer: \"" + this.sql + "\"" : (this instanceof DB2PreparedStatement ? "DB2PreparedStatement closed in finalizer: \"" + this.sql + "\"" : "DB2Statement closed in finalizer, last SQL: \"" + this.sql + "\"");
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, string);
                }
                DriverManager.println(string);
                this.close();
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodExit(this, "finalize()");
                }
                throw throwable;
            }
        }
        Object var2_2 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "finalize()");
        }
    }

    protected int[] getBatchReturn() {
        return this.batchReturn;
    }

    protected int getColCount() {
        this.colCount = (short)this.SQLGetColumnCount(this.statementHandle);
        return this.colCount;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public DB2Connection getDB2Connection() {
        return this.connection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getFetchDirection() throws SQLException {
        int n;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getFetchDirection()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            n = this.fetchDirection;
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getFetchDirection()", this.fetchDirection);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getFetchDirection()", this.fetchDirection);
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getFetchSize() throws SQLException {
        int n;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getFetchSize()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            n = this.fetchSize;
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getFetchSize()", this.fetchSize);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getFetchSize()", this.fetchSize);
        return n;
    }

    public int getHandle() {
        return this.statementHandle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getMaxFieldSize() throws SQLException {
        int n;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getMaxFieldSize()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            n = this.maxFieldSize;
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getMaxFieldSize()", this.maxFieldSize);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getMaxFieldSize()", this.maxFieldSize);
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getMaxRows() throws SQLException {
        int n;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getMaxRows()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            n = this.maxRows;
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getMaxRows()", this.maxRows);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getMaxRows()", this.maxRows);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getMoreResults() throws SQLException {
        boolean bl;
        block12: {
            boolean bl2;
            block11: {
                boolean bl3;
                block10: {
                    boolean bl4;
                    block9: {
                        try {
                            if (DB2Trace.TraceOn) {
                                DB2Trace.methodEntry(this, "getMoreResults()");
                            }
                            if (this.connection.closed) {
                                this.sqlExcptGen.throwConnectionClosedError();
                            }
                            if (this.closed) {
                                this.sqlExcptGen.throwClosedError();
                            }
                            if (!this.moreResults) {
                                bl4 = false;
                                Object var3_5 = null;
                                if (!DB2Trace.TraceOn) return bl4;
                                break block9;
                            }
                            this.rowCount = 0;
                            this.returnCode = 0;
                            this.returnCode = (short)this.SQLMoreResults(this.statementHandle, this.connection.connectionHandle);
                            if (this.returnCode == 100) {
                                this.moreResults = false;
                                bl3 = false;
                                break block10;
                            }
                            if (this.returnCode != 0) {
                                this.sqlExcptGen.check_return_code(this, this.returnCode);
                            }
                            if (this.returnCode == 0 || this.returnCode == 1) {
                                bl2 = this.moreResults = true;
                                break block11;
                            }
                            bl = this.moreResults = false;
                            break block12;
                        }
                        catch (Throwable throwable) {
                            Object var3_9 = null;
                            if (!DB2Trace.TraceOn) throw throwable;
                            DB2Trace.methodExit((Object)this, "getMoreResults()", String.valueOf(this.moreResults));
                            throw throwable;
                        }
                    }
                    DB2Trace.methodExit((Object)this, "getMoreResults()", String.valueOf(this.moreResults));
                    return bl4;
                }
                Object var3_6 = null;
                if (!DB2Trace.TraceOn) return bl3;
                DB2Trace.methodExit((Object)this, "getMoreResults()", String.valueOf(this.moreResults));
                return bl3;
            }
            Object var3_7 = null;
            if (!DB2Trace.TraceOn) return bl2;
            DB2Trace.methodExit((Object)this, "getMoreResults()", String.valueOf(this.moreResults));
            return bl2;
        }
        Object var3_8 = null;
        if (!DB2Trace.TraceOn) return bl;
        DB2Trace.methodExit((Object)this, "getMoreResults()", String.valueOf(this.moreResults));
        return bl;
    }

    public static int getPeakStatementCount() {
        return peakStatementCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getQueryTimeout() throws SQLException {
        int n;
        int n2 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getQueryTimeOut()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            this.returnCode = 0;
            n2 = this.SQLGetQueryTimeout(this.statementHandle);
            if (this.returnCode != 0) {
                this.sqlExcptGen.check_return_code(this, this.returnCode);
            }
            n = n2;
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getQueryTimeOut()", n2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getQueryTimeOut()", n2);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSet getResultSet() throws SQLException {
        DB2ResultSet dB2ResultSet;
        block18: {
            ResultSet resultSet;
            block17: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "getResultSet()");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (this.connection.closed) {
                        this.sqlExcptGen.throwConnectionClosedError();
                    }
                    if (this.closed) {
                        this.sqlExcptGen.throwClosedError();
                    }
                    boolean bl = false;
                    if (this.rsTypeAllocated != 1003) {
                        SQLWarning sQLWarning = this.getWarnings();
                        while (true) {
                            if (sQLWarning == null) {
                                if (this.resultSet != null && !bl && !(this.resultSet instanceof DB2ScrollableResultSet)) {
                                    this.resultSet = null;
                                }
                                if (!DB2Trace.TraceOn) break;
                                DB2Trace.data(10, "rsTypeAllocated,rsType,rsTypeDowngraded", String.valueOf(this.rsTypeAllocated) + "," + this.rsType + "," + bl);
                                break;
                            }
                            if (sQLWarning.getSQLState().equalsIgnoreCase("01S02")) {
                                this.rsType = 1003;
                                bl = true;
                                boolean bl2 = this.resultSet != null && this.resultSet instanceof DB2ScrollableResultSet;
                                this.resultSet = null;
                            }
                            sQLWarning = sQLWarning.getNextWarning();
                        }
                    }
                    if (this.moreResults && this.rsType != 1003 && this.rowCount == 0) {
                        this.rowCount = this.SQLGetRowCount(this.statementHandle);
                    }
                    if (this.resultSet == null) {
                        this.resultSet = this.rsType != 1003 ? (DB2Trace.TraceOn ? new DB2ScrollableResultSetTrace(this, 0, this.rowCount) : new DB2ScrollableResultSet(this, 0, this.rowCount)) : (DB2Trace.TraceOn ? new DB2ResultSetTrace(this, 0) : new DB2ResultSet(this, 0));
                    } else if (this.rsType != 1003) {
                        this.resultSet.reset(this.resultSet.numCols, this.rowCount);
                    } else if (!(this instanceof DB2PreparedStatement) || ((DB2PreparedStatement)this).statementType != 24) {
                        this.resultSet.reset(this.resultSet.numCols);
                    }
                    if (this.resultSet.numCols <= 0 || !this.moreResults) {
                        resultSet = null;
                        Object var3_5 = null;
                        if (!DB2Trace.TraceOn) return resultSet;
                        break block17;
                    }
                    dB2ResultSet = this.resultSet;
                    break block18;
                }
                catch (Throwable throwable) {
                    Object var3_7 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit(this, "getResultSet()");
                    throw throwable;
                }
            }
            DB2Trace.methodExit(this, "getResultSet()");
            return resultSet;
        }
        Object var3_6 = null;
        if (!DB2Trace.TraceOn) return dB2ResultSet;
        DB2Trace.methodExit(this, "getResultSet()");
        return dB2ResultSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getResultSetConcurrency() throws SQLException {
        int n;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getResultSetConcurrency()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            n = this.rsConcur;
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getResultSetConcurrency()", this.rsConcur);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getResultSetConcurrency()", this.rsConcur);
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getResultSetType() throws SQLException {
        int n;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getResultSetType()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            n = this.rsType;
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getResultSetType()", this.rsType);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getResultSetType()", this.rsType);
        return n;
    }

    public static int getStatementCount() {
        return statementCount;
    }

    protected int getStatementHandle() throws SQLException {
        return this.statementHandle;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected short getStatementType(String string) {
        int n;
        int n2;
        block23: {
            String string2;
            short s;
            block22: {
                n2 = 26;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "getStatementType( " + string + " )");
                    }
                    if (string != null) {
                        int n3 = string.length();
                        int n4 = 0;
                        if (n3 > 0 && string.charAt(n4) == '#') {
                            s = 27;
                            Object var5_10 = null;
                            if (!DB2Trace.TraceOn) return s;
                            string2 = null;
                            break block22;
                        }
                        while (true) {
                            char c;
                            if (n4 >= n3 || !Character.isWhitespace(c = string.charAt(n4)) && c != '{' && c != ';' && c != '?' && c != '(' && c != '=') {
                                n2 = string.regionMatches(true, n4, "select", 0, 6) || string.regionMatches(true, n4, "values", 0, 6) || string.regionMatches(true, n4, "with", 0, 4) ? 24 : (string.regionMatches(true, n4, "call", 0, 4) ? 25 : 26);
                            }
                            ++n4;
                        }
                    }
                    n = n2;
                    break block23;
                }
                catch (Throwable throwable) {
                    Object var5_12 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    String string3 = null;
                    switch (n2) {
                        case 24: {
                            string3 = "STMT_TYPE_QUERY (24)";
                            break;
                        }
                        case 25: {
                            string3 = "STMT_TYPE_CALL (25)";
                            break;
                        }
                        case 27: {
                            string3 = "STMT_TYPE_SQLJ (27)";
                            break;
                        }
                        default: {
                            string3 = "STMT_TYPE_OTHER (26)";
                        }
                    }
                    DB2Trace.methodExit((Object)this, "getStatementType()", string3);
                    throw throwable;
                }
            }
            switch (n2) {
                case 24: {
                    string2 = "STMT_TYPE_QUERY (24)";
                    break;
                }
                case 25: {
                    string2 = "STMT_TYPE_CALL (25)";
                    break;
                }
                case 27: {
                    string2 = "STMT_TYPE_SQLJ (27)";
                    break;
                }
                default: {
                    string2 = "STMT_TYPE_OTHER (26)";
                }
            }
            DB2Trace.methodExit((Object)this, "getStatementType()", string2);
            return s;
        }
        Object var5_11 = null;
        if (!DB2Trace.TraceOn) return (short)n;
        String string4 = null;
        switch (n2) {
            case 24: {
                string4 = "STMT_TYPE_QUERY (24)";
                break;
            }
            case 25: {
                string4 = "STMT_TYPE_CALL (25)";
                break;
            }
            case 27: {
                string4 = "STMT_TYPE_SQLJ (27)";
                break;
            }
            default: {
                string4 = "STMT_TYPE_OTHER (26)";
            }
        }
        DB2Trace.methodExit((Object)this, "getStatementType()", string4);
        return (short)n;
    }

    protected String getTraceHandle() {
        int n = this.statementHandle >> 16;
        int n2 = this.statementHandle & 0xFFFF;
        String string = String.valueOf(n) + ":" + n2;
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getUpdateCount() throws SQLException {
        int n;
        int n2;
        block9: {
            int n3;
            block8: {
                n2 = 0;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "getUpdateCount()");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (this.connection.closed) {
                        this.sqlExcptGen.throwConnectionClosedError();
                    }
                    if (this.closed) {
                        this.sqlExcptGen.throwClosedError();
                    }
                    this.colCount = (short)this.SQLGetColumnCount(this.statementHandle);
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "colCount", this.colCount);
                    }
                    if (this.colCount > 0 || !this.moreResults) {
                        n3 = n2 = -1;
                        Object var4_4 = null;
                        if (!DB2Trace.TraceOn) return n3;
                        break block8;
                    }
                    if (this.rowCount == 0) {
                        this.rowCount = this.SQLGetRowCount(this.statementHandle);
                    }
                    n2 = this.rowCount < 0 ? 0 : this.rowCount;
                    n = n2;
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.data(10, "rowCount", this.rowCount);
                    DB2Trace.methodExit((Object)this, "getUpdateCount()", n2);
                    throw throwable;
                }
            }
            DB2Trace.data(10, "rowCount", this.rowCount);
            DB2Trace.methodExit((Object)this, "getUpdateCount()", n2);
            return n3;
        }
        Object var4_5 = null;
        if (!DB2Trace.TraceOn) return n;
        DB2Trace.data(10, "rowCount", this.rowCount);
        DB2Trace.methodExit((Object)this, "getUpdateCount()", n2);
        return n;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    private synchronized void incrementStatementCount() {
        if (!this.counted) {
            DB2Statement.adjustStatementCount(1);
            this.counted = true;
        }
    }

    protected void newBatchUpdateException(String string, String string2, int n, int[] nArray) {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "newBatchUpdateException()");
            }
            BatchUpdateException batchUpdateException = new BatchUpdateException(string, string2, n, nArray);
            if (this.batchUpdateException == null) {
                this.batchUpdateException = batchUpdateException;
            } else {
                this.lastBatchUpdateException.setNextException(batchUpdateException);
            }
            this.lastBatchUpdateException = batchUpdateException;
        }
        finally {
            Object var6_6 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "newBatchUpdateException()");
            }
        }
    }

    protected void selectInBatchUpdateException(int[] nArray) {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "selectInBatchUpdateException()");
            }
            this.newBatchUpdateException(this.sqlExcptGen.errMsgClass.getString("0641"), "HY0000", -99999, nArray);
        }
        finally {
            Object var3_2 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "selectInBatchUpdateException()");
            }
        }
    }

    public void setCursorName(String string) throws SQLException {
        int n;
        block10: {
            n = 0;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "setCursorName( " + string + " )");
                    DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                }
                if (this.connection.closed) {
                    this.sqlExcptGen.throwConnectionClosedError();
                }
                if (this.closed) {
                    this.sqlExcptGen.throwClosedError();
                }
                DB2Connection dB2Connection = this.connection;
                synchronized (dB2Connection) {
                    n = this.SQLSetCursorName(string, this.statementHandle, this.connection.connectionHandle);
                }
                if (n == 0) break block10;
                this.sqlExcptGen.check_return_code(this, n);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "SQLSetCursorName - rc ", n);
                    DB2Trace.methodExit(this, "setCursorName()");
                }
                throw throwable;
            }
        }
        Object var4_4 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, "SQLSetCursorName - rc ", n);
            DB2Trace.methodExit(this, "setCursorName()");
        }
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        int n;
        block7: {
            n = 0;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "setEscapeProcessing( " + bl + " )");
                    DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                }
                if (this.connection.closed) {
                    this.sqlExcptGen.throwConnectionClosedError();
                }
                if (this.closed) {
                    this.sqlExcptGen.throwClosedError();
                }
                if ((n = this.SQLScan(bl, this.statementHandle)) == 0) break block7;
                this.sqlExcptGen.check_return_code(this, n);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "SQLScan- rc ", n);
                    DB2Trace.methodExit(this, "setEscapeProcessing()");
                }
                throw throwable;
            }
        }
        Object var4_3 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, "SQLScan- rc ", n);
            DB2Trace.methodExit(this, "setEscapeProcessing()");
        }
    }

    public void setFetchDirection(int n) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setFetchDirection( " + n + " )");
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            this.checkFetchDirection(this.rsType, n);
            this.fetchDirection = n;
        }
        finally {
            Object var3_2 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "fetchDirection ", this.fetchDirection);
                DB2Trace.methodExit(this, "setFetchDirection()");
            }
        }
    }

    public void setFetchSize(int n) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setFetchSize( " + n + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            this.checkFetchSize(this.maxRows, n);
            this.fetchSize = n;
        }
        finally {
            Object var3_2 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "fetchSize ", this.fetchSize);
                DB2Trace.methodExit(this, "setFetchSize()");
            }
        }
    }

    public void setMaxFieldSize(int n) throws SQLException {
        int n2 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setMaxFieldSize( " + n + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n < 0) {
                this.sqlExcptGen.throwOutOfRangeError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if ((n2 = this.SQLMaxFieldSize(n, this.statementHandle)) != 0) {
                this.sqlExcptGen.check_return_code(this, n2);
            }
            this.maxFieldSize = n;
        }
        finally {
            Object var4_3 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "SQLMaxFieldSize- rc ", n2);
                DB2Trace.data(10, "maxFieldSize ", this.maxFieldSize);
                DB2Trace.methodExit(this, "setMaxFieldSize()");
            }
        }
    }

    public void setMaxRows(int n) throws SQLException {
        try {
            int n2;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setMaxRows( " + n + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n < 0) {
                this.sqlExcptGen.throwOutOfRangeError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if ((n2 = this.SQLMaxRows(n, this.statementHandle)) != 0) {
                this.sqlExcptGen.check_return_code(this, n2);
            }
            this.maxRows = n;
        }
        finally {
            Object var3_3 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "maxRows ", this.maxRows);
                DB2Trace.methodExit(this, "setMaxRows()");
            }
        }
    }

    public void setQueryTimeout(int n) throws SQLException {
        int n2;
        block8: {
            n2 = 0;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "setQueryTimeOut( " + n + " )");
                    DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                }
                if (this.connection.closed) {
                    this.sqlExcptGen.throwConnectionClosedError();
                }
                if (this.closed) {
                    this.sqlExcptGen.throwClosedError();
                }
                if (n < 0) {
                    this.sqlExcptGen.throwOutOfRangeError();
                }
                if ((n2 = this.SQLSetQueryTimeout(n, this.statementHandle)) == 0) break block8;
                this.sqlExcptGen.check_return_code(this, n2);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, " SQLSetQueryTimeout- rc ", n2);
                    DB2Trace.methodExit(this, "setQueryTimeOut()");
                }
                throw throwable;
            }
        }
        Object var4_3 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, " SQLSetQueryTimeout- rc ", n2);
            DB2Trace.methodExit(this, "setQueryTimeOut()");
        }
    }

    public String toString() {
        return this.toString("", true);
    }

    protected String toString(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("\r\n" + string + "DB2Statement \r\n" + string + "{");
        if (this.connection != null) {
            stringBuffer.append(this.connection.toString(String.valueOf(string) + "    Connection -> "));
        } else {
            stringBuffer.append("\r\n" + string + "    Connection -> null");
        }
        if (bl) {
            if (this.resultSet != null) {
                stringBuffer.append(this.resultSet.toString(String.valueOf(string) + "    ResultSet -> ", false));
            } else {
                stringBuffer.append("\r\n" + string + "    ResultSet -> null\r\n");
            }
        }
        stringBuffer.append("\r\n");
        stringBuffer.append(String.valueOf(string) + "    statementHandle = " + this.getTraceHandle() + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    SQL = " + this.sql + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    maxRows = " + this.maxRows + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    maxFieldSize = " + this.maxFieldSize + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    rowCount = " + this.rowCount + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    colCount = " + this.colCount + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    closed = " + this.closed + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    internalStmt = " + this.internalStmt + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    returnCode = " + this.returnCode + "\r\n");
        stringBuffer.append(String.valueOf(string) + "}\r\n");
        return stringBuffer.toString();
    }
}

