/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.stat;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyString;

public class StatView
extends CMSObj {
    public static final int OBJ_TYPE = 486563092;
    public static final String DB_TABLE_NAME = "WCMSTATVIEW";
    public static final String DB_ID_NAME = "STATVIEWID";
    public static final int VIEW_TYPE_TEMPLATE = 1;
    public static final int VIEW_TYPE_FIELD = 2;
    public static final int VIEW_TYPE_QUERY = 3;
    public static final int VIEW_TYPE_ALL = 0;
    public static final int VIEW_TYPE_MIN = 1;
    public static final int VIEW_TYPE_MAX = 3;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 486563092;
    }

    public String getViewName() {
        return this.getPropertyAsString("VIEWNAME");
    }

    public boolean setViewName(String _sViewName) throws WCMException {
        return this.setProperty("VIEWNAME", _sViewName);
    }

    public String getViewDesc() {
        return this.getPropertyAsString("VIEWDESC");
    }

    public boolean setViewDesc(String _sViewDesc) throws WCMException {
        return this.setProperty("VIEWDESC", _sViewDesc);
    }

    public int getViewType() {
        return this.getPropertyAsInt("VIEWTYPE", 0);
    }

    public boolean setViewType(int _nViewType) throws WCMException {
        return this.setProperty("VIEWTYPE", _nViewType);
    }

    public String getStatHost() {
        return this.getPropertyAsString("STATHOST");
    }

    public boolean setStatHost(String _sStatHost) throws WCMException {
        return this.setProperty("STATHOST", _sStatHost);
    }

    public String getResultTable() {
        return this.getPropertyAsString("RESULTTABLE");
    }

    public boolean setResultTable(String _sResultTable) throws WCMException {
        return this.setProperty("RESULTTABLE", _sResultTable);
    }

    public String getViewSelect() {
        return this.getPropertyAsString("VIEWSELECT");
    }

    public boolean setViewSelect(String _sViewSelect) throws WCMException {
        return this.setProperty("VIEWSELECT", _sViewSelect);
    }

    public String getViewFrom() {
        return this.getPropertyAsString("VIEWFROM");
    }

    public boolean setViewFrom(String _sViewFrom) throws WCMException {
        return this.setProperty("VIEWFROM", _sViewFrom);
    }

    public String getViewWhere() {
        return this.getPropertyAsString("VIEWWHERE");
    }

    public boolean setViewWhere(String _sViewWhere) throws WCMException {
        return this.setProperty("VIEWWHERE", _sViewWhere);
    }

    public String getViewOrderBy() {
        return this.getPropertyAsString("VIEWORDERBY");
    }

    public boolean setViewOrderBy(String _sViewOrderBy) throws WCMException {
        return this.setProperty("VIEWORDERBY", _sViewOrderBy);
    }

    public String getViewGroupBy() {
        return this.getPropertyAsString("VIEWGROUPBY");
    }

    public boolean setViewGroupBy(String _sViewGroupBy) throws WCMException {
        return this.setProperty("VIEWGROUPBY", _sViewGroupBy);
    }

    public String getViewAttribute() {
        return this.getPropertyAsString("VIEWATTRIBUTE");
    }

    public boolean setViewAttribute(String _sViewAttribute) throws WCMException {
        return this.setProperty("VIEWATTRIBUTE", _sViewAttribute);
    }

    @Override
    public boolean isValid() throws WCMException {
        String sName = null;
        if (this.isAddMode()) {
            sName = (String)this.getProperty("VIEWNAME");
            if (sName == null) {
                throw new WCMException(1106, I18NMessage.get(StatView.class, "StatView.label1", "\u5c5e\u6027ViewName\u6ca1\u6709\u8bbe\u7f6e!"));
            }
            if (this.getProperty("STATHOST") == null) {
                throw new WCMException(1106, I18NMessage.get(StatView.class, "StatView.label2", "\u5c5e\u6027StatHost\u6ca1\u6709\u8bbe\u7f6e!"));
            }
            if (this.getProperty("VIEWFROM") == null) {
                throw new WCMException(1106, I18NMessage.get(StatView.class, "StatView.label3", "\u5c5e\u6027ViewFrom\u6ca1\u6709\u8bbe\u7f6e!"));
            }
            if (this.getProperty("VIEWSELECT") == null) {
                throw new WCMException(1106, I18NMessage.get(StatView.class, "StatView.label4", "\u5c5e\u6027ViewSelect\u6ca1\u6709\u8bbe\u7f6e!"));
            }
            String sType = this.getPropertyAsString("VIEWTYPE");
            if (sType == null) {
                throw new WCMException(1106, I18NMessage.get(StatView.class, "StatView.label5", "\u5c5e\u6027ViewType\u6ca1\u6709\u8bbe\u7f6e!"));
            }
            int nType = Integer.parseInt(sType);
            if (nType < 1 || nType > 3) {
                throw new WCMException(1104, I18NMessage.get(StatView.class, "StatView.label6", "\u5c5e\u6027ViewType\u7684\u503c\u4e0d\u7b26\u5408\u8981\u6c42!"));
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(StatView.class, "StatView.label7", "\u7edf\u8ba1\u89c6\u56fe\u7684\u5c5e\u6027\u6ca1\u6709\u66f4\u6539!"));
            }
            sName = this.getNewPropertyAsString("ViewName");
        }
        if (sName != null) {
            String sCondition = "ViewName='" + CMyString.filterForSQL(sName) + "'";
            if (!this.isAddMode()) {
                sCondition = sCondition + " AND (STATVIEWID>" + this.getId() + " OR " + DB_ID_NAME + "<" + this.getId() + ")";
            }
            if (this.checkExists(sCondition)) {
                throw new WCMException(1104, I18NMessage.get(StatView.class, "StatView.label8", "\u5df2\u7ecf\u5b58\u5728\u540d\u79f0\u4e3a[") + sName + I18NMessage.get(StatView.class, "StatView.label9", "]\u7684\u7edf\u8ba1\u89c6\u56fe!"));
            }
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(_currUser);
        }
    }

    public static final StatView findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (StatView)BaseObj.findById(StatView.class, _nId);
    }

    public static final StatView createNewInstance() throws WCMException {
        return (StatView)BaseObj.createNewInstance(StatView.class);
    }

    public static final StatView findByKey(Object _oKey) throws WCMException {
        return (StatView)BaseObj.findByKey(StatView.class, _oKey);
    }

    public String getFiledNameFromSelect(int _nFieldPos) throws WCMException {
        String sSqlSelect = this.getViewSelect().trim();
        if (sSqlSelect == null || sSqlSelect.length() == 0) {
            throw new WCMException(1100, I18NMessage.get(StatView.class, "StatView.label10", "\u7edf\u8ba1\u89c6\u56fe\u6a21\u677f\u6ca1\u6709\u914d\u7f6eSELECT\uff01"));
        }
        sSqlSelect = sSqlSelect + " ,";
        int nStartPos = 0;
        int nEndPos = -1;
        for (int i = 0; i <= _nFieldPos; ++i) {
            nStartPos = nEndPos + 1;
            nEndPos = sSqlSelect.indexOf(",", nEndPos + 1);
        }
        if (nEndPos == -1) {
            return "";
        }
        String sFieldName = sSqlSelect.substring(nStartPos, nEndPos).trim();
        int nSpacePos = sFieldName.lastIndexOf(" ");
        if (nSpacePos > 0) {
            sFieldName = sFieldName.substring(nSpacePos).trim();
        }
        return sFieldName;
    }

    @Override
    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getViewName();
        }
        return this.getViewName() + I18NMessage.get(StatView.class, "StatView.label11", "[\u7edf\u8ba1\u89c6\u56fe-") + this.getId() + "]";
    }

    public static void main(String[] args) {
        System.out.println("com.trs.components.wcm.stat.StatView".hashCode());
        System.out.println("com.trs.components.wcm.stat.StatHost".hashCode());
        System.out.println("com.trs.components.wcm.stat.StatFieldMap".hashCode());
    }
}

