/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.publish.tagparser;

import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.publish.element.PublishFolderChannelImpl;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Loader;
import com.trs.infra.util.store.FileService;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class InfoviewSpecailTagParseHelper {
    private static final String TAG_ATTR_ENCODING = "encoding";
    private static final String TAG_ATTR_FILE = "file";
    private static final String DEFAULT_ENCODING = "utf-8";
    private static Logger logger = Logger.getLogger(InfoviewSpecailTagParseHelper.class);

    private InfoviewSpecailTagParseHelper() {
    }

    public static String[] parseChnlRelatedEnum(PublishTagContext _context) {
        if (_context == null) {
            return null;
        }
        IPublishFolder folder = _context.getPageFolder();
        if (folder == null || !(folder instanceof PublishFolderChannelImpl)) {
            return null;
        }
        String result = null;
        try {
            Channel channel = (Channel)folder.getSubstance();
            if (channel == null) {
                throw new WCMException(I18NMessage.get(InfoviewSpecailTagParseHelper.class, "InfoviewSpecailTagParseHelper.label1", "\u6ca1\u6709\u4ece\u4e0a\u4e0b\u6587\u73af\u5883\u4e2d\u83b7\u53d6\u5230\u5f53\u524d\u9875\u9762\u7684\u9891\u9053\u5bf9\u8c61\uff01"));
            }
            String sConfigFile = _context.getAttribute(TAG_ATTR_FILE);
            if (CMyString.isEmpty(sConfigFile)) {
                throw new WCMException(I18NMessage.get(InfoviewSpecailTagParseHelper.class, "InfoviewSpecailTagParseHelper.label2", "\u6ca1\u6709\u89e3\u6790\u6240\u9700\u7684\u6587\u4ef6\u8def\u5f84\uff01"));
            }
            URL url = Loader.getResource(sConfigFile);
            if (url == null) {
                throw new WCMException(I18NMessage.get(InfoviewSpecailTagParseHelper.class, "InfoviewSpecailTagParseHelper.label3", "\u6307\u5b9a\u5e94\u7528\u7684\u6839\u76ee\u5f55\u4e0b\u7528\u4e8e\u89e3\u6790\u7684\u6587\u4ef6\u8def\u5f84[") + sConfigFile + I18NMessage.get(InfoviewSpecailTagParseHelper.class, "InfoviewSpecailTagParseHelper.label4", "]\u4e0d\u5b58\u5728\uff01"));
            }
            String sEncoding = _context.getAttribute(TAG_ATTR_ENCODING);
            if (CMyString.isEmpty(sEncoding)) {
                sEncoding = DEFAULT_ENCODING;
            }
            Map hProps = InfoviewSpecailTagParseHelper.loadProps(url.getFile(), DEFAULT_ENCODING);
            result = (String)hProps.get(channel.getDesc());
        }
        catch (Exception ex) {
            logger.warn((Object)(I18NMessage.get(InfoviewSpecailTagParseHelper.class, "InfoviewSpecailTagParseHelper.label5", "\u89e3\u6790\u7f6e\u6807[CHNL_RELATED_ENUM]\u65f6\u51fa\u9519\uff01") + ex.getMessage()));
            return null;
        }
        return new String[]{result};
    }

    private static Map loadProps(String _sFileName, String _sEncoding) {
        InputStream fis = null;
        BufferedReader buffReader = null;
        if (_sEncoding == null) {
            _sEncoding = DEFAULT_ENCODING;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String sLine;
            fis = new FileService(_sFileName).getInputStream();
            buffReader = new BufferedReader(new InputStreamReader(fis, _sEncoding));
            while ((sLine = buffReader.readLine()) != null) {
                int nPos;
                char firstChar;
                int len = (sLine = sLine.trim()).length();
                if (len == 0 || (firstChar = sLine.charAt(0)) == '#' || firstChar == '!' || firstChar == '=' || (nPos = sLine.indexOf("=")) == -1) continue;
                String key = sLine.substring(0, nPos);
                String val = sLine.substring(nPos + 1, len);
                result.put(key, val);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

