/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.helper;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WebSiteHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.infoview.InfoViewConstants;
import com.trs.components.infoview.InfoViewEmployMgr;
import com.trs.components.infoview.InfoViewHelper;
import com.trs.components.infoview.db.LetterConvertor;
import com.trs.components.infoview.helper.InfoViewQueryHelper;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.infoview.persistent.InfoViewDocument;
import com.trs.components.infoview.persistent.InfoViewDocuments;
import com.trs.components.infoview.persistent.InfoViewField;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.publish.IFolderPubStatusCacheMgr;
import com.trs.components.wcm.resource.DocLevel;
import com.trs.components.wcm.resource.DocLevelMgr;
import com.trs.components.wcm.resource.DocLevels;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.infra.util.database.FieldInfo;
import com.trs.infra.util.database.TableInfo;
import com.trs.presentation.util.RequestHelper;
import com.trs.webframework.context.MethodContext;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class InfoViewNewQueryHelper {
    private static Logger logger = Logger.getLogger(InfoViewNewQueryHelper.class);
    private static String[] m_aDefaultOutlineFields = new String[]{"FLOWOPERATIONMARK", "DOCID", "DOCTITLE", "CRTIME", "DOCSTATUS", "DOCNO", "POSTUSER", "RANDOMSERIAL", "POSTUSER", "DOCPUBTIME", "DOCPUBURL", "DOCEDITURL"};
    private static InfoViewEmployMgr m_oIVEmployMgr = null;

    public static InfoViewEmployMgr getInfoViewEmployMgr() {
        if (m_oIVEmployMgr == null) {
            m_oIVEmployMgr = (InfoViewEmployMgr)DreamFactory.createObjectById("InfoViewEmployMgr");
        }
        return m_oIVEmployMgr;
    }

    public static String[] getFieldNames(InfoView infoview, String sSelectedFields) throws WCMException {
        if (CMyString.isEmpty(sSelectedFields) && infoview != null) {
            sSelectedFields = infoview.getOutlineFields();
        }
        sSelectedFields = CMyString.showNull(sSelectedFields);
        String[] aFieldNames = null;
        aFieldNames = CMyString.isEmpty(sSelectedFields) ? m_aDefaultOutlineFields : sSelectedFields.split(",");
        return aFieldNames;
    }

    public static String[] getFieldsDisplay(String[] arrFieldNames) {
        String[] sFieldDisp = new String[arrFieldNames.length];
        for (int i = 0; i < arrFieldNames.length; ++i) {
            String name = arrFieldNames[i];
            int index = name.lastIndexOf(58);
            if (index > 0) {
                sFieldDisp[i] = name.substring(index + 1);
                continue;
            }
            String disp = (String)InfoViewConstants.SYSTEM_FIELD_NAMESMAP.get(name);
            if (disp == null) {
                disp = name;
            }
            sFieldDisp[i] = disp;
        }
        return sFieldDisp;
    }

    public static InfoViewDocuments queryData(MethodContext _methodContext) throws CMyException {
        return InfoViewNewQueryHelper.queryData(_methodContext, null);
    }

    public static InfoViewDocuments queryData(RequestHelper requestHelper) throws CMyException {
        return InfoViewNewQueryHelper.queryData(null, requestHelper);
    }

    public static Documents queryDocuments(MethodContext _methodContext) throws CMyException {
        return InfoViewNewQueryHelper.queryData2(_methodContext, null);
    }

    public static Documents queryDocuments(RequestHelper requestHelper) throws CMyException {
        return InfoViewNewQueryHelper.queryData2(null, requestHelper);
    }

    public static String queryDataXML(MethodContext _context) throws CMyException {
        return InfoViewNewQueryHelper.queryDataXML(_context, null);
    }

    public static String queryDataXML(RequestHelper _requestHelper) throws CMyException {
        return InfoViewNewQueryHelper.queryDataXML(null, _requestHelper);
    }

    public static String queryDataXML2(MethodContext _context) throws CMyException {
        return InfoViewNewQueryHelper.queryDataXML2(_context, null);
    }

    public static String queryDataXML2(RequestHelper _requestHelper) throws CMyException {
        return InfoViewNewQueryHelper.queryDataXML2(null, _requestHelper);
    }

    public static String queryDataXML3(MethodContext _context) throws CMyException {
        return InfoViewNewQueryHelper.queryDataXML3(_context, null);
    }

    public static String queryDataXML3(RequestHelper _requestHelper) throws CMyException {
        return InfoViewNewQueryHelper.queryDataXML3(null, _requestHelper);
    }

    private static User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private static InfoViewDocuments queryData(MethodContext _methodContext, RequestHelper requestHelper) throws CMyException {
        User loginUser = InfoViewNewQueryHelper.getLoginUser();
        CMSBaseObjs objects = InfoViewNewQueryHelper.findObjects(_methodContext, requestHelper);
        Channel currChannel = null;
        if (objects.size() == 1 && objects.getAt(0) instanceof Channel) {
            currChannel = (Channel)objects.getAt(0);
        }
        InfoView oInfoView = InfoViewNewQueryHelper.getInfoView(_methodContext, requestHelper, currChannel);
        String[] arrSelectFields = InfoViewNewQueryHelper.prepareSelectFields(_methodContext, requestHelper, currChannel, oInfoView);
        boolean bAdminstrator = loginUser.isAdministrator();
        int nRightIndex = 30;
        for (int i = objects.size() - 1; i >= 0; --i) {
            RightValue rightValue;
            BaseChannel oChannelOrSite = (BaseChannel)objects.getAt(i);
            if (oChannelOrSite == null || bAdminstrator || loginUser.getName().equalsIgnoreCase(oChannelOrSite.getCrUserName()) || (rightValue = AuthServer.getRightValue((CMSObj)oChannelOrSite, loginUser)).isHasRight(nRightIndex)) continue;
            objects.remove(oChannelOrSite, false);
        }
        InfoViewDocuments oInfoViewDocuments = new InfoViewDocuments(loginUser, 1, 1);
        if (objects == null || objects.isEmpty()) {
            return oInfoViewDocuments;
        }
        InfoViewNewQueryHelper.renderSearchXml(_methodContext, requestHelper);
        WCMFilter filter = InfoViewNewQueryHelper.getQueryInfoViewFilter(_methodContext, requestHelper, loginUser, oInfoView);
        if (_methodContext != null) {
            filter.mergeWith(_methodContext.getExtraWCMFilter());
            logger.debug((Object)("_methodContext:" + _methodContext));
        } else if (requestHelper != null) {
            filter.mergeWith(requestHelper.getPageFilter(null));
            logger.debug((Object)("requestHelper:" + requestHelper));
        }
        logger.debug((Object)("filter:" + filter));
        if (!bAdminstrator) {
            WCMFilter filterBrowser = new WCMFilter();
            int nRightIndexBrowser = 34;
            if (objects.size() == 1) {
                BaseChannel oChannelOrSite = (BaseChannel)objects.getAt(0);
                if (!AuthServer.hasSuperRight(loginUser, oChannelOrSite)) {
                    RightValue rightValue = AuthServer.getRightValue((CMSObj)oChannelOrSite, loginUser);
                    if (!rightValue.isHasRight(nRightIndexBrowser)) {
                        filterBrowser.setWhere("WCMCHNLDOC.cruser=?");
                        filterBrowser.addSearchValues(loginUser.getName());
                    } else if (currChannel != null && !currChannel.getCrUserName().equalsIgnoreCase(loginUser.getName()) && currChannel.isUseDocLevel()) {
                        WCMFilter docLevelFilter = InfoViewNewQueryHelper.makeDocLevelFilter(loginUser);
                        filterBrowser.mergeWith(docLevelFilter);
                    }
                }
            } else if (objects.size() > 1) {
                StringBuffer sBrowserWhere = new StringBuffer();
                for (int i = objects.size() - 1; i >= 0; --i) {
                    BaseChannel oChannelOrSite = (BaseChannel)objects.getAt(i);
                    if (oChannelOrSite == null || oChannelOrSite.isSite() || AuthServer.hasSuperRight(loginUser, oChannelOrSite)) continue;
                    RightValue rightValue = AuthServer.getRightValue((CMSObj)oChannelOrSite, loginUser);
                    if (sBrowserWhere.length() > 0) {
                        sBrowserWhere.append(" or ");
                    }
                    if (!rightValue.isHasRight(nRightIndexBrowser)) {
                        sBrowserWhere.append("(docchannel=? and cruser=?)");
                        filterBrowser.addSearchValues(oChannelOrSite.getId());
                        filterBrowser.addSearchValues(loginUser.getName());
                        continue;
                    }
                    sBrowserWhere.append("(docchannel=?)");
                    filterBrowser.addSearchValues(oChannelOrSite.getId());
                }
                if (sBrowserWhere.length() > 0) {
                    filterBrowser.setWhere(sBrowserWhere.toString());
                }
            }
            filter.mergeWith(filterBrowser);
        }
        filter.mergeWith(InfoViewNewQueryHelper.makeTimeFilterByType(InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "CrTimeInterval", 0), "WCMChnlDoc.CrTime"));
        filter.mergeWith(InfoViewNewQueryHelper.makeTimeFilterByType(InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "PubTimeInterval", 0), "WCMChnlDoc.DocPubTime"));
        int nFilterType = InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "FilterType", 0);
        filter.mergeWith(InfoViewNewQueryHelper.makeFilterByType(loginUser, objects, nFilterType));
        boolean bFromRecycle = InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "FromRecycle", false);
        oInfoViewDocuments.setFromRecycle(bFromRecycle);
        oInfoViewDocuments.setSelectFields(InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "ChnlDocSelectFields"), arrSelectFields[0], arrSelectFields[1]);
        oInfoViewDocuments.setInfoViewId(oInfoView.getId());
        oInfoViewDocuments.setPageSize(InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "PageSize", 20));
        oInfoViewDocuments.setCurrPage(InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "PageIndex", 1));
        oInfoViewDocuments.setRightIndex(64);
        oInfoViewDocuments.setNeedWithAuthFilter(loginUser, true);
        oInfoViewDocuments.open(objects, filter);
        return oInfoViewDocuments;
    }

    private static Documents queryData2(MethodContext _methodContext, RequestHelper requestHelper) throws CMyException {
        User loginUser = InfoViewNewQueryHelper.getLoginUser();
        String sSelectFields = CMyString.showNull(InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "DocumentSelectFields"), "DOCID,DOCTITLE,DOCPUBTIME,DOCPUBURL,DOCEDITURL,POSTUSER,RANDOMSERIAL,DOCNO,FLOWOPERATIONMARK,CRTIME");
        boolean bFromRecycle = InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "FromRecycle", false);
        WCMFilter filter = new WCMFilter("WCMDocument", bFromRecycle ? "docchannel<0" : "docchannel>0", "CrTime desc", sSelectFields);
        if (_methodContext != null) {
            filter.mergeWith(_methodContext.getExtraWCMFilter());
            logger.debug((Object)("_methodContext:" + _methodContext));
        } else if (requestHelper != null) {
            filter.mergeWith(requestHelper.getPageFilter(null));
            logger.debug((Object)("requestHelper:" + requestHelper));
        }
        logger.debug((Object)("filter:" + filter));
        filter.mergeWith(InfoViewNewQueryHelper.makeTimeFilterByType(InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "CrTimeInterval", 0), "CrTime"));
        filter.mergeWith(InfoViewNewQueryHelper.makeTimeFilterByType(InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "PubTimeInterval", 0), "DocPubTime"));
        Documents oDocuments = new Documents(loginUser, 1, 1);
        int nPageSize = InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "PageSize", 20);
        int nPageIndex = InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "PageIndex", 1);
        oDocuments.setPageSize(nPageSize);
        oDocuments.setCurrPage(nPageIndex);
        filter.setPageSize(nPageSize);
        oDocuments.open(filter);
        return oDocuments;
    }

    private static InfoViewDocuments queryData3(MethodContext _methodContext, RequestHelper requestHelper) throws CMyException {
        User loginUser = InfoViewNewQueryHelper.getLoginUser();
        CMSBaseObjs objects = InfoViewNewQueryHelper.findObjects(_methodContext, requestHelper);
        Channel currChannel = null;
        if (objects.size() == 1 && objects.getAt(0) instanceof Channel) {
            currChannel = (Channel)objects.getAt(0);
        }
        InfoView oInfoView = InfoViewNewQueryHelper.getInfoView(_methodContext, requestHelper, currChannel);
        String[] arrSelectFields = InfoViewNewQueryHelper.prepareSelectFields(_methodContext, requestHelper, currChannel, oInfoView);
        InfoViewDocuments oInfoViewDocuments = new InfoViewDocuments(loginUser, 1, 1);
        if (objects == null || objects.isEmpty()) {
            return oInfoViewDocuments;
        }
        InfoViewNewQueryHelper.renderSearchXml(_methodContext, requestHelper);
        WCMFilter filter = InfoViewNewQueryHelper.getQueryInfoViewFilter(_methodContext, requestHelper, loginUser, oInfoView);
        if (_methodContext != null) {
            filter.mergeWith(_methodContext.getExtraWCMFilter());
            logger.debug((Object)("_methodContext:" + _methodContext));
        } else if (requestHelper != null) {
            filter.mergeWith(requestHelper.getPageFilter(null));
            logger.debug((Object)("requestHelper:" + requestHelper));
        }
        logger.debug((Object)("filter:" + filter));
        filter.mergeWith(InfoViewNewQueryHelper.makeTimeFilterByType(InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "CrTimeInterval", 0), "WCMChnlDoc.CrTime"));
        filter.mergeWith(InfoViewNewQueryHelper.makeTimeSpanFilter(_methodContext, requestHelper, "CrTime", "WCMChnlDoc.CrTime"));
        filter.mergeWith(InfoViewNewQueryHelper.makeTimeFilterByType(InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "PubTimeInterval", 0), "WCMChnlDoc.DocPubTime"));
        filter.mergeWith(InfoViewNewQueryHelper.makeTimeSpanFilter(_methodContext, requestHelper, "DocPubTime", "WCMChnlDoc.DocPubTime"));
        int nFilterType = InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "FilterType", 0);
        filter.mergeWith(InfoViewNewQueryHelper.makeFilterByType(loginUser, objects, nFilterType));
        boolean bFromRecycle = InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "FromRecycle", false);
        oInfoViewDocuments.setFromRecycle(bFromRecycle);
        oInfoViewDocuments.setSelectFields(InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "ChnlDocSelectFields"), arrSelectFields[0], arrSelectFields[1]);
        oInfoViewDocuments.setInfoViewId(oInfoView.getId());
        oInfoViewDocuments.setPageSize(InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "PageSize", 20));
        oInfoViewDocuments.setCurrPage(InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "PageIndex", 1));
        oInfoViewDocuments.setRightIndex(64);
        logger.debug((Object)("open filter:" + filter));
        oInfoViewDocuments.open(objects, filter);
        return oInfoViewDocuments;
    }

    private static String queryDataXML(MethodContext _context, RequestHelper _requestHelper) throws CMyException {
        CMSBaseObjs objects = InfoViewNewQueryHelper.findObjects(_context, _requestHelper);
        Channel currChannel = null;
        if (objects.size() == 1 && objects.getAt(0) instanceof Channel) {
            currChannel = (Channel)objects.getAt(0);
        }
        InfoView oInfoView = InfoViewNewQueryHelper.getInfoView(_context, _requestHelper, currChannel);
        String sSelectedFields = InfoViewNewQueryHelper.getValue(_context, _requestHelper, "SelectFields");
        Object[] aFieldNames = InfoViewNewQueryHelper.getFieldNames(oInfoView, sSelectedFields);
        String[] aFieldDisplays = InfoViewNewQueryHelper.getFieldsDisplay((String[])aFieldNames);
        String[] aDBFieldNames = InfoViewHelper.getDBFieldsByFields(oInfoView, (String[])aFieldNames, false);
        InfoViewNewQueryHelper.setValue(_context, _requestHelper, "SelectFields", CMyString.join(aFieldNames, ","));
        InfoViewDocuments oInfoViewDocuments = InfoViewNewQueryHelper.queryData(_context, _requestHelper);
        return InfoViewNewQueryHelper.toDataSetXml(_context, _requestHelper, aFieldDisplays, aDBFieldNames, oInfoViewDocuments);
    }

    private static String queryDataXML2(MethodContext _context, RequestHelper _requestHelper) throws CMyException {
        String sSelectFields = CMyString.showNull(InfoViewNewQueryHelper.getValue(_context, _requestHelper, "DocumentSelectFields"), "DOCID,DOCTITLE,DOCPUBTIME,DOCPUBURL,DOCEDITURL,POSTUSER,RANDOMSERIAL,DOCNO,FLOWOPERATIONMARK,CRTIME");
        String[] aFieldNames = sSelectFields.split(",");
        String[] aFieldDisplays = InfoViewNewQueryHelper.getFieldsDisplay(aFieldNames);
        Documents oDocuments = InfoViewNewQueryHelper.queryData2(_context, _requestHelper);
        return InfoViewNewQueryHelper.toDataSetXml(_context, _requestHelper, aFieldDisplays, aFieldNames, oDocuments);
    }

    private static String queryDataXML3(MethodContext _context, RequestHelper _requestHelper) throws CMyException {
        CMSBaseObjs objects = InfoViewNewQueryHelper.findObjects(_context, _requestHelper);
        Channel currChannel = null;
        if (objects.size() == 1 && objects.getAt(0) instanceof Channel) {
            currChannel = (Channel)objects.getAt(0);
        }
        InfoView oInfoView = InfoViewNewQueryHelper.getInfoView(_context, _requestHelper, currChannel);
        String sSelectedFields = InfoViewNewQueryHelper.getValue(_context, _requestHelper, "SelectFields");
        Object[] aFieldNames = InfoViewNewQueryHelper.getFieldNames(oInfoView, sSelectedFields);
        String[] aFieldDisplays = InfoViewNewQueryHelper.getFieldsDisplay((String[])aFieldNames);
        String[] aDBFieldNames = InfoViewHelper.getDBFieldsByFields(oInfoView, (String[])aFieldNames, false);
        InfoViewNewQueryHelper.setValue(_context, _requestHelper, "SelectFields", CMyString.join(aFieldNames, ","));
        InfoViewDocuments oInfoViewDocuments = InfoViewNewQueryHelper.queryData3(_context, _requestHelper);
        return InfoViewNewQueryHelper.toDataSetXml(_context, _requestHelper, aFieldDisplays, aDBFieldNames, oInfoViewDocuments);
    }

    private static String toDataSetXml(MethodContext _context, RequestHelper _requestHelper, String[] aFieldDisplays, String[] aDBFieldNames, CMSBaseObjs oBaseObjs) throws WCMException {
        Document oDataSetDocument = InfoViewQueryHelper.createDataSetDocument();
        Element oRootElement = oDataSetDocument.getRootElement();
        oRootElement.addAttribute("totalsize", String.valueOf(oBaseObjs.size()));
        Element oHeaderElement = InfoViewQueryHelper.createDataHeader(aDBFieldNames, aFieldDisplays);
        oRootElement.add(oHeaderElement);
        Element oDataItem = null;
        int nHitCount = oBaseObjs.size();
        if (nHitCount == 0) {
            return null;
        }
        CPager currPager = new CPager(InfoViewNewQueryHelper.getValue(_context, _requestHelper, "PageSize", 20));
        currPager.setItemCount(oBaseObjs.size());
        currPager.setCurrentPageIndex(InfoViewNewQueryHelper.getValue(_context, _requestHelper, "PageIndex", 1));
        for (int i = currPager.getFirstItemIndex(); i <= currPager.getLastItemIndex(); ++i) {
            try {
                BaseObj oBaseObj = oBaseObjs.getAt(i - 1);
                if (oBaseObj == null) continue;
                HashMap hsMapDocumentFields = InfoViewNewQueryHelper.mapObjectFields(aDBFieldNames, oBaseObj);
                String docId = CMyString.showNull(oBaseObj.getPropertyAsString("DOCID"));
                hsMapDocumentFields.put("_DOCID", docId);
                hsMapDocumentFields.put("ARCHIVESERIAL", CMyString.showNull(oBaseObj.getPropertyAsString("DOCNO")));
                hsMapDocumentFields.put("POSITIONCODE", CMyString.showNull(oBaseObj.getPropertyAsString("RANDOMSERIAL")));
                int nChannelId = oBaseObj.getPropertyAsInt("DOCCHANNEL", 0);
                String sEditUrl = "";
                if (nChannelId > 0) {
                    Channel chnl = Channel.findById(nChannelId);
                    IPublishElement content = PublishElementFactory.makeElementFrom(chnl);
                    PublishPathCompass compass = new PublishPathCompass();
                    sEditUrl = CMyString.showNull(compass.getAbsoluteHttpPath(content));
                    IPublishFolder folder = content.getFolder();
                    TemplateEmployMgr employMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
                    Template _template = employMgr.getDefaultOutlineTemplate(folder);
                    String sFileName = _template.getOutputFileName();
                    String sTempExt = _template.getOutputFileExt();
                    sEditUrl = sEditUrl + sFileName + "." + sTempExt + "?documentId=" + docId;
                }
                hsMapDocumentFields.put("DOCEDITURL", sEditUrl);
                oDataItem = InfoViewQueryHelper.createDataItem(aDBFieldNames, hsMapDocumentFields);
                oRootElement.add(oDataItem);
                continue;
            }
            catch (Exception ex) {
                throw new WCMException(200006, I18NMessage.get(InfoViewNewQueryHelper.class, "InfoViewNewQueryHelper.label1", "\u83b7\u53d6\u7b2c[") + i + I18NMessage.get(InfoViewNewQueryHelper.class, "InfoViewNewQueryHelper.label2", "]\u7bc7\u6587\u6863\u5931\u8d25\uff01"), ex);
            }
        }
        String sResultXml = oDataSetDocument.asXML();
        oDataSetDocument.clearContent();
        return sResultXml;
    }

    private static HashMap mapObjectFields(String[] fieldNames, BaseObj baseObj) throws WCMException {
        HashMap<String, String> hsMapDocumentFields = new HashMap<String, String>();
        for (int column = 0; column < fieldNames.length; ++column) {
            String sFieldName = fieldNames[column];
            if (sFieldName.startsWith("_")) continue;
            String sFieldValue = null;
            sFieldValue = baseObj instanceof InfoViewDocument ? InfoViewNewQueryHelper.getFieldValue((InfoViewDocument)baseObj, sFieldName) : baseObj.getPropertyAsString(sFieldName);
            hsMapDocumentFields.put(sFieldName, CMyString.showNull(sFieldValue));
        }
        return hsMapDocumentFields;
    }

    public static String getFieldValue(InfoViewDocument _infoviewDoc, String _sFieldName) throws WCMException {
        if (_sFieldName.equalsIgnoreCase("DocStatus")) {
            if (_infoviewDoc.getStatus() == null) {
                return Status.findById(_infoviewDoc.getPropertyAsInt("DocStatus", 0)).getName();
            }
            return _infoviewDoc.getStatus().getName();
        }
        if (_sFieldName.equalsIgnoreCase("DocChannel")) {
            return _infoviewDoc.getChannel().getName();
        }
        int nIndexDot = _sFieldName.indexOf(".");
        if (nIndexDot != -1) {
            _sFieldName = _sFieldName.substring(nIndexDot + 1);
        }
        return _infoviewDoc.getPropertyAsString(_sFieldName, _infoviewDoc.getChnlDocProperty(_sFieldName));
    }

    private static InfoView getInfoView(MethodContext _methodContext, RequestHelper requestHelper, Channel currChannel) throws WCMException {
        InfoView oInfoView = null;
        int nInfoViewId = InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "InfoViewId", 0);
        oInfoView = nInfoViewId == 0 && currChannel != null ? InfoViewHelper.getInfoView(currChannel) : InfoView.findById(nInfoViewId);
        if (oInfoView == null) {
            throw new WCMException(I18NMessage.get(InfoViewNewQueryHelper.class, "InfoViewNewQueryHelper.label3", "\u672a\u6307\u5b9aInfoViewId\u65f6\u4e0d\u80fd\u5728\u591a\u4e2a\u680f\u76ee\u6216\u7ad9\u70b9\u68c0\u7d22\uff0c\u53ea\u80fd\u5728\u4e00\u4e2a\u6307\u5b9a\u4e86\u8868\u5355\u7684\u680f\u76ee\u4e0a\u68c0\u7d22\uff01"));
        }
        return oInfoView;
    }

    private static String[] prepareSelectFields(MethodContext _methodContext, RequestHelper requestHelper, Channel currChannel, InfoView oInfoView) throws WCMException {
        String sOutlineDBFields = null;
        String sExportFields = CMyString.showNull(InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "ExportFields"), InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "SelectFields"));
        if (!CMyString.isEmpty(sExportFields)) {
            sOutlineDBFields = InfoViewHelper.getDBFieldsByFields(oInfoView, sExportFields, true);
            logger.debug((Object)("ExportFields/SelectFields:" + sExportFields + ";OutlineDBFields:" + sOutlineDBFields));
        }
        if (CMyString.isEmpty(sOutlineDBFields) && currChannel != null) {
            sOutlineDBFields = currChannel.getPropertyAsString("OutlineDBFields", oInfoView.getOutlineDBFields());
        }
        String sTrueTableName = oInfoView.getTrueTableName();
        String[] arrDefaultSelectFields = InfoViewHelper.splitSelectFields(sOutlineDBFields, sTrueTableName);
        String[] arrSelectFields = new String[]{CMyString.showNull(InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "DocumentSelectFields"), arrDefaultSelectFields[0]), CMyString.showNull(InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "InfoViewSelectFields"), arrDefaultSelectFields[1])};
        return arrSelectFields;
    }

    private static CMSBaseObjs findObjects(MethodContext _methodContext, RequestHelper requestHelper) throws WCMException {
        User loginUser = InfoViewNewQueryHelper.getLoginUser();
        CMSBaseObjs objects = null;
        String sChannelIds = CMyString.showNull(InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "ChannelIds"), InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "ChannelId"));
        String sSiteIds = CMyString.showNull(InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "SiteIds"), InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "SiteId"));
        int nSiteType = InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "SiteType", -1);
        if (sChannelIds != null && sChannelIds.length() > 0) {
            objects = Channels.findByIds(loginUser, sChannelIds);
        } else if (sSiteIds != null && sSiteIds.length() > 0) {
            objects = WebSites.findByIds(loginUser, sSiteIds);
        } else if (nSiteType >= 0) {
            objects = WebSiteHelper.getWebSitesByType(loginUser, nSiteType, null);
        } else {
            int nInfoViewId = InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "InfoViewId", 0);
            if (nInfoViewId == 0) {
                throw new WCMException(I18NMessage.get(InfoViewNewQueryHelper.class, "InfoViewNewQueryHelper.label4", "\u6ca1\u6709\u6307\u5b9a\u68c0\u7d22\u7684\u8868\u5355[InfoViewId]\u6216\u8005\u680f\u76ee[ChannelIds]\u6216\u8005\u68c0\u7d22\u7684\u7ad9\u70b9[SiteIds]\uff01"));
            }
            List lstEmployers = InfoViewNewQueryHelper.getInfoViewEmployMgr().getInfoViewEmployers(nInfoViewId, null);
            objects = new Channels(InfoViewNewQueryHelper.getLoginUser());
            for (int i = 0; i < lstEmployers.size(); ++i) {
                CMSObj oCmsObj = (CMSObj)lstEmployers.get(i);
                if (!(oCmsObj instanceof Channel)) continue;
                objects.addElement(oCmsObj);
            }
            InfoViewNewQueryHelper.setValue(_methodContext, requestHelper, "ChannelIds", objects.getIdListAsString());
        }
        return objects;
    }

    private static void renderSearchXml(MethodContext _methodContext, RequestHelper requestHelper) throws WCMException {
        List list;
        String sSearchXML = InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "SearchXML");
        if (CMyString.isEmpty(sSearchXML)) {
            return;
        }
        Document oDom4jDocument = null;
        try {
            oDom4jDocument = DocumentHelper.parseText((String)sSearchXML);
        }
        catch (DocumentException ex) {
            ex.printStackTrace();
            return;
        }
        List lstNodes = oDom4jDocument.selectNodes("//SearchItem");
        if (lstNodes != null && !lstNodes.isEmpty()) {
            Iterator iterItems = lstNodes.iterator();
            StringBuffer dateTimeValue = new StringBuffer();
            int i = 0;
            while (iterItems.hasNext()) {
                Element oItem = (Element)iterItems.next();
                String sSearchKey = oItem.attributeValue("key");
                String sSearchValue = oItem.attributeValue("value");
                sSearchKey = sSearchKey.replaceAll("(?i)^/[^\\/]*/", "");
                if ((sSearchKey = InfoViewHelper.infoPathToFieldName(sSearchKey)).indexOf("#") != -1) {
                    sSearchKey = sSearchKey.split("#")[0];
                    dateTimeValue.append(sSearchValue + "~!~");
                    if (++i != 2) continue;
                    sSearchValue = dateTimeValue.toString();
                    i = 0;
                }
                if (CMyString.isEmpty(sSearchValue)) continue;
                dateTimeValue.delete(0, dateTimeValue.length());
                InfoViewNewQueryHelper.setValue(_methodContext, requestHelper, sSearchKey, sSearchValue);
            }
        }
        if ((list = oDom4jDocument.selectNodes("//TimeRange")) != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Element timeElement = (Element)list.get(i);
                String sStartTime = timeElement.attributeValue("StartTime");
                String sEndTime = timeElement.attributeValue("EndTime");
                String sFieldName = CMyString.showNull(timeElement.attributeValue("Field"), "CrTime");
                if (sFieldName.equalsIgnoreCase("CrTime")) {
                    if (sStartTime != null) {
                        InfoViewNewQueryHelper.setValue(_methodContext, requestHelper, "StartTime", sStartTime);
                    }
                    if (sEndTime == null) continue;
                    InfoViewNewQueryHelper.setValue(_methodContext, requestHelper, "EndTime", sEndTime);
                    continue;
                }
                InfoViewNewQueryHelper.setValue(_methodContext, requestHelper, sFieldName, sStartTime + "~!~" + sEndTime);
            }
        }
    }

    private static void setValue(MethodContext context, RequestHelper requestHelper, String _sField, String _sValue) {
        if (context != null) {
            context.setValue(_sField, _sValue);
            return;
        }
        if (requestHelper != null) {
            requestHelper.setValue(_sField, _sValue);
            return;
        }
    }

    private static WCMFilter getQueryInfoViewFilter(MethodContext _methodContext, RequestHelper requestHelper, User _loginUser, InfoView _view) throws WCMException, CMyException {
        String sTrueTableName = _view.getTrueTableName();
        WCMFilter filter = new WCMFilter("", "", "");
        WCMFilter docidsFilter = InfoViewNewQueryHelper.getInfoViewDocIdsFilter(_methodContext, requestHelper, _view);
        filter.mergeWith(docidsFilter);
        TableInfo oTableInfo = DBManager.getDBManager().getTableInfo(sTrueTableName);
        if (oTableInfo == null) {
            throw new WCMException(I18NMessage.get(InfoViewNewQueryHelper.class, "InfoViewNewQueryHelper.label5", "\u8868\u5355\u6ca1\u6709\u5bf9\u5e94\u7684\u5b58\u50a8\u8868\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u662f\u5386\u53f2\u8868\u5355\u6570\u636e\uff0c\u5c1a\u672a\u5b8c\u6210\u6570\u636e\u540c\u6b65\u64cd\u4f5c\u3002"));
        }
        Enumeration enumFieldNames = oTableInfo.getFieldNames();
        StringBuffer sbWhereFields = new StringBuffer(oTableInfo.getFieldCount() * 10);
        while (enumFieldNames.hasMoreElements()) {
            String sSearchValue;
            String sSearchName = (String)enumFieldNames.nextElement();
            if ("ChannelId".equalsIgnoreCase(sSearchName) || CMyString.isEmpty(sSearchValue = InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, sSearchName))) continue;
            InfoViewNewQueryHelper.makeFilter(filter, sbWhereFields, sTrueTableName, sSearchName, sSearchValue);
        }
        List lstFields = _view.allFields();
        int nSize = lstFields.size();
        for (int i = 0; i < nSize; ++i) {
            String sSearchValue;
            String sSearchName;
            InfoViewField field = (InfoViewField)lstFields.get(i);
            if (field == null || oTableInfo.getFieldInfo(sSearchName = field.getName()) != null || CMyString.isEmpty(sSearchValue = InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, sSearchName))) continue;
            String sFieldName = null;
            int nFromInfoViewId = InfoViewNewQueryHelper.getNewRuleFromInfoViewId();
            if (field.getInfoViewID() < nFromInfoViewId) {
                sFieldName = InfoViewConstants.makeTrueFieldName(field.getId());
            } else {
                sFieldName = field.getDesc();
                sFieldName = LetterConvertor.convertToFirstLetter(sFieldName);
            }
            FieldInfo oFieldInfo = oTableInfo.getFieldInfo(sFieldName);
            if (oFieldInfo == null) continue;
            InfoViewNewQueryHelper.makeFilter(filter, sbWhereFields, sTrueTableName, sFieldName, sSearchValue);
        }
        if (sbWhereFields.length() > 0) {
            filter.setWhere(sbWhereFields.toString());
        }
        return filter;
    }

    private static WCMFilter getInfoViewDocIdsFilter(MethodContext _methodContext, RequestHelper requestHelper, InfoView _view) throws WCMException {
        WCMFilter docidsFilter = null;
        String sTrueTableName = _view.getTrueTableName();
        String sSelectDocIds = InfoViewNewQueryHelper.getValue(_methodContext, requestHelper, "SelectedDocIds");
        if (!CMyString.isEmpty(sSelectDocIds)) {
            docidsFilter = new WCMFilter("", "", "");
            docidsFilter.setWhere(sTrueTableName + "." + "DocumentId" + " in(" + sSelectDocIds + ")");
        }
        return docidsFilter;
    }

    private static String getValue(MethodContext context, RequestHelper requestHelper, String searchName) throws WCMException {
        if (context != null) {
            return context.getValue(searchName);
        }
        if (requestHelper != null) {
            return requestHelper.getString(searchName);
        }
        return null;
    }

    private static int getValue(MethodContext context, RequestHelper requestHelper, String searchName, int _nDefault) throws WCMException {
        if (context != null) {
            return context.getValue(searchName, _nDefault);
        }
        if (requestHelper != null) {
            return requestHelper.getInt(searchName, _nDefault);
        }
        return 0;
    }

    private static boolean getValue(MethodContext context, RequestHelper requestHelper, String searchName, boolean _bDefault) throws WCMException {
        if (context != null) {
            return context.getValue(searchName, _bDefault);
        }
        if (requestHelper != null) {
            return requestHelper.getBoolean(searchName, _bDefault);
        }
        return false;
    }

    private static void makeFilter(WCMFilter _filter, StringBuffer _sbWhereFields, String _sTableName, String _sFieldName, String _sSearchValue) throws CMyException {
        FieldInfo oFieldInfo = DBManager.getDBManager().getFieldInfo(_sTableName, _sFieldName);
        if (oFieldInfo == null || oFieldInfo.getDataType() == null) {
            return;
        }
        _sFieldName = _sTableName + "." + _sFieldName;
        int nDbType = oFieldInfo.getDataType().getType();
        if (nDbType != 93 && nDbType != 92 && nDbType != 91) {
            InfoViewNewQueryHelper.makeFilterForNormalField(_filter, _sbWhereFields, _sTableName, _sFieldName, _sSearchValue, oFieldInfo);
        } else {
            InfoViewNewQueryHelper.makeFilterForDateField(_filter, _sbWhereFields, _sTableName, _sFieldName, _sSearchValue, oFieldInfo);
        }
    }

    private static void makeFilterForNormalField(WCMFilter _filter, StringBuffer _sbWhereFields, String _sTableName, String _sFieldName, String _sSearchValue, FieldInfo oFieldInfo) throws CMyException {
        if (CMyString.isEmpty(_sSearchValue)) {
            return;
        }
        if (_sbWhereFields.length() > 0) {
            _sbWhereFields.append(" and ");
        }
        _sbWhereFields.append("(");
        InfoViewNewQueryHelper.setFilterOfNormalField(_filter, _sbWhereFields, _sTableName, _sFieldName, _sSearchValue, oFieldInfo);
        _sbWhereFields.append(")");
    }

    private static void setFilterOfNormalField(WCMFilter _filter, StringBuffer _sbWhereFields, String _sTableName, String _sFieldName, String _sSearchValue, FieldInfo oFieldInfo) throws CMyException {
        if (_sSearchValue == null || CMyString.isEmpty(_sSearchValue)) {
            return;
        }
        int nValueCount = 0;
        _sSearchValue = _sSearchValue.trim();
        _sbWhereFields.append(_sFieldName);
        switch (oFieldInfo.getDataType().getType()) {
            case -1: 
            case 12: 
            case 2005: {
                if (_sSearchValue.startsWith("-")) {
                    _sbWhereFields.append(" not");
                    _sSearchValue = _sSearchValue.substring(1);
                    _sbWhereFields.append(" like ?");
                    _filter.addSearchValues("%" + _sSearchValue + "%");
                    break;
                }
                String[] pValues = _sSearchValue.trim().split(" ");
                nValueCount = pValues.length;
                for (int j = 0; j < nValueCount; ++j) {
                    if (j > 0) {
                        _sbWhereFields.append(" and " + _sFieldName);
                    }
                    String sTempSearchValue = pValues[j];
                    _sbWhereFields.append(" like ?");
                    sTempSearchValue = '%' + sTempSearchValue + '%';
                    _filter.addSearchValues(sTempSearchValue);
                }
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                break;
            }
            default: {
                if (_sSearchValue.startsWith("-")) {
                    _sbWhereFields.append(" !");
                }
                _sbWhereFields.append("=?");
                _filter.addSearchValues(Integer.parseInt(_sSearchValue));
            }
        }
    }

    private static void makeFilterForDateField(WCMFilter _filter, StringBuffer _sbWhereFields, String _sTableName, String _sFieldName, String _sSearchValue, FieldInfo oFieldInfo) throws CMyException {
        if (CMyString.isEmpty(_sSearchValue)) {
            return;
        }
        if (!CMyString.isEmpty(_sSearchValue)) {
            CMyDateTime dtTemp;
            String[] aTimeRange = _sSearchValue.split("~!~");
            if (aTimeRange.length == 0) {
                return;
            }
            if (_sbWhereFields.length() > 0) {
                _sbWhereFields.append(" and ");
            }
            String[] ops = new String[]{">=", "<="};
            boolean bPart1 = false;
            if (InfoViewNewQueryHelper.testDateFormat(aTimeRange[0])) {
                _sbWhereFields.append(_sFieldName);
                _sbWhereFields.append(ops[0] + "?");
                dtTemp = new CMyDateTime();
                dtTemp.setDateTimeWithString(aTimeRange[0]);
                _filter.addSearchValues(dtTemp);
                bPart1 = true;
            }
            if (aTimeRange.length == 2 && InfoViewNewQueryHelper.testDateFormat(aTimeRange[1])) {
                if (bPart1) {
                    _sbWhereFields.append(" and ");
                }
                _sbWhereFields.append(_sFieldName);
                _sbWhereFields.append(ops[1] + "?");
                dtTemp = new CMyDateTime();
                aTimeRange[1] = aTimeRange[1] + " 23:59:59";
                dtTemp.setDateTimeWithString(aTimeRange[1]);
                _filter.addSearchValues(dtTemp);
            }
        }
    }

    private static boolean testDateFormat(String _sFieldValue) {
        if ("null".equalsIgnoreCase(_sFieldValue) || "0".equalsIgnoreCase(_sFieldValue)) {
            return false;
        }
        try {
            CMyDateTime dtTemp = new CMyDateTime();
            boolean isValid = dtTemp.setDateTimeWithString(_sFieldValue);
            return isValid;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static WCMFilter makeTimeFilterByType(int _nFilterType, String _sTimeField) throws WCMException {
        WCMFilter filter = new WCMFilter("", _sTimeField + ">=?", "");
        try {
            switch (_nFilterType) {
                case 5: {
                    filter.addSearchValues(0, CMyDateTime.now().dateAdd(3, -3));
                    break;
                }
                case 6: {
                    filter.addSearchValues(0, CMyDateTime.now().dateAdd(12, -1));
                    break;
                }
                case 7: {
                    filter.addSearchValues(0, CMyDateTime.now().dateAdd(2, -1));
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(InfoViewNewQueryHelper.class, "InfoViewNewQueryHelper.label6", "\u6784\u9020\u65f6\u95f4\u8fc7\u6ee4\u5668\u5931\u8d25!"), e);
        }
        return filter;
    }

    private static WCMFilter makeTimeSpanFilter(MethodContext _methodContext, RequestHelper _requestHelper, String sQueryFieldName, String _sDBFieldName) throws CMyException {
        String sEndTimeValue;
        WCMFilter filter = new WCMFilter("", "", "");
        String sWhere = "";
        String sStartTimeValue = InfoViewNewQueryHelper.getValue(_methodContext, _requestHelper, sQueryFieldName + "_Start");
        if (!CMyString.isEmpty(sStartTimeValue)) {
            sWhere = sWhere + _sDBFieldName + " >= ?";
            CMyDateTime dt = new CMyDateTime();
            dt.setDateTimeWithString(sStartTimeValue);
            filter.addSearchValues(dt);
        }
        if (!CMyString.isEmpty(sEndTimeValue = InfoViewNewQueryHelper.getValue(_methodContext, _requestHelper, sQueryFieldName + "_End"))) {
            if (!CMyString.isEmpty(sStartTimeValue)) {
                sWhere = sWhere + " and ";
            }
            sWhere = sWhere + _sDBFieldName + " <= ?";
            CMyDateTime dt = new CMyDateTime();
            dt.setDateTimeWithString(sEndTimeValue);
            filter.addSearchValues(dt);
        }
        if (CMyString.isEmpty(sWhere)) {
            return null;
        }
        filter.setWhere(sWhere);
        return filter;
    }

    private static WCMFilter makeFilterByType(User _loginUser, BaseObjs _oSitesOrChannels, int _nFilterType) throws WCMException {
        if (_nFilterType == 0) {
            return null;
        }
        try {
            WCMFilter filter = new WCMFilter();
            String sWhere = null;
            switch (_nFilterType) {
                case 1: {
                    sWhere = "WCMChnlDoc.DocStatus=?";
                    filter.addSearchValues(0, 1);
                    break;
                }
                case 3: {
                    sWhere = "WCMChnlDoc.DocStatus=?";
                    filter.addSearchValues(0, 10);
                    break;
                }
                case 8: {
                    sWhere = "WCMChnlDoc.DocStatus=?";
                    filter.addSearchValues(0, 15);
                    break;
                }
                case 2: {
                    if (_oSitesOrChannels.size() > 1) {
                        sWhere = "WCMChnlDoc.DocStatus in(1,2,16,18)";
                        break;
                    }
                    WebSite site = ((BaseChannel)_oSitesOrChannels.getAt(0)).getSite();
                    IFolderPubStatusCacheMgr oCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
                    int[] pStatus = oCacheMgr.findStatusesCanDoIncreasePub(site.getWCMType(), site.getId());
                    if (pStatus == null) {
                        pStatus = new int[]{-1};
                    }
                    for (int i = 0; i < pStatus.length; ++i) {
                        sWhere = sWhere == null ? "WCMChnlDoc.DocStatus in(?" : sWhere + ",?";
                        filter.addSearchValues(i, pStatus[i]);
                    }
                    if (sWhere == null) break;
                    sWhere = sWhere + ")";
                    break;
                }
                case 4: {
                    sWhere = "WCMCHNLDOC.CrUser=?";
                    filter.addSearchValues(0, _loginUser.getName());
                    break;
                }
                case 5: {
                    sWhere = "WCMCHNLDOC.CrTime>=?";
                    filter.addSearchValues(0, CMyDateTime.now().dateAdd(3, -3));
                    break;
                }
                case 6: {
                    sWhere = "WCMCHNLDOC.CrTime>=?";
                    filter.addSearchValues(0, CMyDateTime.now().dateAdd(12, -1));
                    break;
                }
                case 7: {
                    sWhere = "WCMCHNLDOC.CrTime>=?";
                    filter.addSearchValues(0, CMyDateTime.now().dateAdd(2, -1));
                    break;
                }
            }
            filter.setWhere(sWhere);
            return filter;
        }
        catch (Exception ex) {
            throw new WCMException(I18NMessage.get(InfoViewNewQueryHelper.class, "InfoViewNewQueryHelper.label7", "\u672a\u77e5\u9519\u8bef"), ex);
        }
    }

    private static int getNewRuleFromInfoViewId() throws WCMException {
        int nFromInfoViewId = -1;
        String sConfigValue = ConfigServer.getServer().getSysConfigValue("NEWRULE_FROM_INFOVIEWID", "-1");
        try {
            nFromInfoViewId = Integer.parseInt(sConfigValue);
        }
        catch (NumberFormatException e) {
            logger.error((Object)(I18NMessage.get(InfoViewNewQueryHelper.class, "InfoViewNewQueryHelper.label8", "\u65b0\u89c4\u5219\u8d77\u59cb\u7684ID\u914d\u7f6e\u9519\u8bef![") + sConfigValue + "]"), (Throwable)e);
            nFromInfoViewId = -1;
        }
        return nFromInfoViewId;
    }

    private static WCMFilter makeDocLevelFilter(User loginUser) throws WCMException {
        StringBuffer _sbWhere = new StringBuffer();
        WCMFilter _filter = new WCMFilter();
        DocLevel docLevel = loginUser.getDocLevel();
        int nDocLevelId = docLevel.getId();
        DocLevelMgr docLevelMgr = new DocLevelMgr();
        DocLevels docLevels = docLevelMgr.queryLowerDocLevels(loginUser, docLevel);
        if (docLevels.isEmpty()) {
            _sbWhere.append("WCMChnlDoc.DOCLEVEL=?");
            _filter.addSearchValues(nDocLevelId);
        } else {
            _sbWhere.append("WCMChnlDoc.DOCLEVEL in(");
            int nSize = docLevels.size();
            for (int i = 0; i < nSize; ++i) {
                DocLevel currLevel = (DocLevel)docLevels.getAt(i);
                if (currLevel == null) continue;
                _sbWhere.append(" ?,");
                _filter.addSearchValues(currLevel.getId());
            }
            _sbWhere.append(" ?)");
            _filter.addSearchValues(nDocLevelId);
        }
        _sbWhere.append(" or WCMChnlDoc.DOCLEVEL is null");
        _sbWhere.append(" or WCMChnlDoc.DOCLEVEL=0");
        _sbWhere.append(" or WCMChnlDoc.CrUser=?");
        _filter.addSearchValues(loginUser.getName());
        _filter.setWhere(_sbWhere.toString());
        return _filter;
    }
}

