/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.IWidgetMgr;
import com.trs.components.common.publish.widget.IWidgetServiceProvider;
import com.trs.components.common.publish.widget.SpecialAuthServer;
import com.trs.components.common.publish.widget.Widget;
import com.trs.components.common.publish.widget.Widgets;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.webframework.context.MethodContext;

public class WidgetServiceProvider
implements IWidgetServiceProvider {
    private IWidgetMgr m_oIWidgetMgr = (IWidgetMgr)DreamFactory.createObjectById("IWidgetMgr");

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    @Override
    public void delete(MethodContext _context) throws Exception {
        String sWigetIds;
        User loginUser = this.getLoginUser();
        Widgets oWidgets = Widgets.findByIds(loginUser, sWigetIds = _context.getObjectIds());
        if (oWidgets == null || oWidgets.size() == 0) {
            throw new WCMException(200006, "\u6ca1\u6709\u8981\u5220\u9664\u7684\u8d44\u6e90.");
        }
        int nSize = oWidgets.size();
        for (int i = 0; i < nSize; ++i) {
            Widget oWidget = (Widget)oWidgets.getAt(i);
            if (oWidget == null) continue;
            boolean bHasRight = SpecialAuthServer.hasRight(loginUser, oWidget, 23);
            if (!bHasRight) {
                throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u8d44\u6e90[" + oWidget.getWname() + "]\u3002");
            }
            this.m_oIWidgetMgr.delete(loginUser, oWidget);
        }
    }

    @Override
    public Object query(MethodContext _context) throws Exception {
        User loginUser = this.getLoginUser();
        int nWidgetType = _context.getValue("WidgetType", 0);
        WCMFilter oFilter = new WCMFilter(_context.getQueryFilter());
        WCMFilter tempFilter = new WCMFilter();
        if (nWidgetType != 0) {
            tempFilter.addSearchValues(nWidgetType);
            tempFilter.setWhere("WidgetType in (0,?)");
        }
        oFilter.mergeWith(tempFilter);
        Widgets oWidgets = this.m_oIWidgetMgr.query(loginUser, oFilter);
        for (int i = oWidgets.size() - 1; i >= 0; --i) {
            boolean bHasRight;
            Widget oWidget = (Widget)oWidgets.getAt(i);
            if (oWidget == null || (bHasRight = SpecialAuthServer.hasRight(loginUser, oWidget, 24))) continue;
            oWidgets.remove(oWidget, false);
        }
        return oWidgets;
    }

    @Override
    public int save(MethodContext _context) throws Exception {
        int nRightIndex;
        User loginUser = this.getLoginUser();
        int nWidgetId = _context.getObjectId();
        Widget oCurrWidget = null;
        oCurrWidget = nWidgetId > 0 ? Widget.findById(nWidgetId) : new Widget();
        boolean bHasRight = SpecialAuthServer.hasRight(loginUser, oCurrWidget, nRightIndex = nWidgetId > 0 ? 22 : 21);
        if (!bHasRight) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650" + (nWidgetId > 0 ? "\u4fee\u6539\u8d44\u6e90[" + oCurrWidget.getWname() + "]\u3002" : "\u65b0\u5efa\u8d44\u6e90\u3002"));
        }
        String[] pLogicFields = new String[]{"WidgetId"};
        oCurrWidget = (Widget)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _context, oCurrWidget, pLogicFields);
        this.m_oIWidgetMgr.saveWidget(loginUser, oCurrWidget);
        return oCurrWidget.getId();
    }

    @Override
    public boolean existsSimilarName(MethodContext _context) throws Exception {
        WCMFilter existFilter = new WCMFilter("XWCMWIDGET", "WNAME=? and WIDGETID<>?", "", "WIDGETID");
        existFilter.addSearchValues(_context.getValue("widgetName"));
        existFilter.addSearchValues(_context.getObjectId());
        return DBManager.getDBManager().sqlExecuteIntQuery(existFilter) > 0;
    }

    @Override
    public String importWidgets(MethodContext _context) throws Exception {
        User loginUser = this.getLoginUser();
        String sImportFile = _context.getValue("ImportFile");
        int nImportMode = _context.getValue("ImportMode", 1);
        WCMAJAXServiceHelper.validateFile(sImportFile);
        boolean bHasRight = SpecialAuthServer.hasRight(loginUser, Widget.createNewInstance(), 21);
        if (!bHasRight) {
            throw new WCMException(1002, "\u60a8\u6ca1\u6709\u65b0\u5efa\u8d44\u6e90\u7684\u6743\u9650\uff0c\u4e0d\u80fd\u5bfc\u5165\u8d44\u6e90");
        }
        return this.m_oIWidgetMgr.importWidgets(sImportFile, nImportMode).toJSONXML();
    }

    @Override
    public String export(MethodContext _context) throws Exception {
        User loginUser = this.getLoginUser();
        String sIds = _context.getObjectIds();
        Widgets oWidgets = Widgets.findByIds(loginUser, sIds);
        for (int i = oWidgets.size() - 1; i >= 0; --i) {
            Widget currWidget = (Widget)oWidgets.getAt(i);
            if (currWidget == null || SpecialAuthServer.hasRight(loginUser, currWidget, 24)) continue;
            throw new WCMException(1002, "\u60a8\u6ca1\u6709\u6743\u9650\u5bfc\u51fa\u8d44\u6e90");
        }
        return this.m_oIWidgetMgr.export(oWidgets);
    }

    @Override
    public Object findById(MethodContext context) throws Throwable {
        return null;
    }

    @Override
    public Object findByIds(MethodContext context) throws Throwable {
        return null;
    }
}

