/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.xmlconvertors;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.database.TableInfo;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class XMLToCMSObj {
    private static Logger logger = Logger.getLogger(XMLToCMSObj.class);
    private User m_oCurrUser = null;
    private StringBuffer m_sbObjectIds = new StringBuffer("0");
    private CMSObj[] m_pCMSObjs = null;
    private CMSObj m_oSrcInstance = null;

    public XMLToCMSObj(User _currUser, CMSObj _oSrcInstance) {
        this.m_oCurrUser = _currUser;
        this.m_oSrcInstance = _oSrcInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String _sXMLText) throws WCMException {
        this.clear();
        if (_sXMLText == null || (_sXMLText = _sXMLText.trim()).length() == 0) {
            return;
        }
        TableInfo currTableInfo = DBManager.getDBManager().getTableInfo(this.m_oSrcInstance.getDbTableName());
        boolean bException = true;
        try {
            Document rootDocument = null;
            try {
                rootDocument = DocumentHelper.parseText((String)_sXMLText);
            }
            catch (Exception e) {
                logger.error((Object)(I18NMessage.get(XMLToCMSObj.class, "XMLToCMSObj.label1", "\u63d0\u4ea4\u7684\u8f6c\u6362\u6210\u5bf9\u8c61\u7684XML\u683c\u5f0f\u6709\u8bef\uff01\n======== XML BEGIN =======") + _sXMLText + "\n======== XML END ======="), (Throwable)e);
                throw new WCMException(I18NMessage.get(XMLToCMSObj.class, "XMLToCMSObj.label2", "\u63d0\u4ea4\u7684\u8f6c\u6362\u6210\u5bf9\u8c61\u7684XML\u683c\u5f0f\u6709\u8bef\uff01"), e);
            }
            List lObjects = rootDocument.getRootElement().elements("OBJECT");
            this.m_pCMSObjs = new CMSObj[lObjects.size()];
            this.m_sbObjectIds = new StringBuffer(5 * (lObjects.size() + 1));
            this.m_sbObjectIds.append("0");
            int nSize = lObjects.size();
            for (int i = 0; i < nSize; ++i) {
                Element element = (Element)lObjects.get(i);
                if (element == null) continue;
                try {
                    this.m_pCMSObjs[i] = this.toCMSObj(element, currTableInfo);
                    continue;
                }
                catch (WCMException e) {
                    throw new WCMException(I18NMessage.get(XMLToCMSObj.class, "XMLToCMSObj.label3", "\u5904\u7406\u7b2c[") + (i + 1) + I18NMessage.get(XMLToCMSObj.class, "XMLToCMSObj.label4", "]\u4e2a\u8282\u70b9\u53d1\u751f\u5f02\u5e38\uff01"), e);
                }
            }
            bException = false;
        }
        finally {
            if (bException) {
                this.cancelUpdate();
            }
        }
    }

    private boolean isIgnoreProperty(String paramName) {
        return (paramName = paramName.toUpperCase()).equals("ID");
    }

    private void clear() {
        this.m_sbObjectIds = new StringBuffer("0");
        this.m_pCMSObjs = null;
    }

    public void cancelUpdate() {
        if (this.m_pCMSObjs == null) {
            return;
        }
        for (int i = 0; i < this.m_pCMSObjs.length; ++i) {
            if (this.m_pCMSObjs[i] == null) continue;
            this.m_pCMSObjs[i].cancelUpdate(this.m_oCurrUser);
        }
    }

    private CMSObj toCMSObj(Element element, TableInfo currTableInfo) throws WCMException {
        String sId = element.attributeValue("ID");
        int nId = 0;
        if (sId != null && (sId = sId.trim()).length() > 0) {
            try {
                nId = Integer.parseInt(sId);
            }
            catch (NumberFormatException e) {
                throw new WCMException("ID[" + nId + I18NMessage.get(XMLToCMSObj.class, "XMLToCMSObj.label5", "]\u4e0d\u662f\u6574\u578b\u6570\uff01"), e);
            }
        }
        CMSObj currObject = null;
        try {
            currObject = (CMSObj)this.m_oSrcInstance.getClass().newInstance();
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(XMLToCMSObj.class, "XMLToCMSObj.label6", "\u5bf9\u8c61\u521d\u59cb\u5316\u5931\u8d25\uff01"), e);
        }
        if (nId > 0) {
            currObject = (CMSObj)BaseObj.findById(this.m_oSrcInstance.getClass(), nId);
            currObject.validCanEditAndLock(this.m_oCurrUser);
            this.m_sbObjectIds.append(",");
            this.m_sbObjectIds.append(nId);
        }
        List lPropertyNames = element.attributes();
        int nPropertySize = lPropertyNames.size();
        for (int j = 0; j < nPropertySize; ++j) {
            String sPropertyName;
            Attribute attr = (Attribute)lPropertyNames.get(j);
            if (attr == null || this.isIgnoreProperty(sPropertyName = attr.getName())) continue;
            if (currTableInfo.getFieldInfo(sPropertyName) == null) {
                logger.warn((Object)(I18NMessage.get(XMLToCMSObj.class, "XMLToCMSObj.label7", "\u66f4\u65b0\u5bf9\u8c61[") + this.m_oSrcInstance + I18NMessage.get(XMLToCMSObj.class, "XMLToCMSObj.label8", "]\u65f6\u5019\uff0c\u7531\u4e8e\u5b57\u6bb5[") + sPropertyName + I18NMessage.get(XMLToCMSObj.class, "XMLToCMSObj.label9", "]\u5728\u8868[") + this.m_oSrcInstance.getDbTableName() + I18NMessage.get(XMLToCMSObj.class, "XMLToCMSObj.label10", "]\u4e2d\u4e0d\u5b58\u5728\uff0c\u5ffd\u7565\u6570\u636e\uff01")));
                continue;
            }
            try {
                currObject.setPropertyWithString(sPropertyName, attr.getValue());
                continue;
            }
            catch (Exception e) {
                throw new WCMException(I18NMessage.get(XMLToCMSObj.class, "XMLToCMSObj.label11", "\u5904\u7406\u5c5e\u6027[Name=") + sPropertyName + I18NMessage.get(XMLToCMSObj.class, "XMLToCMSObj.label12", "]\u53d1\u751f\u5f02\u5e38\uff01[Value=") + attr.getValue() + "]", e);
            }
        }
        return currObject;
    }

    public CMSObj[] getCMSObjs() {
        return this.m_pCMSObjs;
    }

    public String getObjectIds() {
        return this.m_sbObjectIds.toString();
    }
}

