/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.util;

import org.apache.log4j.Logger;

public abstract class DaemonThreadBase
extends Thread {
    private static final Logger s_logger;
    protected volatile boolean zContinue = true;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.cluster.util.DaemonThreadBase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    public DaemonThreadBase(String name) {
        super(name);
        this.setDaemon(true);
    }

    public void run() {
        try {
            while (this.zContinue) {
                this.loop();
                this.waitCycle();
            }
        }
        catch (Throwable e) {
            s_logger.error((Object)"Unexpected daemon thread end", e);
        }
    }

    protected abstract void loop();

    protected abstract int getCycle();

    private synchronized void waitCycle() {
        try {
            this.wait(this.getCycle());
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable e) {
            s_logger.error((Object)"Unexpected exception", e);
        }
    }

    public synchronized void runow() {
        this.notify();
    }

    public synchronized void startup() {
        this.zContinue = true;
        this.start();
    }

    public void terminate() {
        this.zContinue = false;
        this.interrupt();
    }
}

