/*
 * Decompiled with CFR 0.152.
 */
package com.trsupdate;

import com.trs.cms.auth.persistent.User;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.DebugTimer;
import com.trsupdate.AccessRightUpdater;
import com.trsupdate.InheritCaculatorByWCM52RightMode;
import com.trsupdate.WCM52InheritRight2WCM65Updater;
import java.util.List;
import org.apache.log4j.Logger;

public class RightUpdaterForWCM52 {
    private static Logger logger = Logger.getLogger(RightUpdaterForWCM52.class);
    public static boolean m_bDoUpdate = false;

    public static void update() throws Exception {
        if (!m_bDoUpdate) {
            return;
        }
        String sUpdatedFile = ".WCMRightUpdate";
        boolean bUpdated = CMyFile.fileExists(sUpdatedFile);
        if (bUpdated) {
            return;
        }
        String sUpdateingFile = ".WCMRightUpdateing";
        boolean bUpdating = CMyFile.fileExists(sUpdateingFile);
        if (bUpdating) {
            logger.error((Object)"The system already upgraded right, but error happen.\nPlease shutdown application right now! After do someting follow the upgrade document, startup application again!");
            throw new WCMException("The system already upgraded right!");
        }
        CMyFile.writeFile(sUpdateingFile, CMyDateTime.now() + " begin to upgrade right...");
        RightUpdaterForWCM52.doUpdate();
        CMyFile.deleteFile(sUpdateingFile);
        CMyFile.writeFile(sUpdatedFile, CMyDateTime.now() + " end to upgrade right!");
    }

    private static void doUpdate() throws WCMException {
        DebugTimer timer = new DebugTimer();
        timer.start();
        logger.warn((Object)"The system is upgrading right\u2026\u2026\u2026\u2026\u2026\u2026");
        User admin = User.findByName("admin");
        InheritCaculatorByWCM52RightMode caculator = new InheritCaculatorByWCM52RightMode();
        List lResult = caculator.makeInheritInfo(null);
        logger.warn((Object)("The [" + lResult.size() + "] channels use inherit right rule!"));
        WCM52InheritRight2WCM65Updater updater = new WCM52InheritRight2WCM65Updater(lResult);
        List arNewRights = updater.update();
        logger.warn((Object)("create [" + arNewRights.size() + "] right!"));
        AccessRightUpdater oUpdaterForAccessRight = new AccessRightUpdater(admin);
        oUpdaterForAccessRight.updateAccessRight();
        timer.stop();
        logger.warn((Object)("The system finished upgraded right! use[" + timer.getTime() + "]ms"));
    }
}

