/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.xmlserver.server;

import com.trs.infra.util.CMyJAXPXMLParser;
import com.trs.infra.util.XmlCharCheckedInputStream;
import com.trs.webframework.config.MethodConfig;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.context.ServiceContext;
import com.trs.webframework.xmlserver.parser.StreamBuddy;
import com.trs.webframework.xmlserver.server.IRequestProcessor;
import com.trs.webframework.xmlserver.server.InvocationObserver;
import com.trs.webframework.xmlserver.server.XMLDataProcessingHandler;
import com.trs.webframework.xmlserver.server.XMLParsingPausedException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RequestXMLDataProcessor
implements IRequestProcessor {
    private static Logger logger = Logger.getLogger(RequestXMLDataProcessor.class);
    private InputStream m_oDataInputStream;
    private ServiceContext m_oServiceContext = null;

    public RequestXMLDataProcessor(ServiceContext _serviceContext, InputStream _in) {
        this.m_oServiceContext = _serviceContext;
        if (_in != null) {
            this.m_oDataInputStream = new XmlCharCheckedInputStream(_in);
        }
    }

    public RequestXMLDataProcessor(InputStream _in) {
        this.m_oServiceContext = new ServiceContext();
        if (_in != null) {
            this.m_oDataInputStream = new XmlCharCheckedInputStream(_in);
        }
    }

    @Override
    public Object excute() throws Throwable {
        XMLDataProcessingHandler handler = new XMLDataProcessingHandler(this.m_oServiceContext);
        handler.attachObserver(new InvocationObserver(this.m_oServiceContext));
        InputSource inputSource = StreamBuddy.getInputSource(this.m_oDataInputStream, "utf-8");
        this.doDataProcessing(inputSource, handler, false);
        return handler.getResult();
    }

    protected void doDataProcessing(InputSource is, DefaultHandler handler, boolean validating) throws Throwable {
        Exception innerException;
        try {
            CMyJAXPXMLParser.parseXMLFile(is, handler, validating);
        }
        catch (SAXException ex) {
            innerException = ex.getException();
            if (innerException == null) {
                throw ex;
            }
            throw innerException;
        }
        finally {
            if (innerException instanceof XMLParsingPausedException) {
                if (logger.isDebugEnabled()) {
                    logger.info((Object)"Completed processing before time!");
                }
                return;
            }
        }
    }

    @Override
    public MethodContext getCurrentMethodContext() {
        return null;
    }

    @Override
    public MethodConfig getCurrentMethodConfig() {
        return null;
    }
}

