/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.xmlserver.server;

import com.trs.infra.I18NMessage;
import com.trs.webframework.WebServiceHelper;
import com.trs.webframework.config.MethodConfig;
import com.trs.webframework.config.ServiceConfig;
import com.trs.webframework.config.ServiceConfigHelper;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.context.ServiceContext;
import com.trs.webframework.controler.servlet.XMLParamsValidator;
import com.trs.webframework.exception.ServiceCreationFailException;
import com.trs.webframework.exception.ServiceInvocationException;
import com.trs.webframework.provider.BaseServiceDecorator;
import com.trs.webframework.xmlserver.parser.XMLParseException;
import com.trs.webframework.xmlserver.server.IObserver;
import com.trs.webframework.xmlserver.server.IObserverable;
import com.trs.webframework.xmlserver.server.XMLDataProcessingHandler;
import org.apache.log4j.Logger;

public class InvocationObserver
implements IObserver {
    private static Logger logger = Logger.getLogger(InvocationObserver.class);
    private MethodConfig m_oMethodConfig = null;
    private XMLDataProcessingHandler m_oVisitor;
    private ServiceContext m_oServiceContext = null;
    private Object m_oVisitorArg = null;

    public InvocationObserver() {
    }

    public InvocationObserver(ServiceContext _serviceContext) {
        this.m_oServiceContext = _serviceContext;
    }

    @Override
    public void clear() {
        this.m_oMethodConfig = null;
        this.m_oVisitorArg = null;
    }

    @Override
    public void update(IObserverable _subject) throws Throwable {
        this.update(_subject, null);
    }

    @Override
    public void update(IObserverable _subject, Object _arg) throws Throwable {
        this.m_oVisitor = (XMLDataProcessingHandler)_subject;
        this.m_oVisitorArg = _arg;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(">> update at status: " + this.m_oVisitor.getParsingStatus()));
        }
        switch (this.m_oVisitor.getParsingStatus()) {
            case 1: {
                this.doOnTypeDetected();
                break;
            }
            case 2: {
                this.doOnInvocationNameDetected();
                break;
            }
            case 3: 
            case 4: {
                this.doOnParameterDetected();
                break;
            }
        }
    }

    private void doOnTypeDetected() {
        int nInvocationType = this.m_oVisitor.getParsingInfo().getInvocationType();
        if (nInvocationType == 1) {
            // empty if block
        }
    }

    private void doOnInvocationNameDetected() throws Throwable {
        String sServiceId = this.m_oVisitor.getParsingInfo().getInvocationId();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("sServiceId:" + sServiceId));
        }
        if (sServiceId == null) {
            throw new XMLParseException("No Service defined in the xml stream\uff01");
        }
        ServiceConfig serviceConfig = ServiceConfigHelper.findServiceConfig(sServiceId);
        if (serviceConfig == null) {
            throw new ServiceCreationFailException(I18NMessage.get(InvocationObserver.class, "InvocationObserver.label1", "\u6ca1\u6709\u53d1\u73b0Service[") + sServiceId + I18NMessage.get(InvocationObserver.class, "InvocationObserver.label2", "]\u7684\u914d\u7f6e\u6587\u4ef6 [") + ServiceConfigHelper.getSevicesConfigFileName(sServiceId) + "].");
        }
        String sMethodName = this.m_oVisitor.getParsingInfo().getMethodName();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("methodname:" + sMethodName));
        }
        this.m_oMethodConfig = ServiceConfigHelper.findMethodConfig(sServiceId, sMethodName);
        if (this.m_oMethodConfig == null) {
            throw new ServiceCreationFailException(I18NMessage.get(InvocationObserver.class, "InvocationObserver.label3", "\u662f\u5426\u5728\u6587\u4ef6[") + ServiceConfigHelper.getSevicesConfigFileName(sServiceId) + I18NMessage.get(InvocationObserver.class, "InvocationObserver.label4", "]\u4e2d\u6ca1\u6709\u5b9a\u4e49\u65b9\u6cd5[") + sMethodName + "]?");
        }
        if (!this.m_oMethodConfig.isParamsRequired()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"execute....");
            }
            this.execute(4);
        }
    }

    private void doOnParameterDetected() throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"execute....");
        }
        int nInvocationType = this.m_oVisitor.getParsingInfo().getInvocationType();
        this.execute(nInvocationType);
    }

    private void execute(int _nInvocationType) throws Throwable {
        if (this.m_oMethodConfig == null) {
            logger.warn((Object)"method is null!");
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("serviceid:" + this.m_oMethodConfig.getServiceConfig().getServiceId()));
            logger.debug((Object)("provider:" + this.m_oMethodConfig.getProvider().getClass().getName()));
            logger.debug((Object)("methodname:" + this.m_oMethodConfig.getName()));
        }
        Object result = null;
        MethodContext validatedContext = new XMLParamsValidator(this.m_oVisitor.getParsingInfo().getNamedParamsMap(), this.m_oMethodConfig).getMethodContext();
        MethodContext methodContext = validatedContext != null ? validatedContext : new MethodContext(this.m_oMethodConfig);
        try {
            switch (_nInvocationType) {
                case 1: {
                    methodContext.setObjectIds(this.m_oVisitor.getParsingInfo().getObjectIds());
                    break;
                }
                case 5: {
                    methodContext.setObjectId(this.m_oVisitor.getParsingInfo().getObjectId());
                    break;
                }
                case 7: {
                    methodContext.setObjectIds(this.m_oVisitor.getParsingInfo().getObjectIds());
                }
            }
        }
        catch (Throwable ex) {
            throw new ServiceInvocationException(ex);
        }
        if (this.m_oMethodConfig.getProvider() instanceof BaseServiceDecorator) {
            ((BaseServiceDecorator)this.m_oMethodConfig.getProvider()).decorate(this.m_oServiceContext);
        }
        if (this.m_oVisitorArg != null && this.m_oVisitorArg instanceof ServiceContext) {
            methodContext.setServiceContext((ServiceContext)this.m_oVisitorArg);
        }
        result = WebServiceHelper.execute(this.m_oMethodConfig, methodContext);
        this.m_oVisitor.stopOnParsingCompleted(result);
    }
}

