/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.controler.servlet;

import com.trs.bbs.plad.upload.RFC1867FormPart;
import com.trs.bbs.plad.upload.RFC1867InputStream;
import com.trs.bbs.plad.upload.RFC1867ServletRequest;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.dev4.jdk16.servlet24.RequestUtil;
import com.trs.dev4.jdk16.servlet24.ResponseUtil;
import com.trs.infra.WCMServiceHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DebugTimer;
import com.trs.infra.util.ImgFileHelperForReadImg;
import com.trs.infra.util.RemoteAddrUtil;
import com.trs.presentation.locale.LocaleServer;
import com.trs.presentation.util.LoginHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.json.JSONObject;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class OpenAPIServiceControler
extends HttpServlet {
    private static Logger logger = Logger.getLogger(OpenAPIServiceControler.class);
    private static final long serialVersionUID = 1L;
    private static HashMap<String, String> paramNameMap = new HashMap();
    private String[] m_pAllowIPPaths = null;

    private void initParamesMap() {
        paramNameMap.put("DOC_APPENDIX_FILE_SIZE_LIMIT", "filesize");
        paramNameMap.put("DOC_APPENDIX_IMAGE_SIZE_LIMIT", "imagesize");
        paramNameMap.put("DOC_APPENDIX_VIDEO_SIZE_LIMIT", "appendixvideosize");
        paramNameMap.put("DOC_APPENDIX_AUDIO_SIZE_LIMIT", "appendixaudiosize");
        paramNameMap.put("DOCUMENT_IMAGE_SIZE_LIMIT", "imageindocsize");
        paramNameMap.put("DOCUMENT_FLASH_SIZE_LIMIT", "flashsize");
        paramNameMap.put("DOCUMENT_VIDEO_SIZE_LIMIT", "videosize");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DebugTimer allTimer = new DebugTimer();
        allTimer.start();
        String pathinfo = request.getPathInfo();
        try {
            if (pathinfo.equalsIgnoreCase("/allowippath")) {
                this.allowippath(request, response);
                return;
            }
            if (pathinfo.equalsIgnoreCase("/validatewebpic")) {
                this.validateImageRight(request, response);
                return;
            }
            if (pathinfo.equalsIgnoreCase("/validate")) {
                this.validate(request, response);
                return;
            }
            if (pathinfo.equalsIgnoreCase("/readimg")) {
                this.readImgAndScale(request, response);
                return;
            }
            LoginHelper currLoginHelper = new LoginHelper(request, this.getServletContext());
            User loginUser = currLoginHelper.getLoginUser();
            if (loginUser == null) {
                throw new ServletException("Not Login!Forbidden");
            }
            if (pathinfo.equalsIgnoreCase("/uploadImage")) {
                this.uploadImage0(request, response);
                return;
            }
            if (pathinfo.equalsIgnoreCase("/uploadFile")) {
                this.uploadFile(request, response);
                return;
            }
            if (pathinfo.equalsIgnoreCase("/uploadImageForEditor")) {
                this.uploadImageForEditor(request, response);
                return;
            }
            response.getWriter().write("\u8bf7\u6c42\u9519\u8bef\uff01");
        }
        finally {
            ContextHelper.clear();
            allTimer.stop();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Open API[" + pathinfo + "] use [" + allTimer.getTime() + "]ms!"));
            }
        }
    }

    private void allowIp(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String sXForwardedFor = RemoteAddrUtil.getRemoteAddr(request);
        if (this.isAllowIPPath(sXForwardedFor)) {
            String sURL = request.getParameter("url");
            response.setHeader("X-Accel-Redirect", sURL);
            response.setHeader("X-Sendfile", sURL);
            return;
        }
        logger.error((Object)" \u975e\u6cd5IP ! ");
        response.setStatus(403);
    }

    private void allowippath(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Not Login!Forbidden\uff0cSession InValidate?");
            }
            this.allowIp(request, response);
            return;
        }
        Object userKey = session.getAttribute("WCM52.loginUser");
        if (userKey == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Not Login!Forbidden");
            }
            this.allowIp(request, response);
            return;
        }
        String sURL = request.getParameter("url");
        if (CMyString.isEmpty(sURL)) {
            logger.error((Object)"invalidate url!");
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("url: " + sURL));
        }
        response.setHeader("X-Accel-Redirect", sURL);
        response.setHeader("X-Sendfile", sURL);
    }

    private void validate(HttpServletRequest request, HttpServletResponse response) {
        String sURL;
        HttpSession session = request.getSession(false);
        if (session == null) {
            logger.error((Object)"Not Login!Forbidden\uff0cSession InValidate?");
            response.setStatus(403);
            return;
        }
        Object userKey = session.getAttribute("WCM52.loginUser");
        if (userKey == null) {
            logger.error((Object)"Not Login!Forbidden");
            response.setStatus(403);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(RequestUtil.getRequestInfo((HttpServletRequest)request) + "; All Headers: " + RequestUtil.getAllHeadersStr((HttpServletRequest)request)));
        }
        if (CMyString.isEmpty(sURL = request.getParameter("url"))) {
            logger.error((Object)"invalidate url!");
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sURL);
        }
        response.setHeader("X-Accel-Redirect", sURL);
        response.setHeader("X-Sendfile", sURL);
    }

    private boolean isLogin(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            logger.error((Object)"Not Login!Forbidden\uff0cSession InValidate?");
            return false;
        }
        Object userKey = session.getAttribute("WCM52.loginUser");
        if (userKey == null) {
            logger.error((Object)"Not Login!Forbidden");
            return false;
        }
        return true;
    }

    private void validateImageRight(HttpServletRequest request, HttpServletResponse response) {
        String sURL;
        if (!this.isLogin(request, response)) {
            response.setStatus(403);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(RequestUtil.getRequestInfo((HttpServletRequest)request) + "; All Headers: " + RequestUtil.getAllHeadersStr((HttpServletRequest)request)));
        }
        if (CMyString.isEmpty(sURL = request.getParameter("url"))) {
            logger.error((Object)"invalidate url!");
            return;
        }
        sURL = "/webpic/" + sURL;
        String sImageType = CMyFile.extractFileExt(sURL).trim();
        if (sImageType.equals("jpe") || sImageType.equals("jpg")) {
            sImageType = "jpeg";
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sURL);
            logger.debug((Object)("image/" + sImageType));
        }
        response.setHeader("Content-Type", "image/" + sImageType);
        response.setHeader("X-Accel-Redirect", sURL);
        response.setHeader("X-Sendfile", sURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadImage0(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"upload....");
        }
        DebugTimer timer = new DebugTimer();
        timer.start();
        org.json.JSONObject oResult = new org.json.JSONObject();
        try {
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
            String sysConfigImageSize = ConfigServer.getServer().getSysConfigValue("DEFAULT_IMAGE_UPLOAD_SIZE_LIMIT", "10240");
            if (!isMultipart) {
                String sErrorMsg = "\u6587\u4ef6\u4e3a\u7a7a";
                oResult.put("error", (Object)sErrorMsg);
                ResponseUtil.json((HttpServletResponse)response, (String)oResult.toString());
                return;
            }
            ServletFileUpload upload = this.initFileUpload();
            List list = upload.parseRequest(request);
            for (FileItem oFileItem : list) {
                if (oFileItem.isFormField()) {
                    if (!logger.isDebugEnabled()) continue;
                    String ds = oFileItem.getString("UTF-8");
                    System.err.println("\u8bf4\u660e\u662f:" + ds);
                    continue;
                }
                String sFileName = oFileItem.getName();
                if (this.isForbidFileExt(sFileName)) {
                    String sErrorMsg = CMyString.format("\u7cfb\u7edf\u7981\u6b62\u4e0a\u4f20{0}\u683c\u5f0f\u7684\u6587\u4ef6\uff01", new String[]{CMyFile.extractFileExt(sFileName).toUpperCase()});
                    oResult.put("error", (Object)sErrorMsg);
                    ResponseUtil.json((HttpServletResponse)response, (String)oResult.toString());
                    return;
                }
                long sizeLimitKB = Long.parseLong(sysConfigImageSize);
                boolean sizeExceeded = OpenAPIServiceControler.isSizeExceeded(oFileItem.getSize(), sizeLimitKB);
                if (sizeExceeded) {
                    String errorMsg = OpenAPIServiceControler.buildSizeExceededMsg(sizeLimitKB);
                    oResult.put("error", (Object)errorMsg);
                    ResponseUtil.json((HttpServletResponse)response, (String)oResult.toString());
                    return;
                }
                String sFileExt = CMyFile.extractFileExt(sFileName);
                FilesMan aFilesMan = FilesMan.getFilesMan();
                String sSaveFile = aFilesMan.getNextFilePathName("U0", sFileExt);
                oFileItem.write(new File(sSaveFile));
                String strShowName = CMyFile.extractFileName(sFileName, "/");
                strShowName = CMyFile.extractFileName(strShowName, "\\");
                String sUploadName = CMyFile.extractFileName(sSaveFile);
                File srcFile = new File(sSaveFile);
                if (srcFile.isDirectory() || !srcFile.exists()) {
                    logger.error((Object)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01", (Throwable)new Exception("who do this?"));
                }
                oResult.put("success", (Object)"\u4e0a\u4f20\u6210\u529f\uff01");
                oResult.put("imgName", (Object)sUploadName);
                oResult.put("imgSrc", (Object)WCMServiceHelper.getReadImgURL(sUploadName, 600));
                ResponseUtil.json((HttpServletResponse)response, (String)oResult.toString());
            }
            return;
        }
        catch (Throwable ex) {
            int errorCode = 0;
            if (ex instanceof WCMException) {
                WCMException myEx = (WCMException)ex;
                errorCode = myEx.getErrNo();
            }
            logger.error((Object)"Fail to upload file", ex);
            oResult.put("error", (Object)("\u4e0a\u4f20\u5931\u8d25\uff0c\u9519\u8bef\u53f7[" + errorCode + "]"));
            ResponseUtil.json((HttpServletResponse)response, (String)oResult.toString());
            return;
        }
        finally {
            timer.stop();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("end!use[" + timer.getTime() + "]ms"));
            }
        }
    }

    private static boolean isSizeExceeded(long sizeB, long sizeLimitKB) {
        return sizeLimitKB < sizeB / 1024L;
    }

    private static String buildSizeExceededMsg(long sizeLimitKB) {
        return String.format("\u4e0a\u4f20\u56fe\u7247\u5927\u5c0f\u8d85\u8fc7\u7cfb\u7edf\u914d\u7f6e\u7684\u6700\u5927\u503c %s M\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u56fe\u7247\uff01", BigDecimal.valueOf((double)sizeLimitKB / 1024.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadImageForEditor(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String action;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"upload....");
        }
        if (StringUtils.isNotEmpty((String)(action = request.getParameter("action"))) && action.equalsIgnoreCase("config")) {
            this.loadUEditorConfig(request, response);
            return;
        }
        DebugTimer timer = new DebugTimer();
        timer.start();
        org.json.JSONObject oResult = new org.json.JSONObject();
        try {
            String sSaveFile = null;
            String sErrorMsg = null;
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
            if (!isMultipart) {
                this.writeErrorInoForEditor(response, "\u6587\u4ef6\u4e3a\u7a7a");
                return;
            }
            ServletFileUpload upload = this.initFileUpload();
            List list = upload.parseRequest(request);
            for (FileItem oFileItem : list) {
                if (oFileItem.isFormField()) {
                    if (!logger.isDebugEnabled()) continue;
                    String ds = oFileItem.getString("UTF-8");
                    System.err.println("\u8bf4\u660e\u662f:" + ds);
                    continue;
                }
                String sFileName = oFileItem.getName();
                if (this.isForbidFileExt(sFileName)) {
                    sErrorMsg = CMyString.format("\u7cfb\u7edf\u7981\u6b62\u4e0a\u4f20{0}\u683c\u5f0f\u7684\u6587\u4ef6\uff01", new String[]{CMyFile.extractFileExt(sFileName).toUpperCase()});
                    this.writeErrorInoForEditor(response, sErrorMsg);
                    return;
                }
                String sFileExt = CMyFile.extractFileExt(sFileName);
                FilesMan aFilesMan = FilesMan.getFilesMan();
                sSaveFile = aFilesMan.getNextFilePathName("U0", sFileExt);
                oFileItem.write(new File(sSaveFile));
                String strShowName = CMyFile.extractFileName(sFileName, "/");
                strShowName = CMyFile.extractFileName(strShowName, "\\");
                String sUploadName = CMyFile.extractFileName(sSaveFile);
                File srcFile = new File(sSaveFile);
                if (srcFile.isDirectory() || !srcFile.exists()) {
                    logger.error((Object)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01", (Throwable)new Exception("who do this?"));
                }
                oResult.put("state", (Object)"SUCCESS");
                oResult.put("url", (Object)sUploadName);
                oResult.put("title", (Object)strShowName);
                oResult.put("original", (Object)strShowName);
                ResponseUtil.json((HttpServletResponse)response, (String)oResult.toString());
            }
            return;
        }
        catch (Throwable ex) {
            int errorCode = 0;
            if (ex instanceof WCMException) {
                WCMException myEx = (WCMException)ex;
                errorCode = myEx.getErrNo();
            }
            logger.error((Object)"ERROR:", ex);
            oResult.put("error", (Object)("\u4e0a\u4f20\u5931\u8d25\uff0c\u9519\u8bef\u53f7[" + errorCode + "]"));
            ResponseUtil.json((HttpServletResponse)response, (String)oResult.toString());
            return;
        }
        finally {
            timer.stop();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("end!use[" + timer.getTime() + "]ms"));
            }
        }
    }

    private void loadUEditorConfig(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int read;
        InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("ueditor/config.json");
        InputStreamReader isr = new InputStreamReader(is, "utf-8");
        String result = "";
        while ((read = isr.read()) != -1) {
            result = result + (char)read;
        }
        isr.close();
        String callback = request.getParameter("callback");
        JSONObject jsonObject = JSONObject.fromObject((Object)result);
        response.setContentType("text/html;charset=UTF-8");
        if (StringUtils.isNotEmpty((String)callback)) {
            ResponseUtil.json((HttpServletResponse)response, (String)(callback + "(" + jsonObject.toString() + ")"));
        } else {
            ResponseUtil.json((HttpServletResponse)response, (String)jsonObject.toString());
        }
    }

    private void writeErrorInoForEditor(HttpServletResponse response, String sErrorMsg) throws IOException {
        sErrorMsg = "0<!--##########-->" + sErrorMsg;
        sErrorMsg = sErrorMsg + "<!--##########--><!--ERROR-->";
        response.getWriter().write(sErrorMsg);
    }

    private ServletFileUpload initFileUpload() throws WCMException {
        FilesMan aFilesMan = FilesMan.getFilesMan();
        String sUploadTempPath = aFilesMan.getPathConfigValue("ST", 0);
        String sFileSize = ConfigServer.getServer().getSysConfigValue("UPLOAD_SIZE", "30");
        int nFileSize = Integer.parseInt(sFileSize);
        DiskFileItemFactory f = new DiskFileItemFactory();
        f.setRepository(new File(sUploadTempPath));
        f.setSizeThreshold(8192);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)f);
        upload.setHeaderEncoding("UTF-8");
        upload.setFileSizeMax((long)(0x100000 * nFileSize));
        upload.setSizeMax(0x3C00000L);
        return upload;
    }

    private void uploadFile(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"upload....");
        }
        DebugTimer timer = new DebugTimer();
        timer.start();
        org.json.JSONObject oResult = new org.json.JSONObject();
        try {
            RFC1867ServletRequest oUploadHelper;
            RFC1867InputStream.POST_ENCODING = "UTF-8";
            FilesMan aFilesMan = FilesMan.getFilesMan();
            String sUploadTempPath = aFilesMan.getPathConfigValue("ST", 0);
            RFC1867ServletRequest newRequest = oUploadHelper = new RFC1867ServletRequest(request, sUploadTempPath);
            String sType = newRequest.getParameter("type");
            String sysConfigSize = null;
            if (!CMyString.isEmpty(sType)) {
                if (paramNameMap.size() == 0) {
                    this.initParamesMap();
                }
                sysConfigSize = ConfigServer.getServer().getSysConfigValue(sType.toUpperCase(), "0");
            } else {
                sysConfigSize = ConfigServer.getServer().getSysConfigValue("DEFAULT_FILE_UPLOAD_SIZE_LIMIT", "30720");
            }
            String sSaveFile = null;
            String sErrorMsg = null;
            RFC1867FormPart oFileHelper = oUploadHelper.getFormPart("file");
            if (oFileHelper == null) {
                sErrorMsg = LocaleServer.getString("file_upload_dowith.label.noContent", "\u6587\u4ef6\u4e3a\u7a7a");
                oResult.put("error", (Object)sErrorMsg);
                ResponseUtil.json((HttpServletResponse)response, (String)oResult.toString());
                logger.error((Object)"upload file is empty");
                return;
            }
            if (oFileHelper.getSize() <= 0L) {
                sErrorMsg = LocaleServer.getString("file_upload_dowith.label.noContent", "\u6587\u4ef6\u4e3a\u7a7a");
                oResult.put("error", (Object)sErrorMsg);
                ResponseUtil.json((HttpServletResponse)response, (String)oResult.toString());
                logger.error((Object)"upload file is empty");
                return;
            }
            if (this.isForbidFileExt(oFileHelper.getFileName())) {
                sErrorMsg = CMyString.format(LocaleServer.getString("file_upload_dowith.jsp.forbid_upload_filetype", "\u7cfb\u7edf\u7981\u6b62\u4e0a\u4f20{0}\u683c\u5f0f\u7684\u6587\u4ef6\uff01"), new String[]{CMyString.showEmpty(CMyFile.extractFileExt(oFileHelper.getFileName()).toUpperCase(), "\u65e0\u540e\u7f00")});
                oResult.put("error", (Object)sErrorMsg);
                ResponseUtil.json((HttpServletResponse)response, (String)oResult.toString());
                return;
            }
            long lSize = oFileHelper.getSize();
            if (lSize <= 0L) {
                sErrorMsg = LocaleServer.getString("file_upload_dowith.label.noFileFound", "\u672c\u5730\u6587\u4ef6\u4e0d\u5b58\u5728");
                oResult.put("error", (Object)sErrorMsg);
                ResponseUtil.json((HttpServletResponse)response, (String)oResult.toString());
                return;
            }
            long nRestrictSize = 0L;
            if (!CMyString.isEmpty(sysConfigSize) && (nRestrictSize = Long.parseLong(sysConfigSize)) > 0L && lSize > nRestrictSize * 1024L) {
                Float fSizeToM = Float.valueOf(Float.parseFloat(sysConfigSize));
                fSizeToM = Float.valueOf(fSizeToM.floatValue() / 1024.0f);
                fSizeToM = Float.valueOf((float)Math.round(fSizeToM.floatValue() * 100.0f) / 100.0f);
                sErrorMsg = CMyString.format(LocaleServer.getString("file_upload_dowith.filesize.toolarge1", "\u4e0a\u4f20\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u7cfb\u7edf\u914d\u7f6e\u7684\u6700\u5927\u503c {0}M\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6587\u4ef6\uff01"), new String[]{"" + fSizeToM});
                oResult.put("error", (Object)sErrorMsg);
                ResponseUtil.json((HttpServletResponse)response, (String)oResult.toString());
                return;
            }
            timer.stop();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("start write file.....before use[" + timer.getTime() + "]ms"));
            }
            timer.start();
            sSaveFile = aFilesMan.getNextFilePathName("U0", oFileHelper.getFileType());
            oFileHelper.writeTo(new File(sSaveFile));
            timer.stop();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("end write file!before use[" + timer.getTime() + "]ms"));
            }
            timer.start();
            String strShowName = CMyFile.extractFileName(oFileHelper.getFileName(), "/");
            strShowName = CMyFile.extractFileName(strShowName, "\\");
            String sUploadName = CMyFile.extractFileName(sSaveFile);
            File srcFile = new File(sSaveFile);
            if (srcFile.isDirectory() || !srcFile.exists()) {
                logger.error((Object)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01", (Throwable)new Exception("who do this?"));
            }
            oResult.put("success", (Object)"\u4e0a\u4f20\u6210\u529f\uff01");
            oResult.put("imgName", (Object)sUploadName);
            oResult.put("imgSrc", (Object)WCMServiceHelper.mapWebURLOfFile(sUploadName));
            ResponseUtil.json((HttpServletResponse)response, (String)oResult.toString());
            timer.stop();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("End! before use[" + timer.getTime() + "]ms"));
            }
            return;
        }
        catch (Throwable ex) {
            int errorCode = 0;
            if (ex instanceof WCMException) {
                WCMException myEx = (WCMException)ex;
                errorCode = myEx.getErrNo();
            }
            logger.error((Object)"ERROR:", ex);
            oResult.put("error", (Object)("\u4e0a\u4f20\u5931\u8d25\uff0c\u9519\u8bef\u53f7[" + errorCode + "]"));
            ResponseUtil.json((HttpServletResponse)response, (String)oResult.toString());
            return;
        }
    }

    private void uploadImage(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"upload....");
        }
        DebugTimer timer = new DebugTimer();
        timer.start();
        org.json.JSONObject oResult = new org.json.JSONObject();
        try {
            RFC1867ServletRequest oUploadHelper;
            RFC1867InputStream.POST_ENCODING = "UTF-8";
            FilesMan aFilesMan = FilesMan.getFilesMan();
            String sUploadTempPath = aFilesMan.getPathConfigValue("ST", 0);
            RFC1867ServletRequest newRequest = oUploadHelper = new RFC1867ServletRequest(request, sUploadTempPath);
            String sType = newRequest.getParameter("type");
            String sysConfigImageSize = null;
            if (!CMyString.isEmpty(sType)) {
                if (paramNameMap.size() == 0) {
                    this.initParamesMap();
                }
                sysConfigImageSize = ConfigServer.getServer().getSysConfigValue(sType.toUpperCase(), "0");
            }
            String sSaveFile = null;
            String sErrorMsg = null;
            RFC1867FormPart oFileHelper = oUploadHelper.getFormPart("file");
            if (oFileHelper == null) {
                sErrorMsg = LocaleServer.getString("file_upload_dowith.label.noContent", "\u6587\u4ef6\u4e3a\u7a7a");
                oResult.put("error", (Object)sErrorMsg);
                ResponseUtil.json((HttpServletResponse)response, (String)oResult.toString());
                return;
            }
            if (oFileHelper.getSize() <= 0L) {
                sErrorMsg = LocaleServer.getString("file_upload_dowith.label.noContent", "\u6587\u4ef6\u4e3a\u7a7a");
                oResult.put("error", (Object)sErrorMsg);
                ResponseUtil.json((HttpServletResponse)response, (String)oResult.toString());
                return;
            }
            if (this.isForbidFileExt(oFileHelper.getFileName())) {
                sErrorMsg = CMyString.format(LocaleServer.getString("file_upload_dowith.jsp.forbid_upload_filetype", "\u7cfb\u7edf\u7981\u6b62\u4e0a\u4f20{0}\u683c\u5f0f\u7684\u6587\u4ef6\uff01"), new String[]{CMyString.showEmpty(CMyFile.extractFileExt(oFileHelper.getFileName()).toUpperCase(), "\u65e0\u540e\u7f00")});
                oResult.put("error", (Object)sErrorMsg);
                ResponseUtil.json((HttpServletResponse)response, (String)oResult.toString());
                return;
            }
            long lSize = oFileHelper.getSize();
            if (lSize <= 0L) {
                sErrorMsg = LocaleServer.getString("file_upload_dowith.label.noFileFound", "\u672c\u5730\u6587\u4ef6\u4e0d\u5b58\u5728");
                oResult.put("error", (Object)sErrorMsg);
                ResponseUtil.json((HttpServletResponse)response, (String)oResult.toString());
                return;
            }
            long nRestrictSize = 0L;
            if (!CMyString.isEmpty(sysConfigImageSize) && (nRestrictSize = Long.parseLong(sysConfigImageSize)) > 0L && lSize > nRestrictSize * 1024L) {
                Float fImageSizeToM = Float.valueOf(Float.parseFloat(sysConfigImageSize));
                fImageSizeToM = Float.valueOf(fImageSizeToM.floatValue() / 1024.0f);
                fImageSizeToM = Float.valueOf((float)Math.round(fImageSizeToM.floatValue() * 100.0f) / 100.0f);
                sErrorMsg = CMyString.format(LocaleServer.getString("file_upload_dowith.filesize.toolarge1", "\u4e0a\u4f20\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u7cfb\u7edf\u914d\u7f6e\u7684\u6700\u5927\u503c {0}M\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6587\u4ef6\uff01"), new String[]{"" + fImageSizeToM});
                oResult.put("error", (Object)sErrorMsg);
                ResponseUtil.json((HttpServletResponse)response, (String)oResult.toString());
                return;
            }
            timer.stop();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("start write file.....before use[" + timer.getTime() + "]ms"));
            }
            timer.start();
            sSaveFile = aFilesMan.getNextFilePathName("U0", oFileHelper.getFileType());
            oFileHelper.writeTo(new File(sSaveFile));
            timer.stop();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("end write file!before use[" + timer.getTime() + "]ms"));
            }
            timer.start();
            String strShowName = CMyFile.extractFileName(oFileHelper.getFileName(), "/");
            strShowName = CMyFile.extractFileName(strShowName, "\\");
            String sUploadName = CMyFile.extractFileName(sSaveFile);
            File srcFile = new File(sSaveFile);
            if (srcFile.isDirectory() || !srcFile.exists()) {
                logger.error((Object)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01", (Throwable)new Exception("who do this?"));
            }
            oResult.put("success", (Object)"\u4e0a\u4f20\u6210\u529f\uff01");
            oResult.put("imgName", (Object)sUploadName);
            oResult.put("imgSrc", (Object)WCMServiceHelper.getReadImgURL(sUploadName, 600));
            ResponseUtil.json((HttpServletResponse)response, (String)oResult.toString());
            timer.stop();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("End! before use[" + timer.getTime() + "]ms"));
            }
            return;
        }
        catch (Throwable ex) {
            int errorCode = 0;
            if (ex instanceof WCMException) {
                WCMException myEx = (WCMException)ex;
                errorCode = myEx.getErrNo();
            }
            logger.error((Object)"ERROR:", ex);
            oResult.put("error", (Object)("\u4e0a\u4f20\u5931\u8d25\uff0c\u9519\u8bef\u53f7[" + errorCode + "]"));
            ResponseUtil.json((HttpServletResponse)response, (String)oResult.toString());
            return;
        }
    }

    public void init() throws ServletException {
        String sServiceAllowIPs = CMyString.showEmpty(ConfigServer.getServer().getInitProperty("SERVICE_ALLOW_IPS"));
        this.m_pAllowIPPaths = sServiceAllowIPs.split(",");
    }

    public boolean isForbidFileExt(String fileName) {
        String strExt = CMyFile.extractFileExt(fileName).toUpperCase();
        if (CMyString.isEmpty(strExt)) {
            return true;
        }
        String strSuffixConfig = ConfigServer.getServer().getInitProperty("FILE_UPLOAD_SUFFIX_CONFIG");
        if (CMyString.isEmpty(strSuffixConfig)) {
            return true;
        }
        if ("FILE_UPLOAD_ALLOW_SUFFIX".equals(strSuffixConfig)) {
            String strAllowExt = ConfigServer.getServer().getInitProperty(strSuffixConfig);
            if (CMyString.isEmpty(strAllowExt)) {
                return true;
            }
            strAllowExt = strAllowExt.toUpperCase().trim();
            return ("," + strAllowExt + ",").indexOf("," + strExt + ",") < 0;
        }
        if ("FILE_UPLOAD_FORBIDEN_SUFFIX".equals(strSuffixConfig)) {
            String strForbidExt = ConfigServer.getServer().getInitProperty(strSuffixConfig);
            if (CMyString.isEmpty(strForbidExt)) {
                return false;
            }
            strForbidExt = strForbidExt.toUpperCase().trim();
            return ("," + strForbidExt + ",").indexOf("," + strExt + ",") > 0;
        }
        return true;
    }

    private void readImgAndScale(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String sFileName;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"upload....");
        }
        if ((sFileName = request.getParameter("FileName")) == null || sFileName.trim().length() == 0) {
            this.writeError(response, "\u4e0a\u4f20\u5165\u6587\u4ef6\u540d\u4e3a\u7a7a\uff01");
            return;
        }
        int nScaleWidth = 0;
        String sValue = request.getParameter("ScaleWidth");
        if (!CMyString.isEmpty(sValue)) {
            try {
                nScaleWidth = Integer.parseInt(sValue);
            }
            catch (Exception e) {
                this.writeError(response, "ScaleWidth\u4e0d\u662f\u6574\u578b\u6570");
            }
        }
        try {
            FilesMan currFilesMan = FilesMan.getFilesMan();
            String sFileExt = CMyFile.extractFileExt(sFileName);
            String sFilePath = currFilesMan.mapFilePath(sFileName, 0);
            String sSrcAbsolutFileName = sFilePath + sFileName;
            String sNewAbsolutFileName = ImgFileHelperForReadImg.convert(sSrcAbsolutFileName, nScaleWidth);
            String sImageType = sFileExt;
            if (sFileExt.equals("jpe") || sFileExt.equals("jpg")) {
                sImageType = "jpeg";
            }
            String sContentType = "image/" + sImageType;
            ResponseUtil.responseStream((HttpServletResponse)response, (String)sContentType, (File)new File(sNewAbsolutFileName));
            return;
        }
        catch (Exception e) {
            logger.error((Object)"Fail to read img!", (Throwable)e);
            this.writeError(response, "Fail to read img!" + e.getMessage());
            return;
        }
    }

    private void writeError(HttpServletResponse response, String _sError) throws IOException {
        org.json.JSONObject oResult = new org.json.JSONObject();
        oResult.put("error", (Object)_sError);
        ResponseUtil.json((HttpServletResponse)response, (String)oResult.toString());
    }

    private boolean isAllowIPPath(String sAccessIPPath) {
        if (this.m_pAllowIPPaths.length == 0) {
            return false;
        }
        for (int i = 0; i < this.m_pAllowIPPaths.length; ++i) {
            String sAllowIPPath = this.m_pAllowIPPaths[i].trim();
            if (CMyString.isEmpty(sAllowIPPath)) continue;
            boolean bInnerResult = true;
            if (!this.isAllowIP(sAllowIPPath, sAccessIPPath)) {
                bInnerResult = false;
                break;
            }
            if (!bInnerResult) continue;
            return true;
        }
        return false;
    }

    private boolean isAllowIP(String _sStandardAddr, String _sRemoteAddr) {
        String[] pRemoteIPList;
        String[] pAllowIPList;
        if (CMyString.isEmpty(_sStandardAddr)) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("_sStandardAddr:" + _sStandardAddr + ";_sRemoteAddr:" + _sRemoteAddr));
        }
        if ((pAllowIPList = _sStandardAddr.split("\\.")).length != (pRemoteIPList = _sRemoteAddr.split("\\.")).length) {
            return false;
        }
        for (int j = 0; j < pRemoteIPList.length; ++j) {
            if (pAllowIPList[j].equals("*") || pRemoteIPList[j].equals(pAllowIPList[j])) continue;
            return false;
        }
        return true;
    }
}

