/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.BaseContextHelper;
import com.trs.infra.common.ContextParameters;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.log.Log;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.webframework.AbstractLogger;
import com.trs.webframework.ServiceExcuteLogger;
import com.trs.webframework.config.MethodConfig;
import com.trs.webframework.context.MethodContext;
import org.apache.log4j.Logger;

public class DefaultSaveLogger
extends AbstractLogger
implements ServiceExcuteLogger {
    private static final Logger LOG = Logger.getLogger(DefaultSaveLogger.class);
    private static final int LOGDESC_MAX_BYTE_LENGTH = 3000;
    private static final int LOGDESC_MAX_LENGTH = 1500;

    @Override
    public int startLog(MethodConfig _methodConf, MethodContext _methodContext) {
        try {
            String sKlassName = _methodConf.getLogObjClassName();
            if (CMyString.isEmpty(sKlassName)) {
                LOG.warn((Object)"no objklass provide ,execute log fail!");
                return 0;
            }
            Class<?> clazz = Class.forName(sKlassName);
            BaseObj logobj = null;
            boolean zAdd = _methodContext.getObjectId() == 0;
            String sLogDesc = null;
            if (zAdd) {
                logobj = (BaseObj)clazz.newInstance();
                sLogDesc = I18NMessage.get(DefaultSaveLogger.class, "DefaultSaveLogger.label1", "\u65b0\u5efa");
                sLogDesc = sLogDesc + WCMTypes.getObjName(logobj.getWCMType(), true);
            } else {
                logobj = BaseObj.findById(clazz, _methodContext.getObjectId());
                sLogDesc = I18NMessage.get(DefaultSaveLogger.class, "DefaultSaveLogger.label2", "\u4fee\u6539");
                sLogDesc = sLogDesc + logobj;
            }
            return this.log(_methodConf, sLogDesc, logobj);
        }
        catch (Exception e) {
            LOG.error((Object)"execute log fail", (Throwable)e);
            return 0;
        }
    }

    @Override
    public void endLog(int _nLogId) {
        int nId = 0;
        try {
            nId = (Integer)ContextParameters.get(6);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (nId > 0) {
            try {
                Log log = new Log();
                log.loadById(_nLogId, "LOGID,TOPID,STIMEMILLIS,LOGOBJTYPE");
                long endtime = System.currentTimeMillis();
                log.setEndTimeMillis(endtime);
                log.setExecTime(endtime - log.getStartTimeMillis());
                log.setResult(1);
                log.setLogType(3);
                log.setObj(log.getObjType(), nId);
                if (log.getTopLogId() == 0) {
                    BaseContextHelper.setArg(LogServer.CONTEXT_INDEX_TOPID, null);
                }
                log.save();
            }
            catch (Exception ex) {
                LOG.error((Object)"Failed to finish a log", (Throwable)ex);
            }
        } else {
            LogServer.endRecordSucceedOperation(_nLogId);
        }
    }

    @Override
    public void endLogWithFaliure(int _nLogId, Throwable _throwable) {
        int nId = 0;
        try {
            nId = (Integer)ContextParameters.get(6);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (nId > 0) {
            try {
                Log log = Log.findById(_nLogId);
                long endtime = System.currentTimeMillis();
                log.setEndTimeMillis(endtime);
                log.setExecTime(endtime - log.getStartTimeMillis());
                log.setResult(1);
                log.setLogType(3);
                log.setObj(BaseObj.findById(log.getObjType(), nId));
                String sDesc = log.getDesc();
                sDesc = sDesc + "\n" + CMyException.getStackTraceText(_throwable);
                if (sDesc.getBytes().length > 3000) {
                    sDesc = sDesc.substring(0, 1500);
                }
                log.setDesc(sDesc);
                if (log.getTopLogId() == 0) {
                    BaseContextHelper.setArg(LogServer.CONTEXT_INDEX_TOPID, null);
                }
                log.save();
            }
            catch (Exception ex) {
                LOG.error((Object)"Failed to finish a log", (Throwable)ex);
            }
        } else {
            LogServer.endRecordFailedOperation(_nLogId, _throwable);
        }
    }

    @Override
    public String getClassDesc() {
        return "\u7cfb\u7edf\u9ed8\u8ba4\u4fdd\u5b58\u64cd\u4f5c\u65e5\u5fd7\u7c7b";
    }
}

