/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.photo.impl;

import com.trs.DreamFactory;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyFileX;
import com.trs.wcm.photo.IImageLibConfig;
import com.trs.wcm.photo.IMagicImage;
import com.trs.wcm.photo.impl.ImageMagickCmd;

public class JMarkUtilX {
    public static void addWatermark(String filename, String watermarkfile, int[] pos) throws Exception {
        IImageLibConfig imageLibConfig = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
        int[] scalesizes = imageLibConfig.getScaleSizes();
        if (imageLibConfig.isCmdUsed()) {
            ImageMagickCmd.ImageObj src = new ImageMagickCmd.ImageObj(filename);
            FilesMan fileman = FilesMan.getFilesMan();
            ImageMagickCmd.ImageObj watermark = new ImageMagickCmd.ImageObj();
            watermark.setFilename(watermarkfile);
            watermarkfile = fileman.mapFilePath(watermarkfile, 0) + watermarkfile;
            String tempwatermarkfile = fileman.getNextFileName("ST", CMyFile.extractFileExt(watermarkfile), CMyDateTime.now(), true);
            ImageMagickCmd.ImageObj tempwatermark = new ImageMagickCmd.ImageObj(tempwatermarkfile, 0, 0);
            JMarkUtilX.addWatermarkWithCmd(imageLibConfig, scalesizes[scalesizes.length - 1], watermark, tempwatermark, watermarkfile, tempwatermarkfile, src.filename, pos);
        } else {
            IMagicImage magicImage = (IMagicImage)DreamFactory.createObjectById("IMagicImage");
            int nWaterWidth = imageLibConfig.getWaterMarkSize(scalesizes[scalesizes.length - 1]);
            if (nWaterWidth > 0) {
                magicImage.initMagicImage(watermarkfile);
                JMarkUtilX.addWaterMark(filename, magicImage, nWaterWidth, pos);
            }
        }
    }

    public static String addWatermark_new(String filename, String watermarkfile, int[] pos) throws Exception {
        String pic = filename;
        IImageLibConfig imageLibConfig = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
        int[] scalesizes = imageLibConfig.getScaleSizes();
        if (imageLibConfig.isCmdUsed()) {
            ImageMagickCmd.ImageObj src = new ImageMagickCmd.ImageObj(filename);
            FilesMan fileman = FilesMan.getFilesMan();
            ImageMagickCmd.ImageObj watermark = new ImageMagickCmd.ImageObj();
            watermark.setFilename(watermarkfile);
            watermarkfile = fileman.mapFilePath(watermarkfile, 0) + watermarkfile;
            String tempwatermarkfile = fileman.getNextFileName("ST", CMyFile.extractFileExt(watermarkfile), CMyDateTime.now(), true);
            ImageMagickCmd.ImageObj tempwatermark = new ImageMagickCmd.ImageObj(tempwatermarkfile, 0, 0);
            String temp = JMarkUtilX.addWatermarkWithCmd_new(imageLibConfig, scalesizes[scalesizes.length - 1], watermark, tempwatermark, watermarkfile, tempwatermarkfile, src.filename, pos);
            if (temp != null && temp.length() > 0) {
                pic = temp;
            }
        } else {
            IMagicImage magicImage = (IMagicImage)DreamFactory.createObjectById("IMagicImage");
            int nWaterWidth = imageLibConfig.getWaterMarkSize(scalesizes[scalesizes.length - 1]);
            if (nWaterWidth > 0) {
                magicImage.initMagicImage(watermarkfile);
                JMarkUtilX.addWaterMark(filename, magicImage, nWaterWidth, pos);
            }
        }
        return pic;
    }

    private static void addWaterMark(String _sImageFile, IMagicImage _warterMarkImage, int _nWarterWidth, int[] _pWarterMarkPos) throws Exception {
        IMagicImage oSrcMagicImage = (IMagicImage)DreamFactory.createObjectById("IMagicImage");
        oSrcMagicImage.initMagicImage(_sImageFile);
        String sWaterMarkImageFile = _warterMarkImage.getSrcImageFileName();
        int w = (int)_warterMarkImage.getWidth();
        if (w > _nWarterWidth) {
            _warterMarkImage.scaleImage(_nWarterWidth, 0);
            sWaterMarkImageFile = _warterMarkImage.writeImageToSystemTemp();
        }
        oSrcMagicImage.addWaterMark(sWaterMarkImageFile, _pWarterMarkPos);
        String sTempImageFile = oSrcMagicImage.writeImageToSystemTemp();
        oSrcMagicImage.initMagicImage(sTempImageFile);
        CMyFile.moveFile(sTempImageFile, CMyFileX.autoToAbsoluteFilePath(_sImageFile));
    }

    private static void addWatermarkWithCmd(IImageLibConfig conf, int nScaleSize, ImageMagickCmd.ImageObj watermark, ImageMagickCmd.ImageObj tempwatermark, String watermarkfile, String tempwatermarkfile, String fn, int[] arMarkpos) throws Exception {
        int nWatermarkWidth = conf.getWaterMarkSize(nScaleSize);
        if (nWatermarkWidth <= 0) {
            return;
        }
        int w = watermark.width;
        if (w > nWatermarkWidth) {
            int h = watermark.height;
            tempwatermark.width = nWatermarkWidth;
            tempwatermark.height = h * nWatermarkWidth / w <= 10 ? h : 0;
            ImageMagickCmd.scale(watermark, tempwatermark);
            ImageMagickCmd.addWaterkmark(tempwatermarkfile, fn, arMarkpos);
        } else {
            ImageMagickCmd.addWaterkmark(watermarkfile, fn, arMarkpos);
        }
    }

    private static String addWatermarkWithCmd_new(IImageLibConfig conf, int nScaleSize, ImageMagickCmd.ImageObj watermark, ImageMagickCmd.ImageObj tempwatermark, String watermarkfile, String tempwatermarkfile, String fn, int[] arMarkpos) throws Exception {
        String pic = null;
        int nWatermarkWidth = conf.getWaterMarkSize(nScaleSize);
        if (nWatermarkWidth <= 0) {
            return null;
        }
        int w = watermark.width;
        if (w > nWatermarkWidth) {
            int h = watermark.height;
            tempwatermark.width = nWatermarkWidth;
            tempwatermark.height = h * nWatermarkWidth / w <= 10 ? h : 0;
            ImageMagickCmd.scale(watermark, tempwatermark);
            pic = ImageMagickCmd.addWaterkmark_new(tempwatermarkfile, fn, arMarkpos);
        } else {
            ImageMagickCmd.addWaterkmark(watermarkfile, fn, arMarkpos);
        }
        return pic;
    }
}

