/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.photo.impl;

import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import com.trs.wcm.photo.ImageLibConstants;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.jfree.util.Log;

public final class ImageMagickCmd {
    private static Logger logger = Logger.getLogger(ImageMagickCmd.class);
    private static final int SUCCESS = 0;
    private static int NOT_SCALESIZE = -1;
    private static String CONVERT_QUALITY;
    private static String CONVERT_STRIP;
    private static String CMD_CONVERT;
    private static String CMD_COMPOSITE;
    private static String CMD_IDENTIFY;
    private static final String[] GRAVITIES;

    public static void setCmds(Map cmds) {
        String sConvertQuality = (String)cmds.get("CONVERT_QUALITY");
        String sConvertStrip = (String)cmds.get("CONVERT_STRIP");
        CONVERT_QUALITY = CMyString.showEmpty(sConvertQuality, "100");
        CONVERT_STRIP = CMyString.showEmpty(sConvertStrip, "");
        CMD_CONVERT = (String)cmds.get("CMD_CONVERT");
        CMD_COMPOSITE = (String)cmds.get("CMD_COMPOSITE");
        CMD_IDENTIFY = (String)cmds.get("CMD_IDENTIFY");
    }

    public static int scale(ImageObj _originalImage, ImageObj _dstImage) throws Exception {
        File tempFile;
        int nHeight;
        if (_originalImage.filename == _dstImage.filename) {
            return 0;
        }
        String sLocalTmpFilePath = ImageMagickCmd.storeToLocalTmpFile(_originalImage.filename);
        FilesMan fileman = FilesMan.getFilesMan();
        String tmpDoWithcFilePath = fileman.getTmpNextFilePath("jpg");
        int nWidth = _dstImage.width;
        if (nWidth <= 0) {
            nWidth = _originalImage.width * _dstImage.height / _originalImage.height;
        }
        if (nWidth == 0) {
            nWidth = 1;
        }
        if ((nHeight = _dstImage.height) <= 0) {
            nHeight = _originalImage.height * _dstImage.width / _originalImage.width;
        }
        if (nHeight == 0) {
            nHeight = 1;
        }
        String[] cmd = new String[7];
        cmd[0] = CMD_CONVERT;
        cmd[1] = "-scale";
        StringBuffer buff = new StringBuffer(16);
        buff.append(nWidth).append('x').append(nHeight).append('!');
        cmd[2] = buff.toString();
        buff.setLength(0);
        buff = null;
        cmd[3] = "-quality";
        cmd[4] = CONVERT_QUALITY;
        cmd[5] = sLocalTmpFilePath;
        cmd[6] = tmpDoWithcFilePath;
        if (!CMyString.isEmpty(CONVERT_STRIP)) {
            String[] newCmd = new String[8];
            System.arraycopy(cmd, 0, newCmd, 0, 5);
            newCmd[5] = CONVERT_STRIP;
            System.arraycopy(cmd, 5, newCmd, 6, 2);
            cmd = newCmd;
        }
        if (cmd != null) {
            int newCmd = ImageMagickCmd.exec(cmd);
        }
        int result = ImageMagickCmd.exec(cmd);
        ImageMagickCmd.uploadToRemoteFile1(tmpDoWithcFilePath, _dstImage.filename);
        ImageMagickCmd.putDataToLocalPath(tmpDoWithcFilePath, _originalImage.filename);
        File tempFile1 = new File(tmpDoWithcFilePath);
        if (tempFile1.exists()) {
            tempFile1.delete();
        }
        if ((tempFile = new File(sLocalTmpFilePath)).exists()) {
            tempFile.delete();
        }
        return result;
    }

    static int execSimple(String[] cmd) throws Exception {
        Process proc = Runtime.getRuntime().exec(cmd);
        return proc.waitFor();
    }

    public static int addWaterkmark(String watermarkfile, String filename, int[] gravity) throws Exception {
        if (ImageMagickCmd.isSelfDefinePosition(gravity, ImageLibConstants.MARKPOS_SELF_DEFIND)) {
            ImageMagickCmd.addWaterMarkInDefindePosition(watermarkfile, filename, gravity);
        } else {
            ImageMagickCmd.addWaterMarkInPosition(watermarkfile, filename, gravity);
        }
        return 0;
    }

    public static String addWaterkmark_new(String watermarkfile, String filename, int[] gravity) throws Exception {
        String pic = null;
        if (ImageMagickCmd.isSelfDefinePosition(gravity, ImageLibConstants.MARKPOS_SELF_DEFIND)) {
            ImageMagickCmd.addWaterMarkInDefindePosition(watermarkfile, filename, gravity);
        } else {
            pic = ImageMagickCmd.addWaterMarkInPosition_new(watermarkfile, filename, gravity);
        }
        return pic;
    }

    public static String addWaterkmarkWithPosAndAlpha(String watermarkfile, String filename, int[] gravity, int alphaNum) throws Exception {
        return ImageMagickCmd.addWaterMarkWithPositionAndAlpha(watermarkfile, filename, gravity, alphaNum);
    }

    private static void addWaterMarkInDefindePosition(String watermarkfile, String filename, int[] gravity) throws Exception {
        String sLocalTmpFilePathwatermarkfile = ImageMagickCmd.storeToLocalTmpFile(watermarkfile);
        String sLocalTmpFilePathfilename = ImageMagickCmd.storeToLocalTmpFile(filename);
        FilesMan fileman = FilesMan.getFilesMan();
        String _dstfilename = fileman.getNextFileName("ST", CMyFile.extractFileExt(filename));
        String tmpDoWithcFilePath = fileman.getTmpNextPath() + filename;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("watermarkfile:" + watermarkfile));
            logger.debug((Object)("filename:" + filename));
        }
        ImageObj img = new ImageObj(filename);
        img.setFilename(filename);
        Float temp = new Float((float)gravity[2] / (float)gravity[3] * (float)img.width);
        int opX = temp.intValue();
        temp = new Float((float)gravity[1] / (float)gravity[4] * (float)img.height);
        int opY = temp.intValue();
        String[] cmd = new String[8];
        cmd[0] = CMD_COMPOSITE;
        cmd[1] = "-compose";
        cmd[2] = "atop";
        cmd[3] = "-geometry";
        StringBuffer buff = new StringBuffer(16);
        buff.append('+').append(opX).append('+').append(opY);
        cmd[4] = buff.toString();
        buff.setLength(0);
        cmd[5] = sLocalTmpFilePathwatermarkfile;
        cmd[6] = sLocalTmpFilePathfilename;
        cmd[7] = sLocalTmpFilePathfilename;
        ImageMagickCmd.exec(cmd);
        ImageMagickCmd.uploadToRemoteFile(tmpDoWithcFilePath, _dstfilename);
    }

    private static void addWaterMarkInPosition(String watermarkfile, String filename, int[] gravity) throws Exception {
        String sLocalTmpFilePathwatermarkfile = ImageMagickCmd.storeToLocalTmpFile(watermarkfile);
        String sLocalTmpFilePathfilename = ImageMagickCmd.storeToLocalTmpFile(filename);
        FilesMan fileman = FilesMan.getFilesMan();
        String _dstfilename = fileman.getNextFileName("ST", CMyFile.extractFileExt(filename));
        String tmpDoWithcFilePath = fileman.getTmpNextPath() + filename;
        String[] cmd = new String[8];
        cmd[0] = CMD_COMPOSITE;
        cmd[1] = "-compose";
        cmd[2] = "atop";
        cmd[3] = "-gravity";
        cmd[5] = sLocalTmpFilePathwatermarkfile;
        cmd[6] = sLocalTmpFilePathfilename;
        cmd[7] = sLocalTmpFilePathfilename;
        int len = gravity.length;
        for (int i = 0; i < len; ++i) {
            cmd[4] = gravity[i] > 3 ? GRAVITIES[gravity[i] - 2] : GRAVITIES[gravity[i] - 1];
            ImageMagickCmd.exec(cmd);
            ImageMagickCmd.uploadToRemoteFile(tmpDoWithcFilePath, _dstfilename);
        }
    }

    private static String addWaterMarkInPosition_new(String watermarkfile, String filename, int[] gravity) throws Exception {
        String sLocalTmpFilePathwatermarkfile = ImageMagickCmd.storeToLocalTmpFile(watermarkfile);
        String sLocalTmpFilePathfilename = ImageMagickCmd.storeToLocalTmpFile(filename);
        FilesMan fileman = FilesMan.getFilesMan();
        String _dstfilename = fileman.getNextFileName("ST", CMyFile.extractFileExt(filename));
        String tmpDoWithcFilePath = fileman.getTmpNextPath() + filename;
        String pic = _dstfilename;
        String[] cmd = new String[8];
        cmd[0] = CMD_COMPOSITE;
        cmd[1] = "-compose";
        cmd[2] = "atop";
        cmd[3] = "-gravity";
        cmd[5] = sLocalTmpFilePathwatermarkfile;
        cmd[6] = sLocalTmpFilePathfilename;
        cmd[7] = sLocalTmpFilePathfilename;
        int len = gravity.length;
        for (int i = 0; i < len; ++i) {
            cmd[4] = gravity[i] > 3 ? GRAVITIES[gravity[i] - 2] : GRAVITIES[gravity[i] - 1];
            ImageMagickCmd.exec(cmd);
            ImageMagickCmd.uploadToRemoteFile(tmpDoWithcFilePath, _dstfilename);
        }
        return pic;
    }

    private static String addWaterMarkWithPositionAndAlpha(String watermarkfile, String filename, int[] gravity, int alphaNum) throws Exception {
        String sLocalTmpFilePathwatermarkfile = ImageMagickCmd.storeToLocalTmpFile(watermarkfile);
        String sLocalTmpFilePathfilename = ImageMagickCmd.storeToLocalTmpFile(filename);
        FilesMan fileman = FilesMan.getFilesMan();
        String dstfilename = fileman.getNextFileName("ST", CMyFile.extractFileExt(filename));
        String tmpDoWithcFilePath = fileman.getTmpNextPath() + filename;
        String[] cmd = new String[10];
        cmd[0] = CMD_COMPOSITE;
        cmd[1] = "-compose";
        cmd[2] = "atop";
        cmd[3] = "-dissolve";
        cmd[4] = String.valueOf(alphaNum);
        cmd[5] = "-gravity";
        cmd[7] = sLocalTmpFilePathwatermarkfile;
        cmd[8] = sLocalTmpFilePathfilename;
        cmd[9] = sLocalTmpFilePathfilename;
        for (int aGravity : gravity) {
            cmd[6] = aGravity > 3 ? GRAVITIES[aGravity - 2] : GRAVITIES[aGravity - 1];
            ImageMagickCmd.exec(cmd);
            ImageMagickCmd.uploadToRemoteFile(sLocalTmpFilePathfilename, dstfilename);
        }
        return dstfilename;
    }

    private static boolean isSelfDefinePosition(int[] _pPosition, int _nPosition) {
        if (_pPosition == null || _pPosition.length < 5) {
            return false;
        }
        return _pPosition[0] == _nPosition;
    }

    public static void roateImg(ImageObj srcimg, String degree) throws Exception {
        String sLocalTmpFilePath = ImageMagickCmd.storeToLocalTmpFile(srcimg.filename);
        FilesMan fileman = FilesMan.getFilesMan();
        String filename = fileman.getNextFileName("ST", CMyFile.extractFileExt(srcimg.filename));
        String tmpDoWithcFilePath = fileman.getTmpNextPath() + filename;
        String[] cmd = new String[]{CMD_CONVERT, "-rotate", degree, sLocalTmpFilePath, filename};
        ImageMagickCmd.exec(cmd);
        ImageMagickCmd.uploadToRemoteFile(tmpDoWithcFilePath, filename);
        srcimg.setFilename(filename);
    }

    public static void borderImg(ImageObj srcimg, String color, int width, int height) throws Exception {
        String sLocalTmpFilePath = ImageMagickCmd.storeToLocalTmpFile(srcimg.filename);
        FilesMan fileman = FilesMan.getFilesMan();
        String filename = fileman.getNextFileName("ST", CMyFile.extractFileExt(srcimg.filename));
        String tmpDoWithcFilePath = fileman.getTmpNextPath() + filename;
        String[] cmd = new String[7];
        cmd[0] = CMD_CONVERT;
        cmd[1] = "-border";
        StringBuffer buff = new StringBuffer(16);
        buff.append(width).append('x').append(height).append('!');
        cmd[2] = buff.toString();
        cmd[3] = "-bordercolor";
        cmd[4] = color;
        cmd[5] = sLocalTmpFilePath;
        cmd[6] = filename;
        ImageMagickCmd.exec(cmd);
        srcimg.setFilename(filename);
        ImageMagickCmd.uploadToRemoteFile(tmpDoWithcFilePath, filename);
    }

    public static void raiseImg(ImageObj srcimg, int width, int height, boolean zRaised) throws Exception {
        String sLocalTmpFilePath = ImageMagickCmd.storeToLocalTmpFile(srcimg.filename);
        FilesMan fileman = FilesMan.getFilesMan();
        String filename = fileman.getNextFileName("ST", CMyFile.extractFileExt(srcimg.filename));
        String tmpDoWithcFilePath = fileman.getTmpNextPath() + filename;
        String[] cmd = new String[5];
        cmd[1] = zRaised ? "-raise" : "+raise";
        StringBuffer buff = new StringBuffer(16);
        buff.append(width).append('x').append(height).append('!');
        cmd[2] = buff.toString();
        cmd[3] = sLocalTmpFilePath;
        cmd[4] = filename;
        ImageMagickCmd.exec(cmd);
        srcimg.setFilename(filename);
        ImageMagickCmd.uploadToRemoteFile(tmpDoWithcFilePath, filename);
    }

    public static void convertBmp(ImageObj srcimg, String bmp2type) throws Exception {
        String[] cmd;
        String sLocalTmpFilePath = ImageMagickCmd.storeToLocalTmpFile(srcimg.filename);
        FilesMan fileman = FilesMan.getFilesMan();
        String filename = fileman.getNextFileName("ST", CMyFile.extractFileExt(srcimg.filename));
        String tmpDoWithcFilePath = fileman.getTmpNextPath() + filename;
        cmd = new String[]{CMD_CONVERT, sLocalTmpFilePath, cmd[1].substring(0, cmd[1].lastIndexOf(46) + 1) + bmp2type};
        ImageMagickCmd.exec(cmd);
        srcimg.filename = cmd[2];
        ImageMagickCmd.uploadToRemoteFile(tmpDoWithcFilePath, filename);
    }

    public static void crop(ImageObj srcimg, int x, int y, int width, int height) throws Exception {
        String sLocalTmpFilePath = ImageMagickCmd.storeToLocalTmpFile(srcimg.filename);
        FilesMan fileman = FilesMan.getFilesMan();
        String filename = fileman.getNextFileName("ST", CMyFile.extractFileExt(srcimg.filename));
        String tmpDoWithcFilePath = fileman.getTmpNextPath() + filename;
        String[] cmd = new String[]{CMD_CONVERT, sLocalTmpFilePath, "-crop", width + "x" + height + "+" + x + "+" + y, tmpDoWithcFilePath};
        ImageMagickCmd.exec(cmd);
        ImageMagickCmd.uploadToRemoteFile(tmpDoWithcFilePath, filename);
        srcimg.setFilename(filename);
    }

    static int exec(String[] cmd) throws Exception {
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < cmd.length; ++i) {
                sb.append(" " + cmd[i]);
            }
            logger.debug((Object)("CMD\u547d\u4ee4\uff1a " + sb.toString()));
        }
        if (cmd == null) {
            return 0;
        }
        return ImageMagickCmd.exec(cmd, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int exec(String[] cmd, String[] result) throws Exception {
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (cmd == null) {
            return 0;
        }
        Process proc = Runtime.getRuntime().exec(cmd);
        InputStream pis = proc.getInputStream();
        final InputStream per = proc.getErrorStream();
        try {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        int a = 0;
                        while ((a = per.read()) != -1) {
                            baos.write(a);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            t.start();
            int a = 0;
            while ((a = pis.read()) != -1) {
                baos.write(a);
            }
            t.join();
            int exitCode = proc.waitFor();
            String msg = new String(baos.toByteArray());
            if (exitCode != 0) {
                throw new Exception("process fail:" + exitCode + ",msg=" + msg);
            }
            if (result != null && result.length > 0) {
                result[0] = msg.trim();
            }
            int n = 0;
            return n;
        }
        finally {
            if (pis != null) {
                try {
                    pis.close();
                }
                catch (Exception exception) {}
            }
            if (per != null) {
                try {
                    per.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static int[] getImageSize(ImageObj img) throws Exception {
        String sNewFile = ImageMagickCmd.storeToLocalTmpFile(img.filename);
        String[] cmd = new String[]{CMD_IDENTIFY, "-format", "%wx%h", sNewFile};
        String[] holder = new String[1];
        ImageMagickCmd.exec(cmd, holder);
        String[] wh = holder[0].split("x");
        int[] result = new int[]{Integer.parseInt(wh[0]), Integer.parseInt(wh[1])};
        return result;
    }

    public static String scale(String _sSrcFile, String _sDstFile, int scaleLen, boolean scaleWidth) throws Exception {
        if (scaleLen <= 0) {
            throw new Exception("Illeagal options: target scalelen is zero.");
        }
        if (_sSrcFile == _sDstFile) {
            return _sDstFile;
        }
        String sLocalTmpFilePath = ImageMagickCmd.storeToLocalTmpFile(_sSrcFile);
        FilesMan fileman = FilesMan.getFilesMan();
        String tmpDoWithcFilePath = fileman.getTmpNextFilePath("jpg");
        String[] cmd = new String[7];
        cmd[0] = CMD_CONVERT;
        cmd[1] = "-scale";
        StringBuffer buff = new StringBuffer(16);
        ImageObj originalImage = new ImageObj();
        originalImage.setFilename(_sSrcFile);
        boolean enlargePic = false;
        if (scaleWidth || originalImage.width >= originalImage.height) {
            buff.append(scaleLen).append('x');
            enlargePic = scaleLen >= originalImage.width;
        } else {
            enlargePic = scaleLen >= originalImage.height;
            buff.append('x').append(scaleLen);
        }
        if (enlargePic) {
            return _sSrcFile;
        }
        cmd[2] = buff.toString();
        buff.setLength(0);
        buff = null;
        cmd[3] = "-quality";
        cmd[4] = CONVERT_QUALITY;
        cmd[5] = sLocalTmpFilePath;
        cmd[6] = tmpDoWithcFilePath;
        if (!CMyString.isEmpty(CONVERT_STRIP)) {
            String[] newCmd = new String[8];
            System.arraycopy(cmd, 0, newCmd, 0, 5);
            newCmd[5] = CONVERT_STRIP;
            System.arraycopy(cmd, 5, newCmd, 6, 2);
            cmd = newCmd;
        }
        if (ImageMagickCmd.exec(cmd) == 0) {
            ImageMagickCmd.putDataToLocalPath(tmpDoWithcFilePath, _sSrcFile);
            ImageMagickCmd.uploadToRemoteFile1(tmpDoWithcFilePath, _sDstFile);
            return _sDstFile;
        }
        ImageMagickCmd.putDataToLocalPath(tmpDoWithcFilePath, _sSrcFile);
        ImageMagickCmd.uploadToRemoteFile1(tmpDoWithcFilePath, _sDstFile);
        return _sSrcFile;
    }

    protected static String makeFileName(String filename, int scaleLen) {
        int dotIndex = filename.lastIndexOf(46);
        StringBuffer buff = new StringBuffer(filename.length() + String.valueOf(scaleLen).length() + 1);
        buff.append(filename.substring(0, dotIndex));
        buff.append('_');
        buff.append(scaleLen);
        buff.append(filename.substring(dotIndex));
        return buff.toString();
    }

    public static String convert(String _sSrcFile, String _sDstFile, int _nQuality, int _nScaleSizeWidth) throws Exception {
        String sLocalTmpFilePath = ImageMagickCmd.storeToLocalTmpFile(_sSrcFile);
        FilesMan fileman = FilesMan.getFilesMan();
        String tmpDoWithcFilePath = fileman.getTmpNextFilePath("jpg");
        ImageObj originalImage = new ImageObj();
        originalImage.setFilename(_sSrcFile);
        String[] cmd = new String[5];
        if (_nQuality > 0 && _nQuality < 100) {
            cmd[0] = CMD_CONVERT;
            cmd[1] = "-quality";
            cmd[2] = String.valueOf(_nQuality);
            cmd[3] = sLocalTmpFilePath;
            cmd[4] = _sDstFile;
            if (_nScaleSizeWidth > 0 && originalImage.width > _nScaleSizeWidth) {
                String[] newCmd = new String[7];
                System.arraycopy(cmd, 0, newCmd, 0, 1);
                newCmd[1] = "-scale";
                newCmd[2] = _nScaleSizeWidth + "x";
                System.arraycopy(cmd, 1, newCmd, 3, 4);
                cmd = newCmd;
            }
        } else if (_nScaleSizeWidth > 0 && originalImage.width > _nScaleSizeWidth) {
            cmd = new String[]{CMD_CONVERT, "-scale", _nScaleSizeWidth + "x", sLocalTmpFilePath, _sDstFile};
        } else {
            return _sSrcFile;
        }
        if (ImageMagickCmd.exec(cmd) == 0) {
            ImageMagickCmd.putDataToLocalPath(tmpDoWithcFilePath, _sSrcFile);
            ImageMagickCmd.uploadToRemoteFile(tmpDoWithcFilePath, _sDstFile);
            return _sDstFile;
        }
        ImageMagickCmd.putDataToLocalPath(tmpDoWithcFilePath, _sSrcFile);
        ImageMagickCmd.uploadToRemoteFile(tmpDoWithcFilePath, _sDstFile);
        return _sSrcFile;
    }

    public static String convert(String _sSrcFile, String _sDstFile) throws Exception {
        return ImageMagickCmd.convert(_sSrcFile, _sDstFile, Integer.parseInt(CONVERT_QUALITY), NOT_SCALESIZE);
    }

    public static String convertQuality(String _sSrcFile, String _sDstFile, int _nQuality) throws Exception {
        return ImageMagickCmd.convert(_sSrcFile, _sDstFile, _nQuality, NOT_SCALESIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String storeToLocalTmpFile(String sRemoteFilePath) {
        block27: {
            String string;
            OutputStream os = null;
            InputStream is = null;
            try {
                String sFileName = CMyFile.extractFileName(sRemoteFilePath);
                FilesMan fileman = FilesMan.getFilesMan();
                String sParentSrcFilePath = fileman.getTmpNextPath();
                String tmpSrcFilePath = sParentSrcFilePath + sFileName;
                if (CMyFile.fileExists(tmpSrcFilePath)) {
                    String string2 = tmpSrcFilePath;
                    return string2;
                }
                File file = new File(tmpSrcFilePath);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                os = new FileService(tmpSrcFilePath).getOutputStream();
                is = new FileService(sRemoteFilePath).getInputStream();
                byte[] buffer = new byte[1024];
                int len = 0;
                while ((len = is.read(buffer)) != -1) {
                    os.write(buffer, 0, len);
                }
                string = tmpSrcFilePath;
            }
            catch (Exception e) {
                logger.error((Object)"\u4fdd\u5b58\u8fdc\u7a0b\u6587\u4ef6\u5230\u672c\u5730\u5931\u8d25!", (Throwable)e);
                break block27;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void uploadToRemoteFile(String tmpDoWithcFilePath, String _dstFileName) throws WCMException {
        InputStream is = null;
        OutputStream os = null;
        _dstFileName = FilesMan.getFilesMan().mapFilePath(_dstFileName, 0) + _dstFileName;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("tmpDoWithcFilePath:" + tmpDoWithcFilePath));
            logger.debug((Object)("_dstFileName:" + _dstFileName));
        }
        try {
            int len;
            os = new FileService(_dstFileName).getOutputStream();
            is = new FileService(tmpDoWithcFilePath).getInputStream();
            byte[] buffer = new byte[1024];
            while ((len = is.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
        }
        catch (Exception e) {
            Log.error((Object)"\u4e0a\u4f20\u672c\u5730\u6587\u4ef6\u5230\u8fdc\u7a0b\u5931\u8d25!", (Exception)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void uploadToRemoteFile1(String tmpDoWithcFilePath, String _dstFileName) throws WCMException {
        InputStream is = null;
        OutputStream os = null;
        _dstFileName = FilesMan.getFilesMan().mapFilePath(_dstFileName, 0) + _dstFileName.substring(_dstFileName.lastIndexOf(File.separator) + 1);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("tmpDoWithcFilePath:" + tmpDoWithcFilePath));
            logger.debug((Object)("_dstFileName:" + _dstFileName));
        }
        try {
            int len;
            os = new FileService(_dstFileName).getOutputStream();
            is = new FileService(tmpDoWithcFilePath).getInputStream();
            byte[] buffer = new byte[1024];
            while ((len = is.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
        }
        catch (Exception e) {
            Log.error((Object)"\u4e0a\u4f20\u672c\u5730\u6587\u4ef6\u5230\u8fdc\u7a0b\u5931\u8d25!", (Exception)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putDataToLocalPath(String tmpDoWithcFilePath, String fileName) {
        OutputStream os = null;
        InputStream is = null;
        try {
            int len;
            os = new FileService(tmpDoWithcFilePath).getOutputStream();
            is = new FileService(fileName).getInputStream();
            byte[] buffer = new byte[1024];
            while ((len = is.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
        }
        catch (Exception e) {
            Log.error((Object)"\u628a\u6570\u636e\u5199\u5230\u672c\u5730\u8def\u5f84\u4e2d\u5931\u8d25!", (Exception)e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRemoteFileName(String _dstFile) {
        if (_dstFile == null) {
            return null;
        }
        OutputStream os = null;
        InputStream is = null;
        try {
            String tmpDstFilePath;
            FilesMan fileman = FilesMan.getFilesMan();
            if (fileman == null) {
                fileman = FilesMan.getFilesMan();
            }
            if ((tmpDstFilePath = fileman.getTmpNextFilePath("jpg")) != null) {
                os = new FileService(tmpDstFilePath).getOutputStream();
            }
            is = new FileService(_dstFile).getInputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = is.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
            String string = tmpDstFilePath;
            return string;
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6\u8fdc\u7a0b\u6587\u4ef6\u540d\u5b57\u5931\u8d25!", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    static {
        GRAVITIES = new String[]{"northwest", "center", "southeast", "north", "northeast", "west", "east", "southwest", "south"};
    }

    public static class ImageObj {
        public String filename;
        public int width;
        public int height;

        public ImageObj() {
        }

        public ImageObj(String fn) throws WCMException {
            FileService file = new FileService(fn);
            if (!file.exists()) {
                FilesMan fileman = FilesMan.getFilesMan();
                fn = fileman.mapFilePath(fn, 0) + fn;
                file = new FileService(fn);
            }
            this.filename = file.getAbsolutePath();
        }

        public ImageObj(String fn, int width, int heigth) {
            this.filename = fn;
            this.width = width;
            this.height = heigth;
        }

        public void setFilename(String fn) throws Exception {
            FileService file = new FileService(fn);
            if (!file.exists()) {
                FilesMan fileman = FilesMan.getFilesMan();
                fn = fileman.mapFilePath(fn, 0) + fn;
                file = new FileService(fn);
            }
            this.filename = file.getAbsolutePath();
            try {
                int[] wh = ImageMagickCmd.getImageSize(this);
                this.width = wh[0];
                this.height = wh[1];
            }
            catch (Exception ex) {
                logger.debug((Object)"\u5c1d\u8bd5\u4f7f\u7528\u56fe\u7247\u5e93\u83b7\u53d6\u56fe\u7247\u5c3a\u5bf8\u51fa\u73b0\u5f02\u5e38", (Throwable)ex);
                try {
                    BufferedImage img = ImageIO.read(file.getInputStream());
                    this.width = img.getWidth();
                    this.height = img.getHeight();
                }
                catch (Throwable ex2) {
                    logger.debug((Object)"\u5c1d\u8bd5\u4f7f\u7528jdk\u63a5\u53e3\u83b7\u53d6\u56fe\u7247\u5c3a\u5bf8\u51fa\u73b0\u5f02\u5e38", ex2);
                    try {
                        Image img = Toolkit.getDefaultToolkit().getImage(this.filename);
                        Component component = new Component(){};
                        MediaTracker tracker = new MediaTracker(component);
                        tracker.addImage(img, 1);
                        tracker.waitForID(1, 0L);
                        this.width = img.getWidth(null);
                        this.height = img.getHeight(null);
                    }
                    catch (Throwable ex3) {
                        logger.debug((Object)"\u5c1d\u8bd5\u4f7f\u7528MediaTracker\u63a5\u53e3\u5904\u7406\u51fa\u73b0\u5f02\u5e38", ex3);
                        throw new Exception("\u5904\u7406\u56fe\u7247\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u56fe\u7247\u5e93\u662f\u5426\u8bbe\u7f6e\u6b63\u786e\uff0c\u6216\u8005\u5f53\u524djdk\u914d\u7f6e\u6709\u95ee\u9898  \u8bf7\u8fdb\u4e00\u6b65\u901a\u8fc7\u67e5\u770bdebug\u65e5\u5fd7\u6765\u5206\u6790\u9519\u8bef");
                    }
                }
            }
        }

        public String toString() {
            StringBuffer buff = new StringBuffer(64);
            buff.append(this.filename);
            buff.append(":width=").append(this.width);
            buff.append(",height=").append(this.height);
            return buff.toString();
        }
    }
}

