/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.photo;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import com.trs.wcm.photo.IImageLibMgr;
import org.apache.log4j.Logger;

public class DocumentLCLisenterForPhoto
implements IObjectLCListenerOnDel {
    private IImageLibMgr m_libManager = (IImageLibMgr)DreamFactory.createObjectById("IImageLibMgr");
    private static Logger s_logger = Logger.getLogger(DocumentLCLisenterForPhoto.class);

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) {
        if (_oObjDeleted instanceof Document) {
            try {
                Document doc = (Document)_oObjDeleted;
                if (doc.getChannel().getSite().getType() == 1) {
                    boolean bUsed4PhotoSelf = false;
                    int nPhotoDocId = doc.getId();
                    Documents docs = this.m_libManager.getDocumentsQuoteImage(nPhotoDocId);
                    Document tempDoc = null;
                    String sUsedUrl = "";
                    int size = docs.size();
                    for (int i = 0; i < size; ++i) {
                        tempDoc = (Document)docs.getAt(i);
                        if (tempDoc == null) continue;
                        HtmlElementFinder finder = new HtmlElementFinder(tempDoc.getHtmlContent());
                        HtmlElement photo = null;
                        String photourl = null;
                        while ((photo = finder.findNextElement("img")) != null) {
                            if (!"1".equals(photo.getAttributeValue("fromphoto"))) continue;
                            photourl = this.getWebPic(photo.getAttributeValue("src"));
                            if (!photourl.equals("")) {
                                sUsedUrl = sUsedUrl + photourl + ",";
                            }
                            if (photo.getAttributeValue("href") == null) continue;
                            bUsed4PhotoSelf = true;
                        }
                    }
                    String sWhere = "RelatePhotoIds = ? AND APPFLAG = 20";
                    WCMFilter filter = new WCMFilter("WCMAPPENDIX", sWhere, "");
                    filter.addSearchValues(nPhotoDocId);
                    Appendixes appendixs = Appendixes.openWCMObjs(null, filter);
                    Appendix tempAppendix = null;
                    int size2 = appendixs.size();
                    for (int i = 0; i < size2; ++i) {
                        tempAppendix = (Appendix)appendixs.getAt(i);
                        if (tempAppendix == null || tempAppendix.getFile() == null) continue;
                        sUsedUrl = sUsedUrl + tempAppendix.getFile() + ",";
                        tempAppendix.removeProperty("RelatePhotoIds");
                        tempAppendix.save(ContextHelper.getLoginUser());
                    }
                    String pics = doc.getRelateWords();
                    if (!CMyString.isEmpty(pics)) {
                        String[] temp = pics.split(",");
                        FilesMan fileMan = FilesMan.getFilesMan();
                        int len = temp.length;
                        for (int i = 0; i < len; ++i) {
                            if (sUsedUrl.indexOf(temp[i]) >= 0) continue;
                            fileMan.deleteFile(temp[i]);
                        }
                        pics = doc.getAttributeValue("SRCFILE");
                        if (!CMyString.isEmpty(pics) && !bUsed4PhotoSelf) {
                            fileMan.deleteFile(pics);
                        }
                    }
                }
            }
            catch (Exception e) {
                s_logger.warn((Object)"fail to delete the relate files!", (Throwable)e);
            }
        }
    }

    private String getWebPic(String attributeValue) {
        String sResult = "";
        if (attributeValue != null) {
            int nIndex = attributeValue.lastIndexOf(47);
            if (nIndex >= 0) {
                sResult = attributeValue.substring(nIndex + 1);
            } else if (attributeValue.startsWith("W0")) {
                sResult = attributeValue;
            }
        }
        return sResult;
    }
}

