/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.old;

import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMy3WLib;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import com.trs.wcm.old.ImportDocsContext;
import java.sql.Connection;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class ImportDocsFromFile {
    private ImportDocsContext m_oCurrContext = new ImportDocsContext();
    protected static Logger m_oLogger = Logger.getLogger(ImportDocsFromFile.class);
    protected static int s_nTagSize = 7;
    protected static boolean s_bDownloadA = false;
    protected static String[] s_arTagName = new String[s_nTagSize];
    protected static String[] s_arTagSrcName;

    public abstract void importDocs() throws Exception;

    protected Document addNewDocument(Documents _newDocs) {
        return this.addNewDocument(_newDocs, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document addNewDocument(Documents _newDocs, Channel _currChnl) {
        Document newDoc = null;
        Connection currConn = null;
        DBManager dbManger = null;
        try {
            dbManger = DBManager.getDBManager();
            newDoc = (Document)_newDocs.addNew();
            currConn = dbManger.getConnection();
            newDoc.setNextId();
            if (_currChnl != null) {
                newDoc.setChannel(_currChnl);
            }
            newDoc.setType(20);
            newDoc.setReleaseTime(CMyDateTime.now());
            Document document = newDoc;
            dbManger.freeConnection(currConn);
            return document;
        }
        catch (Exception ex) {
            try {
                m_oLogger.error((Object)I18NMessage.get(ImportDocsFromFile.class, "ImportDocsFromFile.label1", "\u7cfb\u7edf\u65b0\u5efa\u6587\u6863\u53d1\u751f\u5f02\u5e38\uff01"), (Throwable)ex);
                this.getCurrContext().addErrorInfo(I18NMessage.get(ImportDocsFromFile.class, "ImportDocsFromFile.label2", "\u7cfb\u7edf\u65b0\u5efa\u6587\u6863\u53d1\u751f\u5f02\u5e38"));
                dbManger.freeConnection(currConn);
            }
            catch (Throwable throwable) {
                dbManger.freeConnection(currConn);
                throw throwable;
            }
        }
        return null;
    }

    protected String dowithHTMLContent(Document _currDoc, String _sHTMLContent) throws Exception {
        String sHtmlContent = _sHTMLContent;
        HtmlElementFinder imgFinder = null;
        HtmlElement element = null;
        class ImgRec {
            public String src;
            public String oldSrc;
            public int oldId = 0;

            ImgRec() {
            }
        }
        Vector<ImgRec> vImgRecs = new Vector<ImgRec>();
        ImgRec imgRec = null;
        FilesMan filesMan = null;
        Appendix appendix = null;
        String sTemp = "";
        boolean nTemp = false;
        try {
            for (int nTagIndex = 0; nTagIndex < s_arTagName.length; ++nTagIndex) {
                String currTagName = s_arTagName[nTagIndex];
                String currTagSrcName = s_arTagSrcName[nTagIndex];
                imgFinder = new HtmlElementFinder(sHtmlContent);
                while ((element = imgFinder.findNextElement(currTagName, true)) != null) {
                    String sDstFile;
                    String sFileName;
                    String sImgSrc;
                    block14: {
                        sImgSrc = element.getAttributeValue(currTagSrcName);
                        if (sImgSrc == null || (sImgSrc = sImgSrc.trim()).length() == 0) {
                            imgFinder.putElement(element);
                            continue;
                        }
                        element.removeAttribute("OLDSRC");
                        element.removeAttribute("OLDID");
                        element.removeAttribute("UploadPic");
                        sFileName = null;
                        boolean bAddAppendix = true;
                        for (int i = 0; i < vImgRecs.size(); ++i) {
                            imgRec = (ImgRec)vImgRecs.get(i);
                            if (sImgSrc.compareToIgnoreCase(imgRec.src) != 0) continue;
                            bAddAppendix = false;
                            element.setAttribute("OLDSRC", imgRec.oldSrc);
                            element.setAttribute("OLDID", String.valueOf(imgRec.oldId));
                            element.setAttribute(currTagSrcName, imgRec.oldSrc);
                            break;
                        }
                        if (!bAddAppendix) {
                            imgFinder.putElement(element);
                            continue;
                        }
                        if (filesMan == null) {
                            filesMan = FilesMan.getFilesMan();
                        }
                        sDstFile = filesMan.getNextFilePathName("W0", ImportDocsFromFile.extractFileExt(sImgSrc));
                        if (sImgSrc.toUpperCase().indexOf("HTTP") >= 0) {
                            try {
                                if (!CMy3WLib.getFile(sImgSrc, sDstFile)) {
                                }
                                break block14;
                            }
                            catch (Exception ex) {}
                            continue;
                        }
                        String sAppFile = this.getCurrContext().getAbsoluteAppFileName(ImportDocsFromFile.extractFileName(sImgSrc));
                        if (sAppFile == null || sAppFile.length() <= 0 || !CMyFile.fileExists(sAppFile)) continue;
                        CMyFile.copyFile(sAppFile, sDstFile);
                    }
                    sFileName = CMyFile.extractFileName(sDstFile);
                    try {
                        appendix = new Appendix();
                        appendix.setDocId(_currDoc.getId());
                        appendix.setFile(sFileName);
                        appendix.setCrUser(User.getSystem());
                        appendix.setFlag(30);
                        appendix.setUsedByVersion(_currDoc.getVersion(), true);
                        appendix.setSrcFile(sImgSrc);
                        appendix.setFileExt(CMyFile.extractFileExt(sFileName));
                        appendix.insert();
                    }
                    catch (Exception ex) {
                        m_oLogger.error((Object)(I18NMessage.get(ImportDocsFromFile.class, "ImportDocsFromFile.label3", "\u6dfb\u52a0\u6587\u6863\u9644\u4ef6\u5931\u8d25\uff08") + this.getClass().getName() + "dowithHTMLContent\uff09"), (Throwable)ex);
                    }
                    element.setAttribute("OLDSRC", sFileName);
                    element.setAttribute("OLDID", String.valueOf(appendix.getId()));
                    imgRec = new ImgRec();
                    imgRec.src = sImgSrc;
                    imgRec.oldSrc = sFileName;
                    imgRec.oldId = appendix.getId();
                    vImgRecs.add(imgRec);
                    element.setAttribute(currTagSrcName, sFileName);
                    imgFinder.putElement(element);
                }
                sHtmlContent = imgFinder.getContent();
            }
        }
        catch (Exception ex) {
            m_oLogger.error((Object)(I18NMessage.get(ImportDocsFromFile.class, "ImportDocsFromFile.label4", "\u5904\u7406HTML\u5185\u5bb9\u5931\u8d25(") + this.getClass().getName() + "dowithHTMLContent)"), (Throwable)ex);
        }
        return sHtmlContent;
    }

    protected static String getBodyHTML(String _sContent) throws WCMException {
        try {
            String sContent = _sContent.toUpperCase();
            int nStartPose = sContent.indexOf("<BODY>");
            if (nStartPose < 0) {
                nStartPose = sContent.indexOf("<BODY ");
                if (nStartPose < 0) {
                    return sContent;
                }
                HtmlElement elBody = new HtmlElement();
                elBody.ONLY_SEARCH_SELF = true;
                nStartPose += elBody.fromString(_sContent.substring(nStartPose));
            }
            if (nStartPose < 0) {
                return _sContent;
            }
            int nEndPose = sContent.lastIndexOf("</BODY>");
            if (nEndPose < 0) {
                return _sContent.substring(nStartPose);
            }
            return _sContent.substring(nStartPose, nEndPose);
        }
        catch (Exception ex) {
            m_oLogger.error((Object)I18NMessage.get(ImportDocsFromFile.class, "ImportDocsFromFile.label5", "\u83b7\u53d6\u6587\u6863Body\u7684HTML\u5185\u5bb9\u53d1\u751f\u5f02\u5e38!"), (Throwable)ex);
            throw new WCMException(1100, I18NMessage.get(ImportDocsFromFile.class, "ImportDocsFromFile.label5", "\u83b7\u53d6\u6587\u6863Body\u7684HTML\u5185\u5bb9\u53d1\u751f\u5f02\u5e38!"), ex);
        }
    }

    protected static String filterHTMLConToPubHTML(String _sHTMLCon) throws WCMException {
        try {
            String sFilterHtml = _sHTMLCon;
            for (int i = 0; i < s_arTagName.length; ++i) {
                HtmlElementFinder currFinder = new HtmlElementFinder(sFilterHtml);
                HtmlElement elTemp = null;
                while ((elTemp = currFinder.findNextElement(s_arTagName[i], true)) != null) {
                    elTemp.removeAttribute("OLDSRC");
                    elTemp.removeAttribute("OLDID");
                    elTemp.removeAttribute("RELATED");
                    elTemp.removeAttribute("UPLOADPIC");
                    currFinder.putElement(elTemp);
                }
                sFilterHtml = currFinder.getContent();
            }
            return sFilterHtml;
        }
        catch (Exception ex) {
            m_oLogger.error((Object)I18NMessage.get(ImportDocsFromFile.class, "ImportDocsFromFile.label6", "\u8fc7\u6ee4HTMLContent\u4e2d\u7684\u7279\u6b8a\u6807\u8bb0\u53d1\u751f\u5f02\u5e38!"), (Throwable)ex);
            throw new WCMException(1100, I18NMessage.get(ImportDocsFromFile.class, "ImportDocsFromFile.label7", "\u8fc7\u6ee4HTMLContent\u4e2d\u7684\u7279\u6b8a\u6807\u8bb0!"), ex);
        }
    }

    public ImportDocsContext getCurrContext() {
        return this.m_oCurrContext;
    }

    public void setCurrContext(ImportDocsContext _currContexxt) {
        this.m_oCurrContext = _currContexxt;
    }

    private static String extractFileName(String _sAbsoluteFileName) {
        int nTemp = _sAbsoluteFileName.lastIndexOf("/");
        if (nTemp >= 0) {
            return _sAbsoluteFileName.substring(nTemp + 1);
        }
        nTemp = _sAbsoluteFileName.lastIndexOf("\\");
        if (nTemp >= 0) {
            return _sAbsoluteFileName.substring(nTemp + 1);
        }
        return _sAbsoluteFileName;
    }

    private static String extractFileExt(String _sAbsoluteFileName) {
        String sFileName = "";
        int nTemp = _sAbsoluteFileName.lastIndexOf("/");
        if (nTemp >= 0) {
            sFileName = _sAbsoluteFileName.substring(nTemp + 1);
        }
        if ((nTemp = _sAbsoluteFileName.lastIndexOf("\\")) >= 0) {
            sFileName = _sAbsoluteFileName.substring(nTemp + 1);
        }
        if ((nTemp = sFileName.lastIndexOf(".")) >= 0) {
            return sFileName.substring(nTemp + 1);
        }
        return "";
    }

    static {
        ImportDocsFromFile.s_arTagName[0] = "BODY";
        ImportDocsFromFile.s_arTagName[1] = "TABLE";
        ImportDocsFromFile.s_arTagName[2] = "TD";
        ImportDocsFromFile.s_arTagName[3] = "IMG";
        ImportDocsFromFile.s_arTagName[4] = "INPUT";
        ImportDocsFromFile.s_arTagName[5] = "LINK";
        ImportDocsFromFile.s_arTagName[6] = "SCRIPT";
        if (s_bDownloadA) {
            ImportDocsFromFile.s_arTagName[ImportDocsFromFile.s_nTagSize - 1] = "A";
        }
        s_arTagSrcName = new String[s_nTagSize];
        ImportDocsFromFile.s_arTagSrcName[0] = "BACKGROUND";
        ImportDocsFromFile.s_arTagSrcName[1] = "BACKGROUND";
        ImportDocsFromFile.s_arTagSrcName[2] = "BACKGROUND";
        ImportDocsFromFile.s_arTagSrcName[3] = "SRC";
        ImportDocsFromFile.s_arTagSrcName[4] = "SRC";
        ImportDocsFromFile.s_arTagSrcName[5] = "HREF";
        ImportDocsFromFile.s_arTagSrcName[6] = "SRC";
        if (s_bDownloadA) {
            ImportDocsFromFile.s_arTagSrcName[ImportDocsFromFile.s_nTagSize - 1] = "HREF";
        }
    }
}

