/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcag2.validator;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyString;
import com.trs.wcag2.HTMLUtil;
import com.trs.wcag2.validator.AbstractValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class EventsValidator
extends AbstractValidator {
    protected String m_sType = "Events";
    protected Object m_oWarning = I18NMessage.get(EventsValidator.class, "EventsValidator.label1", "Events\u5176\u4ed6\u9519\u8bef");
    protected String m_oExample = "";

    @Override
    public Object doValid(String content, HashMap known) {
        HashMap rst = new HashMap();
        ArrayList rst1 = new ArrayList();
        ArrayList rst2 = new ArrayList();
        ArrayList rst3 = new ArrayList();
        this.renderEle(content, rst1, rst2, rst3, "A");
        this.renderEle(content, rst1, rst2, rst3, "B");
        this.renderEle(content, rst1, rst2, rst3, "P");
        this.renderEle(content, rst1, rst2, rst3, "IMG");
        this.renderEle(content, rst1, rst2, rst3, "I");
        this.renderEle(content, rst1, rst2, rst3, "DIV");
        this.renderEle(content, rst1, rst2, rst3, "SPAN");
        this.renderEle(content, rst1, rst2, rst3, "MARQUEE");
        this.renderEle(content, rst1, rst2, rst3, "TD");
        this.renderEle(content, rst1, rst2, rst3, "BUTTON");
        this.renderEle(content, rst1, rst2, rst3, "INPUT");
        this.renderEle(content, rst1, rst2, rst3, "TEXTAREA");
        this.renderEle(content, rst1, rst2, rst3, "SELECT");
        rst.put("fail1", rst1);
        rst.put("fail2", rst2);
        rst.put("fail3", rst3);
        return rst;
    }

    private void renderEle(String content, List rstFail1, List rstFail2, List rstFail3, String eleName) {
        List tags = HTMLUtil.findTagOuterHTML(content, eleName);
        for (int i = 0; i < tags.size(); ++i) {
            int[] pos = (int[])tags.get(i);
            String attrs = HTMLUtil.getEleAttrs(content, pos, eleName);
            HashMap hsAttrs = HTMLUtil.makeHsAttrs(attrs);
            if (!CMyString.isEmpty((String)hsAttrs.get("onmouseover")) && CMyString.isEmpty((String)hsAttrs.get("onfocus"))) {
                this.addToList(content, rstFail1, pos);
                continue;
            }
            if (!CMyString.isEmpty((String)hsAttrs.get("onmouseout")) && CMyString.isEmpty((String)hsAttrs.get("onblur"))) {
                this.addToList(content, rstFail2, pos);
                continue;
            }
            if (CMyString.isEmpty((String)hsAttrs.get("onclick")) || "A".equalsIgnoreCase(eleName) || "BUTTON".equalsIgnoreCase(eleName) || "INPUT".equalsIgnoreCase(eleName) || "TEXTAREA".equalsIgnoreCase(eleName) || "SELECT".equalsIgnoreCase(eleName) || !CMyString.isEmpty((String)hsAttrs.get("tabindex"))) continue;
            this.addToList(content, rstFail3, pos);
        }
    }

    private void addToList(String content, List rstFail, int[] pos) {
        int[] lenPos = HTMLUtil.getPosition(content.substring(0, pos[0]));
        rstFail.add(new String[]{String.valueOf(lenPos[0]), String.valueOf(lenPos[1]), HTMLUtil.getEleOuterHTML(content, pos)});
    }

    @Override
    public Object getWarnObj() {
        return this.m_oWarning;
    }

    @Override
    public String getType() {
        return this.m_sType;
    }

    @Override
    public String getWarning(Object o) {
        if ("fail1".equals(o)) {
            return I18NMessage.get(EventsValidator.class, "EventsValidator.label2", "\u63a7\u4ef6\u6307\u5b9a\u4e86onmouseover\u4e8b\u4ef6\u7684\u884c\u4e3a,\u4f46\u662f\u6ca1\u6709\u4e0e\u4e4b\u76f8\u540c\u884c\u4e3a\u7684onfocus\u4e8b\u4ef6\u76f8\u5bf9\u5e94");
        }
        if ("fail2".equals(o)) {
            return I18NMessage.get(EventsValidator.class, "EventsValidator.label3", "\u63a7\u4ef6\u6307\u5b9a\u4e86onmouseout\u4e8b\u4ef6\u7684\u884c\u4e3a,\u4f46\u662f\u6ca1\u6709\u4e0e\u4e4b\u76f8\u540c\u884c\u4e3a\u7684onblur\u4e8b\u4ef6\u76f8\u5bf9\u5e94");
        }
        if ("fail3".equals(o)) {
            return I18NMessage.get(EventsValidator.class, "EventsValidator.label4", "\u63a7\u4ef6\u6307\u5b9a\u4e86onclick\u4e8b\u4ef6\u7684\u884c\u4e3a,\u4f46\u662f\u8be5\u63a7\u4ef6\u4e0d\u53ef\u9009\u4e2d(focus)");
        }
        return (String)this.m_oWarning;
    }

    @Override
    public Object getExampleObj() {
        return this.m_oExample;
    }

    @Override
    public String getExample(Object o) {
        if ("fail1".equals(o)) {
            return I18NMessage.get(EventsValidator.class, "EventsValidator.label5", "\u4e3a\u63a7\u4ef6\u540c\u65f6\u6307\u5b9aonfocus\u884c\u4e3a\uff0c\u5e76\u4e0eonmouseover\u4e00\u81f4\uff0c\u4f8b\u5982\uff1a<br>") + "<br>&nbsp;&nbsp;&lt;div <span style=\"color:blue\">onmouseover=\"fn1();\" onfocus=\"fn1();\"</span> onmouseout=\"fn2();\" onblur=\"fn2();\"&gt;";
        }
        if ("fail2".equals(o)) {
            return I18NMessage.get(EventsValidator.class, "EventsValidator.label6", "\u4e3a\u63a7\u4ef6\u540c\u65f6\u6307\u5b9aonblur\u884c\u4e3a\uff0c\u5e76\u4e0eonmouseout\u4e00\u81f4\uff0c\u4f8b\u5982\uff1a<br>") + "<br>&nbsp;&nbsp;&lt;div onmouseover=\"fn1();\" onfocus=\"fn1();\" <span style=\"color:blue\">onmouseout=\"fn2();\" onblur=\"fn2();\"</span>&gt;";
        }
        if ("fail3".equals(o)) {
            return I18NMessage.get(EventsValidator.class, "EventsValidator.label7", "\u4f7f\u7528\u53ef\u901a\u8fc7\u952e\u76d8\u5207\u6362\u5230\u7126\u70b9\u7684\u63a7\u4ef6\u66ff\u6362\u8be5\u63a7\u4ef6\uff0c\u4f8b\u5982\uff1a<br>") + "<br>&nbsp;&nbsp;&lt;div onclick=\"fn1();\"&gt;" + I18NMessage.get(EventsValidator.class, "EventsValidator.label8", "<br><br>\u8f6c\u6362\u4e3a<br>") + "<br>&nbsp;&nbsp;&lt;a href=\"#\" onclick=\"fn1();return false;\"&gt;";
        }
        return (String)this.m_oWarning;
    }
}

