/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcag2.validator;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyString;
import com.trs.wcag2.HTMLUtil;
import com.trs.wcag2.validator.AbstractValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class EmbedAltValidator
extends AbstractValidator {
    protected String m_sType = "Objects";
    protected Object m_oWarning = I18NMessage.get(EmbedAltValidator.class, "EmbedAltValidator.label1", "Embed\u8282\u70b9\u6ca1\u6709\u6307\u5b9aalt\u5c5e\u6027");
    protected String m_oExample = I18NMessage.get(EmbedAltValidator.class, "EmbedAltValidator.label2", "\u4e3aEmbed\u8282\u70b9\u6307\u5b9aalt\u5c5e\u6027\uff0c\u4f8b\u5982\uff1a<br>") + "<br>&nbsp;&nbsp;&lt;embed src=\"head.swf\" quality=\"high\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" type=\"application/x-shockwave-flash\" width=\"400\" height=\"100\" <span style=\"color:blue\">alt=\"head.swf\"</span>&gt;&lt;/embed&gt;";

    @Override
    public Object doValid(String content, HashMap known) {
        ArrayList rst = new ArrayList();
        this.renderEle(content, rst, "EMBED");
        return rst;
    }

    private void renderEle(String content, List rstFail, String eleName) {
        List tags = HTMLUtil.findTagOuterHTML(content, eleName);
        for (int i = 0; i < tags.size(); ++i) {
            int[] pos = (int[])tags.get(i);
            String attrs = HTMLUtil.getEleAttrs(content, pos, eleName);
            HashMap hsAttrs = HTMLUtil.makeHsAttrs(attrs);
            if (!CMyString.isEmpty((String)hsAttrs.get("alt"))) continue;
            this.addToList(content, rstFail, pos);
        }
    }

    private void addToList(String content, List rstFail, int[] pos) {
        int[] lenPos = HTMLUtil.getPosition(content.substring(0, pos[0]));
        rstFail.add(new String[]{String.valueOf(lenPos[0]), String.valueOf(lenPos[1]), HTMLUtil.getEleOuterHTML(content, pos)});
    }

    @Override
    public Object getWarnObj() {
        return this.m_oWarning;
    }

    @Override
    public String getType() {
        return this.m_sType;
    }

    @Override
    public Object getExampleObj() {
        return this.m_oExample;
    }
}

