/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class TablesCleaner {
    private static boolean isDebug = false;

    public static void main(String[] args) {
        if (args.length > 6) {
            isDebug = Boolean.valueOf(args[6]);
        }
        Connection cn = TablesCleaner.getConnection(args[0], args[1], args[2], args[3]);
        TablesCleaner.dropTables(cn, args[4]);
        TablesCleaner.dropViews(cn, args[5]);
        TablesCleaner.closeConnection(cn);
    }

    private static void dropTables(Connection cn, String sPattern) {
        TablesCleaner.drop(cn, sPattern, new String[]{"TABLE"}, "drop table ");
    }

    private static void dropViews(Connection cn, String sPattern) {
        TablesCleaner.drop(cn, sPattern, new String[]{"VIEW"}, "drop view ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void drop(Connection cn, String sPattern, String[] sType, String sPrefix) {
        Statement statement = null;
        try {
            statement = cn.createStatement();
            DatabaseMetaData metadata = cn.getMetaData();
            ResultSet resultSet = metadata.getTables(null, null, sPattern, sType);
            while (resultSet.next()) {
                String sSQL = sPrefix + resultSet.getString("TABLE_NAME");
                System.out.println(sSQL);
                statement.addBatch(sSQL);
            }
            if (!isDebug) {
                statement.executeBatch();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    private static Connection getConnection(String sDriverCls, String sUrl, String sUserName, String sPassWord) {
        try {
            Class.forName(sDriverCls);
        }
        catch (ClassNotFoundException e) {
            System.out.println("\u52a0\u8f7d\u9a71\u52a8\u76f8\u5173\u7c7b[" + sDriverCls + "]\u5931\u8d25!");
            e.printStackTrace(System.err);
        }
        try {
            return DriverManager.getConnection(sUrl, sUserName, sPassWord);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    private static void closeConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace(System.err);
            }
        }
    }
}

