/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.infra.util.store.FileStoreFilter;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocaleTools {
    private static Pattern chinesePattern = Pattern.compile("\"([^\"\n\u4e00-\u9fbb]*[\u4e00-\u9fbb]+[^\"\n]*)\"");
    private static String[] aRootPath = new String[]{"E:\\MyWorkspace\\TRS.WCM.V6.1.Std\\SourceCode\\Java\\scene"};
    private static String sRootPrefix = "E:\\MyWorkspace\\TRS.WCM.V6.1.Std\\SourceCode\\Java\\scene";
    private static Pattern findMaxLabelIndexPattern = Pattern.compile("(?m)I18NMessage[\\. \\s]+get\\([^,]+,[^,\\d]+([\\d]+)");
    private static boolean bOnlyFind = true;
    private static String newFileExt = "";
    private static int nCurrLabelIndex = 0;
    private static String sCurrPackageName = null;
    private static String sCurrFileName = null;
    private static List properties = null;
    private static Map mProperties = new HashMap();
    private static BufferedWriter propertiesWriter = null;
    private static Pattern localeServerPattern = Pattern.compile("(?m)I18NMessage[\\. \\s]+get\\([^,]+,\\s*\"([^,\"\\d]+([\\d]+))\"\\s*,\\s*");

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            StringBuffer sbInfo = new StringBuffer(200);
            sbInfo.append("\u6307\u5b9a\u7684\u53c2\u6570\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u4e2a\u53c2\u6570\n");
            sbInfo.append("\u7b2c\u4e00\u4e2a\u53c2\u6570\u6307\u5b9a\u9700\u8981\u5904\u7406\u7684java\u6e90\u7801\u76ee\u5f55\uff1a\n");
            sbInfo.append("\t\t\u5982\uff1a\n");
            sbInfo.append("d:/workspace/TRS.WCM.V6.1/SourceCode/Java/scene/com/trs");
            sbInfo.append("\n\u7b2c\u4e8c\u4e2a\u53c2\u6570\u6307\u5b9a\u662f\u5426\u4fee\u6539java\u6587\u4ef6\uff0c\u503c\u4e3afalse\uff0c\u4fee\u6539\u5f53\u524d\u6b63\u5728\u5206\u6790\u7684\u6e90\u7801\u6587\u4ef6\uff0c\u4e3atrue\u65f6\u4e0d\u4fee\u6539\n");
            sbInfo.append("\n\u7b2c\u4e09\u4e2a\u53c2\u6570\uff0c\u53ef\u9009\uff0c\u6307\u5b9ajava\u6587\u4ef6\u5305\u540d\u63d0\u53d6\u7684\u76ee\u5f55\u524d\u7f00\uff0c\u9ed8\u8ba4\u4e0e\u7b2c\u4e00\u4e2a\u53c2\u6570\u76f8\u540c\uff1a\n");
            sbInfo.append("\t\t\u5982\uff1a\n");
            sbInfo.append("d:/workspace/TRS.WCM.V6.1/SourceCode/Java/scene/");
            System.out.println(sbInfo.toString());
            return;
        }
        LocaleTools.aRootPath[0] = args[0];
        sRootPrefix = args[0];
        if ("true".equals(args[1])) {
            bOnlyFind = true;
        } else if ("false".equals(args[1])) {
            bOnlyFind = false;
        }
        if (args.length > 2) {
            sRootPrefix = args[2];
        }
        LocaleTools.analyzeDir(new FileService(aRootPath[0]));
    }

    private static void analyzeDir(FileStore dir) throws Exception {
        int i;
        if (!dir.exists() || LocaleTools.isExcludeDir(dir.getPath())) {
            return;
        }
        String sPath = dir.getAbsolutePath();
        System.out.println(">>>>>>>>>>>>" + sPath);
        sCurrPackageName = sPath.substring(sRootPrefix.length()).replaceAll("\\\\", ".");
        properties = new ArrayList();
        FileStore[] aFile = dir.listFiles(new FileStoreFilter(){

            @Override
            public boolean accept(FileStore file) {
                return file.isDirectory() || file.getName().endsWith(".java");
            }
        });
        for (i = 0; i < aFile.length; ++i) {
            if (!aFile[i].isFile()) continue;
            LocaleTools.analyzeFile(aFile[i]);
        }
        if (properties.size() > 0) {
            LocaleTools.writeProperties(dir);
        }
        for (i = 0; i < aFile.length; ++i) {
            if (!aFile[i].isDirectory()) continue;
            LocaleTools.analyzeDir(aFile[i]);
        }
    }

    private static boolean isExcludeDir(String sFilePath) {
        return sFilePath.indexOf("/com/trs/util") >= 0 || sFilePath.indexOf("CVS") >= 0 || sFilePath.indexOf("svn") >= 0;
    }

    private static void analyzeFile(FileStore file) throws Exception {
        String sFileName = file.getAbsolutePath();
        System.out.println("^^^^^^^^^^^^^^^^^" + sFileName);
        sCurrFileName = file.getName().replaceFirst("\\.[^\\.]+$", "");
        String sEncoding = CharsetDetector.detect(sFileName);
        String sFileContent = CMyFile.readFile(sFileName, sEncoding);
        StringBuffer sb = new StringBuffer(sFileContent.length());
        nCurrLabelIndex = LocaleTools.getMaxLabelIndex(sFileContent) + 1;
        int nPosIndex = 0;
        Matcher matcher = chinesePattern.matcher(sFileContent);
        while (matcher.find()) {
            int nStart = matcher.start();
            int nEnd = matcher.end();
            String sLastSegment = sFileContent.substring(nPosIndex, nStart);
            sb.append(sLastSegment);
            nPosIndex = nEnd;
            if (LocaleTools.isInComment(sLastSegment) || LocaleTools.isInLocale(sLastSegment, matcher.group(1))) {
                sb.append(matcher.group(0));
                continue;
            }
            String strChinese = matcher.group(1);
            String strChineseKey = sCurrFileName + ":" + strChinese;
            String sLocaleKey = (String)mProperties.get(strChineseKey);
            if (sLocaleKey == null) {
                String sTempIndex = "" + nCurrLabelIndex;
                sLocaleKey = LocaleTools.getLocaleKey();
                properties.add(new String[]{sLocaleKey, strChinese, sTempIndex});
                mProperties.put(strChineseKey, sLocaleKey);
            }
            String strLocale = LocaleTools.getReplaceLocale(sLocaleKey, strChinese);
            sb.append(strLocale);
        }
        if (nPosIndex < sFileContent.length()) {
            sb.append(sFileContent.substring(nPosIndex));
        }
        if (bOnlyFind) {
            return;
        }
        CMyFile.writeFile(sFileName + newFileExt, sb.toString(), sEncoding);
    }

    private static Writer getPropertiesWriter(FileStore file) throws Exception {
        if (propertiesWriter == null) {
            propertiesWriter = new BufferedWriter(new OutputStreamWriter(new FileService(file.getAbsolutePath() + "/i18nmessage.properties").getOutputStream()));
        }
        return propertiesWriter;
    }

    private static void closePropertiesWriter() throws Exception {
        if (propertiesWriter == null) {
            return;
        }
        propertiesWriter.close();
        propertiesWriter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeProperties(FileStore file) throws Exception {
        try {
            Collections.sort(properties, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String[] pair1 = (String[])o1;
                    String[] pair2 = (String[])o2;
                    int result = pair1[0].compareToIgnoreCase(pair1[2]);
                    return result != 0 ? -result : Integer.parseInt(pair1[2]) - Integer.parseInt(pair2[2]);
                }
            });
            Writer writer = LocaleTools.getPropertiesWriter(file);
            writer.write("#" + sCurrPackageName + "\n");
            int length = properties.size();
            for (int i = 0; i < length; ++i) {
                String[] info = (String[])properties.get(i);
                writer.write(info[0]);
                writer.write("=");
                writer.write(info[1]);
                writer.write("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            LocaleTools.closePropertiesWriter();
        }
    }

    private static String getLocaleKey() {
        return sCurrFileName + ".label" + nCurrLabelIndex++;
    }

    private static String getReplaceLocale(String sLocaleKey, String strChinese) {
        return "I18NMessage.get(" + sCurrFileName + ".class, \"" + sLocaleKey + "\", \"" + strChinese + "\")";
    }

    private static boolean isInComment(String sContent) {
        int nEnterStartPos;
        int nCommentStartPos = sContent.lastIndexOf("//");
        if (nCommentStartPos > (nEnterStartPos = sContent.lastIndexOf(10))) {
            return true;
        }
        int nSP1 = sContent.lastIndexOf("/*");
        if (nSP1 < 0) {
            return false;
        }
        int nSP2 = sContent.lastIndexOf("*/");
        return nSP1 > nSP2;
    }

    private static boolean isInLocale(String sContent, String strChinese) {
        int nPos = sContent.lastIndexOf("I18NMessage");
        if (nPos < 0) {
            return false;
        }
        String sTemp = sContent.substring(nPos);
        Matcher matcher = localeServerPattern.matcher(sTemp);
        if (!matcher.find()) {
            return false;
        }
        String strChineseKey = sCurrFileName + ":" + strChinese;
        String sLocaleKey = (String)mProperties.get(strChineseKey);
        String sLabelKey = matcher.group(1);
        if (sLabelKey.equals(sLocaleKey)) {
            return true;
        }
        properties.add(new String[]{sLabelKey, strChinese, matcher.group(2)});
        if (sLocaleKey == null) {
            mProperties.put(strChineseKey, sLabelKey);
        }
        return true;
    }

    private static int getMaxLabelIndex(String sContent) {
        int nMaxLabelIndex = 0;
        Matcher matcher = findMaxLabelIndexPattern.matcher(sContent);
        while (matcher.find()) {
            int nTemp = Integer.parseInt(matcher.group(1));
            if (nMaxLabelIndex >= nTemp) continue;
            nMaxLabelIndex = nTemp;
        }
        return nMaxLabelIndex;
    }
}

