/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class LocaleServerCollector {
    private static Logger logger = Logger.getLogger(LocaleServerCollector.class);
    private static Pattern m_pLocalServer = Pattern.compile("(?)LocaleServer\\.getString\\(\"([^\"]*?)\"\\s*,\\s*\"(.*?)\"\\)");
    private String m_sRootPath;
    private String m_sLocaleOutputFile;
    private Map m_tmpLocaleParams = new HashMap();
    private List list = new ArrayList();
    private Writer m_localePropsWriter = null;

    public LocaleServerCollector(String sRootPath, String sLocaleOutputFile) {
        this.m_sRootPath = new FileService(sRootPath.replace('/', File.separatorChar).replace('\\', File.separatorChar)).getAbsolutePath();
        this.m_sLocaleOutputFile = sLocaleOutputFile.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public void analyze() throws CMyException, IOException {
        this.analyzePath(new FileService(this.m_sRootPath));
        this.writeLocaleOutputFile();
    }

    private void analyzePath(FileStore oPath) throws CMyException, IOException {
        if (oPath.isDirectory()) {
            FileStore[] arrFiles = oPath.listFiles();
            for (int i = 0; i < arrFiles.length; ++i) {
                this.analyzePath(arrFiles[i]);
            }
            return;
        }
        this.analyzeFile(oPath);
    }

    private boolean accept(String sFileName) {
        return sFileName.endsWith(".jsp");
    }

    private void analyzeFile(FileStore oFile) throws CMyException, IOException {
        String sFileName = oFile.getAbsolutePath();
        if (!this.accept(sFileName)) {
            return;
        }
        String sFileEncoding = CharsetDetector.detect(sFileName);
        String sHtml = CMyFile.readFile(sFileName, sFileEncoding);
        this.analyzeContent(sFileName, sHtml);
    }

    private void analyzeContent(String sFileName, String html) throws IOException {
        Matcher oMatcher = m_pLocalServer.matcher(html);
        while (oMatcher.find()) {
            String param = oMatcher.group(1);
            String value = oMatcher.group(2);
            String lastValue = (String)this.m_tmpLocaleParams.get(param);
            if (lastValue != null) {
                if (lastValue.equals(value)) continue;
                logger.warn((Object)(sFileName + "\n\t===>\u91cd\u590d\u4f7f\u7528\u53d8\u91cf:" + param + "\n\t\u65e7\u503c:" + lastValue + "\n\t\u65b0\u503c:" + value + "\n\t"));
                continue;
            }
            this.list.add(new String[]{param, value});
            this.m_tmpLocaleParams.put(param, value);
        }
    }

    private void writeLocaleOutputFile() {
        Collections.sort(this.list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String[] pair1 = (String[])o1;
                String[] pair2 = (String[])o2;
                return pair1[0].compareToIgnoreCase(pair2[0]);
            }
        });
        try {
            Writer writer = this.getLocalePropsWriter();
            int length = this.list.size();
            for (int i = 0; i < length; ++i) {
                String[] pair = (String[])this.list.get(i);
                writer.write(pair[0]);
                writer.write("=");
                writer.write(pair[1]);
                writer.write("\n");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.closeLocalePropsWriter();
            }
            catch (IOException e) {
                logger.error((Object)"\u5173\u95ed\u591a\u8bed\u8a00\u5904\u7406\u6d41\u65f6\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            }
        }
    }

    private Writer getLocalePropsWriter() throws IOException {
        if (this.m_localePropsWriter == null) {
            if (!new FileService(this.m_sLocaleOutputFile).exists()) {
                CMyFile.makeDir(CMyFile.extractFilePath(this.m_sLocaleOutputFile), true);
            }
            OutputStream fileos = new FileService(this.m_sLocaleOutputFile).getOutputStream();
            this.m_localePropsWriter = new OutputStreamWriter(fileos, "GBK");
        }
        return this.m_localePropsWriter;
    }

    private void closeLocalePropsWriter() throws IOException {
        if (this.m_localePropsWriter != null) {
            this.m_localePropsWriter.close();
        }
    }

    public static void main(String[] args) throws CMyException, IOException {
        if (args.length < 2) {
            StringBuffer sbInfo = new StringBuffer(200);
            sbInfo.append("\u6307\u5b9a\u7684\u53c2\u6570\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u9700\u8981\u4e24\u4e2a\u53c2\u6570\n");
            sbInfo.append("\u7b2c\u4e00\u4e2a\u53c2\u6570\u6307\u5b9a\u9700\u8981\u5904\u7406\u7684\u76ee\u5f55\uff1a\n");
            sbInfo.append("\u5982\uff1a\n");
            sbInfo.append("E:/workspace/TRS.WCM.V6.1.Std-1095-EN/SourceCode/WebApp/app/");
            sbInfo.append("\n\u7b2c\u4e8c\u4e2a\u53c2\u6570\u6307\u5b9a\u751f\u6210\u7684\u8d44\u6e90\u6587\u4ef6\u5168\u8def\u5f84\uff1a\n");
            sbInfo.append("\u5982\uff1a\n");
            sbInfo.append("E:/workspace/TRS.WCM.V6.1.Std-1095-EN/SourceCode/Java/configfiles/locale/zh_CN.properties\n");
            logger.error((Object)sbInfo);
            return;
        }
        LocaleServerCollector oInstance = new LocaleServerCollector(args[0], args[1]);
        oInstance.analyze();
    }
}

