/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.infra.util.store.FileStoreFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPIncludeFileFinder {
    private String m_sRootPath;
    private String m_sOutputFileName;
    private Pattern m_IncludeRegExp = Pattern.compile("(?im)<%@ *include.*?file=.*?\".*?([a-zA-Z_0-9]+\\.jsp)\".*?%>");
    private Map m_FileContentMapping = new HashMap();
    private FileStoreFilter jspFileFilter = new FileStoreFilter(){

        @Override
        public boolean accept(FileStore pathname) {
            return pathname.isDirectory() || pathname.getName().endsWith(".jsp");
        }
    };

    public JSPIncludeFileFinder(String sRootPath, String sOutputFileName) {
        this.m_sRootPath = sRootPath;
        this.m_sOutputFileName = sOutputFileName;
    }

    public void analyze() throws CMyException {
        FileService oRootPath = new FileService(this.m_sRootPath);
        StringBuffer sbResult = new StringBuffer(1000);
        this.analyzeFolder(oRootPath, oRootPath, sbResult);
        if (sbResult.length() > 0) {
            CMyFile.writeFile(this.m_sOutputFileName, sbResult.toString());
        }
    }

    private void analyzeFolder(FileStore oRootPath, FileStore oCurrPath, StringBuffer sbResult) throws CMyException {
        FileStore[] oFiles = oCurrPath.listFiles(this.jspFileFilter);
        for (int i = 0; i < oFiles.length; ++i) {
            if (oFiles[i].isDirectory()) {
                this.analyzeFolder(oRootPath, oFiles[i], sbResult);
                continue;
            }
            System.out.println("\u5f00\u59cb\u5206\u6790\u6587\u4ef6[" + oFiles[i].getAbsolutePath() + "]");
            if (!this.isIncludInFolder(oRootPath, oFiles[i])) continue;
            sbResult.append(oFiles[i].getName()).append("\n");
            System.out.println(oFiles[i].getName());
        }
    }

    private boolean isIncludInFolder(FileStore oFolder, FileStore oFile) throws CMyException {
        FileStore[] oFiles = oFolder.listFiles(this.jspFileFilter);
        for (int i = 0; i < oFiles.length; ++i) {
            if (!(oFiles[i].isDirectory() ? this.isIncludInFolder(oFiles[i], oFile) : this.isIncludeInFile(oFiles[i], oFile))) continue;
            return true;
        }
        return false;
    }

    public List getIncludeFiles(String sFileName) throws CMyException {
        ArrayList<String> includeFiles = (ArrayList<String>)this.m_FileContentMapping.get(sFileName);
        if (includeFiles != null) {
            return includeFiles;
        }
        includeFiles = new ArrayList<String>();
        String sEncoding = CharsetDetector.detect(sFileName);
        String sContent = CMyFile.readFile(sFileName, sEncoding);
        Matcher matcher = this.m_IncludeRegExp.matcher(sContent);
        while (matcher.find()) {
            includeFiles.add(matcher.group(1));
        }
        this.m_FileContentMapping.put(sFileName, includeFiles);
        return includeFiles;
    }

    private boolean isIncludeInFile(FileStore oFile1, FileStore oFile2) throws CMyException {
        String sFileName = oFile1.getAbsolutePath();
        List jspIncludeFiles = this.getIncludeFiles(sFileName);
        String sFileName2 = oFile2.getName();
        int length = jspIncludeFiles.size();
        for (int i = 0; i < length; ++i) {
            if (!sFileName2.equals(jspIncludeFiles.get(i))) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws CMyException {
        if (args.length < 2) {
            System.out.println("\u9700\u8981\u6307\u5b9a\u4e24\u4e2a\u53c2\u6570\uff0c\u8bf7\u53c2\u8003main\u65b9\u6cd5\u6ce8\u91ca");
            return;
        }
        JSPIncludeFileFinder instance = new JSPIncludeFileFinder(args[0], args[1]);
        instance.analyze();
    }
}

