/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.components.infoview.InfoViewConfig;
import com.trs.components.infoview.InfoViewMgr;
import com.trs.components.infoview.config.BindingBean;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import com.trs.service.IInfoViewInitor;
import com.trs.service.IInfoViewInitorValue;
import com.trs.service.InfoViewContext;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class InfoViewInitorImpl
implements IInfoViewInitor {
    private InfoViewMgr m_oInfoViewMgr = (InfoViewMgr)DreamFactory.createObjectById("InfoViewMgr");
    private InfoViewConfig m_oInfoViewConfig = this.m_oInfoViewMgr.getInfoViewConfig();

    @Override
    public Object init(InfoViewContext _oContext) throws WCMException {
        List lstBinding = this.m_oInfoViewConfig.getInfoviewBindings();
        String sRetValue = "{";
        boolean bFirst = true;
        for (BindingBean oBean : lstBinding) {
            String sValue;
            String sClassName = oBean.getClassname();
            if (sClassName != null) {
                try {
                    Class<?> oClass = Class.forName(sClassName);
                    IInfoViewInitorValue oInitorClass = (IInfoViewInitorValue)oClass.newInstance();
                    sValue = (String)oInitorClass.getFieldValue(_oContext, oBean);
                }
                catch (Exception ex) {
                    throw new WCMException(I18NMessage.get(InfoViewInitorImpl.class, "InfoViewInitorImpl.label1", "\u65e0\u6cd5\u627e\u5230\u7c7b[") + sClassName + I18NMessage.get(InfoViewInitorImpl.class, "InfoViewInitorImpl.label2", "],\u6216\u8005\u6b64\u7c7b\u4e0d\u662f\u63a5\u53e3[IInfoViewInitor]\u7684\u5b9e\u73b0\u7c7b"));
                }
            } else {
                sValue = (String)this.getFieldValue(_oContext, oBean);
            }
            if (sValue == null || sValue == "") continue;
            if (!bFirst) {
                sRetValue = sRetValue + ",\n";
            }
            sRetValue = sRetValue + CMyString.filterForJs(oBean.getName()) + ":\"" + CMyString.filterForJs(sValue) + "\"";
            bFirst = false;
        }
        sRetValue = sRetValue + "}";
        return sRetValue;
    }

    public Object getFieldValue(InfoViewContext _oContext, BindingBean _oBean) throws WCMException {
        String sBeanName = _oBean.getName();
        if ("UserName".equalsIgnoreCase(sBeanName)) {
            User oUser = _oContext.getUser();
            if (oUser != null) {
                return oUser.getName();
            }
        } else {
            if ("ChannelName".equalsIgnoreCase(sBeanName)) {
                return _oContext.getChannel().getName();
            }
            if ("GroupName".equalsIgnoreCase(sBeanName)) {
                Groups groups;
                User oUser = _oContext.getUser();
                if (oUser != null && (groups = oUser.getGroups()) != null && groups.size() > 0) {
                    return ((Group)groups.getAt(0)).getName();
                }
            } else {
                if ("CurrDate".equalsIgnoreCase(sBeanName)) {
                    String sFormat = CMyString.showNull(_oBean.getFormat(), "yyyy-MM-dd");
                    Date oCurrDate = new Date();
                    SimpleDateFormat oSimpleDateFormat = new SimpleDateFormat(sFormat);
                    return oSimpleDateFormat.format(oCurrDate);
                }
                if ("CurrTime".equalsIgnoreCase(sBeanName)) {
                    String sFormat = CMyString.showNull(_oBean.getFormat(), "yyyy-MM-dd HH:mm:ss");
                    Date oCurrTime = new Date();
                    SimpleDateFormat oSimpleDateFormat = new SimpleDateFormat(sFormat);
                    return oSimpleDateFormat.format(oCurrTime);
                }
            }
        }
        return null;
    }
}

