/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMProcessServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.infoview.InfoViewDataHelper;
import com.trs.components.infoview.InfoViewMgr;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.infoview.persistent.InfoViewData;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.resource.Statuses;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.XmlDocWithDom4j;
import com.trs.infra.util.store.FileService;
import com.trs.service.IInfoViewService;
import com.trs.service.ISecurityService;
import com.trs.service.ServiceHelper;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class InfoViewDocImportService {
    private static Logger logger = Logger.getLogger(InfoViewDocImportService.class);
    private String m_sSelectFields = null;
    DocumentMgr m_oDocumentMgr = null;
    private static int m_nNewDocStatus = -1;

    public DocumentMgr getDocumentMgr() {
        if (this.m_oDocumentMgr == null) {
            this.m_oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        }
        return this.m_oDocumentMgr;
    }

    public void checkSysInfos(String _sChannelId, String _sInfoViewId) throws Exception {
        ContextHelper.initContext(User.getSystem());
        int nChannelId = 0;
        int nInfoViewId = 0;
        try {
            nChannelId = Integer.parseInt(_sChannelId);
            nInfoViewId = Integer.parseInt(_sInfoViewId);
        }
        catch (NumberFormatException e) {
            String msg = I18NMessage.get(InfoViewDocImportService.class, "InfoViewDocImportService.label1", "\u65e0\u6548\u7684\u53c2\u6570[ChannelId=") + _sChannelId + ",InfoViewId=" + _sInfoViewId + "]!";
            throw new WCMException(10, msg, e);
        }
        Channel channel = Channel.findById(nChannelId);
        if (channel == null || channel.isDeleted()) {
            throw new WCMException(200006, I18NMessage.get(InfoViewDocImportService.class, "InfoViewDocImportService.label2", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u9891\u9053/\u9891\u9053\u5df2\u88ab\u5220\u9664!"));
        }
        InfoView infoView = InfoView.findById(nInfoViewId);
        if (infoView == null) {
            throw new WCMException(200006, I18NMessage.get(InfoViewDocImportService.class, "InfoViewDocImportService.label3", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u8868\u5355/\u8868\u5355\u5df2\u88ab\u5220\u9664!"));
        }
        IInfoViewService oInfoViewService = ServiceHelper.createInfoViewService();
        List employedList = oInfoViewService.getEmployedInfoViews(channel);
        if (employedList == null || employedList.size() == 0) {
            throw new WCMException(1100, I18NMessage.get(InfoViewDocImportService.class, "InfoViewDocImportService.label4", "\u6307\u5b9a\u7684\u9891\u9053\u6ca1\u6709\u6307\u5b9a\u6709\u6548\u7684\u8868\u5355!"));
        }
        InfoView employed = (InfoView)employedList.get(0);
        if (employed == null || employed.getId() != nInfoViewId) {
            throw new WCMException(1100, I18NMessage.get(InfoViewDocImportService.class, "InfoViewDocImportService.label5", "\u6307\u5b9a\u7684\u9891\u9053\u4e0e\u8868\u5355\u4e0d\u5339\u914d!"));
        }
    }

    public String retriveChannelInfo(String siteId, String channelName, String infoViewId) throws Exception {
        ContextHelper.initContext(User.getSystem());
        int nSiteId = 0;
        int nInfoViewId = 0;
        try {
            nSiteId = Integer.parseInt(siteId);
            nInfoViewId = Integer.parseInt(infoViewId);
        }
        catch (NumberFormatException e) {
            String msg = I18NMessage.get(InfoViewDocImportService.class, "InfoViewDocImportService.label6", "\u65e0\u6548\u7684\u53c2\u6570[SiteId=") + siteId + ",InfoViewId=" + infoViewId + "]!";
            throw new WCMException(10, msg, e);
        }
        Channel channel = Channel.findByName(nSiteId, channelName);
        if (channel == null || channel.isDeleted()) {
            throw new WCMException(200006, I18NMessage.get(InfoViewDocImportService.class, "InfoViewDocImportService.label2", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u9891\u9053/\u9891\u9053\u5df2\u88ab\u5220\u9664!"));
        }
        InfoView infoView = InfoView.findById(nInfoViewId);
        if (infoView == null) {
            throw new WCMException(200006, I18NMessage.get(InfoViewDocImportService.class, "InfoViewDocImportService.label3", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u8868\u5355/\u8868\u5355\u5df2\u88ab\u5220\u9664!"));
        }
        IInfoViewService oInfoViewService = ServiceHelper.createInfoViewService();
        List employedList = oInfoViewService.getEmployedInfoViews(channel);
        if (employedList == null || employedList.size() == 0) {
            throw new WCMException(1100, I18NMessage.get(InfoViewDocImportService.class, "InfoViewDocImportService.label4", "\u6307\u5b9a\u7684\u9891\u9053\u6ca1\u6709\u6307\u5b9a\u6709\u6548\u7684\u8868\u5355!"));
        }
        InfoView employed = (InfoView)employedList.get(0);
        if (employed == null || employed.getId() != nInfoViewId) {
            throw new WCMException(1100, I18NMessage.get(InfoViewDocImportService.class, "InfoViewDocImportService.label5", "\u6307\u5b9a\u7684\u9891\u9053\u4e0e\u8868\u5355\u4e0d\u5339\u914d!"));
        }
        return String.valueOf(channel.getId());
    }

    public String importInfoViewData(byte[] _importData, byte[] _signData, String _sChannelId, String _sInfoViewId) throws Exception {
        return this.importInfoViewData(_importData, _signData, _sChannelId, _sInfoViewId, "0", null, null);
    }

    public String importInfoViewData(byte[] _importData, byte[] _signData, String _sChannelId, String _sInfoViewId, String _nDocumentId, String _sPostUser, String _sAttributeStr) throws Exception {
        ISecurityService service = (ISecurityService)DreamFactory.createObjectById("ISecurityService");
        boolean zVerify = false;
        try {
            zVerify = service.verify("InfogateKey", _importData, _signData);
        }
        catch (Exception e) {
            throw new WCMException(1100, I18NMessage.get(InfoViewDocImportService.class, "InfoViewDocImportService.label7", "\u9a8c\u8bc1\u6570\u636e\u6709\u6548\u6027\u5931\u8d25!"), e);
        }
        if (!zVerify) {
            throw new WCMException(1100, I18NMessage.get(InfoViewDocImportService.class, "InfoViewDocImportService.label8", "\u65e0\u6548\u6570\u636e,\u7b7e\u540d\u6709\u8bef!"));
        }
        String file = this.writeFile(_importData, "zip");
        int nChannelId = Integer.parseInt(_sChannelId);
        int nInfoViewId = Integer.parseInt(_sInfoViewId);
        int nDocumentId = 0;
        if (!CMyString.isEmpty(_nDocumentId)) {
            nDocumentId = Integer.parseInt(_nDocumentId);
        }
        return this.importData(file, nChannelId, nInfoViewId, nDocumentId, _sPostUser, _sAttributeStr);
    }

    public String importDataForCustomZip(String _sZipFile, String _nChannelId, String _nInfoViewId, String _nDocumentId, String _sPostUser, String _sAttributeStr) throws WCMException {
        int channelId = Integer.parseInt(_nChannelId);
        int infoviewId = Integer.parseInt(_nInfoViewId);
        int documentId = Integer.parseInt(_nDocumentId);
        return this.importData(_sZipFile, channelId, infoviewId, documentId, _sPostUser, _sAttributeStr);
    }

    public String importInfoViewDataForCustom(Document xmlDoc, String _sChannelId, String _sInfoViewId, String _sPostUser, Map _hMap) throws Exception {
        int nChannelId = Integer.parseInt(_sChannelId);
        int nInfoViewId = Integer.parseInt(_sInfoViewId);
        return this.importDataForCustom(xmlDoc, nChannelId, nInfoViewId, _sPostUser, _hMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeFile(byte[] _pFileContent, String _sFileExt) throws Exception {
        OutputStream fos = null;
        try {
            String sFileName = FilesMan.getFilesMan().getNextFilePathName("U0", _sFileExt);
            fos = new FileService(sFileName).getOutputStream();
            fos.write(_pFileContent);
            String string = sFileName;
            return string;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String importData(String _sZipFile, int _nChannelId, int _nInfoViewId, int _nDocumentId, String _sPostUser, String _sAttributeStr) throws WCMException {
        ContextHelper.initContext(User.getSystem());
        String unzipPath = CMyFile.extractFilePath(_sZipFile) + "unzipiv" + System.currentTimeMillis() + File.separator;
        CMyUnZipFile unzipFile = new CMyUnZipFile(_sZipFile, unzipPath);
        unzipFile.addFileExtFilters("ivx");
        try {
            unzipFile.doUnZipAnd();
        }
        catch (CMyException e) {
            throw new WCMException(50, "Failed to unzip the file!", e);
        }
        finally {
            CMyFile.deleteFile(_sZipFile);
        }
        try {
            List linkapdNodes;
            List linkapds;
            List picapdNodes;
            List picapds;
            String dataFile = this.getDataFile(unzipFile);
            Document xmlDoc = null;
            try {
                xmlDoc = XmlDocWithDom4j.parse(dataFile);
                xmlDoc.setXMLEncoding("utf-8");
            }
            catch (Exception e) {
                throw new WCMException(150, "Failed to parse xml file", e);
            }
            Hashtable mapFiles = unzipFile.getAllFileNameIndex();
            ArrayList appendixes = new ArrayList();
            List fileapdNodes = xmlDoc.selectNodes("//@trs_is_inline_file");
            List fileapds = this.processAppendix(mapFiles, fileapdNodes, 10);
            if (fileapds != null) {
                appendixes.addAll(fileapds);
            }
            if ((picapds = this.processAppendix(mapFiles, picapdNodes = xmlDoc.selectNodes("//@trs_is_inline_image"), 20)) != null) {
                appendixes.addAll(picapds);
            }
            if ((linkapds = this.processLink(linkapdNodes = xmlDoc.selectNodes("//@trs_is_linked_image"))) != null) {
                appendixes.addAll(linkapds);
            }
            IInfoViewService service = ServiceHelper.createInfoViewService();
            InfoView infoView = InfoView.findById(_nInfoViewId);
            com.trs.components.wcm.content.persistent.Document document = null;
            if (_nDocumentId == 0) {
                document = new com.trs.components.wcm.content.persistent.Document();
                document.setType(10);
                document.setChannel(_nChannelId);
                document.setFlag(_nInfoViewId);
                document.setStatus(InfoViewDocImportService.getImportDocStatus());
                if (!CMyString.isEmpty(_sPostUser)) {
                    document.setProperty("PostUser", _sPostUser);
                }
                if (!CMyString.isEmpty(_sAttributeStr)) {
                    document.setAttribute(_sAttributeStr);
                }
            } else {
                document = com.trs.components.wcm.content.persistent.Document.findById(_nDocumentId);
            }
            String title = service.getDocumentTitle(infoView, xmlDoc, _sPostUser);
            document.setTitle(title);
            document.setContent(xmlDoc.asXML());
            InfoViewMgr manager = (InfoViewMgr)DreamFactory.createObjectById("InfoViewMgr");
            String randomSerial = manager.getRandomSerial();
            document.setAttribute("RandomSerial", randomSerial);
            document.setRandomSerial(randomSerial);
            String[] pwd = manager.getPublicPassword();
            if (pwd.length == 2) {
                document.setProperty(pwd[0], pwd[1]);
            }
            ContextHelper.initContext(User.getSystem());
            this.getDocumentMgr().save(document);
            if (_nDocumentId == 0) {
                WCMProcessServiceHelper.startDocumentInFlow(ContextHelper.getLoginUser(), document, true);
            }
            Appendix appendix = null;
            for (int i = 0; i < appendixes.size(); ++i) {
                appendix = (Appendix)appendixes.get(i);
                appendix.setDocId(document.getId());
                appendix.setProperty("APPSERN", i);
                appendix.setUsedByVersion(document.getVersion(), true);
                appendix.insert();
            }
            StringBuffer result = new StringBuffer(64);
            result.append("<infoviewresult>");
            result.append("<randomserial>");
            result.append(document.getRandomSerial());
            result.append("</randomserial>");
            result.append("<infoviewid>");
            result.append(_nInfoViewId);
            result.append("</infoviewid>");
            InfoViewData viewData = InfoViewData.findById2(_nInfoViewId, document.getId());
            int nInfoviewDataId = viewData.getPropertyAsInt(viewData.getIdFieldName(), 0);
            result.append("<infoviewdataid>");
            result.append(nInfoviewDataId);
            result.append("</infoviewdataid>");
            String sSelectFields = this.getSelectFields();
            if (!CMyString.isEmpty(sSelectFields)) {
                String[] sFieldsArr = sSelectFields.split(",");
                for (int i = 0; i < sFieldsArr.length; ++i) {
                    result.append("<" + sFieldsArr[i] + ">");
                    result.append(InfoViewDataHelper.getFieldValue(document, sFieldsArr[i]));
                    result.append("</" + sFieldsArr[i] + ">");
                }
            }
            if (pwd.length == 2) {
                result.append("<publicpassword>");
                result.append(pwd[1]);
                result.append("</publicpassword>");
            }
            result.append("</infoviewresult>");
            String string = result.toString();
            return string;
        }
        finally {
            block28: {
                try {
                    CMyFile.deleteDir(unzipPath);
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block28;
                    logger.warn((Object)(I18NMessage.get(InfoViewDocImportService.class, "InfoViewDocImportService.label9", "\u65e0\u6cd5\u5220\u9664\u8868\u5355\u63d0\u4ea4\u8fc7\u7a0b\u4e2d\u7684\u89e3\u538b\u7684\u4e34\u65f6\u6587\u4ef6\u76ee\u5f55[") + unzipPath + I18NMessage.get(InfoViewDocImportService.class, "InfoViewDocImportService.label10", "]\uff0c\u60a8\u53ef\u4ee5\u624b\u52a8\u5c06\u5176\u5220\u9664\uff01")));
                }
            }
        }
    }

    private String importDataForCustom(Document xmlDoc, int _nChannelId, int _nInfoViewId, String _sPostUser, Map _hMap) throws WCMException {
        ContextHelper.initContext(User.getSystem());
        xmlDoc.setXMLEncoding("utf-8");
        IInfoViewService service = ServiceHelper.createInfoViewService();
        InfoView infoView = InfoView.findById(_nInfoViewId);
        com.trs.components.wcm.content.persistent.Document newDoc = null;
        Integer sDocumentId = (Integer)_hMap.get("DOCUMENTID");
        if (sDocumentId != null && sDocumentId > 0) {
            int nDocId = sDocumentId;
            newDoc = com.trs.components.wcm.content.persistent.Document.findById(nDocId);
            if (newDoc == null) {
                throw new WCMException("\u65e0\u6cd5\u627e\u5230ID\u4e3a\u3010" + newDoc + "\u3011\u7684\u6587\u6863\uff0c\u4fee\u6539\u6587\u6863\u5931\u8d25\uff01");
            }
            String title = service.getDocumentTitle(infoView, xmlDoc);
            newDoc.setTitle(title);
            newDoc.setContent(xmlDoc.asXML());
            this.getDocumentMgr().save(newDoc);
            return nDocId + "";
        }
        newDoc = new com.trs.components.wcm.content.persistent.Document();
        newDoc.setType(10);
        newDoc.setChannel(_nChannelId);
        newDoc.setFlag(_nInfoViewId);
        newDoc.setStatus(InfoViewDocImportService.getImportDocStatus());
        if (!CMyString.isEmpty(_sPostUser)) {
            newDoc.setProperty("PostUser", _sPostUser);
        }
        if (!CMyString.isEmpty((String)_hMap.get("CRUSER"))) {
            newDoc.setCrUser((String)_hMap.get("CRUSER"));
        }
        if (!CMyString.isEmpty((String)_hMap.get("CRTIME"))) {
            newDoc.setPropertyWithString("CrTime", (String)_hMap.get("CRTIME"));
        }
        if (!CMyString.isEmpty((String)_hMap.get("DOCRELTIME"))) {
            newDoc.setPropertyWithString("docreltime", (String)_hMap.get("DOCRELTIME"));
        }
        String title = service.getDocumentTitle(infoView, xmlDoc);
        newDoc.setTitle(title);
        newDoc.setContent(xmlDoc.asXML());
        String randomSerial = "";
        InfoViewMgr manager = (InfoViewMgr)DreamFactory.createObjectById("InfoViewMgr");
        randomSerial = !CMyString.isEmpty((String)_hMap.get("RANDOMSERIAL")) ? (String)_hMap.get("RANDOMSERIAL") : manager.getRandomSerial();
        newDoc.setAttribute("RandomSerial", randomSerial);
        newDoc.setRandomSerial(randomSerial);
        String[] pwd = manager.getPublicPassword();
        if (pwd.length == 2) {
            newDoc.setProperty(pwd[0], pwd[1]);
        }
        this.getDocumentMgr().save(newDoc);
        WCMProcessServiceHelper.startDocumentInFlow(ContextHelper.getLoginUser(), newDoc, true);
        StringBuffer result = new StringBuffer(64);
        result.append("<infoviewresult>");
        result.append("<randomserial>");
        result.append(newDoc.getRandomSerial());
        result.append("</randomserial>");
        if (pwd.length == 2) {
            result.append("<publicpassword>");
            result.append(pwd[1]);
            result.append("</publicpassword>");
        }
        result.append("</infoviewresult>");
        return result.toString();
    }

    private static int getImportDocStatus() throws WCMException {
        if (m_nNewDocStatus <= 0) {
            int nNewDocStatus = 1;
            ConfigServer oConfigServer = ConfigServer.getServer();
            String sStatusName = oConfigServer.getSysConfigValue("INFOGATE_IMPORT_DOCSTATUS", "");
            if (!CMyString.isEmpty(sStatusName)) {
                Statuses oStatuses = Statuses.createNewInstance(null);
                WCMFilter filter = new WCMFilter("", "SDISP=?", "");
                filter.addSearchValues(0, sStatusName);
                oStatuses.open(filter);
                if (oStatuses != null && oStatuses.size() > 0) {
                    nNewDocStatus = oStatuses.getIdAt(0);
                }
            }
            m_nNewDocStatus = nNewDocStatus;
        }
        return m_nNewDocStatus;
    }

    private String getDataFile(CMyUnZipFile unzipFile) throws WCMException {
        ArrayList xmlFiles = unzipFile.getFilteredFiles();
        if (xmlFiles == null || xmlFiles.size() == 0) {
            throw new WCMException(1100, I18NMessage.get(InfoViewDocImportService.class, "InfoViewDocImportService.label11", "\u6ca1\u6709\u6709\u6548\u7684\u8868\u5355\u6570\u636e!"));
        }
        String dataFile = null;
        if (xmlFiles.size() == 1) {
            dataFile = (String)xmlFiles.get(0);
        } else {
            for (int i = 0; i < xmlFiles.size(); ++i) {
                String temp = CMyFile.extractFileName((String)xmlFiles.get(i));
                if (!temp.startsWith("TRSInfoViewData")) continue;
                dataFile = temp;
                break;
            }
        }
        if (CMyString.isEmpty(dataFile)) {
            throw new WCMException(1100, I18NMessage.get(InfoViewDocImportService.class, "InfoViewDocImportService.label11", "\u6ca1\u6709\u6709\u6548\u7684\u8868\u5355\u6570\u636e!"));
        }
        return dataFile;
    }

    private List processAppendix(Hashtable mapFiles, List fileapds, int _nFlag) throws WCMException {
        if (fileapds == null || fileapds.size() == 0) {
            return null;
        }
        Node tempNode = null;
        Element parentNode = null;
        String fn = null;
        String fnNew = null;
        FilesMan fileMan = FilesMan.getFilesMan();
        String pathFlag = null;
        pathFlag = _nFlag == 10 ? "P0" : "W0";
        ArrayList<Appendix> appendixes = new ArrayList<Appendix>(fileapds.size());
        Appendix appendix = null;
        String sFileDesc = null;
        String sRelatedColumn = null;
        for (int i = 0; i < fileapds.size(); ++i) {
            tempNode = (Node)fileapds.get(i);
            parentNode = tempNode.getParent();
            fn = parentNode.getTextTrim();
            if (CMyString.isEmpty(fn)) continue;
            sFileDesc = parentNode.attributeValue("FileName");
            String sFileName = (String)mapFiles.get(fn.toUpperCase());
            if (CMyString.isEmpty(sFileName)) continue;
            fnNew = fileMan.copyFile(sFileName, pathFlag, false);
            sRelatedColumn = parentNode.getName();
            parentNode.setText(fnNew);
            tempNode.detach();
            appendix = new Appendix();
            appendix.setAlt(CMyString.showNull(sFileDesc, fn));
            appendix.setDesc(CMyString.showNull(sFileDesc, fn));
            appendix.setSrcFile(fn);
            appendix.setFile(fnNew);
            appendix.setFileExt(CMyFile.extractFileExt(fn));
            appendix.setFlag(_nFlag);
            appendix.setCrUser("system");
            appendix.setRelatedColumn(sRelatedColumn);
            appendixes.add(appendix);
        }
        return appendixes;
    }

    private List processLink(List linkapds) throws WCMException {
        return null;
    }

    public void setSelectFields(String temp) {
        this.m_sSelectFields = temp;
    }

    private String getSelectFields() {
        return this.m_sSelectFields;
    }
}

