/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.GroupMgr;
import com.trs.cms.auth.domain.GrpUserIdsMan;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.util.CMyString;
import com.trs.service.IGroupService;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class GroupService
implements IGroupService {
    private static Logger m_oLogger = Logger.getLogger((String)GroupService.class.getName());

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    @Override
    public boolean addUser(User _userToAdd, Group _dstGroup) throws WCMException {
        if (this.getLoginUser() == null) {
            throw new WCMException(20, I18NMessage.get(GroupService.class, "GroupService.label1", "\u767b\u5f55\u7528\u6237\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6dfb\u52a0\u7528\u6237\uff01"));
        }
        if (_dstGroup == null) {
            throw new WCMException(20, I18NMessage.get(GroupService.class, "GroupService.label2", "\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6dfb\u52a0\u7528\u6237\uff01"));
        }
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)_dstGroup, 13)) {
            throw new WCMException(1002, I18NMessage.get(GroupService.class, "GroupService.label3", "\u60a8\u6682\u65f6\u65e0\u6743\u5728\u7ec4\u7ec7\u4e2d\u6dfb\u52a0\u7528\u6237\uff01"));
        }
        String sLogDesc = CMyString.format(I18NMessage.get(GroupService.class, "GroupService.label37", "\u5411{0}\u6dfb\u52a0{1}"), new String[]{_dstGroup.toString(), _userToAdd.toString()});
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), "GROUPUSER_ADD", sLogDesc, _dstGroup);
        try {
            this.getGroupMgr().addUser(_userToAdd, _dstGroup);
        }
        catch (Throwable t) {
            LogServer.endRecordFailedOperation(lStartTime, t);
            throw new WCMException(1100, I18NMessage.get(GroupService.class, "GroupService.label6", "\u5f80\u7ec4\u7ec7\u6dfb\u52a0\u7528\u6237\u5931\u8d25!"), t);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return true;
    }

    @Override
    public boolean removeUser(User _userToRemove, Group _dstGroup) throws WCMException {
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)_dstGroup, 14)) {
            throw new WCMException(1002, I18NMessage.get(GroupService.class, "GroupService.label7", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u5220\u9664\u7ec4\u4e2d\u7684\u7528\u6237"));
        }
        String sLogDesc = CMyString.format(I18NMessage.get(GroupService.class, "GroupService.label38", "\u5220\u9664{0}\u7684\u7528\u6237{1}"), new String[]{_dstGroup.toString(), _userToRemove.toString()});
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), "GROUPUSER_DEL", sLogDesc, _userToRemove);
        try {
            this.getGroupMgr().removeUser(_userToRemove, _dstGroup);
        }
        catch (Throwable t) {
            LogServer.endRecordFailedOperation(lStartTime, t);
            throw new WCMException(1100, I18NMessage.get(GroupService.class, "GroupService.label10", "\u4ece\u7ec4\u7ec7\u4e2d\u5220\u9664\u7528\u6237\u5931\u8d25!"), t);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return true;
    }

    @Override
    public boolean removeUser(User _userToRemove, Group _dstGroup, boolean _bContainsChildren) throws WCMException {
        if (_dstGroup == null) {
            return false;
        }
        if (!_bContainsChildren) {
            return this.removeUser(_userToRemove, _dstGroup);
        }
        Groups oGroups = _userToRemove.getGroups();
        String sUserGroupIds = oGroups.getIdListAsString();
        String sGroupIds = this.getGroupMgr().getOffspringGroupIds(String.valueOf(_dstGroup.getId()), true);
        String[] arrInOffspringGroupIds = sGroupIds.split(",");
        ArrayList<String> includeInGroupIds = new ArrayList<String>();
        sUserGroupIds = "," + sUserGroupIds + ",";
        for (int i = 0; i < arrInOffspringGroupIds.length; ++i) {
            if (CMyString.isEmpty(arrInOffspringGroupIds[i]) || sUserGroupIds.indexOf("," + arrInOffspringGroupIds[i] + ",") == -1) continue;
            includeInGroupIds.add(arrInOffspringGroupIds[i]);
        }
        Groups oRemoveGroups = Groups.findByIds(this.getLoginUser(), CMyString.join(includeInGroupIds, ","));
        boolean bResult = true;
        for (int i = 0; i < oRemoveGroups.size(); ++i) {
            Group oRemoveGroup = (Group)oRemoveGroups.getAt(i);
            if (oRemoveGroup == null) continue;
            bResult = this.removeUser(_userToRemove, oRemoveGroup) && bResult;
        }
        return bResult;
    }

    @Override
    public Users getUsers(Group _dstGroup, WCMFilter _filter) throws WCMException {
        return this.getGroupMgr().getUsers(_dstGroup, _filter);
    }

    @Override
    public Users getUsers(Group _dstGroup, WCMFilter _filter, boolean _bContainsChildGrp) throws WCMException {
        return this.getGroupMgr().getUsers(_dstGroup, _filter, _bContainsChildGrp);
    }

    @Override
    public boolean moveUser(User _userToMove, Group _srcGroup, Group _dstGroup) throws WCMException {
        if (this.getLoginUser() == null || !this.getLoginUser().isSecurityAdmin()) {
            throw new WCMException(1002, I18NMessage.get(GroupService.class, "GroupService.label11", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u66f4\u6539\u7528\u6237\u6240\u5c5e\u7684\u7ec4\u7ec7!"));
        }
        String sLogDesc = CMyString.format(I18NMessage.get(GroupService.class, "GroupService.label39", "\u53d8\u66f4{0}\u7684\u7ec4\u7ec7\u4ece{1}\u5230{2}"), new Object[]{_userToMove, _srcGroup, _dstGroup});
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), "USER_MOVE", sLogDesc, _userToMove);
        try {
            this.getGroupMgr().moveUser(_userToMove, _srcGroup, _dstGroup);
        }
        catch (Throwable t) {
            LogServer.endRecordFailedOperation(lStartTime, t);
            throw new WCMException(1100, I18NMessage.get(GroupService.class, "GroupService.label16", "\u6539\u53d8\u7528\u6237\u7684\u7ec4\u7ec7\u5931\u8d25!"), t);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return true;
    }

    @Override
    public boolean moveUser(User _userToMove, Group _srcGroup, Groups _dstGroups) throws WCMException {
        if (_dstGroups == null || _dstGroups.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(GroupService.class, "GroupService.label17", "\u6ca1\u6307\u5b9a\u6709\u6548\u7684\u76ee\u6807\u7ec4\u7ec7,\u65e0\u6cd5\u5b8c\u6210\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7\u7684\u66f4\u6539!"));
        }
        Group currGroup = null;
        for (int i = 0; i < _dstGroups.size(); ++i) {
            currGroup = (Group)_dstGroups.getAt(i);
            if (currGroup == null) continue;
            this.moveUser(_userToMove, _srcGroup, currGroup);
        }
        return true;
    }

    @Override
    public boolean addManager(User _adminToAdd, Group _dstGroup) throws WCMException {
        String sLogDesc = CMyString.format(I18NMessage.get(GroupService.class, "GroupService.label40", "\u6307\u5b9a{0}\u4e3a{1}\u7684\u7ba1\u7406\u5458"), new Object[]{_adminToAdd, _dstGroup});
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), "GROUPUSER_ADMINADD", sLogDesc, _dstGroup);
        try {
            this.setManager(_adminToAdd, _dstGroup, true);
        }
        catch (Throwable t) {
            LogServer.endRecordFailedOperation(lStartTime, t);
            throw new WCMException(1100, I18NMessage.get(GroupService.class, "GroupService.label21", "\u6307\u5b9a\u7ec4\u7ba1\u7406\u5458\u5931\u8d25!"), t);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return true;
    }

    private String getLoginUserName() {
        return this.getLoginUser().getName();
    }

    @Override
    public boolean removeManager(User _adminToCancel, Group _dstGroup) throws WCMException {
        String sLogDesc = CMyString.format(I18NMessage.get(GroupService.class, "GroupService.label41", "\u53d6\u6d88{0}\u5728{1}\u4e2d\u7684\u7ba1\u7406\u5458\u8eab\u4efd"), new Object[]{_adminToCancel, _dstGroup});
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), "GROUPUSER_ADMINDEL", sLogDesc, _dstGroup);
        try {
            this.setManager(_adminToCancel, _dstGroup, false);
        }
        catch (Throwable t) {
            LogServer.endRecordFailedOperation(lStartTime, t);
            throw new WCMException(1100, I18NMessage.get(GroupService.class, "GroupService.label25", "\u53d6\u6d88\u7ec4\u7ba1\u7406\u5458!"), t);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return true;
    }

    private boolean setManager(User _dstUser, Group _dstGroup, boolean _isAdministrator) throws WCMException {
        if (this.getLoginUser() == null || !AuthServer.hasRight(this.getLoginUser(), _dstGroup)) {
            throw new WCMException(1002, I18NMessage.get(GroupService.class, "GroupService.label26", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u6307\u5b9a\u7ec4\u7ba1\u7406\u5458!"));
        }
        return this.getGroupMgr().setGroupManager(_dstUser, _dstGroup, _isAdministrator);
    }

    @Override
    public Groups getChildren(Group _parentGroup) throws WCMException {
        return this.getGroupMgr().getChildren(_parentGroup);
    }

    @Override
    public Groups getChildren(Group _parentGroup, boolean _bContainsChild) throws WCMException {
        return this.getChildren(_parentGroup, _bContainsChild, null);
    }

    @Override
    public Groups getChildren(Group _parentGroup, boolean _bContainsChild, WCMFilter _filter) throws WCMException {
        if (!_bContainsChild) {
            return this.getGroupMgr().getChildren(_parentGroup, _filter);
        }
        return this.getGroupMgr().getOffspringGroups(_parentGroup, false, _filter);
    }

    @Override
    public boolean delete(int _nGroupId) throws WCMException {
        Group group = Group.findById(_nGroupId);
        if (group == null) {
            throw new WCMException(200006, I18NMessage.get(GroupService.class, "GroupService.label27", "\u6ca1\u627e\u5230\u7ec4\u7ec7[") + _nGroupId + "]");
        }
        return this.delete(group);
    }

    @Override
    public boolean delete(String _sGroupIds) throws WCMException {
        Groups groups = Groups.findByIds(this.getLoginUser(), _sGroupIds);
        if (groups.isEmpty()) {
            throw new WCMException(200006, I18NMessage.get(GroupService.class, "GroupService.label28", "\u6ca1\u6709\u627e\u5230\u8981\u5220\u9664\u7684\u7ec4\u7ec7!"));
        }
        return this.delete(groups);
    }

    @Override
    public boolean delete(Groups _groupsToDelete) throws WCMException {
        if (_groupsToDelete == null || _groupsToDelete.isEmpty()) {
            throw new WCMException(20, I18NMessage.get(GroupService.class, "GroupService.label29", "\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        Groups delGroups = _groupsToDelete;
        for (int i = 0; i < delGroups.size(); ++i) {
            Group delGroup = (Group)delGroups.getAt(i);
            if (delGroup != null) {
                this.delete(delGroup);
                continue;
            }
            m_oLogger.error((Object)I18NMessage.get(GroupService.class, "GroupService.label30", "\u53d6\u7ec4\u7ec7\u96c6\u5408\u4e2d\u7684\u7ec4\u7ec7\u65f6\u4e3a\u7a7a\uff01"));
        }
        return true;
    }

    @Override
    public boolean delete(Group _groupToDelete) throws WCMException {
        if (_groupToDelete == null) {
            throw new WCMException(20, I18NMessage.get(GroupService.class, "GroupService.label29", "\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        Group delGroup = _groupToDelete;
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)delGroup, 12)) {
            throw new WCMException(1002, I18NMessage.get(GroupService.class, "GroupService.label31", "\u60a8\u65e0\u6743\u5220\u9664\u7ec4\u7ec7\uff01"));
        }
        String sLogDesc = I18NMessage.get(GroupService.class, "GroupService.label42", "\u5220\u9664") + "[" + _groupToDelete + "]";
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), "GROUP_DEL", sLogDesc, _groupToDelete);
        try {
            this.getGroupMgr().delete(delGroup);
        }
        catch (Throwable t) {
            LogServer.endRecordFailedOperation(lStartTime, t);
            throw new WCMException(1100, I18NMessage.get(GroupService.class, "GroupService.label32", "\u5220\u9664\u7ec4\u7ec7\u5931\u8d25!"), t);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return true;
    }

    @Override
    public Group save(Group _dstGroup) throws WCMException {
        Group groupPO = _dstGroup;
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)groupPO, 11)) {
            throw new WCMException(1002, I18NMessage.get(GroupService.class, "GroupService.label33", "\u60a8\u65e0\u6743\u4fdd\u5b58\u7ec4\u7ec7\uff01"));
        }
        String sLogDesc = I18NMessage.get(GroupService.class, "GroupService.label43", "\u4fdd\u5b58") + "[" + _dstGroup + "]";
        String sLogType = "GROUP_ADD";
        if (!_dstGroup.isAddMode()) {
            sLogType = "GROUP_EDIT";
        }
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), sLogType, sLogDesc, _dstGroup);
        try {
            groupPO = this.getGroupMgr().save(groupPO);
        }
        catch (Throwable t) {
            LogServer.endRecordFailedOperation(lStartTime, t);
            throw new WCMException(1100, I18NMessage.get(GroupService.class, "GroupService.label35", "\u4fdd\u5b58\u7ec4\u7ec7\u5931\u8d25!"), t);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return groupPO;
    }

    @Override
    public Group moveTo(Group _fromGroup, Group _toGroup) {
        throw new UnsupportedOperationException(I18NMessage.get(GroupService.class, "GroupService.label36", "\u65b9\u6cd5\u672a\u5b9e\u73b0"));
    }

    @Override
    public Users getAdmins(Group _dstGroup) throws WCMException {
        return this.getGroupMgr().getAdmins(_dstGroup);
    }

    private GroupMgr getGroupMgr() {
        return (GroupMgr)DreamFactory.createObjectById("GroupMgr");
    }

    @Override
    public boolean setGroupUsers(int _nDstGroupId, String _sUserIdsToAdd) throws WCMException {
        GrpUserIdsMan grpUserIdsMan = new GrpUserIdsMan(_nDstGroupId);
        grpUserIdsMan.dowithIds(_sUserIdsToAdd);
        return true;
    }
}

