/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.util;

import com.trs.infra.util.CMyString;
import com.trs.scm.sdk.model.Comment;
import com.trs.scm.sdk.model.CommentWrapper;
import com.trs.scm.sdk.model.ExtraParams;
import com.trs.scm.sdk.model.Favorite;
import com.trs.scm.sdk.model.FavoriteWrapper;
import com.trs.scm.sdk.model.MicroContent;
import com.trs.scm.sdk.model.MicroContentWrapper;
import com.trs.scm.sdk.model.MicroUser;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import t4j.TBlog;
import t4j.TBlogException;
import t4j.TBlogResponse;
import t4j.data.Paging;
import t4j.data.Status;
import t4j.data.User;

public class T163ObjectUtil {
    public static final String CURSOR_ID = "Cursor_Id";

    public static MicroContent constructMicroContent(Status t163Status, TBlog tBlog) throws Exception {
        MicroContent oResult = new MicroContent();
        if (t163Status == null) {
            return null;
        }
        String sContent = t163Status.getText();
        Long sMicroContentID = t163Status.getId();
        String sSource = t163Status.getSource();
        oResult.setContent(sContent);
        oResult.setId(String.valueOf(sMicroContentID));
        oResult.setSource(sSource);
        oResult.setBmiddlePic("");
        oResult.setThumbnailPic("");
        oResult.setOriginalPic("");
        Date dCreateDate = t163Status.getCreatedAt();
        oResult.setCreateDate(dCreateDate);
        boolean bIsFavorited = t163Status.isFavorited();
        oResult.setFavorited(bIsFavorited);
        int nCommentCount = t163Status.getCommentsCount();
        int nRepostCount = t163Status.getRetweetCount();
        oResult.setCommentCount(nCommentCount);
        oResult.setRepostCount(nRepostCount);
        MicroUser oMicroUser = null;
        if (t163Status.getUser() != null) {
            oMicroUser = T163ObjectUtil.constructMicroUser(t163Status.getUser());
        }
        oResult.setUser(oMicroUser);
        oResult.setExtraAttribute(CURSOR_ID, t163Status.getCursorId());
        long lRetweetedId = t163Status.getRootInReplyToStatusId();
        if (lRetweetedId == 0L) {
            oResult.setRetweeted(false);
        } else {
            oResult.setRetweeted(true);
            if (tBlog != null) {
                Status oRetweetedStatus = null;
                try {
                    oRetweetedStatus = tBlog.showStatus(lRetweetedId);
                }
                catch (Exception e) {
                    if (e instanceof TBlogException && ((TBlogException)((Object)e)).getErrorCode() == 404) {
                        oResult.setRetweetedMicroContent(null);
                        return oResult;
                    }
                    throw e;
                }
                oResult.setRetweetedMicroContent(T163ObjectUtil.constructMicroContent(oRetweetedStatus, null));
            }
        }
        return oResult;
    }

    public static MicroContentWrapper constructMicroContentWrapper(List<Status> list, TBlog tBlog) throws Exception {
        long lTotalNumber = list.size();
        ArrayList<MicroContent> oMicroContentList = new ArrayList<MicroContent>();
        for (int i = 0; i < list.size(); ++i) {
            try {
                oMicroContentList.add(T163ObjectUtil.constructMicroContent(list.get(i), tBlog));
                continue;
            }
            catch (Exception _oException) {
                throw new Exception("\u6784\u9020MicroContentWrapper\u629b\u9519\uff01", _oException);
            }
        }
        MicroContentWrapper oResult = new MicroContentWrapper(oMicroContentList, lTotalNumber);
        if (oResult != null && oMicroContentList.size() > 0) {
            oResult.setExtraAttribute("Max_Id", ((MicroContent)oMicroContentList.get(0)).getExtraAttributeAsString(CURSOR_ID));
            oResult.setExtraAttribute("Since_Id", ((MicroContent)oMicroContentList.get(oMicroContentList.size() - 1)).getExtraAttributeAsString(CURSOR_ID));
        }
        return oResult;
    }

    public static MicroUser constructMicroUser(User _t163User) {
        Long sMicroUserID = _t163User.getId();
        String sNickName = _t163User.getName();
        String sDescription = _t163User.getDescription();
        long lFollowerCount = _t163User.getFollowersCount();
        long lFriendsCount = _t163User.getFriendsCount();
        String sHead = _t163User.getProfileImageURL();
        long lContentCount = _t163User.getStatusesCount();
        String sLocation = _t163User.getLocation();
        boolean bIsMale = true;
        if (_t163User.getGender() != 2) {
            bIsMale = false;
        }
        MicroUser oResult = new MicroUser();
        oResult.setId(String.valueOf(sMicroUserID));
        oResult.setName(sNickName);
        oResult.setDescription(sDescription);
        oResult.setFollowersCount(lFollowerCount);
        oResult.setFriendsCount(lFriendsCount);
        oResult.setHead(sHead);
        oResult.setMicroContentCount(lContentCount);
        oResult.setLocation(sLocation);
        oResult.setMale(bIsMale);
        return oResult;
    }

    public static Paging constructPaging(int _nRequestNumber, ExtraParams _extraParams) throws Exception {
        if (_nRequestNumber > 200) {
            _nRequestNumber = 200;
        } else if (_nRequestNumber <= 0) {
            throw new Exception("\u4f20\u5165\u7684\u8bf7\u6c42\u83b7\u53d6\u5fae\u535a\u6570\u4e0d\u5408\u6cd5\uff0c\u8bf7\u67e5\u770b\u4f20\u53c2\uff01");
        }
        Paging paging = new Paging();
        paging.setCount(_nRequestNumber);
        if (_extraParams != null) {
            String sSinceID = _extraParams.getParamAsString("Since_Id");
            String sMaxID = _extraParams.getParamAsString("Max_Id");
            if (!CMyString.isEmpty(sSinceID)) {
                paging.setSinceId(sSinceID);
            } else if (!CMyString.isEmpty(sMaxID)) {
                paging.setMaxId(sMaxID);
            }
        }
        return paging;
    }

    public static Comment constructMicroComment(TBlogResponse response, TBlog tBlog) throws Exception {
        Comment oMicroComment = new Comment();
        if (response instanceof Status) {
            User t163User;
            Status status = (Status)response;
            oMicroComment.setCommentId(String.valueOf(status.getId()));
            oMicroComment.setCreateDate(status.getCreatedAt());
            oMicroComment.setContent(status.getText());
            oMicroComment.setSource(status.getSource());
            long lReplyMCId = status.getRootInReplyToStatusId();
            if (lReplyMCId != 0L) {
                Status oReplyStatus;
                block10: {
                    oReplyStatus = null;
                    try {
                        oReplyStatus = tBlog.showStatus(lReplyMCId);
                    }
                    catch (Exception e) {
                        if (e instanceof TBlogException && ((TBlogException)((Object)e)).getErrorCode() == 404) break block10;
                        throw e;
                    }
                }
                if (oReplyStatus != null) {
                    oMicroComment.setReplyMicroContent(T163ObjectUtil.constructMicroContent(oReplyStatus, null));
                } else {
                    oMicroComment.setReplyMicroContent(null);
                }
            }
            if ((t163User = status.getUser()) != null) {
                oMicroComment.setUser(T163ObjectUtil.constructMicroUser(t163User));
            }
            oMicroComment.setExtraAttribute(CURSOR_ID, status.getCursorId());
        } else if (response instanceof t4j.data.Comment) {
            t4j.data.Comment t163Comment = (t4j.data.Comment)response;
            oMicroComment.setCommentId(String.valueOf(t163Comment.getId()));
            oMicroComment.setCreateDate(t163Comment.getCreatedAt());
            oMicroComment.setContent(t163Comment.getText());
            oMicroComment.setSource(t163Comment.getSource());
            User t163User = t163Comment.getUser();
            if (t163User != null) {
                oMicroComment.setUser(T163ObjectUtil.constructMicroUser(t163User));
            }
        }
        return oMicroComment;
    }

    public static CommentWrapper constructCommentWrapper(List<TBlogResponse> list, TBlog tBlog) throws Exception {
        long num = list.size();
        if (num == 0L) {
            return null;
        }
        ArrayList<Comment> comments = new ArrayList<Comment>();
        for (TBlogResponse response : list) {
            comments.add(T163ObjectUtil.constructMicroComment(response, tBlog));
        }
        CommentWrapper oResult = new CommentWrapper(comments, num);
        return oResult;
    }

    public static Favorite constructMicroFavorite(Status status, TBlog tBlog) throws Exception {
        Favorite oResult = new Favorite();
        Date oDate = status.getFavoritedAt();
        MicroContent oMicroContent = T163ObjectUtil.constructMicroContent(status, tBlog);
        oResult.setFavoriteTime(oDate);
        oResult.setMicroContent(oMicroContent);
        oResult.setExtraAttribute(CURSOR_ID, status.getCursorId());
        return oResult;
    }

    public static FavoriteWrapper constructMicroFavoriteWrapper(List<Status> list, TBlog tBlog) throws Exception {
        if (list == null || list.size() == 0) {
            return null;
        }
        long num = list.size();
        ArrayList<Favorite> favorites = new ArrayList<Favorite>();
        for (Status status : list) {
            favorites.add(T163ObjectUtil.constructMicroFavorite(status, tBlog));
        }
        FavoriteWrapper oResult = new FavoriteWrapper(favorites, num);
        if (oResult != null) {
            oResult.setExtraAttribute("Since_Id", ((Favorite)favorites.get((int)num - 1)).getExtraAttribute(CURSOR_ID));
        }
        return oResult;
    }
}

