/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.impl;

import com.tencent.weibo.api.StatusesAPI;
import com.tencent.weibo.api.TAPI;
import com.tencent.weibo.beans.OAuth;
import com.tencent.weibo.oauthv2.OAuthV2;
import com.trs.infra.util.CMyDateTime;
import com.trs.scm.sdk.impl.AbstractCommentMgr;
import com.trs.scm.sdk.impl.TencentMicroContentMgr;
import com.trs.scm.sdk.model.Comment;
import com.trs.scm.sdk.model.CommentWrapper;
import com.trs.scm.sdk.model.ExtraParams;
import com.trs.scm.sdk.model.MicroContent;
import com.trs.scm.sdk.util.TencentObjectUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;

public class TencentCommentMgr
extends AbstractCommentMgr {
    private final int COMMENTS_OF_MC = 1;
    private final int COMMENTS_BY_ME = 2;
    private final int COMMENTS_TO_ME = 3;
    private final int COMMENTS_MENTIONS = 4;
    private static Map<String, CommentWrapper> m_OAuthCommentMap = null;
    private static Map<String, CMyDateTime> m_oLastRefreshDate = null;
    private TAPI m_oTAPI = new TAPI("2.a");
    private StatusesAPI m_oStatusesAPI = new StatusesAPI("2.a");
    private OAuthV2 m_oTencentOAuth = new OAuthV2();

    public TencentCommentMgr(com.trs.scm.sdk.model.OAuth _oAuth) {
        super(_oAuth);
        this.m_oTencentOAuth.setAccessToken(_oAuth.getOAuth_token());
        this.m_oTencentOAuth.setOpenid(_oAuth.getOAuth_token_secret());
        this.m_oTencentOAuth.setClientId(_oAuth.getAppKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Comment createComment(String _sContent, String _sMicroContentId, ExtraParams _oExtraParams) throws Exception {
        this.checkContentLength(_sContent);
        if (_sMicroContentId == null || _sMicroContentId.length() == 0) {
            throw new Exception("\u5fae\u535aId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String sIp = _oExtraParams.getParamAsString("IP");
        String sLatitude = _oExtraParams.getParamAsString("lat");
        String sLongitude = _oExtraParams.getParamAsString("long");
        String sResponse = this.m_oTAPI.comment((OAuth)this.m_oTencentOAuth, "json", _sContent, sIp, sLongitude, sLatitude, _sMicroContentId);
        try {
            TencentObjectUtil.validResult(sResponse, "\u8bc4\u8bba\u5fae\u535a");
        }
        finally {
            String sKey = this.makeKey(2, this.m_oTencentOAuth.getAccessToken(), _sMicroContentId);
            if (m_OAuthCommentMap != null && m_OAuthCommentMap.get(sKey) != null) {
                m_oLastRefreshDate.put(sKey, CMyDateTime.now().dateAdd(5, -2));
            }
            sKey = this.makeKey(1, this.m_oTencentOAuth.getAccessToken(), _sMicroContentId);
            if (m_OAuthCommentMap != null && m_OAuthCommentMap.get(sKey) != null) {
                m_oLastRefreshDate.put(sKey, CMyDateTime.now().dateAdd(5, -2));
            }
        }
        JSONObject jsonObject = JSONObject.fromObject((Object)sResponse);
        jsonObject = jsonObject.getJSONObject("data");
        String sId = jsonObject.getString("id");
        long timeStamp = jsonObject.getLong("time");
        Comment comment = new Comment();
        comment.setCommentId(sId);
        comment.setContent(_sContent);
        comment.setCreateDate(new Date(timeStamp * 1000L));
        MicroContent oMicroContent = new MicroContent();
        oMicroContent.setId(_sMicroContentId);
        comment.setReplyMicroContent(oMicroContent);
        return comment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean destroyComment(String commentId) throws Exception {
        if (commentId == null || commentId.length() == 0) {
            throw new Exception("\u8bc4\u8bbaId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String sResponse = this.m_oTAPI.del((OAuth)this.m_oTencentOAuth, "json", commentId);
        try {
            TencentObjectUtil.validResult(sResponse, "\u5220\u9664\u8bc4\u8bba");
        }
        finally {
            String sKey = this.makeKey(2, this.m_oTencentOAuth.getAccessToken(), null);
            if (m_OAuthCommentMap != null && m_OAuthCommentMap.get(sKey) != null) {
                m_oLastRefreshDate.put(sKey, CMyDateTime.now().dateAdd(5, -2));
            }
        }
        return true;
    }

    @Override
    public CommentWrapper getCommentMentions(int _nPageIndex, int _nPageSize, ExtraParams extraParams) throws Exception {
        int nMaxPageSize = 70;
        int nCommentType = 4;
        return this.getCommentsByType(nCommentType, null, _nPageIndex, _nPageSize, nMaxPageSize);
    }

    @Override
    public CommentWrapper getCommentsByMCId(String _oMicroContentId, int _nPageIndex, int _nPageSize, ExtraParams _oExtraParams) throws Exception {
        int nMaxPageSize = 100;
        int nCommentType = 1;
        return this.getCommentsByType(nCommentType, _oMicroContentId, _nPageIndex, _nPageSize, nMaxPageSize);
    }

    @Override
    public CommentWrapper getCommentsByMe(int _nPageIndex, int _nPageSize, ExtraParams extraParams) throws Exception {
        int nMaxPageSize = 200;
        int nCommentType = 2;
        return this.getCommentsByType(nCommentType, null, _nPageIndex, _nPageSize, nMaxPageSize);
    }

    @Override
    public CommentWrapper getCommentsToMe(int _nPageIndex, int _nPageSize, ExtraParams extraParams) throws Exception {
        int nMaxPageSize = 70;
        int nCommentType = 3;
        return this.getCommentsByType(nCommentType, null, _nPageIndex, _nPageSize, nMaxPageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Comment replyComment(String content, String commentId, ExtraParams extraParams) throws Exception {
        this.checkContentLength(content);
        if (commentId == null || commentId.length() == 0) {
            throw new Exception("\u8bc4\u8bbaId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String sIp = extraParams.getParamAsString("IP");
        String sLatitude = extraParams.getParamAsString("lat");
        String sLongitude = extraParams.getParamAsString("long");
        String sResponse = this.m_oTAPI.comment((OAuth)this.m_oTencentOAuth, "json", content, sIp, sLongitude, sLatitude, commentId);
        try {
            TencentObjectUtil.validResult(sResponse, "\u56de\u590d\u8bc4\u8bba");
        }
        finally {
            String sKey = this.makeKey(2, this.m_oTencentOAuth.getAccessToken(), null);
            if (m_OAuthCommentMap != null && m_OAuthCommentMap.get(sKey) != null) {
                m_oLastRefreshDate.put(sKey, CMyDateTime.now().dateAdd(5, -2));
            }
        }
        JSONObject jsonObject = JSONObject.fromObject((Object)sResponse);
        jsonObject = jsonObject.getJSONObject("data");
        String sId = jsonObject.getString("id");
        TencentMicroContentMgr oMicroContentMgr = new TencentMicroContentMgr(this.m_oOAuth);
        MicroContent oMicroContent = oMicroContentMgr.findById(sId);
        Comment oComment = new Comment();
        oComment.setCommentId(sId);
        oComment.setContent(oMicroContent.getContent());
        oComment.setCreateDate(oMicroContent.getCreateDate());
        MicroContent oReplyContent = oMicroContent.getRetweetedMicroContent();
        if (oReplyContent != null) {
            Comment oReplyComment = new Comment();
            oReplyComment.setCommentId(oReplyContent.getId());
            oReplyComment.setContent(oReplyContent.getContent());
            oReplyComment.setCreateDate(oReplyContent.getCreateDate());
            oComment.setReplyComment(oReplyComment);
        }
        return oComment;
    }

    private CommentWrapper getCommentsByType(int _nCommentType, String _sMCId, int _nPageIndex, int _nPageSize, int _nMaxPageSize) throws Exception {
        if (_nPageSize < 1 || _nPageSize > 70) {
            throw new Exception("\u9875\u9762\u5927\u5c0f\u5fc5\u987b\u57281-70\u4e4b\u95f4");
        }
        if (_nPageIndex < 1) {
            _nPageIndex = 1;
        }
        int nMaxPageSize = _nMaxPageSize;
        int nCommentType = _nCommentType;
        boolean bRefreshed = this.refreshIfNeed(nCommentType, _sMCId, _nPageIndex, _nPageSize, nMaxPageSize);
        String sAccessToken = this.m_oTencentOAuth.getAccessToken();
        String sKey = this.makeKey(nCommentType, sAccessToken, _sMCId);
        CommentWrapper commentWrapper = m_OAuthCommentMap.get(sKey);
        if (commentWrapper == null) {
            return null;
        }
        if (bRefreshed) {
            return this.constructResult(_nPageIndex, _nPageSize, commentWrapper);
        }
        int nFromIndex = _nPageIndex * _nPageSize - _nPageSize;
        int nToIndex = _nPageIndex * _nPageSize;
        long lTotalNum = commentWrapper.getTotalNumber();
        List<Comment> comments = commentWrapper.getComments();
        int nListSize = comments.size();
        int nRequestNum = 0;
        if (lTotalNum <= (long)nFromIndex) {
            return null;
        }
        nRequestNum = lTotalNum < (long)nToIndex ? (int)lTotalNum - nListSize : nToIndex - nListSize;
        if (nRequestNum <= 0) {
            return this.constructResult(_nPageIndex, _nPageSize, commentWrapper);
        }
        commentWrapper = this.loadComments(commentWrapper, nCommentType, _sMCId, nRequestNum, _nPageSize, nMaxPageSize);
        m_OAuthCommentMap.put(sKey, commentWrapper);
        return this.constructResult(_nPageIndex, _nPageSize, commentWrapper);
    }

    private String makeKey(int _nCommentType, String _sAccessToken, String _sMCId) {
        if (_sMCId == null) {
            _sMCId = "";
        }
        return _nCommentType + "_" + _sAccessToken + "_" + _sMCId;
    }

    private boolean refreshIfNeed(int _nCommentType, String _sMCId, int _nPageIndex, int _nPageSize, int _nMaxPageSize) throws Exception {
        if (!this.needRefresh(_nCommentType, _sMCId)) {
            return false;
        }
        int nRequestNum = _nPageIndex * _nPageSize;
        CommentWrapper commentWrapper = this.loadComments(null, _nCommentType, _sMCId, nRequestNum, _nPageSize, _nMaxPageSize);
        if (m_OAuthCommentMap == null) {
            m_OAuthCommentMap = new HashMap<String, CommentWrapper>();
        }
        if (m_oLastRefreshDate == null) {
            m_oLastRefreshDate = new HashMap<String, CMyDateTime>();
        }
        String sAccessToken = this.m_oTencentOAuth.getAccessToken();
        String sKey = this.makeKey(_nCommentType, sAccessToken, _sMCId);
        m_OAuthCommentMap.put(sKey, commentWrapper);
        m_oLastRefreshDate.put(sKey, CMyDateTime.now());
        return true;
    }

    private boolean needRefresh(int _nCommentType, String _sMCId) {
        if (m_oLastRefreshDate == null) {
            return true;
        }
        String sKey = this.makeKey(_nCommentType, this.m_oTencentOAuth.getAccessToken(), _sMCId);
        CMyDateTime oLastRefreshTime = m_oLastRefreshDate.get(sKey);
        if (oLastRefreshTime == null) {
            return true;
        }
        CMyDateTime now = CMyDateTime.now();
        return now.getTimeInMillis() - oLastRefreshTime.getTimeInMillis() > 120000L;
    }

    private CommentWrapper loadComments(CommentWrapper _oCommentWrapper, int _nCommentType, String _sMCId, int _nRequestNum, int _nPageSize, int _nMaxPageSize) throws Exception {
        CommentWrapper tempCommentWrapper;
        int[] nPageParams = this.calculatePageParam(_nRequestNum, _nPageSize, _nMaxPageSize);
        int nPageNum = nPageParams[0];
        int nPageSize = nPageParams[1];
        String sReqnum = Integer.toString(nPageSize);
        String sLastId = "0";
        String sPageTime = "0";
        if (_nCommentType != 1) {
            List<Comment> comments;
            int nListSize;
            if (_oCommentWrapper != null && (nListSize = (comments = _oCommentWrapper.getComments()).size()) > 0) {
                Comment lastComment = comments.get(nListSize - 1);
                sLastId = lastComment.getCommentId();
                sPageTime = Long.toString(lastComment.getCreateDate().getTime() / 1000L);
            }
        } else {
            String sResponse;
            MicroContent oMicroContent;
            MicroContent oReplyMC;
            sLastId = _oCommentWrapper != null ? ((oReplyMC = _oCommentWrapper.getComments().get(0).getReplyMicroContent()).isRetweeted() ? oReplyMC.getRetweetedMicroContent().getId() : _sMCId) : ((oMicroContent = TencentObjectUtil.constructMicroContent(sResponse = this.m_oTAPI.show((OAuth)this.m_oTencentOAuth, "json", _sMCId))).isRetweeted() ? oMicroContent.getRetweetedMicroContent().getId() : _sMCId);
        }
        String sPageFlag = "1";
        CommentWrapper allCommentWrapper = _oCommentWrapper;
        for (int i = 1; i <= nPageNum && (tempCommentWrapper = this.loadCommentsByType(_nCommentType, _sMCId, sPageFlag, sReqnum, sPageTime, sLastId)) != null; ++i) {
            if (allCommentWrapper == null) {
                allCommentWrapper = tempCommentWrapper;
            } else {
                List<Comment> allComments = allCommentWrapper.getComments();
                List<Comment> tempComments = tempCommentWrapper.getComments();
                allComments.addAll(tempComments);
                allCommentWrapper.setComments(allComments);
                allCommentWrapper.setTotalNumber(tempCommentWrapper.getTotalNumber());
            }
            int nHasNext = tempCommentWrapper.getExtraAttributeAsInt("hasnext", 1);
            allCommentWrapper.setExtraAttribute("hasnext", nHasNext);
            sPageTime = tempCommentWrapper.getExtraAttributeAsString("timestamp");
            sLastId = tempCommentWrapper.getExtraAttributeAsString("lastId");
            if (nHasNext == 1) break;
        }
        return allCommentWrapper;
    }

    private CommentWrapper loadCommentsByType(int _nCommentType, String _sMCId, String _sPageFlag, String _sReqnum, String _sPageTime, String _sLastId) throws Exception {
        if (_nCommentType == 1 && (_sMCId == null || _sMCId.length() == 0)) {
            throw new Exception("\u83b7\u53d6\u5fae\u535a\u7684\u8bc4\u8bba\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u5fae\u535aId");
        }
        String sResponse = "";
        String sRequestType = "64";
        switch (_nCommentType) {
            case 2: {
                sResponse = this.m_oStatusesAPI.broadcastTimeline((OAuth)this.m_oTencentOAuth, "json", _sPageFlag, _sPageTime, _sReqnum, _sLastId, sRequestType, "0");
                break;
            }
            case 3: 
            case 4: {
                sResponse = this.m_oStatusesAPI.mentionsTimeline((OAuth)this.m_oTencentOAuth, "json", _sPageFlag, _sPageTime, _sReqnum, _sLastId, sRequestType, "0");
                break;
            }
            case 1: {
                String sFlag = "1";
                sResponse = this.m_oTAPI.reList((OAuth)this.m_oTencentOAuth, "json", sFlag, _sLastId, _sPageFlag, _sPageTime, _sReqnum, _sMCId);
                break;
            }
        }
        CommentWrapper commentWrapper = TencentObjectUtil.constructComments(sResponse);
        return commentWrapper;
    }

    private int[] calculatePageParam(int _nRequestNum, int _nPageSize, int _nMaxPageSize) {
        int nPageNum = 0;
        int nPageSize = _nPageSize;
        int nRequestNum = _nRequestNum;
        if (_nRequestNum <= _nMaxPageSize) {
            nPageNum = 1;
            nPageSize = nRequestNum;
        } else {
            nPageNum = nRequestNum / _nMaxPageSize;
            nPageSize = _nMaxPageSize;
            int nLastPageNum = nRequestNum % _nMaxPageSize;
            if (nLastPageNum > 0) {
                // empty if block
            }
        }
        int[] pageParam = new int[]{++nPageNum, nPageSize};
        return pageParam;
    }

    private CommentWrapper constructResult(int _nPageIndex, int _nPageSize, CommentWrapper _oCommentWrapper) {
        if (_oCommentWrapper == null) {
            return null;
        }
        List<Comment> oComments = _oCommentWrapper.getComments();
        int nNum = oComments.size();
        int nFromIndex = _nPageIndex * _nPageSize - _nPageSize;
        if (oComments == null || nNum == 0 || nNum <= nFromIndex) {
            return null;
        }
        int nToIndex = _nPageIndex * _nPageSize;
        if (nNum < nToIndex) {
            nToIndex = nNum;
        }
        ArrayList<Comment> oNewComments = new ArrayList<Comment>();
        oNewComments.addAll(oComments);
        oNewComments = oNewComments.subList(nFromIndex, nToIndex);
        CommentWrapper oResultCommentWrapper = new CommentWrapper(oNewComments, _oCommentWrapper.getTotalNumber());
        oResultCommentWrapper.setExtraAttributes(_oCommentWrapper.getExtraAttributes());
        return oResultCommentWrapper;
    }
}

